/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.enquiry.api.bo.BaseAllOperLogReqBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogRspBO;
import com.tydic.enquiry.api.bo.BasePhaseReqBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyItemHisBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemRspBO;
import com.tydic.enquiry.api.bo.EnquiryLogReqBO;
import com.tydic.enquiry.api.bo.PurchasePlanDetailsUpdateReqBO;
import com.tydic.enquiry.api.bo.PurchasePlanDetailsUpdateRspBO;
import com.tydic.enquiry.api.bo.PurchaseSecondBargainingPlanItemBO;
import com.tydic.enquiry.api.bo.UpdateClarifyItemReqBO;
import com.tydic.enquiry.api.bo.UpdateExecuteItemStatusReqBO;
import com.tydic.enquiry.busi.api.BaseAllOperLogBusiService;
import com.tydic.enquiry.busi.api.EnquiryExecuteItemBusiService;
import com.tydic.enquiry.busi.api.plan.PurchasePlanDetailsSecondBargainingBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.ability.plan.PebExtPlanItemUpdateAbilityService;
import com.tydic.order.extend.bo.plan.PebExtPlanItemUpdateReqBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemUpdateRspBO;
import com.tydic.order.extend.constant.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryExecuteItemBusiServiceImpl
implements EnquiryExecuteItemBusiService {
    @Autowired
    ExecuteItemMapper executeItemMapper;
    @Autowired
    private PebExtPlanItemUpdateAbilityService pebExtPlanItemUpdateAbilityService;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private PurchasePlanDetailsSecondBargainingBusiService purchasePlanDetailsSecondBargainingBusiService;
    @Autowired
    private BaseAllOperLogBusiService baseAllOperLogBusiService;

    @Override
    public EnquiryExecuteItemRspBO updateExecuteItemStatus(UpdateExecuteItemStatusReqBO reqBO) {
        EnquiryExecuteItemRspBO rspBO = new EnquiryExecuteItemRspBO();
        List executeItemIdList = reqBO.getExecuteItemIdList();
        String executeStatus = reqBO.getExecuteStatus();
        Integer planExecuteUpdateType = reqBO.getPlanExecuteUpdateType();
        String planExecuteStatus = reqBO.getPlanExecuteStatus();
        if (CollUtil.isNotEmpty((Collection)executeItemIdList)) {
            ExecuteItemPO executeItemPO = new ExecuteItemPO();
            executeItemPO.setExecuteItemIdList(executeItemIdList);
            List<ExecuteItemPO> executeItemList = this.executeItemMapper.selectBy(executeItemPO);
            ArrayList<Long> planItemIdList = new ArrayList<Long>();
            HashSet<Long> executeIdSet = new HashSet<Long>();
            for (ExecuteItemPO executeItem : executeItemList) {
                if ("2013".equals(executeItem.getExecuteStatus())) {
                    executeIdSet.add(executeItem.getExecuteId());
                }
                executeItem.setExecuteStatus(executeStatus);
                executeItem.setConfirmFailReason(reqBO.getRemarks());
                executeItem.setConfirmFailFlag(0);
                planItemIdList.add(executeItem.getPlanDetailId());
            }
            this.executeItemMapper.updateItemBatch(executeItemList);
            if (executeIdSet.size() > 0 && "2008".equals(executeStatus)) {
                ExecuteBillPO record = new ExecuteBillPO();
                ArrayList<Long> executeIdList = new ArrayList<Long>(executeIdSet);
                record.setExecuteIdList(executeIdList);
                record.setFailFlag((byte)1);
                this.executeBillMapper.updateFailFlagByIds(record);
                this.saveFailExecuteItemLog(reqBO, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.EXCEPT.getCode(), 2, reqBO.getRemarks());
            }
            ExecuteItemPO executeItemOne = (ExecuteItemPO)CollUtil.getFirst(executeItemList);
            String status = "2005";
            String fail = "2008";
            String finish = "2007";
            String executeFailReason = "";
            if (executeItemOne != null) {
                Long executeId = executeItemOne.getExecuteId();
                ExecuteItemPO allItemQueryPO = new ExecuteItemPO();
                allItemQueryPO.setExecuteId(executeId);
                List<ExecuteItemPO> allItemList = this.executeItemMapper.selectBy(allItemQueryPO);
                int allCount = allItemList.size();
                Map<String, Long> nameMap = allItemList.stream().collect(Collectors.groupingBy(ExecuteItemPO::getExecuteStatus, Collectors.counting()));
                Long failCount = 0L;
                Long finishCount = 0L;
                if (nameMap.containsKey(fail)) {
                    failCount = nameMap.get(fail);
                }
                if (nameMap.containsKey(finish)) {
                    finishCount = nameMap.get(finish);
                }
                if (failCount + finishCount == (long)allCount) {
                    status = "2006";
                }
                if ((long)allCount == failCount) {
                    status = fail;
                    executeFailReason = reqBO.getRemarks();
                    this.saveFailExecuteLog(reqBO, executeId, EnquiryEnumConstant.BasPhaseStatusEnum.EXCEPT.getCode(), 2, executeFailReason);
                }
                ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
                executeBillPO.setExecuteStatus(status);
                executeBillPO.setExecuteFailReason(executeFailReason);
                this.executeBillMapper.updateByPrimaryKeySelective(executeBillPO);
            }
            if (planExecuteUpdateType != null && planItemIdList.size() > 0) {
                PebExtPlanItemUpdateReqBO updatePlanItemReqBO = new PebExtPlanItemUpdateReqBO();
                updatePlanItemReqBO.setPlanItemIdList(planItemIdList);
                updatePlanItemReqBO.setUpdateType(planExecuteUpdateType);
                updatePlanItemReqBO.setExecuteStatus(planExecuteStatus);
                updatePlanItemReqBO.setFitFailReason(reqBO.getRemarks());
                PebExtPlanItemUpdateRspBO planItemUpdateRspBO = this.pebExtPlanItemUpdateAbilityService.dealPebExtPlanItemUpdate(updatePlanItemReqBO);
                if (!"0000".equals(planItemUpdateRspBO.getRespCode())) {
                    throw new BusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff1a" + planItemUpdateRspBO.getRespDesc());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public EnquiryExecuteItemRspBO updateClarifyPlanItem(UpdateClarifyItemReqBO reqBO) {
        EnquiryExecuteItemRspBO rspBO = new EnquiryExecuteItemRspBO();
        Long executeIdReq = reqBO.getExecuteId();
        List afterItemList = reqBO.getAfterItemList();
        ArrayList<Long> planItemIdList = new ArrayList<Long>();
        ArrayList<PurchaseSecondBargainingPlanItemBO> updateSecondBargainingList = new ArrayList<PurchaseSecondBargainingPlanItemBO>();
        if (CollUtil.isNotEmpty((Collection)afterItemList)) {
            for (EnquiryClarifyItemHisBO afterExecuteItemBO : afterItemList) {
                planItemIdList.add(afterExecuteItemBO.getPlanItemId());
                String jsonStr = JSONObject.toJSONString((Object)afterExecuteItemBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                PurchaseSecondBargainingPlanItemBO purchaseSecondBargainingPlanItemBO = (PurchaseSecondBargainingPlanItemBO)JSON.parseObject((String)jsonStr, PurchaseSecondBargainingPlanItemBO.class);
                updateSecondBargainingList.add(purchaseSecondBargainingPlanItemBO);
            }
        }
        PurchasePlanDetailsUpdateReqBO dealPlanItemHisReqBO = new PurchasePlanDetailsUpdateReqBO();
        dealPlanItemHisReqBO.setUpdateType(PebExtConstant.PlanVersionSource.CLARIFY_VERSION_SOURCE);
        dealPlanItemHisReqBO.setPlanItemIdList(planItemIdList);
        dealPlanItemHisReqBO.setUpdateSecondBargainingList(updateSecondBargainingList);
        dealPlanItemHisReqBO.setExecuteId(executeIdReq);
        dealPlanItemHisReqBO.setOperateUserId(reqBO.getUserId() == null ? null : reqBO.getUserId().toString());
        dealPlanItemHisReqBO.setOperateUserName(reqBO.getName());
        PurchasePlanDetailsUpdateRspBO updateRspBO = this.purchasePlanDetailsSecondBargainingBusiService.updatePurchasePlan(dealPlanItemHisReqBO);
        if (!"0000".equals(updateRspBO.getRespCode())) {
            throw new BusinessException("8888", updateRspBO.getRespDesc());
        }
        for (EnquiryClarifyItemHisBO itemHisBO : afterItemList) {
            Long planItemId = itemHisBO.getPlanItemId();
            Long executeId = itemHisBO.getExecuteId();
            ExecuteItemPO itemQueryPO = new ExecuteItemPO();
            itemQueryPO.setExecuteId(executeId);
            itemQueryPO.setPlanDetailId(planItemId);
            List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQueryPO);
            ExecuteItemPO itemPO = (ExecuteItemPO)CollUtil.getFirst(executeItemPOList);
            if (itemPO == null) continue;
            itemHisBO.setExecuteStatus(null);
            BeanUtil.copyProperties((Object)itemHisBO, (Object)itemPO);
            itemPO.setYqdhrq(itemHisBO.getYqdhrq());
            itemPO.setBudgetMoney(itemHisBO.getYsje());
            if (itemHisBO.getYsje() != null && itemHisBO.getSl() != null) {
                BigDecimal budgetPrice = itemHisBO.getYsje().divide(itemHisBO.getSl(), 2, 4);
                itemPO.setBudgetPrice(budgetPrice);
            }
            this.executeItemMapper.updateByPrimaryKeySelective(itemPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveFailExecuteLog(UpdateExecuteItemStatusReqBO reqBO, Long executeId, String status, int dealResult, String failRemark) {
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.FINISH);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(status);
        executePhaseReqBO.setRemark(failRemark);
        EnquiryLogReqBO enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(null).allOperLogReqBO(null).build();
        BaseAllOperLogRspBO logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO);
        if (!"0000".equals(logRspBO.getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    private void saveFailExecuteItemLog(UpdateExecuteItemStatusReqBO reqBO, List<Long> executeItemIdList, String status, int dealResult, String failRemark) {
        EnquiryLogReqBO enquiryLogReqBO;
        BaseAllOperLogRspBO logRspBO;
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.FOUR);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(status);
        demanderPhaseReqBO.setRemark(failRemark);
        BaseAllOperLogReqBO allOperLogReqBO = null;
        if (dealResult == 2) {
            allOperLogReqBO = new BaseAllOperLogReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)allOperLogReqBO);
            allOperLogReqBO.setOperateBusiEnum(EnquiryEnumConstant.AllOperateBusiEnum.TYPE1801);
            allOperLogReqBO.setExecuteItemIdList(executeItemIdList);
        }
        if (!"0000".equals((logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(null).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(allOperLogReqBO).build())).getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }
}

