/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyItemHisBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemRspBO;
import com.tydic.enquiry.api.bo.EnquiryLaunchClarifyPlanDetailIdBO;
import com.tydic.enquiry.api.bo.EnquiryLaunchClarifyReqBO;
import com.tydic.enquiry.api.bo.EnquiryLaunchClarifyRspBO;
import com.tydic.enquiry.api.bo.UpdateClarifyItemReqBO;
import com.tydic.enquiry.busi.api.EnquiryExecuteItemBusiService;
import com.tydic.enquiry.busi.api.EnquiryLaunchClarifyBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.BillFileInfoMapper;
import com.tydic.enquiry.dao.ClarifyInfoMapper;
import com.tydic.enquiry.dao.ClarifyItemHisMapper;
import com.tydic.enquiry.dao.ClarifyItemMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.BillFileInfoPO;
import com.tydic.enquiry.dao.po.ClarifyInfoPO;
import com.tydic.enquiry.dao.po.ClarifyItemHisPO;
import com.tydic.enquiry.dao.po.ClarifyItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryLaunchClarifyBusiServiceImpl
implements EnquiryLaunchClarifyBusiService {
    @Autowired
    private ClarifyInfoMapper clarifyInfoMapper;
    @Autowired
    private ClarifyItemMapper clarifyItemMapper;
    @Autowired
    private BillFileInfoMapper billFileInfoMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private ClarifyItemHisMapper clarifyItemHisMapper;
    @Autowired
    private EnquiryExecuteItemBusiService enquiryExecuteItemBusiService;

    @Override
    public EnquiryLaunchClarifyRspBO addLaunchClarify(EnquiryLaunchClarifyReqBO enquiryLaunchClarifyReqBO) {
        EnquiryLaunchClarifyRspBO rspBO = new EnquiryLaunchClarifyRspBO();
        ClarifyInfoPO clarifyInfoPO = new ClarifyInfoPO();
        BeanUtils.copyProperties((Object)enquiryLaunchClarifyReqBO, (Object)clarifyInfoPO);
        clarifyInfoPO.setClarifyId(Sequence.getInstance().nextId());
        clarifyInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        clarifyInfoPO.setClarifyStatus(EnquiryConstant.clarifyStatus.WAITREPLY);
        clarifyInfoPO.setClarifyType(EnquiryConstant.clarifyType.CLARIFY);
        clarifyInfoPO.setCreateTime(new Date());
        clarifyInfoPO.setCreateUserId(String.valueOf(enquiryLaunchClarifyReqBO.getUserId()));
        clarifyInfoPO.setCreateUserName(enquiryLaunchClarifyReqBO.getName());
        clarifyInfoPO.setCreateOrgId(String.valueOf(enquiryLaunchClarifyReqBO.getOrgId()));
        clarifyInfoPO.setCreateOrgName(enquiryLaunchClarifyReqBO.getOrgName());
        this.clarifyInfoMapper.insert(clarifyInfoPO);
        if (!CollectionUtils.isEmpty((Collection)enquiryLaunchClarifyReqBO.getFileInfoBOList())) {
            ArrayList<BasFileInfoPO> list = new ArrayList<BasFileInfoPO>();
            ArrayList<BillFileInfoPO> billFileInfoPOS = new ArrayList<BillFileInfoPO>();
            for (EnquiryBasFileInfoBO bo : enquiryLaunchClarifyReqBO.getFileInfoBOList()) {
                BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
                BeanUtils.copyProperties((Object)bo, (Object)basFileInfoPO);
                basFileInfoPO.setFileinfoId(Sequence.getInstance().nextId());
                basFileInfoPO.setCreateId(enquiryLaunchClarifyReqBO.getMemIdIn());
                basFileInfoPO.setCreateName(enquiryLaunchClarifyReqBO.getName());
                basFileInfoPO.setCreateTime(new Date());
                list.add(basFileInfoPO);
                BillFileInfoPO billFileInfoPO = new BillFileInfoPO();
                billFileInfoPO.setBillFileinfoId(Sequence.getInstance().nextId());
                billFileInfoPO.setBillId(clarifyInfoPO.getClarifyId());
                billFileInfoPO.setFileinfoId(basFileInfoPO.getFileinfoId());
                billFileInfoPO.setCreateTime(new Date());
                billFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                basFileInfoPO.setCreateName(enquiryLaunchClarifyReqBO.getName());
                basFileInfoPO.setCreateId(enquiryLaunchClarifyReqBO.getMemIdIn());
                billFileInfoPOS.add(billFileInfoPO);
            }
            this.basFileInfoMapper.insertBatch(list);
            this.billFileInfoMapper.insertBatch(billFileInfoPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)enquiryLaunchClarifyReqBO.getPlanDetailIdBOList())) {
            ArrayList<ClarifyItemPO> itemPOList = new ArrayList<ClarifyItemPO>();
            ArrayList<EnquiryClarifyItemHisBO> afterItemList = new ArrayList<EnquiryClarifyItemHisBO>();
            for (EnquiryLaunchClarifyPlanDetailIdBO planDetailIdBO : enquiryLaunchClarifyReqBO.getPlanDetailIdBOList()) {
                ClarifyItemPO itemPO = new ClarifyItemPO();
                itemPO.setClarifyItemId(Sequence.getInstance().nextId());
                itemPO.setClarifyId(clarifyInfoPO.getClarifyId());
                itemPO.setPlanDetailId(planDetailIdBO.getBeforeExecuteItemBO().getPlanItemId());
                itemPOList.add(itemPO);
                ClarifyItemHisPO hisPO = new ClarifyItemHisPO();
                EnquiryClarifyItemHisBO beforeExecuteItemBO = planDetailIdBO.getBeforeExecuteItemBO();
                hisPO = (ClarifyItemHisPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)beforeExecuteItemBO), ClarifyItemHisPO.class);
                hisPO.setPlanItemHistId(Sequence.getInstance().nextId());
                String versionId = this.getVersionId(itemPO.getPlanDetailId());
                hisPO.setVersion(versionId);
                hisPO.setClarifyItemId(itemPO.getClarifyItemId());
                hisPO.setCreateTime(new Date());
                this.clarifyItemHisMapper.insert(hisPO);
                if (!CollectionUtils.isEmpty((Collection)beforeExecuteItemBO.getFileInfoBOList())) {
                    this.saveAnnex(beforeExecuteItemBO.getFileInfoBOList(), hisPO.getPlanItemHistId());
                }
                EnquiryClarifyItemHisBO afterExecuteItemBO = planDetailIdBO.getAfterExecuteItemBO();
                ClarifyItemHisPO after = new ClarifyItemHisPO();
                after = (ClarifyItemHisPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)afterExecuteItemBO), ClarifyItemHisPO.class);
                after.setPlanItemHistId(Sequence.getInstance().nextId());
                after.setClarifyItemId(itemPO.getClarifyItemId());
                after.setCreateTime(new Date());
                after.setVersion(versionId);
                this.clarifyItemHisMapper.insert(after);
                if (!CollectionUtils.isEmpty((Collection)afterExecuteItemBO.getFileInfoBOList())) {
                    this.saveAnnex(afterExecuteItemBO.getFileInfoBOList(), after.getPlanItemHistId());
                }
                afterItemList.add(afterExecuteItemBO);
            }
            this.clarifyItemMapper.insertBatch(itemPOList);
            UpdateClarifyItemReqBO updateClarifyItemReqBO = new UpdateClarifyItemReqBO();
            BeanUtil.copyProperties((Object)enquiryLaunchClarifyReqBO, (Object)updateClarifyItemReqBO);
            updateClarifyItemReqBO.setAfterItemList(afterItemList);
            EnquiryExecuteItemRspBO executeItemRspBO = this.enquiryExecuteItemBusiService.updateClarifyPlanItem(updateClarifyItemReqBO);
            if (!"0000".equals(executeItemRspBO.getRespCode())) {
                throw new BusinessException("8888", executeItemRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getVersionId(Long planDetailId) {
        ClarifyItemHisPO clarifyItemHisPO = new ClarifyItemHisPO();
        clarifyItemHisPO.setPlanItemId(planDetailId);
        List<ClarifyItemHisPO> qryList = this.clarifyItemHisMapper.getQryList(clarifyItemHisPO);
        if (CollectionUtils.isEmpty(qryList)) {
            return "1";
        }
        String version = qryList.get(0).getVersion();
        int i = Integer.parseInt(version) + 1;
        return String.valueOf(i);
    }

    private void saveAnnex(List<EnquiryBasFileInfoBO> fileInfoBOList, Long planItemHistId) {
        ArrayList<BasFileInfoPO> basFileInfoPOS = new ArrayList<BasFileInfoPO>();
        for (EnquiryBasFileInfoBO fileInfoBO : fileInfoBOList) {
            BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
            BeanUtils.copyProperties((Object)fileInfoBO, (Object)basFileInfoPO);
            basFileInfoPO.setFileinfoId(Sequence.getInstance().nextId());
            basFileInfoPO.setRelateId(planItemHistId);
            basFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            basFileInfoPOS.add(basFileInfoPO);
        }
        this.basFileInfoMapper.insertBatch(basFileInfoPOS);
    }
}

