/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyInfoBO;
import com.tydic.enquiry.api.bo.EnquiryConfirmBO;
import com.tydic.enquiry.api.bo.EnquiryConfirmPlanItemBO;
import com.tydic.enquiry.api.bo.EnquiryConfirmSupplierBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmItemPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmResultRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmReviewReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeDeatilRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeQueryReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeRspBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemListBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteQuotePlanItemBO;
import com.tydic.enquiry.api.bo.EnquiryPrintClarifyReqBO;
import com.tydic.enquiry.api.bo.EnquiryPrintClarifyRspBO;
import com.tydic.enquiry.api.bo.EnquiryQryClarifyInfoReqBO;
import com.tydic.enquiry.api.bo.EnquiryQryClarifyInfoRspBO;
import com.tydic.enquiry.api.bo.EnquiryQuateTotalBO;
import com.tydic.enquiry.api.bo.EnquirySupplierQuoteItemBO;
import com.tydic.enquiry.api.bo.EnquirySupplierQuoteItemPageRspBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteBillBo;
import com.tydic.enquiry.busi.api.EnquiryDealConfirmDetailBusiService;
import com.tydic.enquiry.busi.api.EnquiryDealNoticeBusiService;
import com.tydic.enquiry.busi.api.EnquiryPdfPrintBusiService;
import com.tydic.enquiry.busi.api.EnquiryQueryClarifyInfoBusiService;
import com.tydic.enquiry.busi.utils.PdfUtil;
import com.tydic.enquiry.busi.utils.WatermarkInfoBO;
import com.tydic.enquiry.common.EnquiryReqBO;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ProjectInfoMapper;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ProjectInfoPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EnquiryPdfPrintBusiServiceImpl
implements EnquiryPdfPrintBusiService {
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "enquiry";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    EnquiryDealNoticeBusiService enquiryDealNoticeBusiService;
    @Autowired
    EnquiryDealConfirmDetailBusiService enquiryDealConfirmDetailBusiService;
    @Autowired
    ExecuteBillMapper executeBillMapper;
    @Autowired
    ProjectInfoMapper projectInfoMapper;
    @Autowired
    private EnquiryQueryClarifyInfoBusiService queryClarifyInfoBusiService;

    @Override
    public EnquiryDealNoticeRspBO printNoticeDetail(EnquiryDealNoticeQueryReqBO reqBO) {
        EnquiryDealNoticeDeatilRspBO noticeDeatilRspBO = this.enquiryDealNoticeBusiService.queryNoticeDetail(reqBO);
        if (!"0000".equals(noticeDeatilRspBO.getRespCode())) {
            throw new BusinessException("8888", noticeDeatilRspBO.getRespDesc());
        }
        EnquiryDealConfirmItemPageRspBO quoteItemPageRspBO = this.enquiryDealNoticeBusiService.queryNoticeQuoteItemList(reqBO);
        noticeDeatilRspBO.setQuotePlanItemList(quoteItemPageRspBO.getRows());
        EnquiryDealNoticeRspBO rspBO = new EnquiryDealNoticeRspBO();
        if (!"0000".equals(noticeDeatilRspBO.getRespCode())) {
            throw new BusinessException("8888", noticeDeatilRspBO.getRespDesc());
        }
        String fileExportUrl = this.doGenerateNotePdf(noticeDeatilRspBO, (EnquiryReqBO)reqBO);
        rspBO.setNoticePrintUrl(fileExportUrl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u4e66\u6253\u5370\u6210\u529f\uff01");
        return rspBO;
    }

    @Override
    public EnquiryDealConfirmRspBO printConfirmResultList(EnquiryDealConfirmReviewReqBO reqBO) {
        EnquiryDealConfirmResultRspBO enquiryDealConfirmResultRspBO = this.enquiryDealConfirmDetailBusiService.queryConfirmResultList(reqBO);
        if (!"0000".equals(enquiryDealConfirmResultRspBO.getRespCode())) {
            throw new BusinessException("8888", enquiryDealConfirmResultRspBO.getRespDesc());
        }
        EnquiryConfirmBO confirmBO = enquiryDealConfirmResultRspBO.getConfirmBO();
        ExecuteBillPO ExecuteBillPO2 = this.executeBillMapper.selectByPrimaryKey(confirmBO.getExecuteId());
        PurchaseExecuteBillBo executeBillBO = new PurchaseExecuteBillBo();
        BeanUtil.copyProperties((Object)ExecuteBillPO2, (Object)executeBillBO);
        EnquiryCommonUtil.transExecuteBillBO(executeBillBO);
        if (!StringUtils.isEmpty((Object)ExecuteBillPO2.getProjectIdJson())) {
            List projectIdList = JSONObject.parseArray((String)ExecuteBillPO2.getProjectIdJson(), Long.class);
            ProjectInfoPO qryProjectInfoPO = new ProjectInfoPO();
            qryProjectInfoPO.setProjectIdList(projectIdList);
            List<ProjectInfoPO> projectInfoPOList = this.projectInfoMapper.selectListPageByCondition(qryProjectInfoPO);
            if (!CollectionUtils.isEmpty(projectInfoPOList)) {
                ArrayList<String> projectNameList = new ArrayList<String>();
                for (ProjectInfoPO projectInfoPO : projectInfoPOList) {
                    projectNameList.add(projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName());
                }
                executeBillBO.setProjectNameList(projectNameList);
            }
        }
        enquiryDealConfirmResultRspBO.setExecuteBillBO(executeBillBO);
        EnquiryDealConfirmRspBO rspBO = new EnquiryDealConfirmRspBO();
        String fileExportUrl = this.doGenerateConfirmPdf(enquiryDealConfirmResultRspBO, (EnquiryReqBO)reqBO);
        rspBO.setConfirmResultUrl(fileExportUrl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u786e\u8ba4\u7ed3\u679c\u6253\u5370\u6210\u529f\uff01");
        return rspBO;
    }

    @Override
    public EnquiryPrintClarifyRspBO printClarify(EnquiryPrintClarifyReqBO reqBO) {
        EnquiryPrintClarifyRspBO rspBO = new EnquiryPrintClarifyRspBO();
        EnquiryQryClarifyInfoReqBO clarifyInfoReqBO = new EnquiryQryClarifyInfoReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)clarifyInfoReqBO);
        clarifyInfoReqBO.setType(Integer.valueOf(2));
        EnquiryQryClarifyInfoRspBO clarifyInfoRspBO = this.queryClarifyInfoBusiService.qryClarifyInfo(clarifyInfoReqBO);
        String fileExportUrl = this.doGenerateClarifyPdf(clarifyInfoRspBO, (EnquiryReqBO)reqBO);
        rspBO.setClarifyInfoPrintUrl(fileExportUrl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6f84\u6e05\u8be6\u7ec6\u6253\u5370\u6210\u529f\uff01");
        return rspBO;
    }

    private String doGenerateNotePdf(EnquiryDealNoticeDeatilRspBO noticeDeatilRspBO, EnquiryReqBO reqBO) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font contentItemFont = new Font(baseFont, 6.0f, 0);
        int COLUMNS = 41;
        String orgType = reqBO.getIsProfessionalOrgExt();
        if ("2".equals(orgType)) {
            COLUMNS -= 2;
        }
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getUserName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u4e8c\u6b21\u8bae\u4ef7\u901a\u77e5\u5355", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable1);
        PdfUtil.addCellToTable(pdfPTable1, "\u786e\u8ba4\u901a\u77e5\u540d\u79f0\uff1a" + this.getValueStr(noticeDeatilRspBO.getDealNoticeName()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u786e\u8ba4\u901a\u77e5\u7f16\u53f7\uff1a" + this.getValueStr(noticeDeatilRspBO.getDealNoticeCode()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u786e\u8ba4\u901a\u77e5\u72b6\u6001\uff1a" + this.getValueStr(noticeDeatilRspBO.getDealBillStatusStr()), contentFont, 0, 5, Float.valueOf(15.0f), 13, 0);
        PdfPTable pdfPTable2 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "\u4f9b\u5e94\u5546\uff1a" + this.getValueStr(noticeDeatilRspBO.getSupplierName()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable2, "\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\uff1a" + this.getValueStr(noticeDeatilRspBO.getSupplierContactsName()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable2, "\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd\uff1a" + this.getValueStr(noticeDeatilRspBO.getSupplierContactsMobile()), contentFont, 0, 5, Float.valueOf(15.0f), 13, 0);
        PdfPTable pdfPTable3 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u786e\u8ba4\u901a\u77e5\u751f\u6210\u65f6\u95f4\uff1a" + this.getValueStr(noticeDeatilRspBO.getCreateTime()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable3, "\u4f9b\u5e94\u5546\u4e0a\u67b6\u5468\u671f\uff08\u5929\uff09\uff1a" + this.getValueStr(noticeDeatilRspBO.getPutShelfDays()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable3, null, contentFont, 0, 5, Float.valueOf(15.0f), 13, 0);
        PdfPTable pdfPTable4 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u786e\u8ba4\u4eba\uff1a" + this.getValueStr(noticeDeatilRspBO.getDealUserName()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable4, "\u786e\u8ba4\u65f6\u95f4\uff1a" + this.getValueStr(noticeDeatilRspBO.getDealCreateTime()), contentFont, 0, 5, Float.valueOf(15.0f), 14, 0);
        PdfUtil.addCellToTable(pdfPTable4, null, contentFont, 0, 5, Float.valueOf(15.0f), 13, 0);
        PdfPTable pdfPTable5 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable5);
        PdfUtil.addCellToTable(pdfPTable5, null, contentFont, 0, 5, Float.valueOf(20.0f), COLUMNS, 0);
        List totalList = noticeDeatilRspBO.getQuoteTotalList();
        if (CollUtil.isNotEmpty((Collection)totalList)) {
            PdfPTable pdfPTable6 = new PdfPTable(COLUMNS);
            tableList.add(pdfPTable6);
            PdfUtil.addCellToTable(pdfPTable6, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(20.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u4f9b\u5e94\u5546\u540d\u79f0", contentFont, 0, 5, Float.valueOf(20.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u786e\u8ba4\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(20.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6210\u4ea4\u660e\u7ec6\u6570", contentFont, 0, 5, Float.valueOf(20.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6210\u4ea4\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(20.0f), 5, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u62a5\u4ef7\u65f6\u95f4", contentFont, 0, 5, Float.valueOf(20.0f), 5, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(20.0f), 4, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", contentFont, 0, 5, Float.valueOf(20.0f), 5, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd", contentFont, 0, 5, Float.valueOf(20.0f), 5, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u786e\u8ba4\u901a\u77e5\u65f6\u95f4", contentFont, 0, 5, Float.valueOf(20.0f), 5, null);
            int count = 1;
            for (EnquiryQuateTotalBO totalBO : totalList) {
                PdfPTable pdfPTable7 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable7);
                PdfUtil.addCellToTable(pdfPTable7, String.valueOf(count), contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getSupplierName()), contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDealTypeStr()), contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getQuoteItemNum()), contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDealMoney()), contentFont, 0, 5, Float.valueOf(40.0f), 5, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getQuoteTime()), contentFont, 0, 5, Float.valueOf(40.0f), 5, null);
                PdfUtil.addCellToTable(pdfPTable7, "\u8ba2\u5355\u751f\u6548\u540e" + this.getValueStr(totalBO.getPromiseDeliveryDays()) + "\u5929", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getSupplierContactsName()), contentFont, 0, 5, Float.valueOf(40.0f), 5, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getSupplierContactsMobile()), contentFont, 0, 5, Float.valueOf(40.0f), 5, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDealCreateTime()), contentFont, 0, 5, Float.valueOf(40.0f), 5, null);
                ++count;
            }
        }
        PdfPTable pdfPTable8 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable8);
        PdfUtil.addCellToTable(pdfPTable8, null, contentFont, 0, 5, Float.valueOf(20.0f), COLUMNS, 0);
        List quateItemList = noticeDeatilRspBO.getQuotePlanItemList();
        if (CollUtil.isNotEmpty((Collection)quateItemList)) {
            PdfPTable pdfPTable9 = new PdfPTable(COLUMNS);
            tableList.add(pdfPTable9);
            PdfUtil.addCellToTable(pdfPTable9, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u4e0a\u67b6\u72b6\u6001", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6709\u6548\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u603b\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u54c1\u724c", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u751f\u4ea7\u5382\u5bb6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5916\u90e8\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u534f\u8bae\u660e\u7ec6\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "upc\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            if (!"2".equals(orgType)) {
                PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u91d1\u989d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            }
            PdfUtil.addCellToTable(pdfPTable9, "\u4ea4\u8d27\u671f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6267\u884c\u6807\u51c6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5305\u88c5\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u5468\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5176\u4ed6\u6280\u672f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            if (!"2".equals(orgType)) {
                PdfUtil.addCellToTable(pdfPTable9, "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            }
            PdfUtil.addCellToTable(pdfPTable9, "\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u53c2\u8003\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6700\u9ad8\u9650\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u5e93\u5b58", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8ba2\u5355\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            int count = 1;
            for (EnquiryExecuteQuotePlanItemBO quoteItemBo : quateItemList) {
                PdfPTable pdfPTable10 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable10);
                PdfUtil.addCellToTable(pdfPTable10, String.valueOf(count), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getPutSelfStatus()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getQuotedEffTime()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getPromiseDeliveryDaysName()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getWlmc()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getGgxh()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getQuoteNumbers()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getQuotePrice()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getQuoteMoney()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getWxflName()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getWlbhName()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getBrand()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getJhmxbh()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getManufacturer()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getProductModelAndOther()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getProductCode()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getOutsideProductCode()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getAgreementItemCode()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getUpcCode()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getSl()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getBudgetPrice()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                if (!"2".equals(orgType)) {
                    PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getBudgetMoney()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                }
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getYqdhrq()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getZxbz()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getZzsmc()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getAqdj()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getZbdj()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getDsfjczmName()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getBzfsName()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getPtfwName()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getZbzq()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getQtjsyq()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                if (!"2".equals(orgType)) {
                    PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getLscgdj()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                }
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getBz()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getCkspbm()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getBzkmlmc()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getZgxj()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getAqkc()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getJhzq()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable10, this.getValueStr(quoteItemBo.getDw()), contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                String orderNoStr = "-";
                if (quoteItemBo.getOrderNoList() != null) {
                    orderNoStr = CollUtil.join((Iterable)quoteItemBo.getOrderNoList(), (CharSequence)",");
                }
                PdfUtil.addCellToTable(pdfPTable10, orderNoStr, contentItemFont, 0, 5, Float.valueOf(100.0f), 1, null);
                ++count;
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u4e8c\u6b21\u8bae\u4ef7\u6210\u4ea4\u901a\u77e5\u4e66\u5bfc\u51fa.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String doGenerateConfirmPdf(EnquiryDealConfirmResultRspBO confirmResultRspBO, EnquiryReqBO reqBO) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        int COLUMNS = 20;
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getUserName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u4e8c\u6b21\u8bae\u4ef7\u8bae\u4ef7\u5355", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(20);
        tableList.add(pdfPTable1);
        PurchaseExecuteBillBo executeBillBO = confirmResultRspBO.getExecuteBillBO();
        PdfUtil.addCellToTable(pdfPTable1, "\u8bae\u4ef7\u5355\u7f16\u53f7\uff1a" + this.getValueStr(executeBillBO.getExecuteCode()), contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u8bae\u4ef7\u5355\u540d\u79f0\uff1a" + this.getValueStr(executeBillBO.getExecuteName()), contentFont, 0, 5, Float.valueOf(15.0f), 8, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u5355\u636e\u72b6\u6001\uff1a" + this.getValueStr(executeBillBO.getExecuteStatusName()), contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfPTable pdfPTable2 = new PdfPTable(20);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a" + this.getValueStr(executeBillBO.getQuoteStartTime()) + "-" + this.getValueStr(executeBillBO.getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfUtil.addCellToTable(pdfPTable2, "\u8bae\u4ef7\u6b21\u6570\uff1a" + this.getValueStr(executeBillBO.getExecuteRound()), contentFont, 0, 5, Float.valueOf(15.0f), 8, 0);
        List projectNameList = executeBillBO.getProjectNameList();
        if (CollUtil.isNotEmpty((Collection)projectNameList)) {
            for (int i = 0; i < projectNameList.size(); ++i) {
                PdfPTable pdfPTable21;
                if (i == 0) {
                    pdfPTable21 = new PdfPTable(20);
                    tableList.add(pdfPTable21);
                    PdfUtil.addCellToTable(pdfPTable21, "\u9879\u76ee\uff1a" + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), 20, 0);
                    continue;
                }
                pdfPTable21 = new PdfPTable(20);
                tableList.add(pdfPTable21);
                PdfUtil.addCellToTable(pdfPTable21, "             " + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), 20, 0);
            }
        }
        PdfPTable pdfPTable3 = new PdfPTable(20);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u4f9b\u5e94\u5546\u4e0a\u67b6\u5468\u671f\uff08\u5929\uff09\uff1a" + this.getValueStr(executeBillBO.getPutShelfDays()), contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfUtil.addCellToTable(pdfPTable3, "\u7ed3\u7b97\u5e01\u79cd\uff1a" + this.getValueStr(executeBillBO.getAccountCurrencyName()), contentFont, 0, 5, Float.valueOf(15.0f), 8, 0);
        PdfUtil.addCellToTable(pdfPTable3, null, contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfPTable pdfPTable31 = new PdfPTable(20);
        tableList.add(pdfPTable31);
        PdfUtil.addCellToTable(pdfPTable3, "\u63d0\u793a\uff1a\u751f\u6210\u786e\u8ba4\u901a\u77e5\u548c\u540e\u4f9b\u5e94\u5546\u9700\u5728\u6b64\u65f6\u95f4\u5185\u5b8c\u6210\u5546\u54c1\u5339\u914d\u6ca1\u5426\u5219\u9700\u91cd\u65b0\u9009\u5b9a\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(15.0f), 20, 0);
        PdfPTable pdfPTable4 = new PdfPTable(20);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u786e\u8ba4\u65b9\u5f0f\uff1a" + this.getValueStr(executeBillBO.getConfirmDealTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), 20, 0);
        PdfPTable pdfPTable41 = new PdfPTable(20);
        tableList.add(pdfPTable41);
        PdfUtil.addCellToTable(pdfPTable41, EnquiryCommonUtil.getConfirmDealTypeTip(executeBillBO.getConfirmDealType()), contentFont, 0, 5, Float.valueOf(30.0f), 20, 0);
        PdfPTable pdfPTable5 = new PdfPTable(20);
        tableList.add(pdfPTable5);
        PdfUtil.addCellToTable(pdfPTable5, "\u9884\u7b97\u4fe1\u606f\u662f\u5426\u516c\u5e03\uff1a" + this.getValueStr(executeBillBO.getPublishBudgetFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfUtil.addCellToTable(pdfPTable5, "\u8bae\u4ef7\u6d3b\u52a8\u6700\u5c11\u62a5\u4ef7\u5bb6\u6570\uff1a" + this.getValueStr(executeBillBO.getLeastQuoteNumber()), contentFont, 0, 5, Float.valueOf(15.0f), 8, 0);
        PdfUtil.addCellToTable(pdfPTable5, null, contentFont, 0, 5, Float.valueOf(15.0f), 6, 0);
        PdfPTable pdfPTable6 = new PdfPTable(20);
        tableList.add(pdfPTable6);
        PdfUtil.addCellToTable(pdfPTable6, null, contentFont, 0, 5, Float.valueOf(20.0f), 20, 0);
        List planItemList = confirmResultRspBO.getConfirmPlanItemBOList();
        if (CollUtil.isNotEmpty((Collection)planItemList)) {
            for (EnquiryConfirmPlanItemBO planItemBO : planItemList) {
                PdfPTable pdfPTable7 = new PdfPTable(20);
                tableList.add(pdfPTable7);
                PdfUtil.addCellToTable(pdfPTable7, "\u786e\u8ba4\u5ba1\u6838\u5355\u7f16\u53f7\uff1a" + this.getValueStr(planItemBO.getDealConfirmReviewCode()), contentFont, 0, 5, Float.valueOf(20.0f), 15, 0);
                PdfUtil.addCellToTable(pdfPTable7, "\u786e\u8ba4\u5ba1\u6838\u5355\u72b6\u6001\uff1a" + this.getValueStr(planItemBO.getDealConfirmStatusStr()), contentFont, 0, 5, Float.valueOf(20.0f), 5, 0);
                PdfPTable pdfPTable8 = new PdfPTable(20);
                tableList.add(pdfPTable8);
                PdfUtil.addCellToTable(pdfPTable8, "\u8ba1\u5212\u540d\u79f0\uff1a" + this.getValueStr(planItemBO.getJhmc()), contentFont, 0, 5, Float.valueOf(15.0f), 5, 0);
                PdfUtil.addCellToTable(pdfPTable8, "\u8ba1\u5212\u7f16\u53f7\uff1a" + this.getValueStr(planItemBO.getZxlsjhbh()), contentFont, 0, 5, Float.valueOf(15.0f), 5, 0);
                PdfUtil.addCellToTable(pdfPTable8, "\u9700\u6c42\u5355\u4f4d\uff1a" + this.getValueStr(planItemBO.getXqdw()), contentFont, 0, 5, Float.valueOf(15.0f), 5, 0);
                PdfUtil.addCellToTable(pdfPTable8, "\u6210\u4ea4\u603b\u91d1\u989d\uff1a" + this.getValueStr(planItemBO.getTotalMoney()) + "\u5143", contentFont, 0, 5, Float.valueOf(15.0f), 5, 0);
                List supplierItemList = planItemBO.getConfirmPlanItemBOList();
                EnquirySupplierQuoteItemPageRspBO failItemList = planItemBO.getFailQuoteItemPageRspBO();
                if (CollUtil.isNotEmpty((Collection)supplierItemList)) {
                    PdfPTable pdfPTable9 = new PdfPTable(20);
                    tableList.add(pdfPTable9);
                    for (EnquiryConfirmSupplierBO supplierBO : supplierItemList) {
                        EnquirySupplierQuoteItemPageRspBO supplierQuoteItemPageRspBO = supplierBO.getSupplierQuoteItemPageRspBO();
                        if (supplierQuoteItemPageRspBO != null) {
                            PdfUtil.addCellToTable(pdfPTable9, "\u4f9b\u5e94\u5546\uff1a" + this.getValueStr(supplierBO.getSupplierName()), contentFont, 0, 5, Float.valueOf(15.0f), 8, null);
                            PdfUtil.addCellToTable(pdfPTable9, "\u6210\u4ea4\u6761\u6570\uff1a" + this.getValueStr(supplierBO.getConfirmNum()), contentFont, 0, 5, Float.valueOf(15.0f), 6, null);
                            PdfUtil.addCellToTable(pdfPTable9, "\u6210\u4ea4\u91d1\u989d\uff1a" + this.getValueStr(supplierBO.getConfirmMoney()), contentFont, 0, 5, Float.valueOf(15.0f), 6, null);
                            PdfPTable pdfPTable10 = new PdfPTable(20);
                            tableList.add(pdfPTable10);
                            PdfUtil.addCellToTable(pdfPTable10, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u6210\u4ea4\u6570\u91cf", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u6210\u4ea4\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u9884\u7b97\u603b\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u6210\u4ea4\u603b\u4ef7", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            PdfUtil.addCellToTable(pdfPTable10, "\u786e\u8ba4\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                            List quateItemList = supplierQuoteItemPageRspBO.getRows();
                            for (EnquirySupplierQuoteItemBO quoteItemBo : quateItemList) {
                                PdfPTable pdfPTable11 = new PdfPTable(20);
                                tableList.add(pdfPTable11);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWlbh()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuoteNumbers()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, "\u8ba2\u5355\u751f\u6548\u540e" + this.getValueStr(quoteItemBo.getPromiseDeliveryDays()) + "\u5929", contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuotePrice()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBudgetMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuoteMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBz()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                            }
                        }
                        PdfPTable pdfPTable16 = new PdfPTable(20);
                        tableList.add(pdfPTable16);
                        PdfUtil.addCellToTable(pdfPTable16, null, contentFont, 0, 5, Float.valueOf(20.0f), 20, 0);
                    }
                }
                if (!CollUtil.isNotEmpty((Collection)failItemList.getRows())) continue;
                PdfPTable pdfPTable12 = new PdfPTable(20);
                tableList.add(pdfPTable12);
                PdfUtil.addCellToTable(pdfPTable12, "\u8bae\u4ef7\u5931\u8d25", contentFont, 0, 5, Float.valueOf(15.0f), 20, null);
                PdfPTable pdfPTable13 = new PdfPTable(20);
                tableList.add(pdfPTable13);
                PdfUtil.addCellToTable(pdfPTable13, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u6210\u4ea4\u6570\u91cf", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u6210\u4ea4\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u9884\u7b97\u603b\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u6210\u4ea4\u603b\u4ef7", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable13, "\u786e\u8ba4\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(30.0f), 2, null);
                List quateItemList = failItemList.getRows();
                for (EnquirySupplierQuoteItemBO quoteItemBo : quateItemList) {
                    PdfPTable pdfPTable14 = new PdfPTable(20);
                    tableList.add(pdfPTable14);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(quoteItemBo.getWlmc()), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(quoteItemBo.getWlbh()), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(quoteItemBo.getJhmxbh()), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(0), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(null), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(null), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(null), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(null), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(null), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable14, this.getValueStr(quoteItemBo.getBz()), contentFont, 0, 5, Float.valueOf(60.0f), 2, null);
                }
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u4e8c\u6b21\u8bae\u4ef7\u8bae\u4ef7\u5355\u5bfc\u51fa.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String doGenerateClarifyPdf(EnquiryQryClarifyInfoRspBO clarifyInfoRspBO, EnquiryReqBO reqBO) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font title2Font = new Font(baseFont, 10.0f, 0);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        int COLUMNS = 31;
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getUserName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u6f84\u6e05\u4fe1\u606f", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(31);
        tableList.add(pdfPTable1);
        EnquiryClarifyInfoBO clarifyInfoBO = clarifyInfoRspBO.getClarifyInfoBO();
        PdfUtil.addCellToTable(pdfPTable1, "\u6f84\u6e05\u540d\u79f0\uff1a" + this.getValueStr(clarifyInfoBO.getClarifyName()), contentFont, 0, 5, Float.valueOf(15.0f), 15, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u6f84\u6e05\u5185\u5bb9\uff1a" + this.getValueStr(clarifyInfoBO.getClarifyContent()), contentFont, 0, 5, Float.valueOf(15.0f), 16, 0);
        PdfPTable titleTable2 = new PdfPTable(1);
        tableList.add(titleTable2);
        PdfUtil.addCellToTable(titleTable2, "\u9644\u4ef6\u4fe1\u606f", title2Font, 0, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable2 = new PdfPTable(31);
        tableList.add(pdfPTable2);
        List fileInfoBOList = clarifyInfoBO.getFileInfoBOList();
        String fileNames = null;
        if (CollUtil.isNotEmpty((Collection)fileInfoBOList)) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (EnquiryBasFileInfoBO fileInfoBO : fileInfoBOList) {
                fileNameList.add(fileInfoBO.getFileName());
            }
            fileNames = CollUtil.join(fileNameList, (CharSequence)",");
        }
        PdfUtil.addCellToTable(pdfPTable2, "\u6587\u4ef6\uff1a" + this.getValueStr(fileNames), contentFont, 0, 5, Float.valueOf(15.0f), 31, 0);
        PdfPTable titleTable3 = new PdfPTable(1);
        tableList.add(titleTable3);
        PdfUtil.addCellToTable(titleTable3, "\u660e\u7ec6\u53d8\u66f4\u4fe1\u606f", title2Font, 0, 5, Float.valueOf(40.0f), 1, 0);
        List executeItemBOList = clarifyInfoRspBO.getExecuteItemBOList();
        if (CollUtil.isNotEmpty((Collection)executeItemBOList)) {
            int count = 1;
            PdfPTable pdfPTable9 = new PdfPTable(31);
            tableList.add(pdfPTable9);
            PdfUtil.addCellToTable(pdfPTable9, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u53d8\u66f4\u8bb0\u5f55", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u914d\u9001\u5730\u5740", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6267\u884c\u6807\u51c6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5305\u88c5\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u5468\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5176\u4ed6\u6280\u672f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u91d1\u989d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u53c2\u8003\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6700\u9ad8\u9650\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u5e93\u5b58", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6709\u6548\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable9, "\u9644\u4ef6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
            for (EnquiryExecuteItemListBO executeItemListBO : executeItemBOList) {
                LinkedList<EnquiryExecuteItemBO> ExecuteItemListBO = new LinkedList<EnquiryExecuteItemBO>();
                EnquiryExecuteItemBO beforeExecuteItemBO = executeItemListBO.getBeforeExecuteItemBO();
                EnquiryExecuteItemBO afterExecuteItemBO = executeItemListBO.getAfterExecuteItemBO();
                if (afterExecuteItemBO != null) {
                    afterExecuteItemBO.setUpdateType("\u53d8\u66f4\u540e");
                    ExecuteItemListBO.add(afterExecuteItemBO);
                }
                if (beforeExecuteItemBO != null) {
                    beforeExecuteItemBO.setUpdateType("\u53d8\u66f4\u524d");
                    ExecuteItemListBO.add(beforeExecuteItemBO);
                }
                PdfPTable pdfPTable4 = new PdfPTable(31);
                tableList.add(pdfPTable4);
                PdfUtil.addCellToTable(pdfPTable4, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null, 2);
                PdfUtil.addCellToTable(pdfPTable4, this.getValueStr(executeItemListBO.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null, 2);
                int inNum = 29;
                PdfPTable pdfPTable5 = new PdfPTable(inNum);
                for (EnquiryExecuteItemBO executeItemBO : ExecuteItemListBO) {
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getUpdateType()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getWxfl()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getWlbh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getDw()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getDistributionAddress()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getZxbz()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getZzsmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getAqdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getZbdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getDsfjczmName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getBzfsName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getPtfwName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getZbzq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getQtjsyq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getLscgdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getBudgetMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getBz()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getCkspbm()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getBzkmlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getZgxj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getAqkc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getJhzq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getDw()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable5, this.getValueStr(executeItemBO.getQuotedEffTime()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    String attStrs = "-";
                    List itemFileList = executeItemBO.getFileInfoBOList();
                    if (CollUtil.isNotEmpty((Collection)itemFileList)) {
                        ArrayList<String> fileNameList = new ArrayList<String>();
                        for (EnquiryBasFileInfoBO fileInfoBO : itemFileList) {
                            fileNameList.add(fileInfoBO.getFileName());
                        }
                        attStrs = CollUtil.join(fileNameList, (CharSequence)",");
                    }
                    PdfUtil.addCellToTable(pdfPTable5, attStrs, contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                }
                PdfPCell mergeCell = new PdfPCell(pdfPTable5);
                mergeCell.setColspan(inNum);
                pdfPTable4.addCell(mergeCell);
                ++count;
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u6f84\u6e05\u4fe1\u606f\u5bfc\u51fa.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private void doAddTextWatermark(PdfWriter pdfWriter, String userName) {
        ArrayList<WatermarkInfoBO> watermarkInfoList = new ArrayList<WatermarkInfoBO>();
        WatermarkInfoBO watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u65f6\u95f4\uff1a" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        watermarkInfoBO.setX(300.0f);
        watermarkInfoBO.setY(310.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u4eba\uff1a" + userName);
        watermarkInfoBO.setX(320.0f);
        watermarkInfoBO.setY(270.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u7f51\u5740\uff1awww.cnncmall.com");
        watermarkInfoBO.setX(340.0f);
        watermarkInfoBO.setY(230.0f);
        watermarkInfoBO.setRotation(30.0f);
        PdfUtil.addTextWatermark(pdfWriter, watermarkInfoList, 0.5f, 0, BaseColor.GRAY, null, 20.0f);
    }

    private String getValueStr(Object valObj) {
        String valStr = "-";
        if (valObj != null) {
            if (valObj instanceof Date) {
                return DateUtil.format((Date)((Date)valObj), (String)"yyyy-MM-dd HH:mm:ss");
            }
            return valObj.toString();
        }
        return valStr;
    }
}

