/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyInfoBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemListBO;
import com.tydic.enquiry.api.bo.EnquiryQryClarifyInfoReqBO;
import com.tydic.enquiry.api.bo.EnquiryQryClarifyInfoRspBO;
import com.tydic.enquiry.busi.api.EnquiryQueryClarifyInfoBusiService;
import com.tydic.enquiry.busi.impl.QueryPurchaseExecuteItemListBusiServiceImpl;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.BillFileInfoMapper;
import com.tydic.enquiry.dao.ClarifyInfoMapper;
import com.tydic.enquiry.dao.ClarifyItemHisMapper;
import com.tydic.enquiry.dao.ClarifyItemMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.BillFileInfoPO;
import com.tydic.enquiry.dao.po.ClarifyInfoPO;
import com.tydic.enquiry.dao.po.ClarifyItemHisPO;
import com.tydic.enquiry.dao.po.ClarifyItemPO;
import com.tydic.order.extend.constant.PebExtConstant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EnquiryQueryClarifyInfoBusiServiceImpl
implements EnquiryQueryClarifyInfoBusiService {
    @Autowired
    private ClarifyInfoMapper clarifyInfoMapper;
    @Autowired
    private BillFileInfoMapper billFileInfoMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private ClarifyItemMapper clarifyItemMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private ClarifyItemHisMapper clarifyItemHisMapper;
    @Autowired
    private QueryPurchaseExecuteItemListBusiServiceImpl queryPurchaseExecuteItemListBusiService;

    @Override
    public EnquiryQryClarifyInfoRspBO qryClarifyInfo(EnquiryQryClarifyInfoReqBO qryClarifyInfoReqBO) {
        EnquiryQryClarifyInfoRspBO rspBO = new EnquiryQryClarifyInfoRspBO();
        ClarifyInfoPO clarifyInfoPO = this.clarifyInfoMapper.selectByPrimaryKey(qryClarifyInfoReqBO.getClarifyId());
        EnquiryClarifyInfoBO infoBO = new EnquiryClarifyInfoBO();
        BeanUtils.copyProperties((Object)clarifyInfoPO, (Object)infoBO);
        this.buildAnnex(infoBO);
        if (qryClarifyInfoReqBO.getType().equals(2)) {
            this.buildExecuteItem(qryClarifyInfoReqBO, rspBO, clarifyInfoPO);
        }
        rspBO.setClarifyInfoBO(infoBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildAnnex(EnquiryClarifyInfoBO bo) {
        BillFileInfoPO billFileInfoPO = new BillFileInfoPO();
        ArrayList<EnquiryBasFileInfoBO> fileInfoBOList = new ArrayList<EnquiryBasFileInfoBO>();
        billFileInfoPO.setBillId(bo.getClarifyId());
        List<BillFileInfoPO> billFileInfoPOS = this.billFileInfoMapper.qryFileInfoList(billFileInfoPO);
        if (!CollectionUtils.isEmpty(billFileInfoPOS)) {
            for (BillFileInfoPO po : billFileInfoPOS) {
                BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
                basFileInfoPO.setFileinfoId(po.getFileinfoId());
                BasFileInfoPO fileInfoPO = this.basFileInfoMapper.selectByContidion(basFileInfoPO);
                EnquiryBasFileInfoBO fileInfoBO = new EnquiryBasFileInfoBO();
                BeanUtils.copyProperties((Object)fileInfoPO, (Object)fileInfoBO);
                fileInfoBOList.add(fileInfoBO);
            }
            bo.setFileInfoBOList(fileInfoBOList);
        }
    }

    private void buildExecuteItem(EnquiryQryClarifyInfoReqBO qryClarifyInfoReqBO, EnquiryQryClarifyInfoRspBO rspBO, ClarifyInfoPO clarifyInfoPO) {
        ArrayList<EnquiryExecuteItemListBO> executeItemList = new ArrayList<EnquiryExecuteItemListBO>();
        ClarifyItemPO clarifyItemPO = new ClarifyItemPO();
        clarifyItemPO.setClarifyId(clarifyInfoPO.getClarifyId());
        List<ClarifyItemPO> clarifyItemList = this.clarifyItemMapper.getClarifyItemList(clarifyItemPO);
        if (!CollectionUtils.isEmpty(clarifyItemList)) {
            Long executeId = clarifyInfoPO.getExecuteId();
            Byte publishBudgetFlag = this.queryPurchaseExecuteItemListBusiService.getPublishFlag(executeId, qryClarifyInfoReqBO.getIsProfessionalOrgExt());
            for (ClarifyItemPO itemPO : clarifyItemList) {
                EnquiryExecuteItemListBO itemListBO = new EnquiryExecuteItemListBO();
                ClarifyItemHisPO clarifyItemHisPO = new ClarifyItemHisPO();
                clarifyItemHisPO.setPlanItemId(itemPO.getPlanDetailId());
                clarifyItemHisPO.setClarifyItemId(itemPO.getClarifyItemId());
                List<ClarifyItemHisPO> hisPOList = this.clarifyItemHisMapper.getQryList(clarifyItemHisPO);
                if (CollectionUtils.isEmpty(clarifyItemList)) continue;
                List collect = hisPOList.stream().map(item -> {
                    EnquiryExecuteItemBO bo = new EnquiryExecuteItemBO();
                    BeanUtils.copyProperties((Object)item, (Object)bo);
                    if (publishBudgetFlag == 0) {
                        bo.setBudgetPrice("*");
                        bo.setBudgetMoney("*");
                        bo.setYsje("*");
                    }
                    if (item.getDsfjczm() != null) {
                        bo.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)((Object)item.getDsfjczm())));
                    }
                    if (item.getPtfw() != null) {
                        bo.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)((Object)item.getPtfw())));
                    }
                    bo.setBzfsName(EnquiryCommonUtil.getBzfsName(item.getBzfs()));
                    bo.setDemanderOrgId(item.getDemandOrgId());
                    bo.setDemanderOrgName(item.getDemandOrgName());
                    bo.setWlbhName(item.getWlbhStr());
                    bo.setWxflName(item.getWxflStr());
                    bo.setZxlsjhbh(item.getZxlsjhbh());
                    if (!StringUtils.isEmpty((Object)item.getWxfl()) && !StringUtils.isEmpty((Object)item.getWxflStr())) {
                        bo.setWxflDescribe(item.getWxfl() + "-" + item.getWxflStr());
                    }
                    if (!StringUtils.isEmpty((Object)item.getWlbh()) && !StringUtils.isEmpty((Object)item.getWlbhStr())) {
                        bo.setWlbhDescribe(item.getWlbh() + "-" + item.getWlbhStr());
                    }
                    if (!StringUtils.isEmpty((Object)item.getJhmc()) && !StringUtils.isEmpty((Object)item.getZxlsjhbh())) {
                        bo.setPlanDescribe(item.getZxlsjhbh() + "-" + item.getJhmc());
                    }
                    if (!StringUtils.isEmpty((Object)item.getProjectCode()) && !StringUtils.isEmpty((Object)item.getProjectName())) {
                        bo.setProject(item.getProjectCode() + "-" + item.getProjectName());
                    }
                    if (item.getQuotedEffTime() != null) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String quotedEffectiveTime = format.format(item.getQuotedEffTime());
                        bo.setQuotedEffectiveTime(quotedEffectiveTime);
                    }
                    return bo;
                }).collect(Collectors.toList());
                itemListBO.setAfterExecuteItemBO((EnquiryExecuteItemBO)collect.get(1));
                itemListBO.setBeforeExecuteItemBO((EnquiryExecuteItemBO)collect.get(0));
                itemListBO.setJhmxbh(((EnquiryExecuteItemBO)collect.get(0)).getJhmxbh());
                executeItemList.add(itemListBO);
            }
        }
        rspBO.setExecuteItemBOList(executeItemList);
    }

    private void buildExecuteItemAnnex(EnquiryExecuteItemBO itemBO) {
        BasFileInfoPO record = new BasFileInfoPO();
        record.setRelateId(itemBO.getExecuteItemId());
        List<BasFileInfoPO> basFileInfoPOS = this.basFileInfoMapper.selectFileInfoList(record);
        List collect = basFileInfoPOS.stream().map(item -> {
            EnquiryBasFileInfoBO basFileInfoBO = new EnquiryBasFileInfoBO();
            BeanUtils.copyProperties((Object)item, (Object)basFileInfoBO);
            return basFileInfoBO;
        }).collect(Collectors.toList());
        itemBO.setFileInfoBOList(collect);
    }
}

