/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyItemHisBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemRspBO;
import com.tydic.enquiry.api.bo.EnquiryLaunchClarifyPlanDetailIdBO;
import com.tydic.enquiry.api.bo.EnquiryReplyClarifyReqBO;
import com.tydic.enquiry.api.bo.EnquiryReplyClarifyRspBO;
import com.tydic.enquiry.api.bo.UpdateClarifyItemReqBO;
import com.tydic.enquiry.busi.api.EnquiryExecuteItemBusiService;
import com.tydic.enquiry.busi.api.EnquiryReplyClarifyBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.BillFileInfoMapper;
import com.tydic.enquiry.dao.ClarifyInfoMapper;
import com.tydic.enquiry.dao.ClarifyItemHisMapper;
import com.tydic.enquiry.dao.ClarifyItemMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.BillFileInfoPO;
import com.tydic.enquiry.dao.po.ClarifyInfoPO;
import com.tydic.enquiry.dao.po.ClarifyItemHisPO;
import com.tydic.enquiry.dao.po.ClarifyItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryReplyClarifyBusiServiceImpl
implements EnquiryReplyClarifyBusiService {
    @Autowired
    private ClarifyInfoMapper clarifyInfoMapper;
    @Autowired
    private BillFileInfoMapper billFileInfoMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private ClarifyItemMapper clarifyItemMapper;
    @Autowired
    private ClarifyItemHisMapper clarifyItemHisMapper;
    @Autowired
    private EnquiryExecuteItemBusiService enquiryExecuteItemBusiService;

    @Override
    public EnquiryReplyClarifyRspBO replyClarify(EnquiryReplyClarifyReqBO replyClarifyReqBO) {
        EnquiryReplyClarifyRspBO rspBO = new EnquiryReplyClarifyRspBO();
        ClarifyInfoPO clarifyInfoPO = new ClarifyInfoPO();
        Date date = new Date();
        clarifyInfoPO.setClarifyId(Sequence.getInstance().nextId());
        clarifyInfoPO.setReplyClarifyId(replyClarifyReqBO.getClarifyId());
        clarifyInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        clarifyInfoPO.setClarifyName(replyClarifyReqBO.getClarifyName());
        clarifyInfoPO.setClarifyContent(replyClarifyReqBO.getClarifyContent());
        clarifyInfoPO.setCreateTime(date);
        clarifyInfoPO.setClarifyType(EnquiryConstant.clarifyType.ANSWER);
        clarifyInfoPO.setCreateUserId(String.valueOf(replyClarifyReqBO.getUserId()));
        clarifyInfoPO.setCreateUserName(replyClarifyReqBO.getName());
        clarifyInfoPO.setCreateOrgId(String.valueOf(replyClarifyReqBO.getOrgId()));
        clarifyInfoPO.setCreateOrgName(replyClarifyReqBO.getOrgName());
        clarifyInfoPO.setCreateType(replyClarifyReqBO.getCreateType());
        try {
            this.clarifyInfoMapper.insert(clarifyInfoPO);
            if (!CollectionUtils.isEmpty((Collection)replyClarifyReqBO.getFileInfoBOList())) {
                ArrayList<BasFileInfoPO> list = new ArrayList<BasFileInfoPO>();
                ArrayList<BillFileInfoPO> billFileInfoPOS = new ArrayList<BillFileInfoPO>();
                for (EnquiryBasFileInfoBO bo : replyClarifyReqBO.getFileInfoBOList()) {
                    BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
                    BeanUtils.copyProperties((Object)bo, (Object)basFileInfoPO);
                    basFileInfoPO.setFileinfoId(Sequence.getInstance().nextId());
                    basFileInfoPO.setCreateId(replyClarifyReqBO.getMemIdIn());
                    basFileInfoPO.setCreateName(replyClarifyReqBO.getName());
                    basFileInfoPO.setCreateTime(new Date());
                    list.add(basFileInfoPO);
                    BillFileInfoPO billFileInfoPO = new BillFileInfoPO();
                    billFileInfoPO.setBillFileinfoId(Sequence.getInstance().nextId());
                    billFileInfoPO.setBillId(clarifyInfoPO.getClarifyId());
                    billFileInfoPO.setFileinfoId(basFileInfoPO.getFileinfoId());
                    billFileInfoPO.setCreateTime(new Date());
                    basFileInfoPO.setCreateName(replyClarifyReqBO.getName());
                    basFileInfoPO.setCreateId(replyClarifyReqBO.getMemIdIn());
                    billFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                    billFileInfoPOS.add(billFileInfoPO);
                }
                this.basFileInfoMapper.insertBatch(list);
                this.billFileInfoMapper.insertBatch(billFileInfoPOS);
            }
            ClarifyInfoPO record = new ClarifyInfoPO();
            record.setReplyClarifyId(clarifyInfoPO.getClarifyId());
            record.setClarifyStatus(EnquiryConstant.clarifyStatus.REPLIED);
            record.setClarifyId(replyClarifyReqBO.getClarifyId());
            record.setClarifyTime(date);
            this.clarifyInfoMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u56de\u590d\u6f84\u6e05\u5f02\u5e38\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)replyClarifyReqBO.getPlanDetailIdBOList()) && !"2".equals(replyClarifyReqBO.getIsProfessionalOrgExt())) {
            ArrayList<ClarifyItemPO> itemPOList = new ArrayList<ClarifyItemPO>();
            ArrayList<EnquiryClarifyItemHisBO> afterItemList = new ArrayList<EnquiryClarifyItemHisBO>();
            for (EnquiryLaunchClarifyPlanDetailIdBO planDetailIdBO : replyClarifyReqBO.getPlanDetailIdBOList()) {
                ClarifyItemPO itemPO = new ClarifyItemPO();
                itemPO.setClarifyItemId(Sequence.getInstance().nextId());
                itemPO.setClarifyId(clarifyInfoPO.getClarifyId());
                itemPO.setPlanDetailId(planDetailIdBO.getBeforeExecuteItemBO().getPlanItemId());
                itemPOList.add(itemPO);
                EnquiryClarifyItemHisBO beforeExecuteItemBO = planDetailIdBO.getBeforeExecuteItemBO();
                ClarifyItemHisPO hisPO = new ClarifyItemHisPO();
                BeanUtils.copyProperties((Object)beforeExecuteItemBO, (Object)hisPO);
                hisPO.setPlanItemHistId(Sequence.getInstance().nextId());
                String versionId = this.getVersionId(itemPO.getPlanDetailId());
                hisPO.setVersion(versionId);
                hisPO.setClarifyItemId(itemPO.getClarifyItemId());
                hisPO.setCreateTime(new Date());
                this.clarifyItemHisMapper.insert(hisPO);
                this.saveAnnex(beforeExecuteItemBO.getFileInfoBOList(), hisPO.getPlanItemHistId());
                EnquiryClarifyItemHisBO afterExecuteItemBO = planDetailIdBO.getAfterExecuteItemBO();
                ClarifyItemHisPO after = new ClarifyItemHisPO();
                BeanUtils.copyProperties((Object)afterExecuteItemBO, (Object)after);
                after.setPlanItemHistId(Sequence.getInstance().nextId());
                after.setClarifyItemId(itemPO.getClarifyItemId());
                after.setCreateTime(new Date());
                after.setVersion(versionId);
                this.clarifyItemHisMapper.insert(after);
                this.saveAnnex(afterExecuteItemBO.getFileInfoBOList(), after.getPlanItemHistId());
                afterItemList.add(afterExecuteItemBO);
            }
            this.clarifyItemMapper.insertBatch(itemPOList);
            UpdateClarifyItemReqBO updateClarifyItemReqBO = new UpdateClarifyItemReqBO();
            BeanUtil.copyProperties((Object)replyClarifyReqBO, (Object)updateClarifyItemReqBO);
            updateClarifyItemReqBO.setAfterItemList(afterItemList);
            EnquiryExecuteItemRspBO executeItemRspBO = this.enquiryExecuteItemBusiService.updateClarifyPlanItem(updateClarifyItemReqBO);
            if (!"0000".equals(executeItemRspBO.getRespCode())) {
                throw new BusinessException("8888", executeItemRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getVersionId(Long planDetailId) {
        ClarifyItemHisPO clarifyItemHisPO = new ClarifyItemHisPO();
        clarifyItemHisPO.setPlanItemId(planDetailId);
        List<ClarifyItemHisPO> qryList = this.clarifyItemHisMapper.getQryList(clarifyItemHisPO);
        if (CollectionUtils.isEmpty(qryList)) {
            return "1";
        }
        String version = qryList.get(0).getVersion();
        int i = Integer.parseInt(version) + 1;
        return String.valueOf(i);
    }

    private void saveAnnex(List<EnquiryBasFileInfoBO> fileInfoBOList, Long planItemHistId) {
        ArrayList<BasFileInfoPO> basFileInfoPOS = new ArrayList<BasFileInfoPO>();
        if (CollUtil.isNotEmpty(fileInfoBOList)) {
            for (EnquiryBasFileInfoBO fileInfoBO : fileInfoBOList) {
                BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
                BeanUtils.copyProperties((Object)fileInfoBO, (Object)basFileInfoPO);
                basFileInfoPO.setFileinfoId(Sequence.getInstance().nextId());
                basFileInfoPO.setRelateId(planItemHistId);
                basFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                basFileInfoPOS.add(basFileInfoPO);
            }
            this.basFileInfoMapper.insertBatch(basFileInfoPOS);
        }
    }
}

