/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.tydic.enquiry.api.bo.GetDealNoticeRedisNoReqBO;
import com.tydic.enquiry.api.bo.GetDealNoticeRedisNoRspBO;
import com.tydic.enquiry.api.bo.GetQuotationBillRedisNoReqBO;
import com.tydic.enquiry.api.bo.GetQuotationBillRedisNoRspBO;
import com.tydic.enquiry.busi.api.GetQuotationBillRedisNoBusiService;
import com.tydic.enquiry.dao.DealNoticeMapper;
import com.tydic.enquiry.dao.DealNoticeMatchMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.SupQuoteItemMidMapper;
import com.tydic.enquiry.dao.po.DealNoticeMatchPO;
import com.tydic.enquiry.dao.po.DealNoticePO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.SupQuoteItemMidPO;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetQuotationBillRedisNoBusiServiceImpl
implements GetQuotationBillRedisNoBusiService {
    @Autowired
    private SupQuoteItemMidMapper supQuoteItemMidMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private DealNoticeMatchMapper dealNoticeMatchMapper;
    @Autowired
    private DealNoticeMapper dealNoticeMapper;

    @Override
    public GetQuotationBillRedisNoRspBO getRedisNo(GetQuotationBillRedisNoReqBO reqBO) {
        GetQuotationBillRedisNoRspBO rspBO = new GetQuotationBillRedisNoRspBO();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        Date now = new Date();
        if (!"2003".equals(executeBillPO.getExecuteStatus()) || executeBillPO.getQuoteEndTime().before(now) || executeBillPO.getQuoteStartTime().after(now)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u72b6\u6001\u4e0d\u5728\u62a5\u4ef7\u4e2d\u6216\u4e0d\u5728\u62a5\u4ef7\u65f6\u95f4\u5185!");
            return rspBO;
        }
        SupQuoteItemMidPO supQuoteItemMidPO = new SupQuoteItemMidPO();
        supQuoteItemMidPO.setQuoteId(reqBO.getQuoteId());
        supQuoteItemMidPO.setExecuteId(reqBO.getExecuteId());
        this.supQuoteItemMidMapper.deleteByCondition(supQuoteItemMidPO);
        String redisNo = UUID.randomUUID().toString();
        rspBO.setRedisNo(redisNo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public GetDealNoticeRedisNoRspBO getDealNoticeRedisNo(GetDealNoticeRedisNoReqBO reqBO) {
        GetDealNoticeRedisNoRspBO rspBO = new GetDealNoticeRedisNoRspBO();
        DealNoticePO dealNoticePO = this.dealNoticeMapper.selectByPrimaryKey(reqBO.getDealNoticeId());
        if (dealNoticePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        DealNoticeMatchPO dealNoticeMatchPO = new DealNoticeMatchPO();
        dealNoticeMatchPO.setDealNoticeId(reqBO.getDealNoticeId());
        this.dealNoticeMatchMapper.deleteByCondition(dealNoticeMatchPO);
        String redisNo = UUID.randomUUID().toString();
        rspBO.setRedisNo(redisNo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

