/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.AuthorityInfo;
import com.tydic.enquiry.api.bo.BaseAllOperLogReqBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogRspBO;
import com.tydic.enquiry.api.bo.BasePhaseReqBO;
import com.tydic.enquiry.api.bo.EnquiryLogReqBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalListQueryReqBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalListQueryRspBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalQueryReqBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalQueryRspBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalReqBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteApprovalRspBO;
import com.tydic.enquiry.busi.api.BaseAllOperLogBusiService;
import com.tydic.enquiry.busi.api.EnquiryActiveAuditOperateService;
import com.tydic.enquiry.busi.api.PurchaseExecuteApprovalBusiService;
import com.tydic.enquiry.busi.api.bo.AuditCreateReqBO;
import com.tydic.enquiry.busi.api.bo.AuditCreateRspBO;
import com.tydic.enquiry.busi.api.bo.InvokeAuditReqBO;
import com.tydic.enquiry.busi.api.bo.InvokeAuditRspBO;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.BasHoliDayMapper;
import com.tydic.enquiry.dao.ExecuteApprovalMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.PurchaseApprovalConfigureMapper;
import com.tydic.enquiry.dao.PurchaseApprovalExceptionMapper;
import com.tydic.enquiry.dao.po.BasHoliDayPO;
import com.tydic.enquiry.dao.po.ExecuteApprovalPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.PurchaseApprovalConfigurePO;
import com.tydic.enquiry.dao.po.PurchaseApprovalExceptionPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.uac.util.GenerateIdUtil;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseExecuteApprovalBusiServiceImpl
implements PurchaseExecuteApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseExecuteApprovalBusiServiceImpl.class);
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private PurchaseApprovalExceptionMapper purchaseApprovalExceptionMapper;
    @Autowired
    private PurchaseApprovalConfigureMapper purchaseApprovalConfigureMapper;
    @Autowired
    private ExecuteApprovalMapper executeApprovalMapper;
    @Autowired
    ExecuteItemMapper executeItemMapper;
    @Autowired
    ExecuteBillMapper executeBillMapper;
    @Autowired
    BasHoliDayMapper basHoliDayMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    EnquiryActiveAuditOperateService enquiryActiveAuditOperateService;
    @Autowired
    private BaseAllOperLogBusiService baseAllOperLogBusiService;

    @Override
    public PurchaseExecuteApprovalRspBO saveExecuteApprovalInfo(PurchaseExecuteApprovalReqBO reqBO) {
        PurchaseExecuteApprovalRspBO busiRspBO = new PurchaseExecuteApprovalRspBO();
        if (reqBO.getIsNeedApproval() != null && reqBO.getIsNeedApproval() == 0) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u9700\u8981\u5ba1\u6279");
            return busiRspBO;
        }
        Long executeId = reqBO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        if (executeBillPO == null || !"2001".equals(executeBillPO.getExecuteStatus()) && !"2011".equals(executeBillPO.getExecuteStatus())) {
            log.error("\u6267\u884c\u5355id\uff1a" + executeId + ";\u6267\u884c\u5355\u72b6\u6001\u4e3a\uff1a" + (executeBillPO != null ? executeBillPO.getExecuteStatus() : "null"));
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01");
            return busiRspBO;
        }
        if (reqBO.getIsOperatApproval() == null || reqBO.getIsOperatApproval() != 1 || "0".equals(reqBO.getIsProfessionalOrgExt())) {
            PurchaseApprovalConfigurePO purchaseApprovalConfigurePO = new PurchaseApprovalConfigurePO();
            purchaseApprovalConfigurePO.setCode("executeApproval");
            List<PurchaseApprovalConfigurePO> configurePOList = this.purchaseApprovalConfigureMapper.qryList(purchaseApprovalConfigurePO);
            PurchaseApprovalConfigurePO configurePO = new PurchaseApprovalConfigurePO();
            int isApproval = 0;
            if (CollUtil.isNotEmpty(configurePOList)) {
                configurePO = (PurchaseApprovalConfigurePO)CollUtil.getFirst(configurePOList);
                isApproval = configurePO.getIsApproval().intValue();
            }
            if (isApproval != 1) {
                this.dealExecuteFinish(executeBillPO);
                busiRspBO.setIsApproval("0");
                busiRspBO.setRespCode("0000");
                busiRspBO.setRespDesc("\u4e0d\u9700\u8981\u8d70\u5ba1\u6279\uff01");
                return busiRspBO;
            }
            String executeOrgId = executeBillPO.getExecuteOrgId();
            PurchaseApprovalExceptionPO record = new PurchaseApprovalExceptionPO();
            record.setApprovalId(configurePO.getApprovalId());
            List<PurchaseApprovalExceptionPO> exceptionPOList = this.purchaseApprovalExceptionMapper.qryList(record);
            if (CollUtil.isNotEmpty(exceptionPOList)) {
                for (PurchaseApprovalExceptionPO purchaseApprovalExceptionPO : exceptionPOList) {
                    if (purchaseApprovalExceptionPO.getUnitId() == null || !executeOrgId.equals(purchaseApprovalExceptionPO.getUnitId().toString()) || purchaseApprovalExceptionPO.getIsApproval() != null && purchaseApprovalExceptionPO.getIsApproval() == 1) continue;
                    this.dealExecuteFinish(executeBillPO);
                    busiRspBO.setIsApproval("0");
                    busiRspBO.setRespCode("0000");
                    busiRspBO.setRespDesc("\u4e0d\u9700\u8981\u8d70\u5ba1\u6279\uff01");
                    return busiRspBO;
                }
            }
        }
        this.saveConfirmReview(reqBO, executeBillPO);
        ExecuteBillPO updateExecuteBillPO = new ExecuteBillPO();
        updateExecuteBillPO.setExecuteId(executeId);
        updateExecuteBillPO.setExecuteStatus("2002");
        this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        ExecuteItemPO qryExecuteItemPO = new ExecuteItemPO();
        qryExecuteItemPO.setExecuteId(executeId);
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(qryExecuteItemPO);
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            executeItemIdList.add(executeItemPO.getExecuteItemId());
        }
        this.saveExecuteBillLog(reqBO, executeId, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode(), 1);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fdd\u5b58\u5ba1\u6279\u5355\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public PurchaseExecuteApprovalListQueryRspBO queryList(PurchaseExecuteApprovalListQueryReqBO reqBO) {
        PurchaseExecuteApprovalListQueryRspBO busiRspBO = new PurchaseExecuteApprovalListQueryRspBO();
        ArrayList<PurchaseExecuteApprovalBO> rows = new ArrayList<PurchaseExecuteApprovalBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        ExecuteApprovalPO qryExecuteApprovalPO = new ExecuteApprovalPO();
        BeanUtil.copyProperties((Object)reqBO, (Object)qryExecuteApprovalPO);
        if (reqBO.getTabId() != null && reqBO.getTabId() == 1) {
            int checkUserType = this.checkUserType(reqBO.getPermission());
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("1");
            statusList.add("3");
            qryExecuteApprovalPO.setApprovalStatusList(statusList);
            if (checkUserType == 1) {
                qryExecuteApprovalPO.setCheckExecuteOrgId(String.valueOf(reqBO.getOrgId()));
                qryExecuteApprovalPO.setCheckUserType(checkUserType);
            } else if (checkUserType == 3) {
                qryExecuteApprovalPO.setExecuteDepartId(String.valueOf(reqBO.getCompanyId()));
            } else {
                qryExecuteApprovalPO.setExecuteOrgId(String.valueOf(reqBO.getOrgId()));
            }
        } else {
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("2");
            statusList.add("5");
            statusList.add("4");
            qryExecuteApprovalPO.setApprovalStatusList(statusList);
            qryExecuteApprovalPO.setApprovalUserId(reqBO.getUserId().toString());
            if ("1".equals(reqBO.getExecuteStatus())) {
                qryExecuteApprovalPO.setApprovalResult("1");
            } else if ("2".equals(reqBO.getExecuteStatus())) {
                qryExecuteApprovalPO.setApprovalResult("2");
            }
        }
        qryExecuteApprovalPO.setOrderBy("create_time DESC");
        qryExecuteApprovalPO.setCreateUserName(reqBO.getCreateUser());
        List<ExecuteApprovalPO> executeApprovalPOList = this.executeApprovalMapper.getListPage((Page<ExecuteApprovalPO>)page, qryExecuteApprovalPO);
        if (CollUtil.isEmpty(executeApprovalPOList)) {
            busiRspBO.setRows(rows);
            busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        for (ExecuteApprovalPO executeApprovalPO : executeApprovalPOList) {
            PurchaseExecuteApprovalBO newBO = new PurchaseExecuteApprovalBO();
            BeanUtil.copyProperties((Object)executeApprovalPO, (Object)newBO);
            if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getExecuteType())) {
                newBO.setExecuteTypeName(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)executeApprovalPO.getExecuteType()));
            }
            if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getApprovalStatus())) {
                newBO.setApprovalStatusName(EnquiryEnumConstant.ExecuteApprovalStatusEnum.getDesc((String)executeApprovalPO.getApprovalStatus()));
                if ("2".equals(executeApprovalPO.getApprovalStatus()) && "2".equals(executeApprovalPO.getApprovalResult())) {
                    newBO.setApprovalStatusName(EnquiryEnumConstant.ExecuteApprovalStatusEnum.FAIL_APPROVAL.getDesc());
                }
                if ("4".equals(executeApprovalPO.getApprovalStatus()) && "2".equals(executeApprovalPO.getApprovalResult())) {
                    newBO.setApprovalStatusName(EnquiryEnumConstant.ExecuteApprovalStatusEnum.FAIL_OPERATION_APPROVAL.getDesc());
                }
            }
            if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getApprovalResult())) {
                newBO.setApprovalResultName(EnquiryEnumConstant.ApprovalResultEnum.getDesc((String)executeApprovalPO.getApprovalResult()));
            }
            rows.add(newBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5ba1\u6279\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public PurchaseExecuteApprovalQueryRspBO queryExecuteApprovalDetail(PurchaseExecuteApprovalQueryReqBO reqBO) {
        PurchaseExecuteApprovalQueryRspBO busiRspBO = new PurchaseExecuteApprovalQueryRspBO();
        if (reqBO == null || reqBO.getExecuteApprovalId() == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        ExecuteApprovalPO executeApprovalPO = this.executeApprovalMapper.selectByPrimaryKey(reqBO.getExecuteApprovalId());
        if (executeApprovalPO == null) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        BeanUtil.copyProperties((Object)executeApprovalPO, (Object)busiRspBO);
        if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getExecuteType())) {
            busiRspBO.setExecuteTypeName(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)executeApprovalPO.getExecuteType()));
        }
        if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getApprovalStatus())) {
            busiRspBO.setApprovalStatusName(EnquiryEnumConstant.ExecuteApprovalStatusEnum.getDesc((String)executeApprovalPO.getApprovalStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getApprovalResult())) {
            busiRspBO.setApprovalResultName(EnquiryEnumConstant.ApprovalResultEnum.getDesc((String)executeApprovalPO.getApprovalResult()));
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5ba1\u6279\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public PurchaseExecuteApprovalRspBO dealExecuteApproval(PurchaseExecuteApprovalReqBO reqBO) {
        PurchaseExecuteApprovalRspBO busiRspBO = new PurchaseExecuteApprovalRspBO();
        if (reqBO.getUserId() == null) {
            throw new BusinessException("8888", "\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        }
        if (reqBO.getExecuteApprovalId() == null) {
            throw new BusinessException("8888", "\u6267\u884c\u5355\u5ba1\u6279id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getExecuteId() == null) {
            throw new BusinessException("8888", "\u6267\u884c\u5355id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getApprovalResult() == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long executeApprovalId = reqBO.getExecuteApprovalId();
        ExecuteApprovalPO executeApprovalPO = this.executeApprovalMapper.selectByPrimaryKey(executeApprovalId);
        if (executeApprovalPO == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (executeApprovalPO.getApprovalStatus() == null || !executeApprovalPO.getApprovalStatus().equals("1") && !executeApprovalPO.getApprovalStatus().equals("3")) {
            throw new BusinessException("8888", "\u5ba1\u6279\u4e0d\u4e3a\u5f85\u5ba1\u6279\uff0c\u4e0d\u53ef\u4ee5\u63d0\u4ea4\u5ba1\u6279");
        }
        Long executeId = reqBO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        if (executeBillPO == null) {
            throw new BusinessException("8888", "\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (!"2002".equals(executeBillPO.getExecuteStatus())) {
            throw new BusinessException("8888", "\u6267\u884c\u5355\u4e0d\u4e3a\u5ba1\u6279\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u63d0\u4ea4\u5ba1\u6279");
        }
        this.checkUserType(reqBO.getPermission());
        Integer auditObjType = EnquiryConstant.AuditObjType.EXECUTE_APPROVAL;
        if (!StringUtils.isEmpty((CharSequence)executeApprovalPO.getStepId())) {
            auditObjType = Integer.valueOf(executeApprovalPO.getStepId());
        }
        InvokeAuditRspBO auditRspBO = this.dealAuditOrder(reqBO, executeApprovalId, auditObjType);
        Boolean finishFlag = auditRspBO.getAuditFinishMap().get(executeApprovalId);
        log.info("finishFlag=" + finishFlag);
        log.info("executeApprovalPO.getStepId()=" + executeApprovalPO.getStepId());
        log.info("executeApprovalPO.getStepId().equals(EnquiryConstant.AuditObjType.OPERATION_EXECUTE_APPROVAL.toString())=" + executeApprovalPO.getStepId().equals(EnquiryConstant.AuditObjType.OPERATION_EXECUTE_APPROVAL.toString()));
        if (finishFlag.booleanValue() && executeApprovalPO.getStepId() != null && executeApprovalPO.getStepId().equals(EnquiryConstant.AuditObjType.OPERATION_EXECUTE_APPROVAL.toString())) {
            this.dealExecuteApproval(reqBO, executeApprovalPO, executeBillPO);
        } else if (finishFlag.booleanValue() && executeApprovalPO.getStepId() != null && executeApprovalPO.getStepId().equals(EnquiryConstant.AuditObjType.EXECUTE_OPERATION_APPROVAL.toString())) {
            this.dealOperatApprovalFinish(reqBO, executeApprovalPO, executeBillPO);
        } else if (finishFlag.booleanValue()) {
            this.dealExecuteApprovalFinish(reqBO, executeApprovalPO, executeBillPO);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5ba1\u6279\u6210\u529f\uff01");
        return busiRspBO;
    }

    private InvokeAuditRspBO dealAuditOrder(PurchaseExecuteApprovalReqBO reqBO, Long executeApprovalId, Integer auditObjType) {
        InvokeAuditReqBO invokeAuditReqBO = new InvokeAuditReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)invokeAuditReqBO));
        if (reqBO.getApprovalResult() == 1) {
            invokeAuditReqBO.setAuditResult(0);
        } else {
            invokeAuditReqBO.setAuditResult(1);
        }
        invokeAuditReqBO.setAuditAdvice(reqBO.getRemarks());
        invokeAuditReqBO.setObjIds(new HashSet<Long>(Collections.singleton(executeApprovalId)));
        invokeAuditReqBO.setObjType(auditObjType);
        InvokeAuditRspBO auditRspBO = this.enquiryActiveAuditOperateService.dealAuditOrder(invokeAuditReqBO);
        log.info("\u5ba1\u6279\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)((Object)auditRspBO)));
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new BusinessException("8888", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void saveConfirmReview(PurchaseExecuteApprovalReqBO reqBO, ExecuteBillPO executeBillPO) {
        Long executeApprovalId = this.idUtil.nextId();
        ExecuteApprovalPO executeApprovalPO = new ExecuteApprovalPO();
        executeApprovalPO.setExecuteType(executeBillPO.getExecuteType());
        executeApprovalPO.setExecuteCode(executeBillPO.getExecuteCode());
        executeApprovalPO.setExecuteName(executeBillPO.getExecuteName());
        executeApprovalPO.setExecuteId(executeBillPO.getExecuteId());
        executeApprovalPO.setExecuteRound(executeBillPO.getExecuteRound());
        executeApprovalPO.setExecuteApprovalId(executeApprovalId);
        executeApprovalPO.setCreateUserId(EnquiryCommonUtil.valNull(reqBO.getUserId()));
        executeApprovalPO.setCreateUserName(reqBO.getName());
        executeApprovalPO.setCreateTime(new Date());
        executeApprovalPO.setExecuteOrgId(executeBillPO.getExecuteOrgId());
        executeApprovalPO.setExecuteOrgName(executeBillPO.getExecuteOrgName());
        executeApprovalPO.setExecuteDepartId(executeBillPO.getExecuteDepartId());
        executeApprovalPO.setExecuteDepartName(executeBillPO.getExecuteDepartName());
        executeApprovalPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        executeApprovalPO.setApprovalResult("0");
        String stepId = "";
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            executeApprovalPO.setApprovalStatus("3");
            stepId = this.createAuditOrder(reqBO, executeApprovalId, EnquiryConstant.AuditObjType.EXECUTE_OPERATION_APPROVAL, "ExecuteOperatApproval");
        } else if (reqBO.getIsOperatApproval() != null && reqBO.getIsOperatApproval() == 1) {
            executeApprovalPO.setApprovalStatus("3");
            stepId = this.createAuditOrder(reqBO, executeApprovalId, EnquiryConstant.AuditObjType.OPERATION_EXECUTE_APPROVAL, "PurchaserExecuteOperatApproval");
        } else {
            executeApprovalPO.setApprovalStatus("1");
            stepId = this.createAuditOrder(reqBO, executeApprovalId, EnquiryConstant.AuditObjType.EXECUTE_APPROVAL, "purchaserExecuteApproval");
        }
        executeApprovalPO.setStepId(stepId);
        this.executeApprovalMapper.insert(executeApprovalPO);
    }

    private int checkUserType(Set<AuthorityInfo> authorityInfoSet) {
        HashSet<String> roleSet = new HashSet<String>();
        for (AuthorityInfo authorityInfo : authorityInfoSet) {
            roleSet.add(authorityInfo.getKey());
        }
        int userType = 0;
        if (roleSet == null || roleSet.size() <= 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u767b\u5f55\u7528\u6237\u672a\u914d\u7f6e\u6267\u884c\u5355\u5ba1\u6279");
        }
        if (roleSet.contains("overall:yunyingdanweiercijingjiashenhegang")) {
            userType = 1;
        }
        if (roleSet.contains("003")) {
            userType = 2;
        }
        if (roleSet.contains("004")) {
            userType = 3;
        }
        if (userType == 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u767b\u5f55\u7528\u6237\u672a\u914d\u7f6e\u6267\u884c\u5355\u5ba1\u6279");
        }
        return userType;
    }

    private void dealExecuteApproval(PurchaseExecuteApprovalReqBO reqBO, ExecuteApprovalPO executeApprovalPO, ExecuteBillPO executeBillPO) {
        ExecuteApprovalPO record = new ExecuteApprovalPO();
        Date approvalTime = new Date();
        record.setUpdateTime(approvalTime);
        String approvalStatus = "4";
        String approvalResult = String.valueOf(reqBO.getApprovalResult());
        record.setApprovalUserId(reqBO.getUserId().toString());
        record.setApprovalUserName(reqBO.getName());
        record.setApprovalRemarks(reqBO.getRemarks());
        record.setApprovalTime(approvalTime);
        record.setApprovalResult(approvalResult);
        record.setApprovalStatus(approvalStatus);
        record.setUpdateTime(approvalTime);
        record.setUpdateUserId(reqBO.getUserId().toString());
        record.setUpdateUserName(reqBO.getUserName());
        record.setUpdateTime(approvalTime);
        record.setExecuteApprovalId(reqBO.getExecuteApprovalId());
        this.executeApprovalMapper.updateByPrimaryKeySelective(record);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        ExecuteItemPO qryExecuteItemPO = new ExecuteItemPO();
        qryExecuteItemPO.setExecuteId(executeApprovalPO.getExecuteId());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(qryExecuteItemPO);
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            executeItemIdList.add(executeItemPO.getExecuteItemId());
        }
        if ("1".equals(approvalResult)) {
            PurchaseApprovalConfigurePO purchaseApprovalConfigurePO = new PurchaseApprovalConfigurePO();
            purchaseApprovalConfigurePO.setCode("executeApproval");
            List<PurchaseApprovalConfigurePO> configurePOList = this.purchaseApprovalConfigureMapper.qryList(purchaseApprovalConfigurePO);
            PurchaseApprovalConfigurePO configurePO = new PurchaseApprovalConfigurePO();
            int isApproval = 0;
            if (CollUtil.isNotEmpty(configurePOList)) {
                configurePO = (PurchaseApprovalConfigurePO)CollUtil.getFirst(configurePOList);
                isApproval = configurePO.getIsApproval().intValue();
            }
            if (isApproval != 1) {
                this.dealExecuteFinish(executeBillPO);
                return;
            }
            String executeOrgId = executeBillPO.getExecuteOrgId();
            PurchaseApprovalExceptionPO purchaseApprovalRecord = new PurchaseApprovalExceptionPO();
            purchaseApprovalRecord.setApprovalId(configurePO.getApprovalId());
            List<PurchaseApprovalExceptionPO> exceptionPOList = this.purchaseApprovalExceptionMapper.qryList(purchaseApprovalRecord);
            if (CollUtil.isNotEmpty(exceptionPOList)) {
                for (PurchaseApprovalExceptionPO purchaseApprovalExceptionPO : exceptionPOList) {
                    if (purchaseApprovalExceptionPO.getUnitId() == null || !executeOrgId.equals(purchaseApprovalExceptionPO.getUnitId().toString()) || purchaseApprovalExceptionPO.getIsApproval() != null && purchaseApprovalExceptionPO.getIsApproval() == 1) continue;
                    this.dealExecuteFinish(executeBillPO);
                    return;
                }
            }
            Long executeApprovalId = this.idUtil.nextId();
            executeApprovalPO.setExecuteApprovalId(executeApprovalId);
            executeApprovalPO.setCreateTime(new Date());
            executeApprovalPO.setApprovalResult("0");
            executeApprovalPO.setApprovalStatus("1");
            executeApprovalPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            String stepId = this.createAuditOrder(reqBO, executeApprovalId, EnquiryConstant.AuditObjType.EXECUTE_APPROVAL, "purchaserExecuteApproval");
            executeApprovalPO.setStepId(stepId);
            this.executeApprovalMapper.insert(executeApprovalPO);
            this.saveExecuteLog(reqBO, executeApprovalPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode(), 1, reqBO.getRemarks());
        } else if ("2".equals(approvalResult)) {
            ExecuteBillPO updateExecuteBillPO = new ExecuteBillPO();
            updateExecuteBillPO.setExecuteId(executeApprovalPO.getExecuteId());
            String executeStatus = "2011";
            updateExecuteBillPO.setExecuteStatus(executeStatus);
            this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
            this.saveExecuteLog(reqBO, executeApprovalPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 2, reqBO.getRemarks());
        }
    }

    private void dealOperatApprovalFinish(PurchaseExecuteApprovalReqBO reqBO, ExecuteApprovalPO executeApprovalPO, ExecuteBillPO executeBillPO) {
        ExecuteApprovalPO record = new ExecuteApprovalPO();
        Date approvalTime = new Date();
        record.setUpdateTime(approvalTime);
        String approvalStatus = "4";
        String approvalResult = String.valueOf(reqBO.getApprovalResult());
        record.setApprovalUserId(reqBO.getUserId().toString());
        record.setApprovalUserName(reqBO.getName());
        record.setApprovalRemarks(reqBO.getRemarks());
        record.setApprovalTime(approvalTime);
        record.setApprovalResult(approvalResult);
        record.setApprovalStatus(approvalStatus);
        record.setUpdateTime(approvalTime);
        record.setUpdateUserId(reqBO.getUserId().toString());
        record.setUpdateUserName(reqBO.getUserName());
        record.setUpdateTime(approvalTime);
        record.setExecuteApprovalId(reqBO.getExecuteApprovalId());
        this.executeApprovalMapper.updateByPrimaryKeySelective(record);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        ExecuteItemPO qryExecuteItemPO = new ExecuteItemPO();
        qryExecuteItemPO.setExecuteId(executeApprovalPO.getExecuteId());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(qryExecuteItemPO);
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            executeItemIdList.add(executeItemPO.getExecuteItemId());
        }
        ExecuteBillPO updateExecuteBillPO = new ExecuteBillPO();
        updateExecuteBillPO.setExecuteId(executeApprovalPO.getExecuteId());
        String executeStatus = null;
        if ("1".equals(approvalResult)) {
            executeStatus = "2012";
            try {
                SimpleDateFormat quoteStartTimeStrFormat;
                SimpleDateFormat quoteStartTimeFormat;
                int i;
                List<String> holidayList;
                GregorianCalendar quoteStartTimeCal;
                Date quoteStartTime = new Date();
                Date quoteEndTime = new Date();
                if (executeBillPO.getQuoteTimeDaysAppr() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                    for (i = 1; i <= executeBillPO.getQuoteTimeDaysAppr(); ++i) {
                        ((Calendar)quoteStartTimeCal).add(5, 1);
                        if (!DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMM").equals(DateUtil.format((Date)quoteStartTime, (String)"yyyyMM"))) {
                            holidayList = this.getHoliday(quoteStartTime);
                        }
                        if (!CollUtil.isEmpty(holidayList) && holidayList.contains(DateUtil.format((Date)quoteStartTime, (String)"yyyyMMdd"))) {
                            --i;
                        }
                        if (CollUtil.isEmpty(holidayList) && (quoteStartTimeCal.get(7) == 6 || quoteStartTimeCal.get(7) == 7)) {
                            --i;
                        }
                        quoteStartTime = quoteStartTimeCal.getTime();
                    }
                }
                if (executeBillPO.getQuoteTimeAppr() != null) {
                    quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quoteStartTimeStr = quoteStartTimeFormat.format(quoteStartTime);
                    quoteStartTimeStr = quoteStartTimeStr + " " + executeBillPO.getQuoteTimeAppr();
                    quoteStartTime = quoteStartTimeStrFormat.parse(quoteStartTimeStr);
                }
                if (executeBillPO.getQuoteTimeDays() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                    for (i = 1; i <= executeBillPO.getQuoteTimeDays(); ++i) {
                        ((Calendar)quoteStartTimeCal).add(5, 1);
                        if (!DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMM").equals(DateUtil.format((Date)quoteEndTime, (String)"yyyyMM"))) {
                            holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                        }
                        if (!CollUtil.isEmpty(holidayList) && holidayList.contains(DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMMdd"))) {
                            --i;
                        }
                        if (CollUtil.isEmpty(holidayList) && (quoteStartTimeCal.get(7) == 6 || quoteStartTimeCal.get(7) == 7)) {
                            --i;
                        }
                        quoteEndTime = quoteStartTimeCal.getTime();
                    }
                }
                if (executeBillPO.getQuoteTime() != null) {
                    quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quoteEndTimeStr = quoteStartTimeFormat.format(quoteEndTime);
                    quoteEndTimeStr = quoteEndTimeStr + " " + executeBillPO.getQuoteTime();
                    quoteEndTime = quoteStartTimeStrFormat.parse(quoteEndTimeStr);
                }
                updateExecuteBillPO.setQuoteStartTime(quoteStartTime);
                updateExecuteBillPO.setQuoteEndTime(quoteEndTime);
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u62a5\u4ef7\u5f00\u59cb\u65f6\u95f4\u62fc\u63a5\u5931\u8d25", e);
            }
            this.saveExecuteLog(reqBO, executeApprovalPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 1, reqBO.getRemarks());
        } else if ("2".equals(approvalResult)) {
            executeStatus = "2011";
            this.saveExecuteLog(reqBO, executeApprovalPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 2, reqBO.getRemarks());
        }
        updateExecuteBillPO.setExecuteStatus(executeStatus);
        this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
    }

    private void dealExecuteApprovalFinish(PurchaseExecuteApprovalReqBO reqBO, ExecuteApprovalPO executeApprovalPO, ExecuteBillPO executeBillPO) {
        ExecuteApprovalPO record = new ExecuteApprovalPO();
        Date approvalTime = new Date();
        record.setUpdateTime(approvalTime);
        String approvalResult = String.valueOf(reqBO.getApprovalResult());
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        ExecuteItemPO qryExecuteItemPO = new ExecuteItemPO();
        qryExecuteItemPO.setExecuteId(executeApprovalPO.getExecuteId());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(qryExecuteItemPO);
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            executeItemIdList.add(executeItemPO.getExecuteItemId());
        }
        String approvalStatus = "2";
        record.setApprovalUserId(reqBO.getUserId().toString());
        record.setApprovalUserName(reqBO.getName());
        record.setApprovalRemarks(reqBO.getRemarks());
        record.setApprovalTime(approvalTime);
        record.setApprovalResult(approvalResult);
        record.setApprovalStatus(approvalStatus);
        record.setUpdateTime(approvalTime);
        record.setUpdateUserId(reqBO.getUserId().toString());
        record.setUpdateUserName(reqBO.getUserName());
        record.setUpdateTime(approvalTime);
        record.setExecuteApprovalId(reqBO.getExecuteApprovalId());
        this.executeApprovalMapper.updateByPrimaryKeySelective(record);
        ExecuteBillPO updateExecuteBillPO = new ExecuteBillPO();
        updateExecuteBillPO.setExecuteId(executeApprovalPO.getExecuteId());
        String executeStatus = null;
        if ("1".equals(approvalResult)) {
            executeStatus = "2012";
            try {
                SimpleDateFormat quoteStartTimeStrFormat;
                SimpleDateFormat quoteStartTimeFormat;
                int i;
                List<String> holidayList;
                GregorianCalendar quoteStartTimeCal;
                Date quoteStartTime = new Date();
                Date quoteEndTime = new Date();
                if (executeBillPO.getQuoteTimeDaysAppr() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                    for (i = 1; i <= executeBillPO.getQuoteTimeDaysAppr(); ++i) {
                        ((Calendar)quoteStartTimeCal).add(5, 1);
                        if (!DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMM").equals(DateUtil.format((Date)quoteStartTime, (String)"yyyyMM"))) {
                            holidayList = this.getHoliday(quoteStartTime);
                        }
                        if (!CollUtil.isEmpty(holidayList) && holidayList.contains(DateUtil.format((Date)quoteStartTime, (String)"yyyyMMdd"))) {
                            --i;
                        }
                        if (CollUtil.isEmpty(holidayList) && (quoteStartTimeCal.get(7) == 6 || quoteStartTimeCal.get(7) == 7)) {
                            --i;
                        }
                        quoteStartTime = quoteStartTimeCal.getTime();
                    }
                }
                if (executeBillPO.getQuoteTimeAppr() != null) {
                    quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quoteStartTimeStr = quoteStartTimeFormat.format(quoteStartTime);
                    quoteStartTimeStr = quoteStartTimeStr + " " + executeBillPO.getQuoteTimeAppr();
                    quoteStartTime = quoteStartTimeStrFormat.parse(quoteStartTimeStr);
                }
                if (executeBillPO.getQuoteTimeDays() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                    for (i = 1; i <= executeBillPO.getQuoteTimeDays(); ++i) {
                        ((Calendar)quoteStartTimeCal).add(5, 1);
                        if (!DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMM").equals(DateUtil.format((Date)quoteEndTime, (String)"yyyyMM"))) {
                            holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                        }
                        if (!CollUtil.isEmpty(holidayList) && holidayList.contains(DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMMdd"))) {
                            --i;
                        }
                        if (CollUtil.isEmpty(holidayList) && (quoteStartTimeCal.get(7) == 6 || quoteStartTimeCal.get(7) == 7)) {
                            --i;
                        }
                        quoteEndTime = quoteStartTimeCal.getTime();
                    }
                }
                if (executeBillPO.getQuoteTime() != null) {
                    quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quoteEndTimeStr = quoteStartTimeFormat.format(quoteEndTime);
                    quoteEndTimeStr = quoteEndTimeStr + " " + executeBillPO.getQuoteTime();
                    quoteEndTime = quoteStartTimeStrFormat.parse(quoteEndTimeStr);
                }
                updateExecuteBillPO.setQuoteStartTime(quoteStartTime);
                updateExecuteBillPO.setQuoteEndTime(quoteEndTime);
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u62a5\u4ef7\u5f00\u59cb\u65f6\u95f4\u62fc\u63a5\u5931\u8d25", e);
            }
            this.saveExecuteLog(reqBO, executeApprovalPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 1, reqBO.getRemarks());
        } else if ("2".equals(approvalResult)) {
            executeStatus = "2011";
            this.saveExecuteLog(reqBO, executeApprovalPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 2, reqBO.getRemarks());
        }
        updateExecuteBillPO.setExecuteStatus(executeStatus);
        this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
    }

    private void dealExecuteFinish(ExecuteBillPO executeBillPO) {
        String executeStatus = "2012";
        ExecuteBillPO updateExecuteBillPO = new ExecuteBillPO();
        updateExecuteBillPO.setExecuteId(executeBillPO.getExecuteId());
        updateExecuteBillPO.setExecuteStatus(executeStatus);
        try {
            SimpleDateFormat quoteStartTimeStrFormat;
            SimpleDateFormat quoteStartTimeFormat;
            int i;
            List<String> holidayList;
            GregorianCalendar quoteStartTimeCal;
            Date quoteStartTime = new Date();
            Date quoteEndTime = new Date();
            if (executeBillPO.getQuoteTimeDaysAppr() != null) {
                quoteStartTimeCal = new GregorianCalendar();
                quoteStartTimeCal.setTime(quoteStartTime);
                holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                for (i = 1; i <= executeBillPO.getQuoteTimeDaysAppr(); ++i) {
                    ((Calendar)quoteStartTimeCal).add(5, 1);
                    if (!DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMM").equals(DateUtil.format((Date)quoteStartTime, (String)"yyyyMM"))) {
                        holidayList = this.getHoliday(quoteStartTime);
                    }
                    if (!CollUtil.isEmpty(holidayList) && holidayList.contains(DateUtil.format((Date)quoteStartTime, (String)"yyyyMMdd"))) {
                        --i;
                    }
                    if (CollUtil.isEmpty(holidayList) && (quoteStartTimeCal.get(7) == 6 || quoteStartTimeCal.get(7) == 7)) {
                        --i;
                    }
                    quoteStartTime = quoteStartTimeCal.getTime();
                }
            }
            if (executeBillPO.getQuoteTimeAppr() != null) {
                quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String quoteStartTimeStr = quoteStartTimeFormat.format(quoteStartTime);
                quoteStartTimeStr = quoteStartTimeStr + " " + executeBillPO.getQuoteTimeAppr();
                quoteStartTime = quoteStartTimeStrFormat.parse(quoteStartTimeStr);
            }
            if (executeBillPO.getQuoteTimeDays() != null) {
                quoteStartTimeCal = new GregorianCalendar();
                quoteStartTimeCal.setTime(quoteStartTime);
                holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                for (i = 1; i <= executeBillPO.getQuoteTimeDays(); ++i) {
                    ((Calendar)quoteStartTimeCal).add(5, 1);
                    if (!DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMM").equals(DateUtil.format((Date)quoteEndTime, (String)"yyyyMM"))) {
                        holidayList = this.getHoliday(quoteStartTimeCal.getTime());
                    }
                    if (!CollUtil.isEmpty(holidayList) && holidayList.contains(DateUtil.format((Date)quoteStartTimeCal.getTime(), (String)"yyyyMMdd"))) {
                        --i;
                    }
                    if (CollUtil.isEmpty(holidayList) && (quoteStartTimeCal.get(7) == 6 || quoteStartTimeCal.get(7) == 7)) {
                        --i;
                    }
                    quoteEndTime = quoteStartTimeCal.getTime();
                }
            }
            if (executeBillPO.getQuoteTime() != null) {
                quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String quoteEndTimeStr = quoteStartTimeFormat.format(quoteEndTime);
                quoteEndTimeStr = quoteEndTimeStr + " " + executeBillPO.getQuoteTimeAppr();
                quoteEndTime = quoteStartTimeStrFormat.parse(quoteEndTimeStr);
            }
            updateExecuteBillPO.setQuoteStartTime(quoteStartTime);
            updateExecuteBillPO.setQuoteEndTime(quoteEndTime);
        }
        catch (ParseException e) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u5f00\u59cb\u65f6\u95f4\u62fc\u63a5\u5931\u8d25", e);
        }
        this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
    }

    private String createAuditOrder(PurchaseExecuteApprovalReqBO reqBO, Long executeApprovalId, Integer auditType, String procDefKey) {
        String stepId = "";
        AuditCreateReqBO auditCreateReqBO = new AuditCreateReqBO();
        auditCreateReqBO.setObjId(executeApprovalId.toString());
        auditCreateReqBO.setOrderId(executeApprovalId);
        auditCreateReqBO.setOrgId(reqBO.getOrgIdIn());
        auditCreateReqBO.setOrgName(reqBO.getOrgName());
        auditCreateReqBO.setUserId(String.valueOf(reqBO.getUserId()));
        auditCreateReqBO.setUserName(reqBO.getName());
        auditCreateReqBO.setProcDefKey(procDefKey);
        auditCreateReqBO.setObjType(auditType);
        AuditCreateRspBO auditCreateRspBO = this.enquiryActiveAuditOperateService.createAuditOrder(auditCreateReqBO);
        stepId = auditCreateRspBO.getStepId();
        if (!"0000".equals(auditCreateRspBO.getRespCode())) {
            log.error("\u6267\u884c\u5ba1\u6279id\u3010" + executeApprovalId + "\u3011\u521b\u5efa\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25\uff0c" + auditCreateRspBO.getRespDesc());
            throw new BusinessException("8888", auditCreateRspBO.getRespDesc());
        }
        return stepId;
    }

    private void saveExecuteBillLog(PurchaseExecuteApprovalReqBO reqBO, Long executeId, List<Long> executeItemIdList, String status, int dealResult) {
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.TWO);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(status);
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.FIVE);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(status);
        EnquiryLogReqBO enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(null).allExecuteOperLogReqBO(null).build();
        BaseAllOperLogRspBO logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO);
        if (!"0000".equals(logRspBO.getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    private void saveExecuteLog(PurchaseExecuteApprovalReqBO reqBO, Long executeId, List<Long> executeItemIdList, String status, int dealResult, String remark) {
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.TWO);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(status);
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.FIVE);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(status);
        BaseAllOperLogReqBO allOperLogReqBO = null;
        allOperLogReqBO = new BaseAllOperLogReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)allOperLogReqBO);
        allOperLogReqBO.setExecuteItemIdList(executeItemIdList);
        if (dealResult == 2) {
            allOperLogReqBO.setOperateBusiEnum(EnquiryEnumConstant.AllOperateBusiEnum.TYPE1302);
        }
        if (dealResult == 1) {
            allOperLogReqBO.setOperateBusiEnum(EnquiryEnumConstant.AllOperateBusiEnum.TYPE1301);
        }
        allOperLogReqBO.setRemark(remark);
        BaseAllOperLogReqBO allExecuteOperLogReqBO = null;
        allExecuteOperLogReqBO = new BaseAllOperLogReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)allExecuteOperLogReqBO);
        allExecuteOperLogReqBO.setExecuteItemIdList(executeItemIdList);
        if (dealResult == 2) {
            allExecuteOperLogReqBO.setExecuteOperateBusiEnum(EnquiryEnumConstant.AllExecuteOperateBusiEnum.TYPE201);
        }
        if (dealResult == 1) {
            allExecuteOperLogReqBO.setExecuteOperateBusiEnum(EnquiryEnumConstant.AllExecuteOperateBusiEnum.TYPE202);
        }
        allExecuteOperLogReqBO.setRemark(remark);
        EnquiryLogReqBO enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(allOperLogReqBO).allExecuteOperLogReqBO(allExecuteOperLogReqBO).build();
        BaseAllOperLogRspBO logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO);
        if (!"0000".equals(logRspBO.getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    public List<String> getHoliday(Date startDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        ArrayList<String> holiday = new ArrayList<String>();
        try {
            Date startDateYearMonth = format.parse(DateUtil.format((Date)startDate, (String)"yyyyMM"));
            BasHoliDayPO record = new BasHoliDayPO();
            record.setHoliDayStart(startDateYearMonth);
            List<BasHoliDayPO> basHoliDayPOList = this.basHoliDayMapper.getList(record);
            for (BasHoliDayPO basHoliDayPO : basHoliDayPOList) {
                String yearMonthDayStr = DateUtil.format((Date)basHoliDayPO.getHoliDay(), (String)"yyyyMMdd");
                holiday.add(yearMonthDayStr);
            }
            log.info("holiday\u96c6\u5408:" + JSON.toJSONString(holiday));
        }
        catch (ParseException e) {
            throw new BusinessException("\u65f6\u95f4\u6821\u9a8c\u5931\u8d25", e.getMessage(), e);
        }
        return holiday;
    }
}

