/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.collection.CollUtil;
import com.tydic.enquiry.api.bo.BiddingMallQuotationBO;
import com.tydic.enquiry.api.bo.CurrentQuotationPackBO;
import com.tydic.enquiry.api.bo.QryBiddingMallQuotationReqBO;
import com.tydic.enquiry.api.bo.QryBiddingMallQuotationRspBO;
import com.tydic.enquiry.api.bo.QuotationPackHistoryBO;
import com.tydic.enquiry.busi.api.QryBiddingMallQuotationBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecutePackMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.SupQuotePackMapper;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecutePackPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QryBiddingMallQuotationBusiServiceImpl
implements QryBiddingMallQuotationBusiService {
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private SupQuotePackMapper supQuotePackMapper;
    @Autowired
    private ExecutePackMapper executePackMapper;

    @Override
    public QryBiddingMallQuotationRspBO qryBiddingMallQuotation(QryBiddingMallQuotationReqBO reqBO) {
        List<ExecutePackPO> executePackPOS;
        QryBiddingMallQuotationRspBO rspBO = new QryBiddingMallQuotationRspBO();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        rspBO.setLimitQuoteDate(executeBillPO.getQuoteEndTime());
        rspBO.setDelayCnt(executeBillPO.getDelayCnt());
        rspBO.setDelayLengthTime(executeBillPO.getDelayLengthTime());
        rspBO.setIsDelay(Integer.valueOf(executeBillPO.getTimeDelayFlag().intValue()));
        SupQuotePO supQuotePO = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (supQuotePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        if (supQuotePO.getQuoteStatus().equals(EnquiryConstant.QuoteStatus.YES)) {
            SupQuotePO supQueryPO = new SupQuotePO();
            supQueryPO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
            supQueryPO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
            supQueryPO.setSupplierId(reqBO.getSupplierId());
            supQueryPO.setExecuteId(reqBO.getExecuteId());
            List<SupQuotePO> supList = this.supQuoteMapper.selectByCondition(supQueryPO);
            if (CollUtil.isNotEmpty(supList)) {
                supQuotePO = (SupQuotePO)CollUtil.getFirst(supList);
            }
        }
        HashSet<Long> packIdSet = new HashSet<Long>();
        ArrayList<Long> packIdList = new ArrayList<Long>();
        ArrayList<BiddingMallQuotationBO> biddingMallQuotationBOS = new ArrayList<BiddingMallQuotationBO>();
        SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
        supQuoteItemPO.setQuoteId(reqBO.getQuoteId());
        List<SupQuoteItemPO> supQuoteItemPOList = this.supQuoteItemMapper.selectListBy(supQuoteItemPO);
        if (!CollectionUtils.isEmpty(supQuoteItemPOList)) {
            for (SupQuoteItemPO supQuoteItem : supQuoteItemPOList) {
                packIdSet.add(supQuoteItem.getPackId());
            }
            packIdList.addAll(packIdSet);
        }
        if (!CollectionUtils.isEmpty(executePackPOS = this.executePackMapper.selectByExecuteId(reqBO.getExecuteId(), packIdList))) {
            HashMap<Long, BiddingMallQuotationBO> biddingMallQuotationBOMap = new HashMap<Long, BiddingMallQuotationBO>();
            for (ExecutePackPO executePackPO : executePackPOS) {
                BiddingMallQuotationBO biddingMallQuotationBO = new BiddingMallQuotationBO();
                biddingMallQuotationBO.setPackId(executePackPO.getPackId());
                biddingMallQuotationBO.setPackCode(executePackPO.getPackCode());
                biddingMallQuotationBO.setPackName(executePackPO.getPackName());
                biddingMallQuotationBO.setItemCount(executePackPO.getItemCount());
                biddingMallQuotationBO.setExecuteId(executePackPO.getExecuteId());
                biddingMallQuotationBO.setPackBudgetMoney(executePackPO.getPackBudgetMoney());
                biddingMallQuotationBO.setQuoteId(supQuotePO.getQuoteId());
                biddingMallQuotationBOS.add(biddingMallQuotationBO);
                biddingMallQuotationBOMap.put(executePackPO.getPackId(), biddingMallQuotationBO);
            }
            List<CurrentQuotationPackBO> lowestQuotationPackBOS = this.supQuotePackMapper.selectCurrentBiddingQuotation(reqBO.getExecuteId(), null, null, 1);
            if (!CollectionUtils.isEmpty(lowestQuotationPackBOS)) {
                Long upperQuoteId = null;
                if (supQuotePO.getUpperQuoteId() != null) {
                    upperQuoteId = supQuotePO.getUpperQuoteId();
                }
                List<QuotationPackHistoryBO> supplierLastQuotationPackBOS = this.supQuotePackMapper.selectBiddingQuotationPackByCondition(reqBO.getExecuteId(), null, reqBO.getSupplierId(), upperQuoteId, 1);
                Map lastQuoteBOMap = supplierLastQuotationPackBOS.stream().collect(Collectors.toMap(QuotationPackHistoryBO::getPackId, Function.identity(), (key1, key2) -> key2));
                for (CurrentQuotationPackBO lowestQuotationPackBO : lowestQuotationPackBOS) {
                    Long packId = lowestQuotationPackBO.getPackId();
                    if (biddingMallQuotationBOMap.get(packId) == null) continue;
                    BiddingMallQuotationBO biddingMallQuotationBO = (BiddingMallQuotationBO)biddingMallQuotationBOMap.get(packId);
                    biddingMallQuotationBO.setLowestQuote(lowestQuotationPackBO.getLowestQuote());
                    biddingMallQuotationBO.setQuoteRound(supQuotePO.getQuoteRound());
                    biddingMallQuotationBO.setQuoteId(supQuotePO.getQuoteId());
                    if (lastQuoteBOMap.get(packId) == null) continue;
                    QuotationPackHistoryBO supplierQuotationPackBO = (QuotationPackHistoryBO)lastQuoteBOMap.get(packId);
                    biddingMallQuotationBO.setLastQuoteTime(supplierQuotationPackBO.getQuoteTime());
                    biddingMallQuotationBO.setLastQuotePrice(supplierQuotationPackBO.getQuotePackMoney());
                    if (supplierQuotationPackBO.getQuoteMoney() == null) continue;
                    biddingMallQuotationBO.setLastQuotePrice(supplierQuotationPackBO.getQuoteMoney());
                }
            }
        }
        rspBO.setBiddingMallQuotationList(biddingMallQuotationBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

