/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemBO;
import com.tydic.enquiry.api.bo.EnquriyOrgSupTagBO;
import com.tydic.enquiry.api.bo.ExecuteQuotePlanItemBo;
import com.tydic.enquiry.api.bo.MaxDeliveryDaysBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteItemBO;
import com.tydic.enquiry.api.bo.QryDealQuotationItemListByPageReqBO;
import com.tydic.enquiry.api.bo.QryDealQuotationItemListByPageRspBO;
import com.tydic.enquiry.api.bo.QryLastLowestQuotationRspBO;
import com.tydic.enquiry.api.bo.QryLastLowestQuoteReqBO;
import com.tydic.enquiry.api.bo.QuotationItemBO;
import com.tydic.enquiry.api.bo.RecommendedQuotationItemBO;
import com.tydic.enquiry.api.bo.SupQuoteItemBO;
import com.tydic.enquiry.busi.api.EnquiryDealQuoteBusiService;
import com.tydic.enquiry.busi.api.QryDealQuotationItemListByPageBusiService;
import com.tydic.enquiry.busi.api.bo.QryQuotationBO;
import com.tydic.enquiry.busi.impl.plan.BlackSupinfoCommonService;
import com.tydic.enquiry.busi.utils.BigDecimalUtils;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.ConfParaPOMapper;
import com.tydic.enquiry.dao.DealConfirmItemMapper;
import com.tydic.enquiry.dao.DealNoticeItemMapper;
import com.tydic.enquiry.dao.DealNoticeMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.po.ConfParaPO;
import com.tydic.enquiry.dao.po.DealConfirmItemPO;
import com.tydic.enquiry.dao.po.DealNoticeItemPO;
import com.tydic.enquiry.dao.po.DealNoticePO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.constant.PebExtConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QryDealQuotationItemListByPageBusiServiceImpl
implements QryDealQuotationItemListByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryDealQuotationItemListByPageBusiServiceImpl.class);
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private DealConfirmItemMapper dealConfirmItemMapper;
    @Autowired
    private DealNoticeItemMapper dealNoticeItemMapper;
    @Autowired
    private DealNoticeMapper dealNoticeMapper;
    @Autowired
    private EnquiryDealQuoteBusiService enquiryDealQuoteBusiService;
    @Autowired
    private ConfParaPOMapper confParaPOMapper;
    @Autowired
    private BlackSupinfoCommonService blackSupinfoCommonService;

    @Override
    public QryDealQuotationItemListByPageRspBO qryDealQuotationItemList(QryDealQuotationItemListByPageReqBO reqBO) {
        return this.getDealQuotationItemListNew(reqBO);
    }

    private QryDealQuotationItemListByPageRspBO getDealQuotationItemListNew(QryDealQuotationItemListByPageReqBO reqBO) {
        QryDealQuotationItemListByPageRspBO rspBO = new QryDealQuotationItemListByPageRspBO();
        Long executeId = reqBO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        ArrayList<ExecuteQuotePlanItemBo> executeQuotePlanItemBos = new ArrayList<ExecuteQuotePlanItemBo>();
        ExecuteItemPO executeItemPO = new ExecuteItemPO();
        executeItemPO.setExecuteId(executeId);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
        HashSet<String> remarkSet = new HashSet<String>();
        if (CollUtil.isNotEmpty(executeItemPOList)) {
            List<Long> executeItemIdList = executeItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
            QryLastLowestQuoteReqBO qryLastLowestQuoteReqBO = new QryLastLowestQuoteReqBO();
            qryLastLowestQuoteReqBO.setExecuteId(executeId);
            qryLastLowestQuoteReqBO.setConfirmDealType(executeBillPO.getConfirmDealType());
            qryLastLowestQuoteReqBO.setExecuteType(executeBillPO.getExecuteType());
            qryLastLowestQuoteReqBO.setExecuteItemIdList(executeItemIdList);
            QryLastLowestQuotationRspBO qryLastLowestQuotationRspBO = this.enquiryDealQuoteBusiService.getSubItemLastQuoteList(qryLastLowestQuoteReqBO);
            List supQuoteItem = qryLastLowestQuotationRspBO.getSupQuoteItemList();
            Map<Object, Object> lastQuoteItemMap = new HashMap();
            if (CollUtil.isNotEmpty((Collection)supQuoteItem)) {
                lastQuoteItemMap = supQuoteItem.stream().collect(Collectors.groupingBy(SupQuoteItemBO::getExecuteItemId));
            }
            ArrayList<QuotationItemBO> quotationItemBOList = new ArrayList<QuotationItemBO>();
            Map<String, List<EnquriyOrgSupTagBO>> allOrgBlackMap = this.blackSupinfoCommonService.getQuoteBlackSupList(executeId, quotationItemBOList);
            HashMap<String, Set<String>> executeSupMap = new HashMap<String, Set<String>>();
            for (QuotationItemBO quotationItemBO : quotationItemBOList) {
                Long supId = quotationItemBO.getSupplierId();
                String orgId = quotationItemBO.getDemandOrgId();
                String key = orgId + "_" + supId;
                List<EnquriyOrgSupTagBO> blackList = allOrgBlackMap.get(key);
                if (!CollUtil.isEmpty(blackList)) continue;
                this.addValToMap(executeSupMap, String.valueOf(quotationItemBO.getExecuteItemId()), String.valueOf(quotationItemBO.getSupplierId()));
            }
            String confirmDealType = executeBillPO.getConfirmDealType();
            ArrayList<Long> existItemList = new ArrayList<Long>();
            if ("1".equals(confirmDealType)) {
                DealConfirmItemPO confirmItemQueryPO = new DealConfirmItemPO();
                confirmItemQueryPO.setExecuteItemIdList(executeItemIdList);
                List<DealConfirmItemPO> itemPOList = this.dealConfirmItemMapper.selectItemExistsBy(confirmItemQueryPO);
                DealNoticePO dealNoticePO = new DealNoticePO();
                dealNoticePO.setExecuteId(executeId);
                List<DealNoticePO> dealNoticePOList = this.dealNoticeMapper.getList(dealNoticePO);
                HashMap dealNoticeItemPOMap = new HashMap();
                DealNoticeItemPO dealNoticeItemPO = new DealNoticeItemPO();
                dealNoticeItemPO.setExecuteItemIdList(executeItemIdList);
                List<DealNoticeItemPO> dealNoticeItemPOList = this.dealNoticeItemMapper.selectBy(dealNoticeItemPO);
                ExecuteItemPO record = new ExecuteItemPO();
                record.setExecuteId(executeId);
                record.setFixedFlag((byte)1);
                List<ExecuteItemPO> executeFixItemPOList = this.executeItemMapper.getList(record);
                List<Object> execuFixteItemIdList = new ArrayList();
                if (CollUtil.isNotEmpty(executeFixItemPOList)) {
                    execuFixteItemIdList = executeFixItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
                }
                if (dealNoticeItemPOList == null) {
                    dealNoticeItemPOList = new ArrayList<DealNoticeItemPO>();
                }
                if (itemPOList == null) {
                    itemPOList = new ArrayList<DealConfirmItemPO>();
                }
                for (DealNoticeItemPO dealNoticeItemPO2 : dealNoticeItemPOList) {
                    List<DealNoticeItemPO> dealNoticeItemList;
                    for (DealNoticePO dealNoticePO2 : dealNoticePOList) {
                        if (dealNoticeItemPO2.getDealNoticeId().longValue() != dealNoticePO2.getDealNoticeId().longValue()) continue;
                        dealNoticeItemPO2.setDealBillStatus(dealNoticePO2.getDealBillStatus());
                        break;
                    }
                    if (dealNoticeItemPOMap.get(dealNoticeItemPO2.getDealConfirmItemId()) != null) {
                        dealNoticeItemList = (List)dealNoticeItemPOMap.get(dealNoticeItemPO2.getExecuteItemId());
                        dealNoticeItemList.add(dealNoticeItemPO2);
                        dealNoticeItemPOMap.put(dealNoticeItemPO2.getDealConfirmItemId(), dealNoticeItemList);
                        continue;
                    }
                    dealNoticeItemList = new ArrayList<DealNoticeItemPO>();
                    dealNoticeItemList.add(dealNoticeItemPO2);
                    dealNoticeItemPOMap.put(dealNoticeItemPO2.getDealConfirmItemId(), dealNoticeItemList);
                }
                List<String> dealBillStatusList = Arrays.asList("1", "2");
                block3: for (DealConfirmItemPO dealConfirmItem : itemPOList) {
                    if (CollUtil.isNotEmpty(execuFixteItemIdList) && execuFixteItemIdList.contains(dealConfirmItem.getExecuteItemId())) {
                        existItemList.add(dealConfirmItem.getExecuteItemId());
                        continue;
                    }
                    if (CollUtil.isEmpty((Collection)((Collection)dealNoticeItemPOMap.get(dealConfirmItem.getDealConfirmItemId())))) {
                        existItemList.add(dealConfirmItem.getExecuteItemId());
                        continue;
                    }
                    for (DealNoticeItemPO dealNoticeItem : (List)dealNoticeItemPOMap.get(dealConfirmItem.getDealConfirmItemId())) {
                        if (!dealBillStatusList.contains(dealNoticeItem.getDealBillStatus())) continue;
                        existItemList.add(dealConfirmItem.getExecuteItemId());
                        continue block3;
                    }
                }
            }
            BigDecimal exceptVal = this.getExceptPrice();
            HashMap<Long, SupQuoteItemPO> priceRangMap = new HashMap<Long, SupQuoteItemPO>();
            if ("1".equals(executeBillPO.getExecuteType())) {
                SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
                supQuoteItemPO.setExecuteId(executeId);
                supQuoteItemPO.setExecuteItemIdList(executeItemIdList);
                supQuoteItemPO.setExceptRatio(exceptVal.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                List<SupQuoteItemPO> priceRangeList = this.supQuoteItemMapper.selectLastRoundPriceRange(supQuoteItemPO);
                for (SupQuoteItemPO supQuoteItemPO1 : priceRangeList) {
                    priceRangMap.put(supQuoteItemPO1.getExecuteItemId(), supQuoteItemPO1);
                }
            }
            HashMap dealConfirmItemMap = new HashMap();
            DealConfirmItemPO dealConfirmItemPO = new DealConfirmItemPO();
            dealConfirmItemPO.setExecuteId(executeId);
            dealConfirmItemPO.setExecuteItemIdList(executeItemIdList);
            List<DealConfirmItemPO> dealConfirmItemList = this.dealConfirmItemMapper.selectListBy(dealConfirmItemPO);
            if (!CollectionUtils.isEmpty(dealConfirmItemList)) {
                dealConfirmItemList.forEach(item -> dealConfirmItemMap.put(item.getExecuteItemId(), item));
            }
            Integer leastQuoteNumber = executeBillPO.getLeastQuoteNumber();
            for (ExecuteItemPO executeItem : executeItemPOList) {
                Long executeItemId = executeItem.getExecuteItemId();
                ExecuteQuotePlanItemBo executeQuotePlanItemBo = new ExecuteQuotePlanItemBo();
                EnquiryExecuteItemBO executeItemBO = new EnquiryExecuteItemBO();
                BeanUtil.copyProperties((Object)executeItem, (Object)executeItemBO);
                EnquiryCommonUtil.transItemName(executeItemBO);
                PurchaseExecuteItemBO purchaseExecuteItemBO = new PurchaseExecuteItemBO();
                BeanUtil.copyProperties((Object)executeItemBO, (Object)purchaseExecuteItemBO);
                int itemSelectFlag = 1;
                if (existItemList.contains(executeItemId)) {
                    itemSelectFlag = 0;
                }
                purchaseExecuteItemBO.setCanSelectFlag(Integer.valueOf(itemSelectFlag));
                executeQuotePlanItemBo.setExecuteItemBO(purchaseExecuteItemBO);
                Set set = (Set)executeSupMap.get(String.valueOf(executeItemId));
                int supCount = 0;
                if (CollUtil.isNotEmpty((Collection)set)) {
                    supCount = set.size();
                }
                int lessNumFlag = 0;
                if (supCount < leastQuoteNumber) {
                    lessNumFlag = 1;
                    remarkSet.add("\u5c0f\u4e8e\u6700\u5c0f\u62a5\u4ef7\u5bb6\u6570");
                }
                purchaseExecuteItemBO.setLessNumFlag(Integer.valueOf(lessNumFlag));
                if (lastQuoteItemMap.containsKey(executeItemId)) {
                    BigDecimal quotePrice = BigDecimal.ZERO;
                    List supQuoteItemBOs = (List)lastQuoteItemMap.get(executeItemId);
                    ArrayList<QuotationItemBO> quotationItemList = new ArrayList<QuotationItemBO>();
                    int i = 0;
                    for (SupQuoteItemBO supQuoteItemBO : supQuoteItemBOs) {
                        DealConfirmItemPO confirmItemPO;
                        QuotationItemBO quotationItemBO = new QuotationItemBO();
                        BeanUtil.copyProperties((Object)supQuoteItemBO, (Object)quotationItemBO);
                        if (i == 0) {
                            quotationItemBO.setMostPreferentialFlag(Integer.valueOf(1));
                            quotationItemBO.setRecommended(Integer.valueOf(1));
                            quotePrice = quotationItemBO.getQuotePrice();
                        }
                        int exceptFlag = 0;
                        if (priceRangMap.containsKey(executeItemId)) {
                            SupQuoteItemPO rangPO = (SupQuoteItemPO)priceRangMap.get(executeItemId);
                            log.info("\u5f02\u5e38\u5224\u65ad\u3010itemId:" + executeItemId + ",start:" + rangPO.getExceptPriceStart() + ",end:" + rangPO.getExceptPriceEnd() + ",quote_money:" + quotationItemBO.getQuoteMoney() + "\u3011");
                            exceptFlag = EnquiryCommonUtil.getExceptFlag(rangPO.getExceptPriceStart(), rangPO.getExceptPriceEnd(), quotationItemBO.getQuoteMoney());
                        }
                        if ((confirmItemPO = (DealConfirmItemPO)dealConfirmItemMap.get(supQuoteItemBO.getExecuteItemId())) != null && StrUtil.isNotBlank((CharSequence)confirmItemPO.getQuoteDeviateDescribe())) {
                            quotationItemBO.setQuoteDeviateDescribe(confirmItemPO.getQuoteDeviateDescribe());
                        }
                        int quoteSelectFlag = itemSelectFlag;
                        if (lessNumFlag == 0) {
                            Long supId = supQuoteItemBO.getSupplierId();
                            String orgId = supQuoteItemBO.getDemandOrgId();
                            String key = orgId + "_" + supId;
                            List<EnquriyOrgSupTagBO> orgSupTagBOList = allOrgBlackMap.get(key);
                            if (CollUtil.isNotEmpty(orgSupTagBOList)) {
                                quotationItemBO.setQuoteIsEffective("0");
                                quoteSelectFlag = 0;
                                quotationItemBO.setBlackTagList(orgSupTagBOList);
                            }
                        }
                        quotationItemBO.setCanSelectFlag(Integer.valueOf(quoteSelectFlag));
                        quotationItemBO.setIsLastQuote(Integer.valueOf(1));
                        quotationItemBO.setExceptRatio(exceptVal);
                        quotationItemBO.setExceptFlag(Integer.valueOf(exceptFlag));
                        quotationItemList.add(quotationItemBO);
                        ++i;
                    }
                    List quotePriceList = quotationItemList.stream().map(QuotationItemBO::getQuotePrice).distinct().sorted().collect(Collectors.toList());
                    HashMap<BigDecimal, Integer> quotePriceMap = new HashMap<BigDecimal, Integer>(quotePriceList.size());
                    Integer sortFlag = 1;
                    if (!CollectionUtils.isEmpty(quotePriceList)) {
                        for (BigDecimal bigDecimal : quotePriceList) {
                            quotePriceMap.put(bigDecimal, sortFlag);
                            Integer n = sortFlag;
                            Integer n2 = sortFlag = Integer.valueOf(sortFlag + 1);
                        }
                    }
                    for (QuotationItemBO quotationItemBO : quotationItemList) {
                        if (BigDecimal.ZERO.compareTo(quotePrice) != 0) {
                            quotationItemBO.setQuotePriceGapRatio(quotationItemBO.getQuotePrice().subtract(quotePrice).divide(quotePrice, 8, 4).multiply(new BigDecimal(100)).setScale(2, 4));
                        }
                        if (!StringUtils.isEmpty((Object)quotationItemBO.getQuoteIsDeviate())) {
                            quotationItemBO.setQuoteIsDeviateStr(EnquiryEnumConstant.QuoteIsDeviateEnum.getDesc((String)quotationItemBO.getQuoteIsDeviate()));
                        }
                        quotationItemBO.setSortFlag((Integer)quotePriceMap.get(quotationItemBO.getQuotePrice()));
                    }
                    executeQuotePlanItemBo.setQuoteItemList(quotationItemList);
                }
                executeQuotePlanItemBos.add(executeQuotePlanItemBo);
            }
        }
        if (CollUtil.isNotEmpty(remarkSet)) {
            rspBO.setConfirmRemark(CollUtil.join(remarkSet, (CharSequence)";"));
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(executeQuotePlanItemBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addValToMap(Map<String, Set<String>> dataMap, String key, String val) {
        if (StrUtil.isNotBlank((CharSequence)val)) {
            if (dataMap.containsKey(key)) {
                dataMap.get(key).add(val);
            } else {
                HashSet<String> dataSet = new HashSet<String>();
                dataSet.add(val);
                dataMap.put(key, dataSet);
            }
        }
    }

    private BigDecimal getExceptPrice() {
        ConfParaPO confQueryPO = new ConfParaPO();
        confQueryPO.setConfCode("exceptPrice");
        ConfParaPO confParaPO = this.confParaPOMapper.selectBy(confQueryPO);
        if (confParaPO == null) {
            throw new BusinessException("8888", "\u5f02\u5e38\u4ef7\u683c\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (confParaPO.getConfVal() == null || confParaPO.getConfVal() < 1.0) {
            throw new BusinessException("8888", "\u5f02\u5e38\u4ef7\u683c\u914d\u7f6e\u8981\u5927\u4e8e0");
        }
        return new BigDecimal(confParaPO.getConfVal());
    }

    private QryDealQuotationItemListByPageRspBO getDealQuotationItemListOld(QryDealQuotationItemListByPageReqBO reqBO) {
        QryDealQuotationItemListByPageRspBO rspBO = new QryDealQuotationItemListByPageRspBO();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        ArrayList<RecommendedQuotationItemBO> recommendedQuotationItemList = new ArrayList<RecommendedQuotationItemBO>();
        ArrayList<ExecuteQuotePlanItemBo> executeQuotePlanItemBos = new ArrayList<ExecuteQuotePlanItemBo>();
        ExecuteItemPO executeItemPO = new ExecuteItemPO();
        executeItemPO.setExecuteId(reqBO.getExecuteId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
        HashMap planQuotationItemMap = new HashMap();
        if (!CollectionUtils.isEmpty(executeItemPOList)) {
            ArrayList<Long> executeItemIds = new ArrayList<Long>();
            for (ExecuteItemPO executeItem : executeItemPOList) {
                ExecuteQuotePlanItemBo executeQuotePlanItemBo = new ExecuteQuotePlanItemBo();
                PurchaseExecuteItemBO executeItemBO = (PurchaseExecuteItemBO)JSON.parseObject((String)JSON.toJSONString((Object)executeItem), PurchaseExecuteItemBO.class);
                if (executeItem.getDsfjczm() != null) {
                    executeItemBO.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)executeItem.getDsfjczm()));
                }
                if (executeItem.getPtfw() != null) {
                    executeItemBO.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)executeItem.getPtfw()));
                }
                executeItemBO.setBzfsName(EnquiryCommonUtil.getBzfsName(executeItem.getBzfs()));
                if (executeItem.getDealType() != null) {
                    executeItemBO.setDealTypeName(EnquiryEnumConstant.RecommendDealTypeEnum.getDesc((Integer)executeItem.getDealType()));
                    executeItemBO.setDealTypeStr(EnquiryEnumConstant.RecommendDealTypeEnum.getDesc((Integer)executeItem.getDealType()));
                }
                if (executeItem.getQuotedEffTime() != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quotedEffectiveTime = format.format(executeItem.getQuotedEffTime());
                    executeItemBO.setQuotedEffectiveTime(quotedEffectiveTime);
                    executeItemBO.setQuotedEffTimeStr(quotedEffectiveTime);
                }
                executeItemBO.setYsje(BigDecimalUtils.bigDecimalToStr(executeItem.getBudgetMoney()));
                executeItemBO.setDemanderOrgId(executeItem.getDemandOrgId());
                executeItemBO.setDemanderOrgName(executeItem.getDemandOrgName());
                executeItemBO.setDistributeAddressId(executeItem.getDistributeAddressId());
                executeItemBO.setDistributeAddress(executeItem.getDistributeAddress());
                executeItemBO.setWlbhName(executeItem.getWlbhStr());
                executeItemBO.setWxflName(executeItem.getWxflStr());
                executeItemBO.setJhly(executeItem.getPlanSource());
                executeItemBO.setJhlyName(executeItem.getPlanSource());
                if (!StringUtils.isEmpty((Object)executeItem.getWxfl()) && !StringUtils.isEmpty((Object)executeItem.getWxflStr())) {
                    executeItemBO.setWxflDescribe(executeItem.getWxfl() + "-" + executeItem.getWxflStr());
                }
                if (!StringUtils.isEmpty((Object)executeItem.getWlbh()) && !StringUtils.isEmpty((Object)executeItem.getWlbhStr())) {
                    executeItemBO.setWlbhDescribe(executeItem.getWlbh() + "-" + executeItem.getWlbhStr());
                }
                if (!StringUtils.isEmpty((Object)executeItem.getJhmc()) && !StringUtils.isEmpty((Object)executeItem.getZxlsjhbh())) {
                    executeItemBO.setPlanDescribe(executeItem.getZxlsjhbh() + "-" + executeItem.getJhmc());
                }
                if (!StringUtils.isEmpty((Object)executeItem.getProjectCode()) && !StringUtils.isEmpty((Object)executeItem.getProjectName())) {
                    executeItemBO.setProject(executeItem.getProjectCode() + "-" + executeItem.getProjectName());
                }
                executeItemBO.setBeiz(executeItemPO.getBz());
                executeQuotePlanItemBo.setExecuteItemBO(executeItemBO);
                ArrayList quotationItemBOS = new ArrayList();
                executeQuotePlanItemBo.setQuoteItemList(quotationItemBOS);
                executeItemIds.add(executeItem.getExecuteItemId());
                executeQuotePlanItemBos.add(executeQuotePlanItemBo);
            }
            String confirmDealType = executeBillPO.getConfirmDealType();
            List<Object> existItemList = new ArrayList();
            if ("1".equals(confirmDealType)) {
                DealConfirmItemPO confirmItemQueryPO = new DealConfirmItemPO();
                confirmItemQueryPO.setExecuteItemIdList(executeItemIds);
                List<DealConfirmItemPO> itemPOList = this.dealConfirmItemMapper.selectItemExistsBy(confirmItemQueryPO);
                if (CollUtil.isNotEmpty(itemPOList)) {
                    existItemList = itemPOList.stream().map(DealConfirmItemPO::getExecuteItemId).collect(Collectors.toList());
                }
            }
            QryQuotationBO qryQuotationBO = new QryQuotationBO();
            qryQuotationBO.setExecuteId(reqBO.getExecuteId());
            qryQuotationBO.setExecuteItemIdList(executeItemIds);
            qryQuotationBO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
            if ("1".equals(executeBillPO.getExecuteType())) {
                qryQuotationBO.setHisStatus(3);
            }
            qryQuotationBO.setOrderBy("i.execute_item_id ASC , b.quote_round DESC");
            List<QuotationItemBO> supQuoteItemPOList = this.supQuoteItemMapper.selectListPageWithBiddingQuoteByCondition(qryQuotationBO);
            HashMap<Long, Integer> minPromiseDeliveryDaysMap = new HashMap<Long, Integer>();
            HashMap<Long, BigDecimal> minQuotatPriceMap = new HashMap<Long, BigDecimal>();
            if (!CollectionUtils.isEmpty(supQuoteItemPOList)) {
                HashMap quotationItemBOMap = new HashMap();
                for (QuotationItemBO quotationItemBO : supQuoteItemPOList) {
                    ArrayList<QuotationItemBO> quotationItemBOS;
                    if ("2".equals(executeBillPO.getExecuteType()) && quotationItemBOMap.containsKey(quotationItemBO.getExecuteItemId()) && ((List)quotationItemBOMap.get(quotationItemBO.getExecuteItemId())).size() >= 3) continue;
                    if (quotationItemBOMap.containsKey(quotationItemBO.getExecuteItemId())) {
                        ((List)quotationItemBOMap.get(quotationItemBO.getExecuteItemId())).add(quotationItemBO);
                    } else {
                        quotationItemBOS = new ArrayList<QuotationItemBO>();
                        quotationItemBOS.add(quotationItemBO);
                        quotationItemBOMap.put(quotationItemBO.getExecuteItemId(), quotationItemBOS);
                    }
                    if (planQuotationItemMap.containsKey(quotationItemBO.getPlanId())) {
                        ((List)planQuotationItemMap.get(quotationItemBO.getPlanId())).add(quotationItemBO);
                    } else {
                        quotationItemBOS = new ArrayList();
                        quotationItemBOS.add(quotationItemBO);
                        planQuotationItemMap.put(quotationItemBO.getPlanId(), quotationItemBOS);
                    }
                    if (minPromiseDeliveryDaysMap.containsKey(quotationItemBO.getExecuteItemId()) && quotationItemBO.getPromiseDeliveryDays() != null && (Integer)minPromiseDeliveryDaysMap.get(quotationItemBO.getExecuteItemId()) > quotationItemBO.getPromiseDeliveryDays()) {
                        minPromiseDeliveryDaysMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getPromiseDeliveryDays());
                    } else if (!minPromiseDeliveryDaysMap.containsKey(quotationItemBO.getExecuteItemId()) && quotationItemBO.getPromiseDeliveryDays() != null) {
                        minPromiseDeliveryDaysMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getPromiseDeliveryDays());
                    }
                    if (minQuotatPriceMap.containsKey(quotationItemBO.getExecuteItemId()) && quotationItemBO.getQuotePrice() != null && ((BigDecimal)minQuotatPriceMap.get(quotationItemBO.getExecuteItemId())).compareTo(quotationItemBO.getQuotePrice()) > 0) {
                        minQuotatPriceMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getQuotePrice());
                        continue;
                    }
                    if (minQuotatPriceMap.containsKey(quotationItemBO.getExecuteItemId()) || quotationItemBO.getQuotePrice() == null) continue;
                    minQuotatPriceMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getQuotePrice());
                }
                for (ExecuteQuotePlanItemBo executeQuotePlanItemBo : executeQuotePlanItemBos) {
                    PurchaseExecuteItemBO purchaseExecuteItemBO = executeQuotePlanItemBo.getExecuteItemBO();
                    if (existItemList.contains(purchaseExecuteItemBO.getExecuteItemId())) {
                        purchaseExecuteItemBO.setCanSelectFlag(Integer.valueOf(0));
                    } else {
                        purchaseExecuteItemBO.setCanSelectFlag(Integer.valueOf(1));
                    }
                    if (quotationItemBOMap.get(purchaseExecuteItemBO.getExecuteItemId()) == null) continue;
                    executeQuotePlanItemBo.setQuoteItemList((List)quotationItemBOMap.get(purchaseExecuteItemBO.getExecuteItemId()));
                }
            }
            HashMap<Long, Long> planShortestDeliverDaysSupplierIdMap = new HashMap<Long, Long>();
            HashMap<Long, Long> planLowestAmountSupplierIdMap = new HashMap<Long, Long>();
            QryQuotationBO quotationBO = new QryQuotationBO();
            quotationBO.setExecuteId(reqBO.getExecuteId());
            List<MaxDeliveryDaysBO> maxDeliveryDaysBOS = this.supQuoteItemMapper.selectMaxDeliveryDaysByCondition(quotationBO);
            if (!CollectionUtils.isEmpty(maxDeliveryDaysBOS)) {
                HashMap<Long, Integer> planShortestDeliverDaysMap = new HashMap<Long, Integer>();
                HashMap<Long, BigDecimal> planLowestAmountMap = new HashMap<Long, BigDecimal>();
                for (MaxDeliveryDaysBO maxDeliveryDaysBO : maxDeliveryDaysBOS) {
                    if (planLowestAmountMap.containsKey(maxDeliveryDaysBO.getPlanId()) && maxDeliveryDaysBO.getAmount() != null && ((BigDecimal)planLowestAmountMap.get(maxDeliveryDaysBO.getPlanId())).compareTo(maxDeliveryDaysBO.getAmount()) > 0) {
                        planLowestAmountMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getAmount());
                        planLowestAmountSupplierIdMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getSupplierId());
                    } else if (!planLowestAmountMap.containsKey(maxDeliveryDaysBO.getPlanId()) && maxDeliveryDaysBO.getAmount() != null) {
                        planLowestAmountMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getAmount());
                        planLowestAmountSupplierIdMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getSupplierId());
                    }
                    if (planShortestDeliverDaysMap.containsKey(maxDeliveryDaysBO.getPlanId()) && maxDeliveryDaysBO.getMaxDays() != null && (Integer)planShortestDeliverDaysMap.get(maxDeliveryDaysBO.getPlanId()) > maxDeliveryDaysBO.getMaxDays()) {
                        planShortestDeliverDaysMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getMaxDays());
                        planShortestDeliverDaysSupplierIdMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getSupplierId());
                        continue;
                    }
                    if (planShortestDeliverDaysMap.containsKey(maxDeliveryDaysBO.getPlanId()) || maxDeliveryDaysBO.getMaxDays() == null) continue;
                    planShortestDeliverDaysMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getMaxDays());
                    planShortestDeliverDaysSupplierIdMap.put(maxDeliveryDaysBO.getPlanId(), maxDeliveryDaysBO.getSupplierId());
                }
                log.info("\u8ba1\u5212\u4fe1\u606f\u62a5\u4ef7\uff1a" + JSON.toJSONString(planLowestAmountMap));
                log.info("\u8ba1\u5212\u4fe1\u606f\u4f9b\u5e94\uff1a" + JSON.toJSONString(planLowestAmountSupplierIdMap));
            }
            HashMap<Long, Long> planRecommendedSupplierIdMap = new HashMap<Long, Long>();
            for (ExecuteQuotePlanItemBo executeQuotePlanItemBo : executeQuotePlanItemBos) {
                Integer days;
                List quotationItemBOS = executeQuotePlanItemBo.getQuoteItemList();
                if (CollectionUtils.isEmpty((Collection)quotationItemBOS)) continue;
                Long shortestDeliverDaysSupplierId = ((QuotationItemBO)quotationItemBOS.get(0)).getSupplierId();
                Long lowestAmountSupplierId = ((QuotationItemBO)quotationItemBOS.get(0)).getSupplierId();
                BigDecimal mostQuoteAmount = BigDecimal.ZERO;
                if (((QuotationItemBO)quotationItemBOS.get(0)).getQuotePrice() != null) {
                    mostQuoteAmount = ((QuotationItemBO)quotationItemBOS.get(0)).getQuotePrice();
                }
                for (QuotationItemBO quotationItemBO : quotationItemBOS) {
                    days = 0;
                    if (minPromiseDeliveryDaysMap.get(quotationItemBO.getExecuteItemId()) != null) {
                        days = (Integer)minPromiseDeliveryDaysMap.get(quotationItemBO.getExecuteItemId());
                    }
                    if (quotationItemBO.getPromiseDeliveryDays() != null && quotationItemBO.getPromiseDeliveryDays().equals(days)) {
                        shortestDeliverDaysSupplierId = quotationItemBO.getSupplierId();
                    }
                    BigDecimal minQuotatPrice = new BigDecimal("0");
                    if (minQuotatPriceMap.get(quotationItemBO.getExecuteItemId()) != null) {
                        minQuotatPrice = (BigDecimal)minQuotatPriceMap.get(quotationItemBO.getExecuteItemId());
                    }
                    if (quotationItemBO.getQuotePrice() == null || minQuotatPrice.compareTo(quotationItemBO.getQuotePrice()) < 0) continue;
                    mostQuoteAmount = quotationItemBO.getQuotePrice();
                    lowestAmountSupplierId = quotationItemBO.getSupplierId();
                }
                for (QuotationItemBO quotationItemBO : quotationItemBOS) {
                    RecommendedQuotationItemBO recommendedQuotationItemBO;
                    RecommendedQuotationItemBO recommendedQuotationItemBO2;
                    days = 0;
                    if (minPromiseDeliveryDaysMap.get(quotationItemBO.getExecuteItemId()) != null) {
                        days = (Integer)minPromiseDeliveryDaysMap.get(quotationItemBO.getExecuteItemId());
                    }
                    if (quotationItemBO.getPromiseDeliveryDays() != null && quotationItemBO.getPromiseDeliveryDays().equals(days)) {
                        quotationItemBO.setRecentDateFlag(Integer.valueOf(1));
                    }
                    if (quotationItemBO.getQuotePrice() != null && mostQuoteAmount.compareTo(quotationItemBO.getQuotePrice()) == 0) {
                        quotationItemBO.setMostPreferentialFlag(Integer.valueOf(1));
                    }
                    quotationItemBO.setIsLastQuote(Integer.valueOf(0));
                    if (quotationItemBO.getHisStatus() != null && EnquiryConstant.QuoteHisStatus.LATEST.toString().equals(quotationItemBO.getHisStatus().toString())) {
                        quotationItemBO.setIsLastQuote(Integer.valueOf(1));
                    }
                    if (planRecommendedSupplierIdMap.containsKey(quotationItemBO.getExecuteItemId()) && ((Long)planRecommendedSupplierIdMap.get(quotationItemBO.getExecuteItemId())).equals(quotationItemBO.getSupplierId())) {
                        quotationItemBO.setIsLastQuote(Integer.valueOf(0));
                    }
                    Integer dealType = reqBO.getOrderBy();
                    if (reqBO.getOrderBy() == null || EnquiryConstant.DealType.SUGGEST.equals(reqBO.getOrderBy())) {
                        dealType = quotationItemBO.getDealType();
                    }
                    if (EnquiryConstant.DealType.AHBJZD.equals(dealType) && quotationItemBO.getHisStatus() != null && EnquiryConstant.QuoteHisStatus.LATEST.toString().equals(quotationItemBO.getHisStatus().toString()) && !planRecommendedSupplierIdMap.containsKey(quotationItemBO.getExecuteItemId()) && quotationItemBO.getSupplierId().equals(lowestAmountSupplierId)) {
                        quotationItemBO.setRecommended(Integer.valueOf(1));
                        recommendedQuotationItemBO2 = new RecommendedQuotationItemBO();
                        recommendedQuotationItemBO2.setQuoteItemId(quotationItemBO.getQuoteItemId());
                        recommendedQuotationItemBO2.setSupplierId(quotationItemBO.getSupplierId());
                        recommendedQuotationItemBO2.setSupplierName(quotationItemBO.getSupplierName());
                        recommendedQuotationItemBO2.setExecuteItemId(quotationItemBO.getExecuteItemId());
                        recommendedQuotationItemList.add(recommendedQuotationItemBO2);
                        planRecommendedSupplierIdMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getSupplierId());
                    }
                    if (EnquiryConstant.DealType.AHJHQZD.equals(dealType) && quotationItemBO.getHisStatus() != null && EnquiryConstant.QuoteHisStatus.LATEST.toString().equals(quotationItemBO.getHisStatus().toString()) && !planRecommendedSupplierIdMap.containsKey(quotationItemBO.getExecuteItemId()) && quotationItemBO.getSupplierId().equals(shortestDeliverDaysSupplierId)) {
                        quotationItemBO.setRecommended(Integer.valueOf(1));
                        recommendedQuotationItemBO2 = new RecommendedQuotationItemBO();
                        recommendedQuotationItemBO2.setQuoteItemId(quotationItemBO.getQuoteItemId());
                        recommendedQuotationItemBO2.setSupplierId(quotationItemBO.getSupplierId());
                        recommendedQuotationItemBO2.setSupplierName(quotationItemBO.getSupplierName());
                        recommendedQuotationItemBO2.setExecuteItemId(quotationItemBO.getExecuteItemId());
                        recommendedQuotationItemList.add(recommendedQuotationItemBO2);
                        planRecommendedSupplierIdMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getSupplierId());
                    }
                    if (EnquiryConstant.DealType.AJHBJZD.equals(dealType)) {
                        Long planLowestAmountSupplierId = (Long)planLowestAmountSupplierIdMap.get(quotationItemBO.getPlanId());
                        if (quotationItemBO.getHisStatus() != null && EnquiryConstant.QuoteHisStatus.LATEST.toString().equals(quotationItemBO.getHisStatus().toString()) && !planRecommendedSupplierIdMap.containsKey(quotationItemBO.getExecuteItemId()) && planLowestAmountSupplierId != null && quotationItemBO.getSupplierId().equals(planLowestAmountSupplierId)) {
                            quotationItemBO.setRecommended(Integer.valueOf(1));
                            recommendedQuotationItemBO = new RecommendedQuotationItemBO();
                            recommendedQuotationItemBO.setQuoteItemId(quotationItemBO.getQuoteItemId());
                            recommendedQuotationItemBO.setSupplierId(quotationItemBO.getSupplierId());
                            recommendedQuotationItemBO.setSupplierName(quotationItemBO.getSupplierName());
                            recommendedQuotationItemBO.setExecuteItemId(quotationItemBO.getExecuteItemId());
                            recommendedQuotationItemList.add(recommendedQuotationItemBO);
                            planRecommendedSupplierIdMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getSupplierId());
                        }
                    }
                    if (!EnquiryConstant.DealType.AJHJHQZD.equals(dealType)) continue;
                    Long planShortestDeliverDaysSupplierId = (Long)planShortestDeliverDaysSupplierIdMap.get(quotationItemBO.getPlanId());
                    if (quotationItemBO.getHisStatus() == null || !EnquiryConstant.QuoteHisStatus.LATEST.toString().equals(quotationItemBO.getHisStatus().toString()) || planRecommendedSupplierIdMap.containsKey(quotationItemBO.getExecuteItemId()) || planShortestDeliverDaysSupplierId == null || !quotationItemBO.getSupplierId().equals(planShortestDeliverDaysSupplierId)) continue;
                    quotationItemBO.setRecommended(Integer.valueOf(1));
                    recommendedQuotationItemBO = new RecommendedQuotationItemBO();
                    recommendedQuotationItemBO.setQuoteItemId(quotationItemBO.getQuoteItemId());
                    recommendedQuotationItemBO.setSupplierId(quotationItemBO.getSupplierId());
                    recommendedQuotationItemBO.setSupplierName(quotationItemBO.getSupplierName());
                    recommendedQuotationItemBO.setExecuteItemId(quotationItemBO.getExecuteItemId());
                    recommendedQuotationItemList.add(recommendedQuotationItemBO);
                    planRecommendedSupplierIdMap.put(quotationItemBO.getExecuteItemId(), quotationItemBO.getSupplierId());
                }
            }
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecommendedQuotationItemList(recommendedQuotationItemList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(executeQuotePlanItemBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

