/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.PurchaseQuotationDetailFileInfoAddReqBO;
import com.tydic.enquiry.api.bo.PurchaseQuotationDetailFileInfoAddRspBO;
import com.tydic.enquiry.api.bo.QryQuotationDetailReqBO;
import com.tydic.enquiry.api.bo.QryQuotationDetailRspBO;
import com.tydic.enquiry.api.bo.QueryPurchaseQuotationDetailFileInfoReqBO;
import com.tydic.enquiry.api.bo.QueryPurchaseQuotationDetailFileInfoRspBO;
import com.tydic.enquiry.api.bo.SupQuoteBO;
import com.tydic.enquiry.busi.api.QryQuotationDetailBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryGenerateIdUtil;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QryQuotationDetailBusiServiceImpl
implements QryQuotationDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationDetailBusiServiceImpl.class);
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private EnquiryGenerateIdUtil sequence;

    @Override
    public QryQuotationDetailRspBO qryQuotationDetail(QryQuotationDetailReqBO reqBO) {
        QryQuotationDetailRspBO rspBO = new QryQuotationDetailRspBO();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        List basFileInfoList = new ArrayList();
        SupQuotePO supQuotePO = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (supQuotePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        SupQuoteBO supQuoteBO = (SupQuoteBO)JSON.parseObject((String)JSON.toJSONString((Object)supQuotePO), SupQuoteBO.class);
        BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
        basFileInfoPO.setRelateId(reqBO.getQuoteId());
        List<BasFileInfoPO> list = this.basFileInfoMapper.selectFileInfoList(basFileInfoPO);
        if (!CollectionUtils.isEmpty(list)) {
            basFileInfoList = JSON.parseArray((String)JSON.toJSONString(list), EnquiryBasFileInfoBO.class);
        }
        supQuoteBO.setBasFileInfoList(basFileInfoList);
        rspBO.setSupQuoteBO(supQuoteBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PurchaseQuotationDetailFileInfoAddRspBO addAllQuotationDetailFileInfo(PurchaseQuotationDetailFileInfoAddReqBO reqBO) {
        List enquiryBasFileInfoBOList = reqBO.getFileInfoBoList();
        this.basFileInfoMapper.deleteByRelateId(reqBO.getExecuteId(), "1003");
        log.info("basFileInfoPOList:" + JSON.toJSONString((Object)enquiryBasFileInfoBOList));
        List basFileInfoPOList = JSON.parseArray((String)JSON.toJSONString((Object)enquiryBasFileInfoBOList), BasFileInfoPO.class);
        for (BasFileInfoPO basFileInfoPO : basFileInfoPOList) {
            basFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            basFileInfoPO.setRelateId(reqBO.getExecuteId());
            basFileInfoPO.setFileinfoId(this.sequence.nextId());
            basFileInfoPO.setCreateTime(new Date());
            basFileInfoPO.setCreateId(reqBO.getUserId());
            basFileInfoPO.setCreateName(reqBO.getName());
            basFileInfoPO.setFileSumm(reqBO.getRedisNo());
            basFileInfoPO.setBillType("1003");
        }
        if (!CollectionUtils.isEmpty((Collection)basFileInfoPOList)) {
            this.basFileInfoMapper.insertBatch(basFileInfoPOList);
        }
        PurchaseQuotationDetailFileInfoAddRspBO rspBO = new PurchaseQuotationDetailFileInfoAddRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public QueryPurchaseQuotationDetailFileInfoRspBO qryPurchaseExecuteQuoteFile(QueryPurchaseQuotationDetailFileInfoReqBO reqBO) {
        QueryPurchaseQuotationDetailFileInfoRspBO rspBO = new QueryPurchaseQuotationDetailFileInfoRspBO();
        List basFileInfoList = new ArrayList();
        BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
        basFileInfoPO.setRelateId(reqBO.getExecuteId());
        basFileInfoPO.setFileName(reqBO.getRedisNo());
        basFileInfoPO.setBillType("1003");
        List<BasFileInfoPO> list = this.basFileInfoMapper.selectFileInfoList(basFileInfoPO);
        if (!CollectionUtils.isEmpty(list)) {
            basFileInfoList = JSON.parseArray((String)JSON.toJSONString(list), EnquiryBasFileInfoBO.class);
            for (EnquiryBasFileInfoBO enquiryBasFileInfoBO : basFileInfoList) {
                if (StringUtils.isEmpty((CharSequence)enquiryBasFileInfoBO.getFileUrl())) {
                    enquiryBasFileInfoBO.setFileResult("0");
                    enquiryBasFileInfoBO.setFileResultName("\u5bfc\u51fa\u5931\u8d25");
                    continue;
                }
                enquiryBasFileInfoBO.setFileResult("1");
                enquiryBasFileInfoBO.setFileResultName("\u5bfc\u51fa\u6210\u529f");
            }
        }
        rspBO.setFileInfoBoList(basFileInfoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

