/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemBO;
import com.tydic.enquiry.api.bo.ExecutePackBO;
import com.tydic.enquiry.api.bo.QryQuotationPackDetailReqBO;
import com.tydic.enquiry.api.bo.QryQuotationPackDetailRspBO;
import com.tydic.enquiry.busi.api.QryQuotationPackDetailBusiService;
import com.tydic.enquiry.busi.api.bo.QryQuotationBO;
import com.tydic.enquiry.busi.impl.QueryPurchaseExecuteItemListBusiServiceImpl;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.dao.ExecutePackMapper;
import com.tydic.enquiry.dao.ProjectInfoMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.po.ExecutePackPO;
import com.tydic.enquiry.dao.po.ProjectInfoPO;
import com.tydic.order.extend.constant.PebExtConstant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QryQuotationPackDetailBusiServiceImpl
implements QryQuotationPackDetailBusiService {
    @Autowired
    private ExecutePackMapper executePackMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private ProjectInfoMapper projectInfoMapper;
    @Autowired
    private QueryPurchaseExecuteItemListBusiServiceImpl queryPurchaseExecuteItemListBusiService;

    @Override
    public QryQuotationPackDetailRspBO qryQuotationPackDetail(QryQuotationPackDetailReqBO reqBO) {
        QryQuotationPackDetailRspBO rspBO = new QryQuotationPackDetailRspBO();
        ExecutePackPO executePackPO = this.executePackMapper.selectByPrimaryKey(reqBO.getPackId());
        if (executePackPO != null) {
            QryQuotationBO qryQuotationBO = new QryQuotationBO();
            qryQuotationBO.setQuoteId(reqBO.getQuoteId());
            qryQuotationBO.setPackId(reqBO.getPackId());
            List<EnquiryExecuteItemBO> executeItemBOList = this.supQuoteItemMapper.selectPackItemBy(qryQuotationBO);
            if (!CollectionUtils.isEmpty(executeItemBOList)) {
                Long executeId = executePackPO.getExecuteId();
                Byte publishBudgetFlag = this.queryPurchaseExecuteItemListBusiService.getPublishFlag(executeId, reqBO.getIsProfessionalOrgExt());
                ArrayList<Long> projectIdList = new ArrayList<Long>();
                HashSet projectIdSet = new HashSet();
                for (EnquiryExecuteItemBO enquiryExecuteItemBO : executeItemBOList) {
                    if (enquiryExecuteItemBO.getDsfjczm() != null) {
                        enquiryExecuteItemBO.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)((Object)enquiryExecuteItemBO.getDsfjczm())));
                    }
                    if (enquiryExecuteItemBO.getPtfw() != null) {
                        enquiryExecuteItemBO.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)((Object)enquiryExecuteItemBO.getPtfw())));
                    }
                    enquiryExecuteItemBO.setBzfsName(EnquiryCommonUtil.getBzfsName(enquiryExecuteItemBO.getBzfs()));
                    if (enquiryExecuteItemBO.getQuotedEffTime() != null) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String quotedEffectiveTime = format.format(enquiryExecuteItemBO.getQuotedEffTime());
                        enquiryExecuteItemBO.setQuotedEffectiveTime(quotedEffectiveTime);
                        enquiryExecuteItemBO.setQuotedEffTimeStr(quotedEffectiveTime);
                    }
                    if (publishBudgetFlag == 0) {
                        enquiryExecuteItemBO.setBudgetPrice("*");
                        enquiryExecuteItemBO.setBudgetMoney("*");
                        enquiryExecuteItemBO.setYsje("*");
                    } else {
                        enquiryExecuteItemBO.setYsje(enquiryExecuteItemBO.getBudgetMoney());
                    }
                    enquiryExecuteItemBO.setDemanderOrgId(enquiryExecuteItemBO.getDemandOrgId());
                    enquiryExecuteItemBO.setDemanderOrgName(enquiryExecuteItemBO.getDemandOrgName());
                    enquiryExecuteItemBO.setDistributionAddressId(enquiryExecuteItemBO.getDistributeAddressId());
                    enquiryExecuteItemBO.setDistributionAddress(enquiryExecuteItemBO.getDistributeAddress());
                    enquiryExecuteItemBO.setWlbhName(enquiryExecuteItemBO.getWlbhStr());
                    enquiryExecuteItemBO.setWxflName(enquiryExecuteItemBO.getWxflStr());
                    enquiryExecuteItemBO.setJhly(enquiryExecuteItemBO.getPlanSource());
                    enquiryExecuteItemBO.setJhlyName(enquiryExecuteItemBO.getPlanSource());
                    if (!StringUtils.isEmpty((Object)enquiryExecuteItemBO.getWxfl()) && !StringUtils.isEmpty((Object)enquiryExecuteItemBO.getWxflStr())) {
                        enquiryExecuteItemBO.setWxflDescribe(enquiryExecuteItemBO.getWxfl() + "-" + enquiryExecuteItemBO.getWxflStr());
                    }
                    if (!StringUtils.isEmpty((Object)enquiryExecuteItemBO.getWlbh()) && !StringUtils.isEmpty((Object)enquiryExecuteItemBO.getWlbhStr())) {
                        enquiryExecuteItemBO.setWlbhDescribe(enquiryExecuteItemBO.getWlbh() + "-" + enquiryExecuteItemBO.getWlbhStr());
                    }
                    if (!StringUtils.isEmpty((Object)enquiryExecuteItemBO.getJhmc()) && !StringUtils.isEmpty((Object)enquiryExecuteItemBO.getZxlsjhbh())) {
                        enquiryExecuteItemBO.setPlanDescribe(enquiryExecuteItemBO.getZxlsjhbh() + "-" + enquiryExecuteItemBO.getJhmc());
                    }
                    if (!StringUtils.isEmpty((Object)enquiryExecuteItemBO.getProjectCode()) && !StringUtils.isEmpty((Object)enquiryExecuteItemBO.getProjectName())) {
                        enquiryExecuteItemBO.setProject(enquiryExecuteItemBO.getProjectCode() + "-" + enquiryExecuteItemBO.getProjectName());
                    }
                    enquiryExecuteItemBO.setBeiz(enquiryExecuteItemBO.getBz());
                    enquiryExecuteItemBO.setPlanItemId(enquiryExecuteItemBO.getPlanDetailId());
                    if (!StringUtils.isEmpty((Object)enquiryExecuteItemBO.getProjectIdJson())) {
                        enquiryExecuteItemBO.setProjectIdList(JSONObject.parseArray((String)enquiryExecuteItemBO.getProjectIdJson(), Long.class));
                    }
                    if (CollectionUtils.isEmpty((Collection)enquiryExecuteItemBO.getProjectIdList())) continue;
                    projectIdSet.addAll(enquiryExecuteItemBO.getProjectIdList());
                }
                if (!CollectionUtils.isEmpty(projectIdSet)) {
                    HashMap<Long, ProjectInfoPO> projectInfoPOMap = new HashMap<Long, ProjectInfoPO>();
                    projectIdList.addAll(projectIdSet);
                    ProjectInfoPO qryProjectInfoPO = new ProjectInfoPO();
                    qryProjectInfoPO.setProjectIdList(projectIdList);
                    List<ProjectInfoPO> projectInfoPOList = this.projectInfoMapper.selectListPageByCondition(qryProjectInfoPO);
                    for (ProjectInfoPO projectInfoPO : projectInfoPOList) {
                        projectInfoPOMap.put(projectInfoPO.getProjectId(), projectInfoPO);
                    }
                    for (EnquiryExecuteItemBO enquiryExecuteItemBO : executeItemBOList) {
                        String projectStr = "";
                        ArrayList<String> projectNameList = new ArrayList<String>();
                        if (CollectionUtils.isEmpty((Collection)enquiryExecuteItemBO.getProjectIdList())) continue;
                        for (Long projectId : enquiryExecuteItemBO.getProjectIdList()) {
                            if (projectInfoPOMap.get(projectId) == null) continue;
                            ProjectInfoPO projectInfoPO = (ProjectInfoPO)projectInfoPOMap.get(projectId);
                            projectStr = projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName() + ";";
                            projectNameList.add(projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName());
                        }
                        enquiryExecuteItemBO.setProjectName(projectStr);
                        enquiryExecuteItemBO.setProjectNameList(projectNameList);
                    }
                }
            }
            rspBO.setExecuteItemBOList(executeItemBOList);
            ExecutePackBO executePackBO = new ExecutePackBO();
            BeanUtil.copyProperties((Object)executePackPO, (Object)executePackBO);
            rspBO.setExecutePackBO(executePackBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

