/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquriyOrgSupTagBO;
import com.tydic.enquiry.api.bo.QryLastLowestQuotationRspBO;
import com.tydic.enquiry.api.bo.QryLastLowestQuoteReqBO;
import com.tydic.enquiry.api.bo.QryQuotationSummaryReqBO;
import com.tydic.enquiry.api.bo.QryQuotationSummaryRspBO;
import com.tydic.enquiry.api.bo.QuotationSummaryBO;
import com.tydic.enquiry.api.bo.SupQuoteBO;
import com.tydic.enquiry.busi.api.EnquiryDealQuoteBusiService;
import com.tydic.enquiry.busi.api.QryQuotationSummaryBusiService;
import com.tydic.enquiry.busi.impl.plan.BlackSupinfoCommonService;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.ConfParaPOMapper;
import com.tydic.enquiry.dao.DealConfirmItemMapper;
import com.tydic.enquiry.dao.DealNoticeMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.ConfParaPO;
import com.tydic.enquiry.dao.po.DealConfirmItemPO;
import com.tydic.enquiry.dao.po.DealNoticePO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QryQuotationSummaryBusiServiceImpl
implements QryQuotationSummaryBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationSummaryBusiServiceImpl.class);
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private DealConfirmItemMapper dealConfirmItemMapper;
    @Autowired
    private DealNoticeMapper dealNoticeMapper;
    @Autowired
    private EnquiryDealQuoteBusiService enquiryDealQuoteBusiService;
    @Autowired
    private ConfParaPOMapper confParaPOMapper;
    @Autowired
    private BlackSupinfoCommonService blackSupinfoCommonService;

    @Override
    public QryQuotationSummaryRspBO qryQuotationSummary(QryQuotationSummaryReqBO reqBO) {
        String lastQuote = reqBO.getIsLastQuote();
        if ("1".equals(lastQuote)) {
            return this.qryDealQuotationSummary(reqBO);
        }
        ArrayList<QuotationSummaryBO> quotationSummaryBOList = new ArrayList<QuotationSummaryBO>();
        QryQuotationSummaryRspBO rspBO = new QryQuotationSummaryRspBO();
        rspBO.setRows(quotationSummaryBOList);
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        ArrayList<Long> quoteIdList = new ArrayList<Long>();
        ArrayList<Byte> hisStatusList = new ArrayList<Byte>();
        SupQuotePO supQuotePO = new SupQuotePO();
        supQuotePO.setExecuteId(reqBO.getExecuteId());
        if ("1".equals(executeBillPO.getExecuteType()) && StringUtils.isEmpty((Object)reqBO.getIsLastQuote())) {
            hisStatusList.add(EnquiryConstant.QuoteHisStatus.HIS);
        }
        hisStatusList.add(EnquiryConstant.QuoteHisStatus.LATEST);
        supQuotePO.setHisStatusList(hisStatusList);
        supQuotePO.setOrderBy("quote_round DESC");
        List<SupQuotePO> supQuotePOList = this.supQuoteMapper.selectByCondition(supQuotePO);
        if (!CollectionUtils.isEmpty(supQuotePOList)) {
            supQuotePOList.forEach(po -> quoteIdList.add(po.getQuoteId()));
        }
        if (!CollectionUtils.isEmpty(quoteIdList)) {
            int canSelectFlag = this.getCanSelectFlag(executeBillPO);
            supQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.LATEST);
            supQuotePO.setQuoteIdList(quoteIdList);
            supQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
            List<SupQuotePO> QuoteList = this.supQuoteMapper.selectListWithQuoteItem(supQuotePO);
            int endFlag = EnquiryCommonUtil.getEndFlag(executeBillPO);
            int currentRound = 1;
            if (executeBillPO.getExecuteRound() != null) {
                currentRound = executeBillPO.getExecuteRound();
            }
            for (SupQuotePO quotePO : QuoteList) {
                if (quotePO.getQuoteRound() < currentRound) {
                    endFlag = 1;
                }
                QuotationSummaryBO quotationSummaryBO = new QuotationSummaryBO();
                BeanUtils.copyProperties((Object)quotePO, (Object)quotationSummaryBO);
                quotationSummaryBO.setQuoteTotalAmount(quotePO.getQuoteMoney());
                quotationSummaryBO.setQuoteEndFlag(Integer.valueOf(endFlag));
                quotationSummaryBO.setRemark(quotePO.getRemarks());
                quotationSummaryBO.setCanSelectFlag(Integer.valueOf(canSelectFlag));
                quotationSummaryBOList.add(quotationSummaryBO);
            }
            BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
            basFileInfoPO.setRelateIdList(quoteIdList);
            List<BasFileInfoPO> list = this.basFileInfoMapper.selectFileInfoList(basFileInfoPO);
            HashMap basFileMap = new HashMap();
            for (BasFileInfoPO fileInfoPO : list) {
                if (basFileMap.get(fileInfoPO.getRelateId()) != null) {
                    EnquiryBasFileInfoBO basFileInfoBO = (EnquiryBasFileInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)fileInfoPO), EnquiryBasFileInfoBO.class);
                    ((List)basFileMap.get(fileInfoPO.getRelateId())).add(basFileInfoBO);
                    continue;
                }
                ArrayList<EnquiryBasFileInfoBO> basFileInfoBOS = new ArrayList<EnquiryBasFileInfoBO>();
                EnquiryBasFileInfoBO basFileInfoBO = (EnquiryBasFileInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)fileInfoPO), EnquiryBasFileInfoBO.class);
                basFileInfoBOS.add(basFileInfoBO);
                basFileMap.put(fileInfoPO.getRelateId(), basFileInfoBOS);
            }
            if (!CollectionUtils.isEmpty(quotationSummaryBOList)) {
                BigDecimal lowestPrice = ((QuotationSummaryBO)quotationSummaryBOList.get(0)).getQuoteTotalAmount();
                Integer lowestDays = ((QuotationSummaryBO)quotationSummaryBOList.get(0)).getPromiseDeliveryDays();
                for (QuotationSummaryBO quotationSummaryBO : quotationSummaryBOList) {
                    String quotationStr;
                    if (basFileMap.get(quotationSummaryBO.getQuoteId()) != null) {
                        quotationSummaryBO.setFileInfoList((List)basFileMap.get(quotationSummaryBO.getQuoteId()));
                    }
                    if (quotationSummaryBO.getQuoteTotalAmount() != null && quotationSummaryBO.getQuoteTotalAmount().compareTo(lowestPrice) <= 0) {
                        quotationSummaryBO.setMostPreferentialFlag(Integer.valueOf(1));
                    }
                    if (quotationSummaryBO.getPromiseDeliveryDays() != null && quotationSummaryBO.getPromiseDeliveryDays() <= lowestDays) {
                        quotationSummaryBO.setRecentDateFlag(Integer.valueOf(1));
                    }
                    if (quotationSummaryBO.getQuoteTotalAmount() != null) {
                        quotationSummaryBO.setQuoteTotalAmountStr(String.valueOf(quotationSummaryBO.getQuoteTotalAmount().setScale(2, 4)));
                    }
                    if (quotationSummaryBO.getPromiseDeliveryDays() != null) {
                        quotationSummaryBO.setPromiseDeliveryDaysStr(quotationSummaryBO.getPromiseDeliveryDays().toString());
                    }
                    if ("1".equals(executeBillPO.getExecuteType()) && ("2003".equals(executeBillPO.getExecuteStatus()) || "2012".equals(executeBillPO.getExecuteStatus())) && executeBillPO.getExecuteRound() != null && quotationSummaryBO.getQuoteRound() != null && executeBillPO.getExecuteRound().intValue() == quotationSummaryBO.getQuoteRound().intValue()) {
                        quotationStr = "**";
                        quotationSummaryBO.setQuoteTotalAmountStr(quotationStr);
                        quotationSummaryBO.setPromiseDeliveryDaysStr(quotationStr);
                        quotationSummaryBO.setQuoteTotalAmount(null);
                        quotationSummaryBO.setRemark(quotationStr);
                        quotationSummaryBO.setFileInfoList(null);
                    }
                    if (!"2".equals(executeBillPO.getExecuteType()) || !"2003".equals(executeBillPO.getExecuteStatus()) && !"2012".equals(executeBillPO.getExecuteStatus())) continue;
                    quotationStr = "**";
                    quotationSummaryBO.setSupplierContactsMobile(quotationStr);
                    quotationSummaryBO.setSupplierContactsName(quotationStr);
                    quotationSummaryBO.setSupplierName(quotationStr);
                    quotationSummaryBO.setRemark(quotationStr);
                    quotationSummaryBO.setQuoteIp(quotationStr);
                    quotationSummaryBO.setFileInfoList(null);
                }
            }
        }
        rspBO.setRows(quotationSummaryBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private int getCanSelectFlag(ExecuteBillPO executeBillPO) {
        DealConfirmItemPO confirmItemQueryPO;
        String dealType = executeBillPO.getConfirmDealType();
        Long executeId = executeBillPO.getExecuteId();
        int canSelectFlag = 1;
        if ("1".equals(dealType)) {
            canSelectFlag = 0;
        }
        if ("2".equals(dealType)) {
            confirmItemQueryPO = new DealConfirmItemPO();
            confirmItemQueryPO.setExecuteId(executeId);
            List<DealConfirmItemPO> itemPOList = this.dealConfirmItemMapper.selectItemExistsBy(confirmItemQueryPO);
            if (CollUtil.isNotEmpty(itemPOList)) {
                canSelectFlag = 0;
            }
        }
        if ("3".equals(dealType)) {
            confirmItemQueryPO = new DealConfirmItemPO();
            confirmItemQueryPO.setExecuteId(executeId);
            List<DealConfirmItemPO> dealConfirmItemPOList = this.dealConfirmItemMapper.selectItemExistsBy(confirmItemQueryPO);
            List<String> dealBillStatusList = Arrays.asList("1", "2");
            DealNoticePO dealNoticePO = new DealNoticePO();
            dealNoticePO.setExecuteId(executeId);
            List<DealNoticePO> itemPOList = this.dealNoticeMapper.getList(dealNoticePO);
            ExecuteItemPO record = new ExecuteItemPO();
            record.setExecuteId(executeId);
            record.setFixedFlag((byte)1);
            List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(record);
            if (CollUtil.isNotEmpty(dealConfirmItemPOList) && executeItemPOList != null && executeItemPOList.size() > 0) {
                canSelectFlag = 0;
                return canSelectFlag;
            }
            if (CollUtil.isNotEmpty(dealConfirmItemPOList) && CollUtil.isEmpty(itemPOList)) {
                canSelectFlag = 0;
                return canSelectFlag;
            }
            for (DealNoticePO dealNotice : itemPOList) {
                if (StringUtils.isEmpty((Object)dealNotice.getDealBillStatus()) || !dealBillStatusList.contains(dealNotice.getDealBillStatus())) continue;
                canSelectFlag = 0;
                break;
            }
        }
        return canSelectFlag;
    }

    /*
     * WARNING - void declaration
     */
    private QryQuotationSummaryRspBO qryDealQuotationSummary(QryQuotationSummaryReqBO reqBO) {
        QryQuotationSummaryRspBO rspBO = new QryQuotationSummaryRspBO();
        Long executeId = reqBO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        QryLastLowestQuoteReqBO qryLastLowestQuoteReqBO = new QryLastLowestQuoteReqBO();
        qryLastLowestQuoteReqBO.setExecuteId(executeId);
        qryLastLowestQuoteReqBO.setConfirmDealType(executeBillPO.getConfirmDealType());
        qryLastLowestQuoteReqBO.setExecuteType(executeBillPO.getExecuteType());
        QryLastLowestQuotationRspBO lastLowestQuotationRspBO = this.enquiryDealQuoteBusiService.getSummaryQuoteList(qryLastLowestQuoteReqBO);
        List supQuoteList = lastLowestQuotationRspBO.getSupQuoteList();
        ArrayList<QuotationSummaryBO> quotationSummaryBOList = new ArrayList<QuotationSummaryBO>();
        String confirmDealType = executeBillPO.getConfirmDealType();
        HashMap supBlackMap = new HashMap();
        if ("3".equals(confirmDealType) || "2".equals(confirmDealType)) {
            ExecuteItemPO itemQryPO = new ExecuteItemPO();
            itemQryPO.setExecuteId(executeId);
            List<ExecuteItemPO> executeItemList = this.executeItemMapper.selectBy(itemQryPO);
            HashSet<String> orgIdSet = new HashSet<String>();
            if (CollUtil.isNotEmpty(executeItemList)) {
                for (ExecuteItemPO executeItemPO : executeItemList) {
                    String orgId = executeItemPO.getDemandOrgId();
                    orgIdSet.add(orgId);
                }
            }
            HashSet<Long> supIdSet = new HashSet<Long>();
            for (SupQuoteBO supQuoteBO : supQuoteList) {
                Long supplierId = supQuoteBO.getSupplierId();
                supIdSet.add(supplierId);
            }
            for (Long supId : supIdSet) {
                ArrayList<EnquriyOrgSupTagBO> orgSupTagBOS = new ArrayList<EnquriyOrgSupTagBO>();
                for (String demandOrgId : orgIdSet) {
                    if (!StrUtil.isNotBlank((CharSequence)demandOrgId)) continue;
                    Map<Long, List<EnquriyOrgSupTagBO>> orgSupTagMap = this.blackSupinfoCommonService.getBlackSupMap(Long.valueOf(demandOrgId), null, CollUtil.newArrayList((Object[])new Long[]{supId}));
                    for (Map.Entry<Long, List<EnquriyOrgSupTagBO>> entry : orgSupTagMap.entrySet()) {
                        List<EnquriyOrgSupTagBO> blackList = entry.getValue();
                        if (!CollUtil.isNotEmpty(blackList)) continue;
                        orgSupTagBOS.addAll(blackList);
                    }
                }
                supBlackMap.put(supId, orgSupTagBOS);
            }
        }
        HashSet<String> remarkSet = new HashSet<String>();
        if (CollUtil.isNotEmpty((Collection)supQuoteList)) {
            int canSelectFlag = this.getCanSelectFlag(executeBillPO);
            SupQuotePO rangPO = null;
            BigDecimal exceptVal = this.getExceptPrice();
            if ("1".equals(executeBillPO.getExecuteType())) {
                SupQuotePO supQuotePO = new SupQuotePO();
                supQuotePO.setExecuteId(executeId);
                supQuotePO.setExceptRatio(exceptVal.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                rangPO = this.supQuoteMapper.selectLastRoundPriceRange(supQuotePO);
            }
            boolean bl = false;
            for (SupQuoteBO supQuoteBO : supQuoteList) {
                Long supId;
                List orgSupTagBOS;
                void var15_22;
                int mostPreferentialFlag = 0;
                if (var15_22 == false) {
                    mostPreferentialFlag = 1;
                }
                QuotationSummaryBO quotationSummaryBO = new QuotationSummaryBO();
                BeanUtil.copyProperties((Object)supQuoteBO, (Object)quotationSummaryBO);
                quotationSummaryBO.setQuoteTotalAmount(supQuoteBO.getQuoteMoney());
                quotationSummaryBO.setMostPreferentialFlag(Integer.valueOf(mostPreferentialFlag));
                int exceptFlag = 0;
                if (rangPO != null) {
                    log.info("\u5f02\u5e38\u5224\u65ad\u3010executeId:" + executeId + ",start:" + rangPO.getExceptPriceStart() + ",end:" + rangPO.getExceptPriceEnd() + ",quote_money:" + supQuoteBO.getQuoteMoney() + "\u3011");
                    exceptFlag = EnquiryCommonUtil.getExceptFlag(rangPO.getExceptPriceStart(), rangPO.getExceptPriceEnd(), supQuoteBO.getQuoteMoney());
                }
                if (CollUtil.isNotEmpty((Collection)(orgSupTagBOS = (List)supBlackMap.get(supId = supQuoteBO.getSupplierId())))) {
                    for (EnquriyOrgSupTagBO enquriyOrgSupTagBO : orgSupTagBOS) {
                        String error = StrUtil.format((CharSequence)"{}\u4e3a{}\u7684{}", (Object[])new Object[]{enquriyOrgSupTagBO.getSupplierName(), enquriyOrgSupTagBO.getOrgName(), enquriyOrgSupTagBO.getBqmc()});
                        remarkSet.add(error);
                    }
                    canSelectFlag = 0;
                    quotationSummaryBO.setBlackTagList(orgSupTagBOS);
                }
                quotationSummaryBO.setExceptFlag(Integer.valueOf(exceptFlag));
                quotationSummaryBO.setExceptRatio(exceptVal);
                quotationSummaryBO.setCanSelectFlag(Integer.valueOf(canSelectFlag));
                quotationSummaryBOList.add(quotationSummaryBO);
                ++var15_22;
            }
        }
        if (CollUtil.isNotEmpty(remarkSet)) {
            rspBO.setConfirmRemark(CollUtil.join(remarkSet, (CharSequence)";"));
        }
        rspBO.setRows(quotationSummaryBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BigDecimal getExceptPrice() {
        ConfParaPO confQueryPO = new ConfParaPO();
        confQueryPO.setConfCode("exceptPrice");
        ConfParaPO confParaPO = this.confParaPOMapper.selectBy(confQueryPO);
        if (confParaPO == null) {
            throw new BusinessException("8888", "\u5f02\u5e38\u4ef7\u683c\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (confParaPO.getConfVal() == null || confParaPO.getConfVal() < 1.0) {
            throw new BusinessException("8888", "\u5f02\u5e38\u4ef7\u683c\u914d\u7f6e\u8981\u5927\u4e8e0");
        }
        return new BigDecimal(confParaPO.getConfVal());
    }
}

