/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.MallMaterialsInfoBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteItemBO;
import com.tydic.enquiry.api.bo.PurchaseExecutePackBo;
import com.tydic.enquiry.api.bo.PurchaseExecuteProjectItemRspBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteItemListReqBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteItemListRspBO;
import com.tydic.enquiry.busi.api.QueryPurchaseExecuteItemListBusiService;
import com.tydic.enquiry.busi.utils.BigDecimalUtils;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.ExecutePackMapper;
import com.tydic.enquiry.dao.ProjectInfoMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.ExecutePackPO;
import com.tydic.enquiry.dao.po.ProjectInfoPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.constant.PebExtConstant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QueryPurchaseExecuteItemListBusiServiceImpl
implements QueryPurchaseExecuteItemListBusiService {
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecutePackMapper executePackMapper;
    @Autowired
    private ProjectInfoMapper projectInfoMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;

    @Override
    public QueryPurchaseExecuteItemListRspBO queryPurchaseExecuteItemList(QueryPurchaseExecuteItemListReqBO reqBO) {
        QueryPurchaseExecuteItemListRspBO rspBO = new QueryPurchaseExecuteItemListRspBO();
        ArrayList<PurchaseExecuteItemBO> purchaseExecuteItemBOList = new ArrayList<PurchaseExecuteItemBO>();
        ArrayList<PurchaseExecutePackBo> executePackBoList = new ArrayList<PurchaseExecutePackBo>();
        Long executeId = reqBO.getExecuteId();
        ExecuteItemPO record = new ExecuteItemPO();
        record.setExecuteId(reqBO.getExecuteId());
        record.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getListPage((Page<ExecuteItemPO>)page, record);
        if (CollectionUtils.isEmpty(executeItemPOList)) {
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRows(purchaseExecuteItemBOList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        boolean noBudgetFlag = false;
        if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            noBudgetFlag = true;
        }
        Byte publishBudgetFlag = this.getPublishFlag(executeId, reqBO.getIsProfessionalOrgExt());
        HashMap<Long, PurchaseExecutePackBo> executePackMap = new HashMap<Long, PurchaseExecutePackBo>();
        List<ExecutePackPO> executePackPOList = this.executePackMapper.selectByExecuteId(reqBO.getExecuteId(), null);
        if (!CollectionUtils.isEmpty(executeItemPOList)) {
            for (ExecutePackPO executePackPO : executePackPOList) {
                PurchaseExecutePackBo purchaseExecutePackBo = new PurchaseExecutePackBo();
                BeanUtils.copyProperties((Object)executePackPO, (Object)purchaseExecutePackBo);
                ArrayList itemBOList = new ArrayList();
                purchaseExecutePackBo.setItemBOList((List)itemBOList);
                executePackMap.put(executePackPO.getPackId(), purchaseExecutePackBo);
            }
        }
        ArrayList<Long> projectIdList = new ArrayList<Long>();
        HashSet projectIdSet = new HashSet();
        ArrayList<Long> relateIdList = new ArrayList<Long>();
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            PurchaseExecuteItemBO purchaseExecuteBillBo = new PurchaseExecuteItemBO();
            BeanUtils.copyProperties((Object)executeItemPO, (Object)purchaseExecuteBillBo);
            purchaseExecuteBillBo.setPlanItemId(executeItemPO.getPlanDetailId());
            if (executeItemPO.getPackId() != null && executePackMap.get(executeItemPO.getPackId()) != null) {
                PurchaseExecutePackBo purchaseExecutePackBo = (PurchaseExecutePackBo)executePackMap.get(executeItemPO.getPackId());
                List itemBOList = purchaseExecutePackBo.getItemBOList();
                itemBOList.add(purchaseExecuteBillBo);
                purchaseExecutePackBo.setItemCount(Integer.valueOf(itemBOList.size()));
                purchaseExecutePackBo.setItemBOList(itemBOList);
                executePackMap.put(executeItemPO.getPackId(), purchaseExecutePackBo);
                purchaseExecuteBillBo.setPackCode(purchaseExecutePackBo.getPackCode());
                purchaseExecuteBillBo.setPackName(purchaseExecutePackBo.getPackName());
            }
            if (executeItemPO.getDsfjczm() != null) {
                purchaseExecuteBillBo.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemPO.getDsfjczm()));
            }
            if (executeItemPO.getPtfw() != null) {
                purchaseExecuteBillBo.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemPO.getPtfw()));
            }
            purchaseExecuteBillBo.setBzfsName(EnquiryCommonUtil.getBzfsName(executeItemPO.getBzfs()));
            if (executeItemPO.getQuotedEffTime() != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String quotedEffectiveTime = format.format(executeItemPO.getQuotedEffTime());
                purchaseExecuteBillBo.setQuotedEffectiveTime(quotedEffectiveTime);
                purchaseExecuteBillBo.setQuotedEffTimeStr(quotedEffectiveTime);
            }
            if (publishBudgetFlag == 0) {
                purchaseExecuteBillBo.setBudgetPrice("*");
                purchaseExecuteBillBo.setBudgetMoney("*");
                purchaseExecuteBillBo.setYsje("*");
            } else {
                purchaseExecuteBillBo.setYsje(BigDecimalUtils.bigDecimalToStr(executeItemPO.getBudgetMoney()));
            }
            purchaseExecuteBillBo.setDemanderOrgId(executeItemPO.getDemandOrgId());
            purchaseExecuteBillBo.setDemanderOrgName(executeItemPO.getDemandOrgName());
            purchaseExecuteBillBo.setDistributeAddressId(executeItemPO.getDistributeAddressId());
            purchaseExecuteBillBo.setDistributeAddress(executeItemPO.getDistributeAddress());
            purchaseExecuteBillBo.setWlbhName(executeItemPO.getWlbhStr());
            purchaseExecuteBillBo.setWxflName(executeItemPO.getWxflStr());
            purchaseExecuteBillBo.setJhly(executeItemPO.getPlanSource());
            purchaseExecuteBillBo.setJhlyName(executeItemPO.getPlanSource());
            if (!StringUtils.isEmpty((Object)purchaseExecuteBillBo.getWxfl()) && !StringUtils.isEmpty((Object)purchaseExecuteBillBo.getWxflStr())) {
                purchaseExecuteBillBo.setWxflDescribe(purchaseExecuteBillBo.getWxfl() + "-" + purchaseExecuteBillBo.getWxflStr());
            }
            if (!StringUtils.isEmpty((Object)purchaseExecuteBillBo.getWlbh()) && !StringUtils.isEmpty((Object)purchaseExecuteBillBo.getWlbhStr())) {
                purchaseExecuteBillBo.setWlbhDescribe(purchaseExecuteBillBo.getWlbh() + "-" + purchaseExecuteBillBo.getWlbhStr());
            }
            if (!StringUtils.isEmpty((Object)purchaseExecuteBillBo.getJhmc()) && !StringUtils.isEmpty((Object)purchaseExecuteBillBo.getZxlsjhbh())) {
                purchaseExecuteBillBo.setPlanDescribe(purchaseExecuteBillBo.getZxlsjhbh() + "-" + purchaseExecuteBillBo.getJhmc());
            }
            if (!StringUtils.isEmpty((Object)purchaseExecuteBillBo.getProjectCode()) && !StringUtils.isEmpty((Object)purchaseExecuteBillBo.getProjectName())) {
                purchaseExecuteBillBo.setProject(purchaseExecuteBillBo.getProjectCode() + "-" + purchaseExecuteBillBo.getProjectName());
            }
            purchaseExecuteBillBo.setBeiz(executeItemPO.getBz());
            purchaseExecuteBillBo.setPlanItemId(executeItemPO.getPlanDetailId());
            if (executeItemPO.getSecondBargainingId() != null) {
                purchaseExecuteBillBo.setSecondBargainingId(executeItemPO.getSecondBargainingId().toString());
            }
            if (!StringUtils.isEmpty((Object)executeItemPO.getProjectIdJson())) {
                purchaseExecuteBillBo.setProjectIdList(JSONObject.parseArray((String)executeItemPO.getProjectIdJson(), Long.class));
            }
            if (!CollectionUtils.isEmpty((Collection)purchaseExecuteBillBo.getProjectIdList())) {
                projectIdSet.addAll(purchaseExecuteBillBo.getProjectIdList());
            }
            relateIdList.add(executeItemPO.getSecondBargainingId());
            if (noBudgetFlag) {
                purchaseExecuteBillBo.setYsje(null);
                purchaseExecuteBillBo.setBudgetMoney(null);
                purchaseExecuteBillBo.setBudgetPrice(null);
                purchaseExecuteBillBo.setLscgdj(null);
            }
            purchaseExecuteItemBOList.add(purchaseExecuteBillBo);
        }
        BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
        basFileInfoPO.setBillType("1001");
        basFileInfoPO.setRelateIdList(relateIdList);
        List<BasFileInfoPO> basFileInfoPOList = this.basFileInfoMapper.selectFileInfoList(basFileInfoPO);
        if (!CollectionUtils.isEmpty(basFileInfoPOList)) {
            HashMap basFileInfoBOListMap = new HashMap();
            for (BasFileInfoPO basFileInfoPo : basFileInfoPOList) {
                List<EnquiryBasFileInfoBO> basFileInfoBOList;
                EnquiryBasFileInfoBO enquiryBasFileInfoBO = (EnquiryBasFileInfoBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)basFileInfoPo), EnquiryBasFileInfoBO.class);
                if (basFileInfoBOListMap.get(basFileInfoPo.getRelateId()) != null) {
                    basFileInfoBOList = (List)basFileInfoBOListMap.get(basFileInfoPo.getRelateId());
                    basFileInfoBOList.add(enquiryBasFileInfoBO);
                    basFileInfoBOListMap.put(basFileInfoPo.getRelateId(), basFileInfoBOList);
                    continue;
                }
                basFileInfoBOList = new ArrayList<EnquiryBasFileInfoBO>();
                basFileInfoBOList.add(enquiryBasFileInfoBO);
                basFileInfoBOListMap.put(basFileInfoPo.getRelateId(), basFileInfoBOList);
            }
            for (PurchaseExecuteItemBO purchaseExecuteBillBo : purchaseExecuteItemBOList) {
                if (StringUtils.isEmpty((Object)purchaseExecuteBillBo.getSecondBargainingId())) continue;
                purchaseExecuteBillBo.setFileInfoBOList((List)basFileInfoBOListMap.get(Long.valueOf(purchaseExecuteBillBo.getSecondBargainingId())));
            }
        }
        if (!CollectionUtils.isEmpty(projectIdSet)) {
            HashMap<Long, ProjectInfoPO> projectInfoPOMap = new HashMap<Long, ProjectInfoPO>();
            projectIdList.addAll(projectIdSet);
            ProjectInfoPO qryProjectInfoPO = new ProjectInfoPO();
            qryProjectInfoPO.setProjectIdList(projectIdList);
            List<ProjectInfoPO> projectInfoPOList = this.projectInfoMapper.selectListPageByCondition(qryProjectInfoPO);
            for (ProjectInfoPO projectInfoPO : projectInfoPOList) {
                projectInfoPOMap.put(projectInfoPO.getProjectId(), projectInfoPO);
            }
            for (PurchaseExecuteItemBO purchaseExecuteBillBo : purchaseExecuteItemBOList) {
                String projectStr = "";
                ArrayList<String> projectNameList = new ArrayList<String>();
                if (CollectionUtils.isEmpty((Collection)purchaseExecuteBillBo.getProjectIdList())) continue;
                for (Long projectId : purchaseExecuteBillBo.getProjectIdList()) {
                    if (projectInfoPOMap.get(projectId) == null) continue;
                    ProjectInfoPO projectInfoPO = (ProjectInfoPO)projectInfoPOMap.get(projectId);
                    projectStr = projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName() + ";";
                    projectNameList.add(projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName());
                }
                purchaseExecuteBillBo.setProjectNameList(projectNameList);
                purchaseExecuteBillBo.setProjectStr(projectStr);
            }
        }
        if (executePackMap.size() > 0) {
            for (PurchaseExecutePackBo executePackBo : executePackMap.values()) {
                executePackBoList.add(executePackBo);
            }
        }
        rspBO.setExecutePackBoList(executePackBoList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(purchaseExecuteItemBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public Byte getPublishFlag(Long executeId, String isProfessionalOrgExt) {
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        Byte publishBudgetFlag = 1;
        if ("2".equals(isProfessionalOrgExt)) {
            publishBudgetFlag = 0;
            if (executeBillPO.getPublishBudgetFlag() != null) {
                publishBudgetFlag = executeBillPO.getPublishBudgetFlag();
            }
        }
        return publishBudgetFlag;
    }

    @Override
    public QueryPurchaseExecuteItemListRspBO queryPurchaseExecuteItemTempList(QueryPurchaseExecuteItemListReqBO reqBO) {
        QueryPurchaseExecuteItemListRspBO rspBO = new QueryPurchaseExecuteItemListRspBO();
        ArrayList<PurchaseExecuteItemBO> purchaseExecuteItemBOList = new ArrayList<PurchaseExecuteItemBO>();
        ExecuteItemPO record = new ExecuteItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getTempListPage((Page<ExecuteItemPO>)page, record);
        ArrayList<PurchaseExecutePackBo> executePackBoList = new ArrayList<PurchaseExecutePackBo>();
        HashMap<String, PurchaseExecutePackBo> executePackMap = new HashMap<String, PurchaseExecutePackBo>();
        if (CollectionUtils.isEmpty(executeItemPOList)) {
            rspBO.setExecutePackBoList(executePackBoList);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRows(purchaseExecuteItemBOList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<Long> projectIdList = new ArrayList<Long>();
        HashSet projectIdSet = new HashSet();
        ArrayList<Long> relateIdList = new ArrayList<Long>();
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            ArrayList<PurchaseExecuteItemBO> itemBOList;
            PurchaseExecutePackBo purchaseExecutePackBo;
            PurchaseExecuteItemBO purchaseExecuteBillBo = new PurchaseExecuteItemBO();
            BeanUtils.copyProperties((Object)executeItemPO, (Object)purchaseExecuteBillBo);
            purchaseExecuteBillBo.setPlanItemId(executeItemPO.getPlanDetailId());
            if (!StringUtils.isEmpty((Object)executeItemPO.getPackCode()) && executePackMap.get(executeItemPO.getPackCode()) != null) {
                purchaseExecutePackBo = (PurchaseExecutePackBo)executePackMap.get(executeItemPO.getPackCode());
                itemBOList = purchaseExecutePackBo.getItemBOList();
                itemBOList.add(purchaseExecuteBillBo);
                purchaseExecutePackBo.setItemCount(Integer.valueOf(itemBOList.size()));
                purchaseExecutePackBo.setItemBOList(itemBOList);
                executePackMap.put(executeItemPO.getPackCode(), purchaseExecutePackBo);
            } else if (!StringUtils.isEmpty((Object)executeItemPO.getPackCode()) && executePackMap.get(executeItemPO.getPackCode()) == null) {
                purchaseExecutePackBo = new PurchaseExecutePackBo();
                purchaseExecutePackBo.setPackCode(executeItemPO.getPackCode());
                purchaseExecutePackBo.setPackName(executeItemPO.getPackName());
                itemBOList = new ArrayList<PurchaseExecuteItemBO>();
                itemBOList.add(purchaseExecuteBillBo);
                purchaseExecutePackBo.setItemBOList(itemBOList);
                purchaseExecutePackBo.setItemCount(Integer.valueOf(1));
                executePackMap.put(executeItemPO.getPackCode(), purchaseExecutePackBo);
            }
            if (executeItemPO.getDsfjczm() != null) {
                purchaseExecuteBillBo.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemPO.getDsfjczm()));
            }
            if (executeItemPO.getPtfw() != null) {
                purchaseExecuteBillBo.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemPO.getPtfw()));
            }
            purchaseExecuteBillBo.setBzfsName(EnquiryCommonUtil.getBzfsName(executeItemPO.getBzfs()));
            if (executeItemPO.getQuotedEffTime() != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String quotedEffectiveTime = format.format(executeItemPO.getQuotedEffTime());
                purchaseExecuteBillBo.setQuotedEffectiveTime(quotedEffectiveTime);
                purchaseExecuteBillBo.setQuotedEffTimeStr(quotedEffectiveTime);
            }
            purchaseExecuteBillBo.setBeiz(executeItemPO.getBz());
            purchaseExecuteBillBo.setYsje(BigDecimalUtils.bigDecimalToStr(executeItemPO.getBudgetMoney()));
            purchaseExecuteBillBo.setDemanderOrgId(executeItemPO.getDemandOrgId());
            purchaseExecuteBillBo.setDemanderOrgName(executeItemPO.getDemandOrgName());
            purchaseExecuteBillBo.setDistributeAddressId(executeItemPO.getDistributeAddressId());
            purchaseExecuteBillBo.setDistributeAddress(executeItemPO.getDistributeAddress());
            purchaseExecuteBillBo.setWlbhName(executeItemPO.getWlbhStr());
            purchaseExecuteBillBo.setWxflName(executeItemPO.getWxflStr());
            purchaseExecuteBillBo.setJhly(executeItemPO.getPlanSource());
            purchaseExecuteBillBo.setJhlyName(executeItemPO.getPlanSource());
            purchaseExecuteBillBo.setBeiz(executeItemPO.getBz());
            if (!StringUtils.isEmpty((Object)executeItemPO.getProjectIdJson())) {
                purchaseExecuteBillBo.setProjectIdList(JSONObject.parseArray((String)executeItemPO.getProjectIdJson(), Long.class));
            }
            if (!CollectionUtils.isEmpty((Collection)purchaseExecuteBillBo.getProjectIdList())) {
                projectIdSet.addAll(purchaseExecuteBillBo.getProjectIdList());
            }
            if (executeItemPO.getSecondBargainingId() != null) {
                purchaseExecuteBillBo.setSecondBargainingId(executeItemPO.getSecondBargainingId().toString());
            }
            purchaseExecuteItemBOList.add(purchaseExecuteBillBo);
            relateIdList.add(executeItemPO.getSecondBargainingId());
        }
        BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
        basFileInfoPO.setBillType("1001");
        basFileInfoPO.setRelateIdList(relateIdList);
        List<BasFileInfoPO> basFileInfoPOList = this.basFileInfoMapper.selectFileInfoList(basFileInfoPO);
        if (!CollectionUtils.isEmpty(basFileInfoPOList)) {
            HashMap basFileInfoBOListMap = new HashMap();
            for (BasFileInfoPO basFileInfoPo : basFileInfoPOList) {
                List<EnquiryBasFileInfoBO> basFileInfoBOList;
                EnquiryBasFileInfoBO enquiryBasFileInfoBO = (EnquiryBasFileInfoBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)basFileInfoPo), EnquiryBasFileInfoBO.class);
                if (basFileInfoBOListMap.get(basFileInfoPo.getRelateId()) != null) {
                    basFileInfoBOList = (List)basFileInfoBOListMap.get(basFileInfoPo.getRelateId());
                    basFileInfoBOList.add(enquiryBasFileInfoBO);
                    basFileInfoBOListMap.put(basFileInfoPo.getRelateId(), basFileInfoBOList);
                    continue;
                }
                basFileInfoBOList = new ArrayList<EnquiryBasFileInfoBO>();
                basFileInfoBOList.add(enquiryBasFileInfoBO);
                basFileInfoBOListMap.put(basFileInfoPo.getRelateId(), basFileInfoBOList);
            }
            for (PurchaseExecuteItemBO purchaseExecuteBillBo : purchaseExecuteItemBOList) {
                if (StringUtils.isEmpty((Object)purchaseExecuteBillBo.getSecondBargainingId())) continue;
                purchaseExecuteBillBo.setFileInfoBOList((List)basFileInfoBOListMap.get(Long.valueOf(purchaseExecuteBillBo.getSecondBargainingId())));
            }
        }
        if (!CollectionUtils.isEmpty(projectIdSet)) {
            HashMap<Long, ProjectInfoPO> projectInfoPOMap = new HashMap<Long, ProjectInfoPO>();
            projectIdList.addAll(projectIdSet);
            ProjectInfoPO qryProjectInfoPO = new ProjectInfoPO();
            qryProjectInfoPO.setProjectIdList(projectIdList);
            List<ProjectInfoPO> projectInfoPOList = this.projectInfoMapper.selectListPageByCondition(qryProjectInfoPO);
            for (ProjectInfoPO projectInfoPO : projectInfoPOList) {
                projectInfoPOMap.put(projectInfoPO.getProjectId(), projectInfoPO);
            }
            for (PurchaseExecuteItemBO purchaseExecuteBillBo : purchaseExecuteItemBOList) {
                String projectStr = "";
                ArrayList<String> projectNameList = new ArrayList<String>();
                if (CollectionUtils.isEmpty((Collection)purchaseExecuteBillBo.getProjectIdList())) continue;
                for (Long projectId : purchaseExecuteBillBo.getProjectIdList()) {
                    if (projectInfoPOMap.get(projectId) == null) continue;
                    ProjectInfoPO projectInfoPO = (ProjectInfoPO)projectInfoPOMap.get(projectId);
                    projectStr = projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName() + ";";
                    projectNameList.add(projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName());
                }
                purchaseExecuteBillBo.setProjectNameList(projectNameList);
                purchaseExecuteBillBo.setProjectStr(projectStr);
            }
        }
        if (executePackMap.size() > 0) {
            for (PurchaseExecutePackBo executePackBo : executePackMap.values()) {
                executePackBoList.add(executePackBo);
            }
        }
        rspBO.setExecutePackBoList(executePackBoList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(purchaseExecuteItemBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public QueryPurchaseExecuteItemListRspBO queryPurchaseExecuteProjectItemTempList(QueryPurchaseExecuteItemListReqBO reqBO) {
        QueryPurchaseExecuteItemListRspBO rspBO = new QueryPurchaseExecuteItemListRspBO();
        ExecuteItemPO record = new ExecuteItemPO();
        int projectItemMostCount = 0;
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        if ("1".equals(reqBO.getConfirmDealType().toString())) {
            record.setProjectIdJson(null);
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getProjectIdList())) {
            record.setProjectIdJson(JSON.toJSONString((Object)reqBO.getProjectIdList()));
        }
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getTempList(record);
        ArrayList<PurchaseExecutePackBo> executePackBoList = new ArrayList<PurchaseExecutePackBo>();
        HashMap<String, PurchaseExecutePackBo> executePackMap = new HashMap<String, PurchaseExecutePackBo>();
        ArrayList purchaseExecuteItemBOList = new ArrayList();
        if (CollectionUtils.isEmpty(executeItemPOList)) {
            rspBO.setExecutePackBoList(executePackBoList);
            rspBO.setRows(purchaseExecuteItemBOList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setProjectItemMostCount(Integer.valueOf(projectItemMostCount));
            return rspBO;
        }
        HashSet<String> projectIdJsonSet = new HashSet<String>();
        HashMap projectWlbhWxflMap = new HashMap();
        HashSet<MallMaterialsInfoBO> allMallMaterialsInfoBOSet = new HashSet<MallMaterialsInfoBO>();
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            ArrayList<PurchaseExecuteItemBO> itemBOList;
            PurchaseExecutePackBo purchaseExecutePackBo;
            Set<MallMaterialsInfoBO> mallMaterialsInfoBOSet;
            PurchaseExecuteItemBO purchaseExecuteBillBo = this.buildExecuteItemBO(executeItemPO);
            MallMaterialsInfoBO mallMaterialsInfoBO = new MallMaterialsInfoBO();
            mallMaterialsInfoBO.setWlbh(executeItemPO.getWlbh());
            mallMaterialsInfoBO.setWxfl(executeItemPO.getWxfl());
            allMallMaterialsInfoBOSet.add(mallMaterialsInfoBO);
            if (!StringUtils.isEmpty((Object)executeItemPO.getProjectIdJson()) && projectWlbhWxflMap.get(purchaseExecuteBillBo.getProjectIdJson()) != null) {
                mallMaterialsInfoBOSet = (Set)projectWlbhWxflMap.get(purchaseExecuteBillBo.getProjectIdJson());
                mallMaterialsInfoBOSet.add(mallMaterialsInfoBO);
                projectWlbhWxflMap.put(purchaseExecuteBillBo.getProjectIdJson(), mallMaterialsInfoBOSet);
                projectIdJsonSet.add(executeItemPO.getProjectIdJson());
            } else if (!StringUtils.isEmpty((Object)executeItemPO.getProjectIdJson())) {
                mallMaterialsInfoBOSet = new HashSet<MallMaterialsInfoBO>();
                mallMaterialsInfoBOSet.add(mallMaterialsInfoBO);
                projectWlbhWxflMap.put(purchaseExecuteBillBo.getProjectIdJson(), mallMaterialsInfoBOSet);
                projectIdJsonSet.add(executeItemPO.getProjectIdJson());
            }
            if (!StringUtils.isEmpty((Object)executeItemPO.getPackCode()) && executePackMap.get(executeItemPO.getPackCode()) != null) {
                purchaseExecutePackBo = (PurchaseExecutePackBo)executePackMap.get(executeItemPO.getPackCode());
                itemBOList = purchaseExecutePackBo.getItemBOList();
                itemBOList.add(purchaseExecuteBillBo);
                purchaseExecutePackBo.setItemCount(Integer.valueOf(itemBOList.size()));
                purchaseExecutePackBo.setItemBOList(itemBOList);
                executePackMap.put(executeItemPO.getPackCode(), purchaseExecutePackBo);
                continue;
            }
            if (StringUtils.isEmpty((Object)executeItemPO.getPackCode()) || executePackMap.get(executeItemPO.getPackCode()) != null) continue;
            purchaseExecutePackBo = new PurchaseExecutePackBo();
            purchaseExecutePackBo.setPackCode(executeItemPO.getPackCode());
            purchaseExecutePackBo.setPackName(executeItemPO.getPackName());
            itemBOList = new ArrayList<PurchaseExecuteItemBO>();
            itemBOList.add(purchaseExecuteBillBo);
            purchaseExecutePackBo.setItemBOList(itemBOList);
            purchaseExecutePackBo.setItemCount(Integer.valueOf(1));
            executePackMap.put(executeItemPO.getPackCode(), purchaseExecutePackBo);
        }
        if (executePackMap.size() > 0) {
            for (PurchaseExecutePackBo executePackBo : executePackMap.values()) {
                executePackBoList.add(executePackBo);
            }
        }
        ArrayList<PurchaseExecuteProjectItemRspBO> purchaseExecuteProjectItemBOList = new ArrayList<PurchaseExecuteProjectItemRspBO>();
        for (String projectIdJson : projectIdJsonSet) {
            reqBO.setProjectIdJson(projectIdJson);
            PurchaseExecuteProjectItemRspBO projectItemRspBO = this.queryProjectItemTempPage(reqBO);
            if (projectItemRspBO.getRecordsTotal() > projectItemMostCount) {
                projectItemMostCount = projectItemRspBO.getRecordsTotal();
            }
            purchaseExecuteProjectItemBOList.add(projectItemRspBO);
        }
        rspBO.setProjectItemMostCount(Integer.valueOf(projectItemMostCount));
        rspBO.setPurchaseExecuteProjectItemBOList(purchaseExecuteProjectItemBOList);
        rspBO.setExecutePackBoList(executePackBoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PurchaseExecuteProjectItemRspBO queryProjectItemTempPage(QueryPurchaseExecuteItemListReqBO reqBO) {
        String projectIdJson = reqBO.getProjectIdJson();
        if (StrUtil.isEmpty((CharSequence)projectIdJson)) {
            throw new BusinessException("7777", "projectIdJson\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PurchaseExecuteProjectItemRspBO projectItemRspBO = new PurchaseExecuteProjectItemRspBO();
        projectItemRspBO.setRespCode("0000");
        projectItemRspBO.setRespDesc("\u6210\u529f");
        HashSet<MallMaterialsInfoBO> allMallMaterialsInfoBOSet = new HashSet<MallMaterialsInfoBO>();
        HashSet<Long> projectIdSet = new HashSet<Long>();
        ExecuteItemPO pagRecord = new ExecuteItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)pagRecord);
        pagRecord.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ExecuteItemPO> executeItemPOByPagList = this.executeItemMapper.getTempListPage((Page<ExecuteItemPO>)page, pagRecord);
        ArrayList<PurchaseExecuteItemBO> purchaseProjectIdExecuteItemBOList = new ArrayList<PurchaseExecuteItemBO>();
        if (CollUtil.isEmpty(executeItemPOByPagList)) {
            projectItemRspBO.setExecutePackBoList(null);
            projectItemRspBO.setRows(null);
            return projectItemRspBO;
        }
        ArrayList<Long> relateIdList = new ArrayList<Long>();
        for (ExecuteItemPO executeItemPO : executeItemPOByPagList) {
            PurchaseExecuteItemBO purchaseExecuteBillBo = this.buildExecuteItemBO(executeItemPO);
            MallMaterialsInfoBO mallMaterialsInfoBO = new MallMaterialsInfoBO();
            mallMaterialsInfoBO.setWlbh(executeItemPO.getWlbh());
            mallMaterialsInfoBO.setWxfl(executeItemPO.getWxfl());
            allMallMaterialsInfoBOSet.add(mallMaterialsInfoBO);
            if (!StringUtils.isEmpty((Object)executeItemPO.getProjectIdJson())) {
                purchaseExecuteBillBo.setProjectIdList(JSONObject.parseArray((String)executeItemPO.getProjectIdJson(), Long.class));
            }
            if (!CollectionUtils.isEmpty((Collection)purchaseExecuteBillBo.getProjectIdList())) {
                projectIdSet.addAll(purchaseExecuteBillBo.getProjectIdList());
            }
            if (executeItemPO.getSecondBargainingId() != null) {
                purchaseExecuteBillBo.setSecondBargainingId(executeItemPO.getSecondBargainingId().toString());
            }
            purchaseProjectIdExecuteItemBOList.add(purchaseExecuteBillBo);
            relateIdList.add(executeItemPO.getSecondBargainingId());
        }
        this.getFileList(purchaseProjectIdExecuteItemBOList, relateIdList);
        this.setProjectStr(projectIdSet, projectItemRspBO, purchaseProjectIdExecuteItemBOList);
        projectItemRspBO.setProjectWlbhWxfl((List)CollUtil.newArrayList(allMallMaterialsInfoBOSet));
        projectItemRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        projectItemRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        projectItemRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        projectItemRspBO.setRows(purchaseProjectIdExecuteItemBOList);
        projectItemRspBO.setItemCount(Integer.valueOf(page.getTotalCount()));
        return projectItemRspBO;
    }

    private void setProjectStr(Set<Long> allProjectIdSet, PurchaseExecuteProjectItemRspBO purchaseExecuteProjectItemRspBO, List<PurchaseExecuteItemBO> purchaseProjectIdExecuteItemBOList) {
        if (!CollectionUtils.isEmpty(allProjectIdSet)) {
            ArrayList allProjectIdList = CollUtil.newArrayList(allProjectIdSet);
            HashMap<Long, ProjectInfoPO> projectInfoPOMap = new HashMap<Long, ProjectInfoPO>();
            ProjectInfoPO qryProjectInfoPO = new ProjectInfoPO();
            qryProjectInfoPO.setProjectIdList(allProjectIdList);
            List<ProjectInfoPO> projectInfoPOList = this.projectInfoMapper.selectListPageByCondition(qryProjectInfoPO);
            for (ProjectInfoPO projectInfoPO : projectInfoPOList) {
                projectInfoPOMap.put(projectInfoPO.getProjectId(), projectInfoPO);
            }
            for (PurchaseExecuteItemBO purchaseExecuteBillBo : purchaseProjectIdExecuteItemBOList) {
                String projectStr = "";
                if (CollectionUtils.isEmpty((Collection)purchaseExecuteBillBo.getProjectIdList())) continue;
                for (Long projectId : purchaseExecuteBillBo.getProjectIdList()) {
                    if (projectInfoPOMap.get(projectId) == null) continue;
                    ProjectInfoPO projectInfoPO = (ProjectInfoPO)projectInfoPOMap.get(projectId);
                    projectStr = projectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName() + ";";
                }
                purchaseExecuteBillBo.setProjectStr(projectStr);
            }
            String allProjectStr = "";
            for (Long projectId : allProjectIdSet) {
                if (projectInfoPOMap.get(projectId) == null) continue;
                ProjectInfoPO projectInfoPO = (ProjectInfoPO)projectInfoPOMap.get(projectId);
                allProjectStr = allProjectStr + projectInfoPO.getProjectCode() + "-" + projectInfoPO.getProjectName() + ";";
            }
            purchaseExecuteProjectItemRspBO.setProjectIdList((List)allProjectIdList);
            purchaseExecuteProjectItemRspBO.setProjectStr(allProjectStr);
        }
    }

    private void getFileList(List<PurchaseExecuteItemBO> purchaseProjectIdExecuteItemBOList, List<Long> relateIdList) {
        BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
        basFileInfoPO.setBillType("1001");
        basFileInfoPO.setRelateIdList(relateIdList);
        List<BasFileInfoPO> basFileInfoPOList = this.basFileInfoMapper.selectFileInfoList(basFileInfoPO);
        if (!CollectionUtils.isEmpty(basFileInfoPOList)) {
            HashMap basFileInfoBOListMap = new HashMap();
            for (BasFileInfoPO basFileInfoPo : basFileInfoPOList) {
                List<EnquiryBasFileInfoBO> basFileInfoBOList;
                EnquiryBasFileInfoBO enquiryBasFileInfoBO = (EnquiryBasFileInfoBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)basFileInfoPo), EnquiryBasFileInfoBO.class);
                if (basFileInfoBOListMap.get(basFileInfoPo.getRelateId()) != null) {
                    basFileInfoBOList = (List)basFileInfoBOListMap.get(basFileInfoPo.getRelateId());
                    basFileInfoBOList.add(enquiryBasFileInfoBO);
                    basFileInfoBOListMap.put(basFileInfoPo.getRelateId(), basFileInfoBOList);
                    continue;
                }
                basFileInfoBOList = new ArrayList<EnquiryBasFileInfoBO>();
                basFileInfoBOList.add(enquiryBasFileInfoBO);
                basFileInfoBOListMap.put(basFileInfoPo.getRelateId(), basFileInfoBOList);
            }
            for (PurchaseExecuteItemBO purchaseExecuteBillBo : purchaseProjectIdExecuteItemBOList) {
                if (StringUtils.isEmpty((Object)purchaseExecuteBillBo.getSecondBargainingId())) continue;
                purchaseExecuteBillBo.setFileInfoBOList((List)basFileInfoBOListMap.get(Long.valueOf(purchaseExecuteBillBo.getSecondBargainingId())));
            }
        }
    }

    private PurchaseExecuteItemBO buildExecuteItemBO(ExecuteItemPO executeItemPO) {
        PurchaseExecuteItemBO purchaseExecuteBillBo = new PurchaseExecuteItemBO();
        BeanUtils.copyProperties((Object)executeItemPO, (Object)purchaseExecuteBillBo);
        purchaseExecuteBillBo.setPlanItemId(executeItemPO.getPlanDetailId());
        if (executeItemPO.getDsfjczm() != null) {
            purchaseExecuteBillBo.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemPO.getDsfjczm()));
        }
        if (executeItemPO.getPtfw() != null) {
            purchaseExecuteBillBo.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemPO.getPtfw()));
        }
        purchaseExecuteBillBo.setBzfsName(EnquiryCommonUtil.getBzfsName(executeItemPO.getBzfs()));
        if (executeItemPO.getQuotedEffTime() != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String quotedEffectiveTime = format.format(executeItemPO.getQuotedEffTime());
            purchaseExecuteBillBo.setQuotedEffectiveTime(quotedEffectiveTime);
            purchaseExecuteBillBo.setQuotedEffTimeStr(quotedEffectiveTime);
        }
        purchaseExecuteBillBo.setYsje(BigDecimalUtils.bigDecimalToStr(executeItemPO.getBudgetMoney()));
        purchaseExecuteBillBo.setDemanderOrgId(executeItemPO.getDemandOrgId());
        purchaseExecuteBillBo.setDemanderOrgName(executeItemPO.getDemandOrgName());
        purchaseExecuteBillBo.setDistributeAddressId(executeItemPO.getDistributeAddressId());
        purchaseExecuteBillBo.setDistributeAddress(executeItemPO.getDistributeAddress());
        purchaseExecuteBillBo.setWlbhName(executeItemPO.getWlbhStr());
        purchaseExecuteBillBo.setWxflName(executeItemPO.getWxflStr());
        purchaseExecuteBillBo.setJhly(executeItemPO.getPlanSource());
        purchaseExecuteBillBo.setJhlyName(executeItemPO.getPlanSource());
        purchaseExecuteBillBo.setBeiz(executeItemPO.getBz());
        return purchaseExecuteBillBo;
    }
}

