/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteBillBo;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteListReqBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteListRspBO;
import com.tydic.enquiry.busi.api.QueryPurchaseExecuteListBusiService;
import com.tydic.enquiry.busi.api.bo.QueryExecuteBusiBO;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.DealConfirmItemMapper;
import com.tydic.enquiry.dao.DealNoticeMapper;
import com.tydic.enquiry.dao.ExecuteApprovalMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.po.DealConfirmItemPO;
import com.tydic.enquiry.dao.po.DealNoticePO;
import com.tydic.enquiry.dao.po.ExecuteApprovalPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.ability.plan.PebExtPlanItemDetailQueryAbilityService;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingListQueryReqBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingListQueryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryPurchaseExecuteListBusiServiceImpl
implements QueryPurchaseExecuteListBusiService {
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private DealNoticeMapper dealNoticeMapper;
    @Autowired
    private PebExtPlanItemDetailQueryAbilityService pebExtPlanItemDetailQueryAbilityService;
    @Autowired
    private ExecuteApprovalMapper executeApprovalMapper;
    @Autowired
    DealConfirmItemMapper dealConfirmItemMapper;

    @Override
    public QueryPurchaseExecuteListRspBO queryPurchaseExecuteList(QueryPurchaseExecuteListReqBO reqBO) {
        boolean noNoteFlag;
        Integer tabId = reqBO.getTabId();
        if (tabId == null) {
            throw new BusinessException("7777", "\u9875\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        QueryExecuteBusiBO queryPO = new QueryExecuteBusiBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPO);
        if (new Integer(1).equals(reqBO.getQryMemuFlag()) && "0".equals(reqBO.getIsProfessionalOrgExt())) {
            queryPO.setQryAllFlag(1);
        }
        if (StrUtil.isBlank((CharSequence)reqBO.getCreateUserName())) {
            queryPO.setCreateUserId(reqBO.getUserId().toString());
        }
        queryPO.setExecuteStatusList(EnquiryEnumConstant.executeStatusTabEnum.getExecuteStatusList((Integer)reqBO.getTabId()));
        queryPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        queryPO.setOrderBy("create_time DESC");
        boolean bl = noNoteFlag = tabId == 1 || tabId == 2 || tabId == 3 || tabId == 4 || tabId == 9;
        if (!noNoteFlag) {
            Byte noteFlag = this.getNoteFlag(reqBO);
            queryPO.setNoticeFlag(noteFlag);
        }
        queryPO.setQueryTabId(tabId);
        if (tabId == 8) {
            queryPO.setExecuteStatusList(CollUtil.newArrayList((Object[])new String[]{"2008"}));
            if (StrUtil.isBlank((CharSequence)queryPO.getDetailDocStatus())) {
                queryPO.setFailStatus("2008");
            }
        }
        List<ExecuteBillPO> executeBillPOList = this.executeBillMapper.getExecuteListPage((Page<ExecuteBillPO>)page, queryPO);
        QueryPurchaseExecuteListRspBO rspBO = new QueryPurchaseExecuteListRspBO();
        ArrayList<PurchaseExecuteBillBo> purchaseExecuteBillBoList = new ArrayList<PurchaseExecuteBillBo>();
        rspBO.setTabId(tabId);
        if (CollUtil.isNotEmpty(executeBillPOList)) {
            Map<Object, Object> noticeMap = new HashMap();
            if (!noNoteFlag) {
                List<Long> executeList = executeBillPOList.stream().map(ExecuteBillPO::getExecuteId).collect(Collectors.toList());
                DealNoticePO qryDealNoticePO = new DealNoticePO();
                qryDealNoticePO.setExecuteIdList(executeList);
                qryDealNoticePO.setOrderBy("create_time DESC");
                List<DealNoticePO> dealNoticePOList = this.dealNoticeMapper.getList(qryDealNoticePO);
                ArrayList<EnquiryDealNoticeBO> noticeBOList = new ArrayList<EnquiryDealNoticeBO>();
                if (CollUtil.isNotEmpty(dealNoticePOList)) {
                    for (DealNoticePO dealNoticePO : dealNoticePOList) {
                        EnquiryDealNoticeBO dealNoticeBO = new EnquiryDealNoticeBO();
                        BeanUtil.copyProperties((Object)dealNoticePO, (Object)dealNoticeBO);
                        dealNoticeBO.setExecuteTypeStr(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)dealNoticeBO.getExecuteType()));
                        dealNoticeBO.setDealBillStatusStr(EnquiryEnumConstant.DealNoticeStatusEnum.getDesc((String)dealNoticeBO.getDealBillStatus()));
                        noticeBOList.add(dealNoticeBO);
                    }
                    if (CollUtil.isNotEmpty(noticeBOList)) {
                        noticeMap = noticeBOList.stream().collect(Collectors.groupingBy(EnquiryDealNoticeBO::getExecuteId));
                    }
                }
            }
            ArrayList<Long> executeIdList = new ArrayList<Long>();
            for (ExecuteBillPO executeBillPO : executeBillPOList) {
                PurchaseExecuteBillBo purchaseExecuteBillBo = new PurchaseExecuteBillBo();
                BeanUtils.copyProperties((Object)executeBillPO, (Object)purchaseExecuteBillBo);
                EnquiryCommonUtil.transExecuteBillBO(purchaseExecuteBillBo);
                Long executeId = executeBillPO.getExecuteId();
                if (noticeMap.containsKey(executeId)) {
                    purchaseExecuteBillBo.setDealConfirmBOList((List)noticeMap.get(executeId));
                }
                purchaseExecuteBillBo.setDealReason(executeBillPO.getExecuteFailReason());
                int canDealFlag = 1;
                if (tabId == 5) {
                    canDealFlag = this.getCanDealFlag(executeId);
                }
                purchaseExecuteBillBo.setCanDealFlag(Integer.valueOf(canDealFlag));
                executeIdList.add(executeId);
                purchaseExecuteBillBoList.add(purchaseExecuteBillBo);
            }
            if (tabId == 1) {
                ExecuteApprovalPO qryExecuteApprovalPO = new ExecuteApprovalPO();
                qryExecuteApprovalPO.setOrderBy("create_time DESC");
                qryExecuteApprovalPO.setExecuteIdList(executeIdList);
                List<ExecuteApprovalPO> executeApprovalPOList = this.executeApprovalMapper.getList(qryExecuteApprovalPO);
                if (CollUtil.isNotEmpty(executeApprovalPOList)) {
                    block2: for (PurchaseExecuteBillBo purchaseExecuteBillBo : purchaseExecuteBillBoList) {
                        for (ExecuteApprovalPO executeApprovalPO : executeApprovalPOList) {
                            if (executeApprovalPO.getExecuteId().longValue() != purchaseExecuteBillBo.getExecuteId().longValue()) continue;
                            purchaseExecuteBillBo.setApprovalRemarks(executeApprovalPO.getApprovalRemarks());
                            continue block2;
                        }
                    }
                }
            }
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(purchaseExecuteBillBoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private int getCanDealFlag(Long executeId) {
        int canDealFlag = 1;
        ExecuteItemPO executeItemPO = new ExecuteItemPO();
        executeItemPO.setExecuteId(executeId);
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(executeItemPO);
        if (CollUtil.isNotEmpty(executeItemPOList)) {
            List<Long> allExecuteItemList = executeItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
            DealConfirmItemPO itemQueryPO = new DealConfirmItemPO();
            itemQueryPO.setExecuteItemIdList(allExecuteItemList);
            List<DealConfirmItemPO> itemPOList = this.dealConfirmItemMapper.selectItemExistsBy(itemQueryPO);
            List<Object> existIdList = new ArrayList();
            if (CollUtil.isNotEmpty(itemPOList)) {
                existIdList = itemPOList.stream().map(DealConfirmItemPO::getExecuteItemId).collect(Collectors.toList());
            }
            ArrayList<Long> notExistItemList = new ArrayList<Long>();
            for (Long executeItemId : allExecuteItemList) {
                if (existIdList.contains(executeItemId)) continue;
                notExistItemList.add(executeItemId);
            }
            if (CollUtil.isEmpty(notExistItemList)) {
                canDealFlag = 0;
            }
        }
        return canDealFlag;
    }

    private byte getNoteFlag(QueryPurchaseExecuteListReqBO reqBO) {
        byte noteFlag = 0;
        if (StrUtil.isNotBlank((CharSequence)reqBO.getDealNoticeCode())) {
            noteFlag = 1;
        }
        if (StrUtil.isNotBlank((CharSequence)reqBO.getConfirmOperName())) {
            noteFlag = 1;
        }
        if (reqBO.getSupConfirmTimeStart() != null) {
            noteFlag = 1;
        }
        if (reqBO.getSupConfirmTimeEnd() != null) {
            noteFlag = 1;
        }
        return noteFlag;
    }

    @Override
    public QueryPurchaseExecuteListRspBO queryPurchaseExecuteListByPlan(QueryPurchaseExecuteListReqBO reqBO) {
        QueryPurchaseExecuteListRspBO rspBO = new QueryPurchaseExecuteListRspBO();
        ArrayList<PurchaseExecuteBillBo> purchaseExecuteBillBoList = new ArrayList<PurchaseExecuteBillBo>();
        ArrayList<Long> planDetailIdList = new ArrayList<Long>();
        if (reqBO.getPlanId() != null) {
            PebExtPlanItemSecondBargainingListQueryReqBO qryPebExtPlanItemBo = new PebExtPlanItemSecondBargainingListQueryReqBO();
            qryPebExtPlanItemBo.setPlanId(reqBO.getPlanId());
            PebExtPlanItemSecondBargainingListQueryRspBO planItemListQueryRspBO = this.pebExtPlanItemDetailQueryAbilityService.qryPlanItemListSecondBargainingQuery(qryPebExtPlanItemBo);
            List planItemBoList = planItemListQueryRspBO.getRows();
            if (CollectionUtils.isEmpty((Collection)planItemBoList)) {
                throw new BusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            for (PebExtPlanItemSecondBargainingBO planItemBO : planItemBoList) {
                planDetailIdList.add(planItemBO.getPlanItemId());
            }
        }
        ExecuteItemPO qryExecuteItemPO = new ExecuteItemPO();
        qryExecuteItemPO.setPlanDetailId(reqBO.getPlanItemId());
        qryExecuteItemPO.setPlanDetailIdList(planDetailIdList);
        qryExecuteItemPO.setOrderBy("execute_id");
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(qryExecuteItemPO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (CollectionUtils.isEmpty(executeItemPOList)) {
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRows(purchaseExecuteBillBoList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ExecuteBillPO record = new ExecuteBillPO();
        record.setOrderBy("create_time DESC");
        HashSet<Long> executeIdSet = new HashSet<Long>();
        ArrayList<Long> executeIdList = new ArrayList<Long>();
        for (ExecuteItemPO executeItemPO : executeItemPOList) {
            executeIdSet.add(executeItemPO.getExecuteId());
        }
        executeIdList.addAll(executeIdSet);
        record.setExecuteIdList(executeIdList);
        record.setExecuteStatusList(EnquiryEnumConstant.executeStatusTabEnum.getExecuteStatusList((Integer)10));
        List<ExecuteBillPO> executeBillPOList = this.executeBillMapper.getListPage((Page<ExecuteBillPO>)page, record);
        for (ExecuteBillPO executeBillPO : executeBillPOList) {
            PurchaseExecuteBillBo purchaseExecuteBillBo = new PurchaseExecuteBillBo();
            BeanUtils.copyProperties((Object)executeBillPO, (Object)purchaseExecuteBillBo);
            EnquiryCommonUtil.transExecuteBillBO(purchaseExecuteBillBo);
            purchaseExecuteBillBoList.add(purchaseExecuteBillBo);
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(purchaseExecuteBillBoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

