/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.MemInfoBO;
import com.tydic.enquiry.api.bo.PurchaseQuoteInfoDealRevokeReqBO;
import com.tydic.enquiry.api.bo.PurchaseQuoteInfoDealRevokeRspBO;
import com.tydic.enquiry.api.bo.SetNextRoundQuoteReqBO;
import com.tydic.enquiry.api.bo.SetNextRoundQuoteRspBO;
import com.tydic.enquiry.busi.api.SetNextRoundQuoteBusiService;
import com.tydic.enquiry.busi.utils.sendmess.SendMessReqBO;
import com.tydic.enquiry.busi.utils.sendmess.SendMessRspBO;
import com.tydic.enquiry.busi.utils.sendmess.SendMessUtils;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasHoliDayMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.ExecuteSupJoinMapper;
import com.tydic.enquiry.dao.SSystemParaMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.BasHoliDayPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.ExecuteSupJoinPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import com.tydic.umc.ability.bo.UmcQrySupMemAbilityPageReqBO;
import com.tydic.umc.ability.user.UmcQrySupMemByPageAbilityService;
import com.tydic.umc.base.bo.UmcRspPageBO;
import com.tydic.umc.common.UmcSupMemberInfoBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SetNextRoundQuoteBusiServiceImpl
implements SetNextRoundQuoteBusiService {
    private static final Logger log = LoggerFactory.getLogger(SetNextRoundQuoteBusiServiceImpl.class);
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private ExecuteSupJoinMapper executeSupJoinMapper;
    @Autowired
    private SSystemParaMapper sSystemParaMapper;
    @Autowired
    BasHoliDayMapper basHoliDayMapper;
    @Autowired
    UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    UmcQrySupMemByPageAbilityService umcQrySupMemByPageAbilityService;

    @Override
    public SetNextRoundQuoteRspBO nextRound(SetNextRoundQuoteReqBO reqBO) {
        SetNextRoundQuoteRspBO rspBO = new SetNextRoundQuoteRspBO();
        Long start = System.currentTimeMillis();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        if (!"1".equals(executeBillPO.getExecuteType())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u662f\u8bae\u4ef7!\u4e0d\u80fd\u91cd\u65b0\u53d1\u8d77\u62a5\u4ef7");
            return rspBO;
        }
        ExecuteItemPO record = new ExecuteItemPO();
        record.setExecuteId(reqBO.getExecuteId());
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.getList(record);
        if (CollectionUtils.isEmpty(executeItemPOList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u660e\u7ec6\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        Date quoteStartTime = reqBO.getQuoteStartTime();
        Date quoteEndTime = reqBO.getQuoteEndTime();
        Calendar quoteEndTimeCalendar = Calendar.getInstance();
        quoteEndTimeCalendar.setTime(quoteEndTime);
        List<String> holiday = this.getHoliday(quoteStartTime, quoteEndTime);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        Integer lastDateCount = executeItemPOList.size() % 300 > 0 ? (executeItemPOList.size() / 300 + 1) * 3 : executeItemPOList.size() / 300 * 3;
        while (quoteStartTime.getTime() <= quoteEndTime.getTime()) {
            String quoteStartTimeStr = format.format(quoteStartTime);
            calendar.setTime(quoteStartTime);
            if (!CollUtil.isEmpty(holiday) && holiday.contains(quoteStartTimeStr)) {
                quoteEndTimeCalendar.add(5, -1);
            }
            if (CollUtil.isEmpty(holiday) && calendar.get(7) == 6 || calendar.get(7) == 7) {
                quoteEndTimeCalendar.add(5, -1);
            }
            calendar.add(5, 1);
            quoteStartTime = calendar.getTime();
            log.info("quoteStartTime:" + format.format(quoteStartTime));
        }
        long quoteTimelong = quoteEndTimeCalendar.getTime().getTime() - reqBO.getQuoteStartTime().getTime();
        long quoteTimelongday = quoteTimelong / 86400000L;
        if (quoteTimelongday < 3L || executeItemPOList.size() > 300 && quoteTimelongday < (long)lastDateCount.intValue()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u65f6\u95f4\u4e0d\u53ef\u4ee5\u5c11\u4e8e" + lastDateCount + "\u5de5\u4f5c\u65e5\uff01");
            return rspBO;
        }
        ArrayList<Long> quoteSupplierIds = new ArrayList<Long>();
        ExecuteSupJoinPO executeSupJoinPO = new ExecuteSupJoinPO();
        executeSupJoinPO.setExecuteId(reqBO.getExecuteId());
        List<ExecuteSupJoinPO> supJoinPOS = this.executeSupJoinMapper.selectListByCondition(executeSupJoinPO);
        SupQuotePO quoteQueryPO = new SupQuotePO();
        quoteQueryPO.setExecuteId(reqBO.getExecuteId());
        quoteQueryPO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
        quoteQueryPO.setQuoteRound(1);
        List<SupQuotePO> supQuotePOList = this.supQuoteMapper.selectByCondition(quoteQueryPO);
        if (CollectionUtils.isEmpty(supQuotePOList) && executeBillPO.getNeedFirstQuoteFlag() != null && executeBillPO.getNeedFirstQuoteFlag().toString() == "1") {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e3a\u9996\u8f6e\u672a\u62a5\u4ef7\u65f6\u518d\u6b21\u62a5\u4ef7\u4e0d\u5141\u8bb8\u62a5\u4ef7\uff0c\u672a\u6709\u9996\u6b21\u62a5\u4ef7\u7684\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u53d1\u8d77\u518d\u6b21\u62a5\u4ef7\u3002");
            return rspBO;
        }
        if (!CollectionUtils.isEmpty(supQuotePOList)) {
            for (SupQuotePO supQuotePO : supQuotePOList) {
                quoteSupplierIds.add(supQuotePO.getSupplierId());
            }
        }
        Long end = System.currentTimeMillis();
        if (!CollectionUtils.isEmpty(supJoinPOS)) {
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (ExecuteSupJoinPO supJoinPO : supJoinPOS) {
                if (executeBillPO.getNeedFirstQuoteFlag() != null && !"1".equals(executeBillPO.getNeedFirstQuoteFlag().toString()) && !quoteSupplierIds.contains(supJoinPO.getSupplierId())) continue;
                this.addQuotationBill(supJoinPO.getSupplierId(), executeBillPO);
                supplierIds.add(supJoinPO.getSupplierId());
            }
            System.out.println("\u4fdd\u4ef7\uff1a" + (end - start));
            Long end2 = System.currentTimeMillis();
            Map<Long, MemInfoBO> userMemMap = this.getMemInfoList(supplierIds);
            if (!CollectionUtils.isEmpty(userMemMap)) {
                this.sendMsg(userMemMap, executeBillPO.getExecuteId(), 1L, "\u91cd\u65b0\u62a5\u4ef7", executeBillPO.getExecuteCode() + "\u5df2\u91cd\u65b0\u53d1\u8d77\u62a5\u4ef7\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7!", EnquiryConstant.MESSAGE_SEND_MESSAGE);
            }
            System.out.println("\u53d1\u9001\u77ed\u4fe1\uff1a" + (end2 - end));
            ExecuteBillPO updatePO = new ExecuteBillPO();
            int executeRound = 1;
            if (executeBillPO.getExecuteRound() != null) {
                executeRound += executeBillPO.getExecuteRound().intValue();
            }
            updatePO.setExecuteRound(executeRound);
            updatePO.setExecuteId(reqBO.getExecuteId());
            updatePO.setQuoteEndTime(reqBO.getQuoteEndTime());
            updatePO.setQuoteStartTime(reqBO.getQuoteStartTime());
            if (reqBO.getQuoteStartTime().after(new Date())) {
                updatePO.setExecuteStatus("2012");
            } else {
                updatePO.setExecuteStatus("2003");
            }
            this.executeBillMapper.updateByPrimaryKeySelective(updatePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addQuotationBill(Long supplierId, ExecuteBillPO executeBillPO) {
        List<SupQuotePO> supQuotePOList = this.supQuoteMapper.selectCurrentQuotationBySupplierId(executeBillPO.getExecuteId(), supplierId);
        if (!CollectionUtils.isEmpty(supQuotePOList)) {
            SupQuotePO supQuotePO = supQuotePOList.get(0);
            Long quoteId = Sequence.getInstance().nextId();
            SupQuotePO newSupQuotePO = new SupQuotePO();
            newSupQuotePO.setQuoteId(quoteId);
            newSupQuotePO.setSupplierContactsMobile(supQuotePO.getSupplierContactsMobile());
            newSupQuotePO.setSupplierContactsName(supQuotePO.getSupplierContactsName());
            newSupQuotePO.setUpperQuoteId(supQuotePO.getQuoteId());
            newSupQuotePO.setSupplierId(supQuotePO.getSupplierId());
            newSupQuotePO.setSupplierName(supQuotePO.getSupplierName());
            newSupQuotePO.setExecuteId(supQuotePO.getExecuteId());
            newSupQuotePO.setQuoteRound(executeBillPO.getExecuteRound() + 1);
            newSupQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
            newSupQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
            newSupQuotePO.setQuoteCount(supQuotePO.getQuoteCount());
            newSupQuotePO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            newSupQuotePO.setCreateTime(new Date());
            this.supQuoteMapper.insert(newSupQuotePO);
            SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
            supQuoteItemPO.setQuoteId(supQuotePO.getQuoteId());
            supQuoteItemPO.setExecuteId(executeBillPO.getExecuteId());
            Page page = new Page(1, 1000);
            List<SupQuoteItemPO> supQuoteItemPOS = this.supQuoteItemMapper.selectListPageByCondition(supQuoteItemPO, page);
            if (page.getTotalPages() == 1) {
                this.copyQuoteItem(supQuoteItemPOS, quoteId, executeBillPO.getExecuteRound() + 1);
            }
            if (page.getTotalPages() > 1) {
                for (int i = 2; i <= page.getTotalPages(); ++i) {
                    page.setPageNo(i);
                    supQuoteItemPOS = this.supQuoteItemMapper.selectListPageByCondition(supQuoteItemPO, page);
                    this.copyQuoteItem(supQuoteItemPOS, quoteId, executeBillPO.getExecuteRound() + 1);
                }
            }
        }
    }

    private void copyQuoteItem(List<SupQuoteItemPO> supQuoteItemPOS, Long quoteId, Integer executeRound) {
        ArrayList<SupQuoteItemPO> newSupQuoteItemPOS = new ArrayList<SupQuoteItemPO>();
        for (SupQuoteItemPO itemPO : supQuoteItemPOS) {
            SupQuoteItemPO newItemPO = new SupQuoteItemPO();
            newItemPO.setQuoteId(quoteId);
            newItemPO.setExecuteId(itemPO.getExecuteId());
            newItemPO.setQuotePackId(itemPO.getQuotePackId());
            newItemPO.setPlanDetailId(itemPO.getPlanDetailId());
            newItemPO.setPlanId(itemPO.getPlanId());
            newItemPO.setPackId(itemPO.getPackId());
            newItemPO.setSl(itemPO.getSl());
            newItemPO.setQuoteNumbers(itemPO.getQuoteNumbers());
            newItemPO.setQuotePackId(itemPO.getQuotePackId());
            newItemPO.setExecuteItemId(itemPO.getExecuteItemId());
            newItemPO.setExecuteItemId(itemPO.getExecuteItemId());
            newItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            newItemPO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
            newItemPO.setQuoteRound(executeRound);
            newSupQuoteItemPOS.add(newItemPO);
        }
        this.supQuoteItemMapper.insertBatch(newSupQuoteItemPOS);
    }

    private void sendMsg(Map<Long, MemInfoBO> userMemMap, Long orderId, Long userId, String title, String content, Integer sendType) {
        userMemMap.forEach((k, v) -> {
            log.info("userMemMap::key:value = " + k + ":" + v);
            SendMessReqBO sendMessReqBO = new SendMessReqBO();
            sendMessReqBO.setOrderId(orderId);
            sendMessReqBO.setTitle(title);
            sendMessReqBO.setSubject(title);
            sendMessReqBO.setText(content);
            sendMessReqBO.setUserId(userId);
            sendMessReqBO.setReceiveId(v.getUserId());
            sendMessReqBO.setMobile(v.getRegMobile());
            sendMessReqBO.setEmail(v.getRegEmail());
            sendMessReqBO.setSendType(sendType);
            SendMessRspBO sendMessRspBO = SendMessUtils.dealSendRemind(sendMessReqBO);
            log.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u7ed3\u679c::=" + sendMessRspBO);
        });
    }

    private Map<Long, MemInfoBO> getMemInfoList(List<Long> supplierIdList) {
        HashMap<Long, MemInfoBO> memInfoBOMap = new HashMap<Long, MemInfoBO>();
        HashMap supplierBusinessMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(supplierIdList)) {
            for (Long supId : supplierIdList) {
                UmcQrySupplierInfoDetailAbilityReqBO supplierInfoDetail = new UmcQrySupplierInfoDetailAbilityReqBO();
                supplierInfoDetail.setSupplierId(supId);
                UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(supplierInfoDetail);
                if (!"0000".equals(umcQrySupplierInfoDetailAbilityRspBO.getRespCode())) {
                    log.error("getMemInfoList:\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\uff1a[{}]\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)supId, (Object)umcQrySupplierInfoDetailAbilityRspBO.getRespDesc());
                    throw new BusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\u4f9b\u5e94\u5546\u7684\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
                }
                if (umcQrySupplierInfoDetailAbilityRspBO.getOrgCode() == null) continue;
                UmcQrySupMemAbilityPageReqBO umcQrySupMem = new UmcQrySupMemAbilityPageReqBO();
                umcQrySupMem.setOrgId(umcQrySupplierInfoDetailAbilityRspBO.getOrgCode());
                UmcRspPageBO umcSupMemberInfoUmcBO = this.umcQrySupMemByPageAbilityService.qrySupplierMem(umcQrySupMem);
                if (!"0000".equals(umcSupMemberInfoUmcBO.getRespCode())) {
                    log.error("getMemInfoList:\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\uff1a[{}]\u7684\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)umcQrySupplierInfoDetailAbilityRspBO.getOrgCode(), (Object)umcSupMemberInfoUmcBO.getRespDesc());
                    throw new BusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\u67e5\u8be2\u4f9b\u5e94\u5546\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)umcSupMemberInfoUmcBO.getRows())) continue;
                for (UmcSupMemberInfoBO supMemberInfoBO : umcSupMemberInfoUmcBO.getRows()) {
                    if (memInfoBOMap.containsKey(supMemberInfoBO.getUserId())) continue;
                    UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
                    umcMemDetailQueryAbilityReqBO.setUserIdWeb(supMemberInfoBO.getUserId());
                    UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
                    if (!"0000".equals(umcMemDetailQueryAbilityRspBO.getRespCode())) {
                        log.error("getMemInfoList:\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\uff1a[{}]\u7684\u4f1a\u5458\u8be6\u60c5\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)umcQrySupplierInfoDetailAbilityRspBO.getOrgCode(), (Object)umcMemDetailQueryAbilityRspBO.getRespDesc());
                        continue;
                    }
                    MemInfoBO memInfoBO = new MemInfoBO();
                    memInfoBO.setUserId(supMemberInfoBO.getUserId());
                    if (umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
                        memInfoBO.setRegEmail(umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRegEmail());
                        memInfoBO.setRegMobile(umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRegMobile());
                    }
                    memInfoBOMap.put(supMemberInfoBO.getUserId(), memInfoBO);
                }
            }
        }
        log.info("\u4f9b\u5e94\u5546MAP\u96c6\u5408:{},ID\u96c6\u5408:{}", (Object)JSON.toJSONString(supplierBusinessMap), (Object)JSON.toJSONString(supplierIdList));
        return memInfoBOMap;
    }

    public List<String> getHoliday(Date startDate, Date endDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        ArrayList<String> holiday = new ArrayList<String>();
        try {
            Date startDateYearMonth = format.parse(DateUtil.format((Date)startDate, (String)"yyyyMM"));
            Date endDateYearMonth = format.parse(DateUtil.format((Date)startDate, (String)"yyyyMM"));
            Calendar calendar = Calendar.getInstance();
            while (startDateYearMonth.getTime() <= endDateYearMonth.getTime()) {
                calendar.setTime(startDateYearMonth);
                calendar.add(2, 1);
                BasHoliDayPO record = new BasHoliDayPO();
                record.setHoliDayStart(startDateYearMonth);
                record.setHoliDayEnd(calendar.getTime());
                List<BasHoliDayPO> basHoliDayPOList = this.basHoliDayMapper.getList(record);
                for (BasHoliDayPO basHoliDayPO : basHoliDayPOList) {
                    String yearMonthDayStr = DateUtil.format((Date)basHoliDayPO.getHoliDay(), (String)"yyyyMMdd");
                    holiday.add(yearMonthDayStr);
                }
                startDateYearMonth = calendar.getTime();
            }
        }
        catch (ParseException e) {
            throw new BusinessException("\u65f6\u95f4\u6821\u9a8c\u5931\u8d25", e.getMessage(), (Throwable)e);
        }
        log.info("holiday\u96c6\u5408:" + JSON.toJSONString(holiday));
        return holiday;
    }

    public List<String> getAllHoliday(Date startDate, Date endDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        SimpleDateFormat formatHoliDay = new SimpleDateFormat("yyyyMMdd");
        ArrayList<String> holiday = new ArrayList<String>();
        try {
            Date startDateYearMonth = format.parse(DateUtil.format((Date)startDate, (String)"yyyyMM"));
            Date endDateYearMonth = format.parse(DateUtil.format((Date)startDate, (String)"yyyyMM"));
            ArrayList<BasHoliDayPO> records = new ArrayList<BasHoliDayPO>();
            Calendar calendar = Calendar.getInstance();
            while (startDateYearMonth.getTime() <= endDateYearMonth.getTime()) {
                calendar.setTime(startDateYearMonth);
                calendar.add(2, 1);
                String url = "https://zhiwei-tech.com/console/api/holiday/" + DateUtil.format((Date)startDateYearMonth, (String)"yyyyMM");
                String body = HttpRequest.get((String)url).setEncodeUrlParams(true).execute().body();
                log.info("\u65e5\u671f\u4e4b\u95f4\u7684\u5de5\u4f5c\u65e5execute" + HttpRequest.get((String)url).setEncodeUrlParams(true).execute());
                log.info("\u65e5\u671f\u4e4b\u95f4\u7684\u5de5\u4f5c\u65e5body" + body);
                Map yearMonthMap = (Map)JSON.parseObject((String)body, (Type)new TypeReference<HashMap<String, Map<String, Integer>>>(){}, (Feature[])new Feature[0]);
                log.info("yearMonthMap\u96c6\u5408:" + JSON.toJSONString((Object)yearMonthMap));
                Map monthHolidayMap = (Map)yearMonthMap.get(DateUtil.format((Date)startDateYearMonth, (String)"yyyyMM"));
                log.info("treeMap\u96c6\u5408:" + JSON.toJSONString((Object)monthHolidayMap));
                for (String holidayStr : monthHolidayMap.keySet()) {
                    if (holidayStr.length() < 2) {
                        holidayStr = "0" + holidayStr;
                    }
                    String yearMonthDayStr = DateUtil.format((Date)startDateYearMonth, (String)"yyyyMM") + holidayStr;
                    holiday.add(yearMonthDayStr);
                    BasHoliDayPO intBasHoliDayPO = new BasHoliDayPO();
                    intBasHoliDayPO.setDateType((Integer)monthHolidayMap.get(holidayStr));
                    intBasHoliDayPO.setHoliDay(formatHoliDay.parse(yearMonthDayStr));
                    records.add(intBasHoliDayPO);
                }
                startDateYearMonth = calendar.getTime();
            }
            this.basHoliDayMapper.insertBatch(records);
        }
        catch (ParseException e) {
            throw new BusinessException("\u65f6\u95f4\u6821\u9a8c\u5931\u8d25", e.getMessage(), (Throwable)e);
        }
        log.info("holiday\u96c6\u5408:" + JSON.toJSONString(holiday));
        return holiday;
    }

    @Override
    public PurchaseQuoteInfoDealRevokeRspBO dealRevokeQuoteInfo(PurchaseQuoteInfoDealRevokeReqBO reqBO) {
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        PurchaseQuoteInfoDealRevokeRspBO rspBO = new PurchaseQuoteInfoDealRevokeRspBO();
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        if (!"1".equals(executeBillPO.getExecuteType())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u662f\u8bae\u4ef7,\u4e0d\u80fd\u64a4\u56de!!!");
            return rspBO;
        }
        Date now = new Date();
        if (!"2003".equals(executeBillPO.getExecuteStatus()) || executeBillPO.getQuoteEndTime().before(now) || executeBillPO.getQuoteStartTime().after(now)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u72b6\u6001\u4e0d\u5728\u62a5\u4ef7\u4e2d\u6216\u4e0d\u5728\u62a5\u4ef7\u65f6\u95f4\u5185,\u4e0d\u53ef\u64a4\u56de!");
            return rspBO;
        }
        SupQuotePO currentQuotePo = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (currentQuotePo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        if (!currentQuotePo.getQuoteStatus().equals(EnquiryConstant.QuoteStatus.YES)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u672a\u63d0\u4ea4\u62a5\u4ef7,\u4e0d\u53ef\u64a4\u56de!");
            return rspBO;
        }
        ExecuteBillPO updatePO = new ExecuteBillPO();
        int submitQuoteNumber = 0;
        if (executeBillPO.getSubmitQuoteNumber() != null && executeBillPO.getSubmitQuoteNumber() != 0) {
            submitQuoteNumber = executeBillPO.getSubmitQuoteNumber() - 1;
        }
        updatePO.setSubmitQuoteNumber(submitQuoteNumber);
        updatePO.setExecuteId(reqBO.getExecuteId());
        this.executeBillMapper.updateByPrimaryKeySelective(updatePO);
        SupQuotePO supQuotePO = new SupQuotePO();
        supQuotePO.setQuoteId(reqBO.getQuoteId());
        supQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
        supQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
        supQuotePO.setQuoteCount(currentQuotePo.getQuoteCount() == null ? null : Integer.valueOf(currentQuotePo.getQuoteCount() - 1));
        supQuotePO.setRevokeQuoteReason(reqBO.getRevokeQuoteReason());
        supQuotePO.setUpdateTime(now);
        supQuotePO.setUpdateUserId(reqBO.getUserId() == null ? null : reqBO.getUserId().toString());
        supQuotePO.setUpdateUserName(reqBO.getName());
        this.supQuoteMapper.updateByPrimaryKeySelective(supQuotePO);
        SupQuoteItemPO record = new SupQuoteItemPO();
        record.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
        record.setQuoteId(reqBO.getQuoteId());
        this.supQuoteItemMapper.updateByQuoteIdKeySelective(record);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u64a4\u56de\u6210\u529f!");
        return rspBO;
    }
}

