/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.CurrentQuotationPackBO;
import com.tydic.enquiry.api.bo.EnquriyOrgSupTagBO;
import com.tydic.enquiry.api.bo.SubmitQuotationBillReqBO;
import com.tydic.enquiry.api.bo.SubmitQuotationBillRspBO;
import com.tydic.enquiry.busi.api.SubmitQuotationBillBusiService;
import com.tydic.enquiry.busi.impl.plan.BlackSupinfoCommonService;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.constant.EnquiryGenerateIdUtil;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.ExecutePackMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteItemMidMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.SupQuotePackMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.ExecutePackPO;
import com.tydic.enquiry.dao.po.SupQuoteItemMidPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import com.tydic.enquiry.dao.po.SupQuotePackPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubmitQuotationBillBusiServiceImpl
implements SubmitQuotationBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(SubmitQuotationBillBusiServiceImpl.class);
    @Autowired
    private SupQuoteItemMidMapper supQuoteItemMidMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private SupQuotePackMapper supQuotePackMapper;
    @Autowired
    private ExecutePackMapper executePackMapper;
    @Autowired
    private EnquiryGenerateIdUtil sequence;
    @Autowired
    private BlackSupinfoCommonService blackSupinfoCommonService;

    @Override
    public SubmitQuotationBillRspBO submitQuotation(SubmitQuotationBillReqBO reqBO) {
        SupQuotePO currentQuotePo;
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        Date now = new Date();
        if (!"2003".equals(executeBillPO.getExecuteStatus()) || executeBillPO.getQuoteEndTime().before(now) || executeBillPO.getQuoteStartTime().after(now)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u72b6\u6001\u4e0d\u5728\u62a5\u4ef7\u4e2d\u6216\u4e0d\u5728\u62a5\u4ef7\u65f6\u95f4\u5185!");
            return rspBO;
        }
        SubmitQuotationBillRspBO rspBO1 = this.checkSupBlack(reqBO, rspBO, executeBillPO);
        if (rspBO1 != null) {
            return rspBO1;
        }
        if ("1".equals(executeBillPO.getExecuteType())) {
            currentQuotePo = this.updateQuotationBill(reqBO, executeBillPO, rspBO);
        } else if ("2".equals(executeBillPO.getExecuteType())) {
            currentQuotePo = this.updateQuotationBiddingBill(reqBO, executeBillPO, rspBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u636e\u7c7b\u578b\u4e0d\u652f\u6301!");
            return rspBO;
        }
        if (rspBO.getRespCode().equals("8888")) {
            log.error("\u63d0\u4ea4\u62a5\u4ef7\u5931\u8d25:" + rspBO.getRespDesc());
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
        List<Long> supplierIds = this.supQuoteMapper.selectQuoteCount(reqBO.getExecuteId(), EnquiryConstant.QuoteStatus.YES);
        ExecuteBillPO updateExecutePO = new ExecuteBillPO();
        updateExecutePO.setExecuteId(reqBO.getExecuteId());
        updateExecutePO.setSubmitQuoteNumber(supplierIds.size());
        this.executeBillMapper.updateByPrimaryKeySelective(updateExecutePO);
        if ("2".equals(executeBillPO.getExecuteType())) {
            this.addQuotationBill(executeBillPO, currentQuotePo);
        }
        return rspBO;
    }

    private SubmitQuotationBillRspBO checkSupBlack(SubmitQuotationBillReqBO reqBO, SubmitQuotationBillRspBO rspBO, ExecuteBillPO executeBillPO) {
        SupQuoteItemMidPO supQuoteItemMidPO = new SupQuoteItemMidPO();
        supQuoteItemMidPO.setExecuteId(reqBO.getExecuteId());
        supQuoteItemMidPO.setQuoteId(reqBO.getQuoteId());
        supQuoteItemMidPO.setRedisNo(reqBO.getRedisNo());
        Page page = new Page(1, -1);
        List<SupQuoteItemMidPO> supQuoteItemMidPOList = this.supQuoteItemMidMapper.selectListPageByQuote(supQuoteItemMidPO, (Page<SupQuoteItemMidPO>)page);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        for (SupQuoteItemMidPO supQuoteItemMidPO1 : supQuoteItemMidPOList) {
            Long executeItemId = supQuoteItemMidPO1.getExecuteItemId();
            executeItemIdList.add(executeItemId);
        }
        HashMap<Long, ExecuteItemPO> executeItemPOMap = new HashMap<Long, ExecuteItemPO>();
        if (CollUtil.isNotEmpty(executeItemIdList)) {
            ExecuteItemPO record = new ExecuteItemPO();
            record.setExecuteItemIdList(executeItemIdList);
            List<ExecuteItemPO> ExecuteItemPOList = this.executeItemMapper.getList(record);
            if (CollUtil.isNotEmpty((Collection)ExecuteItemPOList)) {
                Iterator iterator = ExecuteItemPOList.iterator();
                while (iterator.hasNext()) {
                    ExecuteItemPO executeItemPO = (ExecuteItemPO)iterator.next();
                    executeItemPOMap.put(executeItemPO.getExecuteItemId(), executeItemPO);
                }
            }
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        for (SupQuoteItemMidPO supQuoteItemMidPO1 : supQuoteItemMidPOList) {
            Long executeItemId = supQuoteItemMidPO1.getExecuteItemId();
            ExecuteItemPO executeItemPO = (ExecuteItemPO)executeItemPOMap.get(executeItemId);
            if (executeItemPO == null) continue;
            String demandOrgId = executeItemPO.getDemandOrgId();
            supQuoteItemMidPO1.setDemandOrgId(executeItemPO.getDemandOrgId());
            orgIdSet.add(demandOrgId);
        }
        SupQuotePO supQuotePO = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (supQuotePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        Long supplierId = supQuotePO.getSupplierId();
        Map<String, List<EnquriyOrgSupTagBO>> allOrgBlackMap = this.blackSupinfoCommonService.getOrgBlackSupMap(orgIdSet, supplierId);
        ArrayList<EnquriyOrgSupTagBO> allBlackTagList = new ArrayList<EnquriyOrgSupTagBO>();
        String confirmDealType = executeBillPO.getConfirmDealType();
        for (SupQuoteItemMidPO supQuoteItemMidPO1 : supQuoteItemMidPOList) {
            String demandOrgId = supQuoteItemMidPO1.getDemandOrgId();
            String key = demandOrgId + "_" + supplierId;
            List<EnquriyOrgSupTagBO> blackList = allOrgBlackMap.get(key);
            if (!CollUtil.isNotEmpty(blackList)) continue;
            allBlackTagList.addAll(blackList);
        }
        if (CollUtil.isNotEmpty(allBlackTagList)) {
            rspBO.setBlackTagList(allBlackTagList);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u4e0d\u53ef\u63d0\u4ea4\u62a5\u4ef7!");
            return rspBO;
        }
        return null;
    }

    private SupQuotePO updateQuotationBill(SubmitQuotationBillReqBO reqBO, ExecuteBillPO executeBillPO, SubmitQuotationBillRspBO rspBO) {
        SupQuotePO currentQuotePo = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (currentQuotePo.getQuoteStatus().equals(EnquiryConstant.QuoteStatus.YES)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672c\u8f6e\u5df2\u7ecf\u5b8c\u6210\u62a5\u4ef7!");
            return currentQuotePo;
        }
        SupQuoteItemMidPO supQuoteItemMidPO = new SupQuoteItemMidPO();
        supQuoteItemMidPO.setExecuteId(reqBO.getExecuteId());
        supQuoteItemMidPO.setQuoteId(reqBO.getQuoteId());
        supQuoteItemMidPO.setRedisNo(reqBO.getRedisNo());
        if (executeBillPO.getConfirmDealType().equals("3")) {
            Integer quoteItemCount = this.supQuoteItemMidMapper.selectListCount(supQuoteItemMidPO);
            ExecuteItemPO itemQueryPO = new ExecuteItemPO();
            itemQueryPO.setExecuteId(executeBillPO.getExecuteId());
            Integer billItemCount = this.executeItemMapper.selectListCount(itemQueryPO);
            if (!quoteItemCount.equals(billItemCount)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6574\u5355\u786e\u8ba4\u6574\u5355\u6210\u4ea4\u6240\u6709\u660e\u7ec6\u5fc5\u987b\u62a5\u4ef7!");
                return currentQuotePo;
            }
        }
        SupQuotePO checkQuotePO = new SupQuotePO();
        checkQuotePO.setSupplierId(reqBO.getSupId());
        checkQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
        checkQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.LATEST);
        checkQuotePO.setExecuteId(executeBillPO.getExecuteId());
        List<SupQuotePO> supQuotePOS = this.supQuoteMapper.selectByCondition(checkQuotePO);
        if (executeBillPO.getNeedFirstQuoteFlag().equals(EnquiryConstant.NeedFirstQuoteFlag.NO) && CollectionUtils.isEmpty(supQuotePOS) && !currentQuotePo.getQuoteRound().equals(1)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9996\u8f6e\u62a5\u4ef7\u6ca1\u6709\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u62a5\u4ef7!");
            return currentQuotePo;
        }
        ArrayList<SupQuoteItemPO> supQuoteItemPOList = new ArrayList();
        if (!CollectionUtils.isEmpty(supQuotePOS)) {
            SupQuoteItemPO queryPO = new SupQuoteItemPO();
            queryPO.setQuoteId(supQuotePOS.get(0).getQuoteId());
            supQuoteItemPOList = this.supQuoteItemMapper.selectListBy(queryPO);
        }
        BigDecimal quoteMoney = new BigDecimal("0");
        int maxDays = 0;
        Page page = new Page(1, 1000);
        List<SupQuoteItemMidPO> supQuoteItemMidPOList = this.supQuoteItemMidMapper.selectListPageByQuote(supQuoteItemMidPO, (Page<SupQuoteItemMidPO>)page);
        if (page.getTotalPages() <= 1) {
            List<Object> priceCheckQuoteItemStrList = new ArrayList();
            for (SupQuoteItemMidPO supQuoteItemMidPO1 : supQuoteItemMidPOList) {
                quoteMoney = quoteMoney.add(supQuoteItemMidPO1.getQuoteMoney());
                if (supQuoteItemMidPO1.getPromiseDeliveryDays() == null) continue;
                maxDays = Math.max(maxDays, supQuoteItemMidPO1.getPromiseDeliveryDays());
            }
            if ("1".equals(executeBillPO.getConfirmDealType()) && !CollectionUtils.isEmpty(supQuoteItemPOList) && !CollectionUtils.isEmpty(supQuoteItemMidPOList)) {
                priceCheckQuoteItemStrList = this.priceCheckQuoteItem(executeBillPO, supQuoteItemMidPOList, supQuoteItemPOList, rspBO);
            }
            if (!CollectionUtils.isEmpty(priceCheckQuoteItemStrList)) {
                throw new BusinessException("8888", "\u62a5\u4ef7\u63d0\u4ea4\u62a5\u4ef7\u6821\u9a8c\u9519\u8bef\uff1a" + priceCheckQuoteItemStrList);
            }
            if (!CollectionUtils.isEmpty(supQuoteItemMidPOList)) {
                this.supQuoteItemMapper.updateSupQuoteItemByBatch(supQuoteItemMidPOList, reqBO.getQuoteId());
            }
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                page.setPageNo(i);
                List<Object> priceCheckQuoteItemStrList = new ArrayList();
                supQuoteItemMidPOList = this.supQuoteItemMidMapper.selectListPageByQuote(supQuoteItemMidPO, (Page<SupQuoteItemMidPO>)page);
                for (SupQuoteItemMidPO supQuoteItemMidPO1 : supQuoteItemMidPOList) {
                    quoteMoney = quoteMoney.add(supQuoteItemMidPO1.getQuoteMoney());
                    if (supQuoteItemMidPO1.getPromiseDeliveryDays() == null) continue;
                    maxDays = Math.max(maxDays, supQuoteItemMidPO1.getPromiseDeliveryDays());
                }
                if ("1".equals(executeBillPO.getConfirmDealType()) && !CollectionUtils.isEmpty(supQuoteItemPOList) && !CollectionUtils.isEmpty(supQuoteItemMidPOList)) {
                    priceCheckQuoteItemStrList = this.priceCheckQuoteItem(executeBillPO, supQuoteItemMidPOList, supQuoteItemPOList, rspBO);
                }
                if (!CollectionUtils.isEmpty(priceCheckQuoteItemStrList)) {
                    throw new BusinessException("8888", "\u62a5\u4ef7\u63d0\u4ea4\u62a5\u4ef7\u6821\u9a8c\u9519\u8bef\uff1a" + priceCheckQuoteItemStrList);
                }
                this.supQuoteItemMapper.updateSupQuoteItemByBatch(supQuoteItemMidPOList, reqBO.getQuoteId());
            }
        }
        if (!"1".equals(executeBillPO.getConfirmDealType()) && !CollectionUtils.isEmpty(supQuotePOS) && quoteMoney.compareTo(supQuotePOS.get(0).getQuoteMoney()) >= 0) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u63d0\u4ea4\u62a5\u4ef7\u6821\u9a8c\u9519\u8bef\uff1a\u62a5\u4ef7\u91d1\u989d\uff1a" + quoteMoney + "\u4e0d\u53ef\u9ad8\u4e8e\u4e0a\u6b21\u62a5\u4ef7\u91d1\u989d\uff1a" + supQuotePOS.get(0).getQuoteMoney());
        }
        SupQuotePO supQuotePO = new SupQuotePO();
        supQuotePO.setQuoteId(reqBO.getQuoteId());
        supQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
        supQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.LATEST);
        supQuotePO.setQuoteMoney(quoteMoney);
        supQuotePO.setPromiseDeliveryDays(maxDays);
        supQuotePO.setQuoteTime(new Date());
        supQuotePO.setUpdateUserId(reqBO.getMemIdIn().toString());
        supQuotePO.setUpdateUserName(reqBO.getName());
        supQuotePO.setSupplierContactsName(reqBO.getSupplierContactsName());
        supQuotePO.setSupplierContactsMobile(reqBO.getSupplierContactsMobile());
        supQuotePO.setRemarks(reqBO.getRemarks());
        supQuotePO.setQuoteIp(reqBO.getQuoteIp());
        supQuotePO.setCreateUserId(reqBO.getMemIdIn().toString());
        supQuotePO.setCreateUserName(reqBO.getName());
        supQuotePO.setQuoteCount(currentQuotePo.getQuoteCount() == null ? 1 : currentQuotePo.getQuoteCount() + 1);
        this.supQuoteMapper.updateQuoteHisStatus(EnquiryConstant.QuoteHisStatus.HIS, currentQuotePo.getSupplierId(), reqBO.getExecuteId(), null);
        this.supQuoteMapper.updateByPrimaryKeySelective(supQuotePO);
        this.basFileInfoMapper.deleteByRelateId(supQuotePO.getQuoteId(), "1004");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFileInfoBoList())) {
            List basFileInfoPOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getFileInfoBoList()), BasFileInfoPO.class);
            for (BasFileInfoPO basFileInfoPO : basFileInfoPOS) {
                basFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                basFileInfoPO.setRelateId(supQuotePO.getQuoteId());
                basFileInfoPO.setFileinfoId(this.sequence.nextId());
                basFileInfoPO.setCreateTime(new Date());
                basFileInfoPO.setCreateId(reqBO.getUserId());
                basFileInfoPO.setCreateName(reqBO.getName());
                basFileInfoPO.setBillType("1004");
            }
            this.basFileInfoMapper.insertBatch(basFileInfoPOS);
        }
        return currentQuotePo;
    }

    private SupQuotePO updateQuotationBiddingBill(SubmitQuotationBillReqBO reqBO, ExecuteBillPO executeBillPO, SubmitQuotationBillRspBO rspBO) {
        List<CurrentQuotationPackBO> list;
        String errorStr;
        SupQuotePO currentQuotePo = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (currentQuotePo.getQuoteStatus().equals(EnquiryConstant.QuoteStatus.YES)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672c\u8f6e\u5df2\u7ecf\u5b8c\u6210\u62a5\u4ef7!");
            return currentQuotePo;
        }
        SupQuoteItemMidPO supQuoteItemMidPO = new SupQuoteItemMidPO();
        supQuoteItemMidPO.setExecuteId(reqBO.getExecuteId());
        supQuoteItemMidPO.setQuoteId(reqBO.getQuoteId());
        supQuoteItemMidPO.setRedisNo(reqBO.getRedisNo());
        if (executeBillPO.getConfirmDealType().equals("3")) {
            Integer quoteItemCount = this.supQuoteItemMidMapper.selectListCount(supQuoteItemMidPO);
            ExecuteItemPO itemQueryPO = new ExecuteItemPO();
            itemQueryPO.setExecuteId(executeBillPO.getExecuteId());
            Integer billItemCount = this.executeItemMapper.selectListCount(itemQueryPO);
            if (!quoteItemCount.equals(billItemCount)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6574\u5355\u786e\u8ba4\u6574\u5355\u6210\u4ea4\u6240\u6709\u660e\u7ec6\u5fc5\u987b\u62a5\u4ef7!");
                return currentQuotePo;
            }
        }
        HashMap<Long, SupQuotePackPO> supQuotePackPOMap = new HashMap<Long, SupQuotePackPO>();
        BigDecimal quoteMoney = new BigDecimal("0");
        int maxDays = 0;
        Page page = new Page(1, 1000);
        List<SupQuoteItemMidPO> supQuoteItemMidPOList = this.supQuoteItemMidMapper.selectListPageByQuote(supQuoteItemMidPO, (Page<SupQuoteItemMidPO>)page);
        ArrayList<Long> packIdList = new ArrayList<Long>();
        Integer quoteRound = null;
        if ("2".equals(executeBillPO.getExecuteType())) {
            SupQuotePO qryQuoteQueryPO = new SupQuotePO();
            qryQuoteQueryPO.setExecuteId(currentQuotePo.getExecuteId());
            qryQuoteQueryPO.setOrderBy("quote_round DESC");
            qryQuoteQueryPO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
            List<SupQuotePO> list2 = this.supQuoteMapper.selectByCondition(qryQuoteQueryPO);
            if (!CollectionUtils.isEmpty(list2)) {
                quoteRound = list2.get(0).getQuoteRound() + 1;
            }
        }
        if (page.getTotalPages() == 1) {
            for (SupQuoteItemMidPO supQuoteItemMidPO2 : supQuoteItemMidPOList) {
                quoteMoney = quoteMoney.add(supQuoteItemMidPO2.getQuoteMoney());
                if (supQuoteItemMidPO2.getPromiseDeliveryDays() != null) {
                    maxDays = Math.max(maxDays, supQuoteItemMidPO2.getPromiseDeliveryDays());
                }
                this.getPackMoneyMap(supQuotePackPOMap, supQuoteItemMidPO2);
                packIdList.add(supQuoteItemMidPO2.getPackId());
                supQuoteItemMidPO2.setQuoteRound(quoteRound);
            }
            this.supQuoteItemMapper.updateSupQuoteItemByBatch(supQuoteItemMidPOList, reqBO.getQuoteId());
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                page.setPageNo(i);
                supQuoteItemMidPOList = this.supQuoteItemMidMapper.selectListPageByQuote(supQuoteItemMidPO, (Page<SupQuoteItemMidPO>)page);
                for (SupQuoteItemMidPO supQuoteItemMidPO3 : supQuoteItemMidPOList) {
                    quoteMoney = quoteMoney.add(supQuoteItemMidPO3.getQuoteMoney());
                    if (supQuoteItemMidPO3.getPromiseDeliveryDays() != null) {
                        maxDays = Math.max(maxDays, supQuoteItemMidPO3.getPromiseDeliveryDays());
                    }
                    this.getPackMoneyMap(supQuotePackPOMap, supQuoteItemMidPO3);
                    packIdList.add(supQuoteItemMidPO3.getPackId());
                    supQuoteItemMidPO3.setQuoteRound(quoteRound);
                }
                this.supQuoteItemMapper.updateSupQuoteItemByBatch(supQuoteItemMidPOList, reqBO.getQuoteId());
            }
        }
        List<ExecutePackPO> executePackPOS = this.executePackMapper.selectByExecuteId(reqBO.getExecuteId(), null);
        HashMap<Long, ExecutePackPO> hashMap = new HashMap<Long, ExecutePackPO>();
        if (CollUtil.isNotEmpty(executePackPOS)) {
            for (ExecutePackPO executePackPO : executePackPOS) {
                hashMap.put(executePackPO.getPackId(), executePackPO);
            }
        }
        if (!"1".equals(executeBillPO.getConfirmDealType())) {
            List<SupQuotePO> currentQuoteList;
            Iterator<Object> supQuotePO;
            if (EnquiryConstant.BiddingDecreaseMethod.OFFER_INCREASE_TYPE_1.equals(executeBillPO.getBiddingDecreaseMethod())) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = new BigDecimal("0");
                supQuotePO = new SupQuotePO();
                ((SupQuotePO)((Object)supQuotePO)).setExecuteId(reqBO.getExecuteId());
                ((SupQuotePO)((Object)supQuotePO)).setOrderBy("quote_money");
                currentQuoteList = this.supQuoteMapper.selectCurrentQuoteByCondition((SupQuotePO)((Object)supQuotePO));
                if (!CollectionUtils.isEmpty(currentQuoteList) && !StringUtils.isEmpty((CharSequence)(errorStr = this.priceCheck(executeBillPO, quoteMoney, bigDecimal = currentQuoteList.get(0).getQuoteMoney(), rspBO)))) {
                    throw new BusinessException("8888", errorStr);
                }
            }
            if (EnquiryConstant.BiddingDecreaseMethod.OFFER_INCREASE_TYPE_2.equals(executeBillPO.getBiddingDecreaseMethod())) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal3 = new BigDecimal("0");
                supQuotePO = new SupQuotePO();
                ((SupQuotePO)((Object)supQuotePO)).setExecuteId(reqBO.getExecuteId());
                ((SupQuotePO)((Object)supQuotePO)).setSupplierId(reqBO.getSupId());
                ((SupQuotePO)((Object)supQuotePO)).setOrderBy("quote_time desc");
                currentQuoteList = this.supQuoteMapper.selectCurrentQuoteByCondition((SupQuotePO)((Object)supQuotePO));
                if (!CollectionUtils.isEmpty(currentQuoteList) && !StringUtils.isEmpty((CharSequence)(errorStr = this.priceCheck(executeBillPO, quoteMoney, bigDecimal = currentQuoteList.get(0).getQuoteMoney(), rspBO)))) {
                    throw new BusinessException("8888", errorStr);
                }
            }
        } else if (EnquiryConstant.BiddingDecreaseMethod.OFFER_INCREASE_TYPE_1.equals(executeBillPO.getBiddingDecreaseMethod())) {
            List<CurrentQuotationPackBO> list3 = this.supQuotePackMapper.selectCurrentBiddingQuotation(executeBillPO.getExecuteId(), null, null, 1);
            if (!CollectionUtils.isEmpty(list3)) {
                for (CurrentQuotationPackBO currentQuotationPackBO : list3) {
                    if (!"1".equals(executeBillPO.getConfirmDealType()) && supQuotePackPOMap.get(currentQuotationPackBO.getPackId()) == null) {
                        throw new BusinessException("8888", "\u5305\u4ef6" + currentQuotationPackBO.getPackCode() + "\u672a\u62a5\u4ef7!");
                    }
                    if (supQuotePackPOMap.get(currentQuotationPackBO.getPackId()) == null || StringUtils.isEmpty((CharSequence)(errorStr = this.priceCheck(executeBillPO, ((SupQuotePackPO)supQuotePackPOMap.get(currentQuotationPackBO.getPackId())).getQuotePackMoney(), currentQuotationPackBO.getLowestQuote(), rspBO)))) continue;
                    throw new BusinessException("8888", errorStr);
                }
            }
        } else if (EnquiryConstant.BiddingDecreaseMethod.OFFER_INCREASE_TYPE_2.equals(executeBillPO.getBiddingDecreaseMethod()) && !CollectionUtils.isEmpty(list = this.supQuotePackMapper.selectCurrentBiddingQuotation(executeBillPO.getExecuteId(), null, reqBO.getSupId(), 1))) {
            for (CurrentQuotationPackBO quotePackPO : list) {
                String errorStr2;
                Long packId = quotePackPO.getPackId();
                if (!"1".equals(executeBillPO.getConfirmDealType()) && supQuotePackPOMap.get(packId) == null) {
                    ExecutePackPO executePackPO = (ExecutePackPO)hashMap.get(packId);
                    throw new BusinessException("8888", "\u5305\u4ef6" + executePackPO.getPackCode() + "\u672a\u62a5\u4ef7!");
                }
                if (supQuotePackPOMap.get(packId) == null || StringUtils.isEmpty((CharSequence)(errorStr2 = this.priceCheck(executeBillPO, ((SupQuotePackPO)supQuotePackPOMap.get(packId)).getQuotePackMoney(), quotePackPO.getLowestQuote(), rspBO)))) continue;
                throw new BusinessException("8888", errorStr2);
            }
        }
        if (!CollectionUtils.isEmpty(supQuotePackPOMap) && !CollectionUtils.isEmpty(hashMap)) {
            log.info("\u62a5\u4ef7\u5305\u4ef6\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString(supQuotePackPOMap));
            log.info("\u5305\u4ef6\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString(hashMap));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Iterator supQuotePackPO : supQuotePackPOMap.values()) {
                ExecutePackPO executePackPO = (ExecutePackPO)hashMap.get(((SupQuotePackPO)((Object)supQuotePackPO)).getPackId());
                BigDecimal quotePackMoney = ((SupQuotePackPO)((Object)supQuotePackPO)).getQuotePackMoney();
                BigDecimal packBudgetMoney = executePackPO.getPackBudgetMoney();
                if (quotePackMoney == null || quotePackMoney == null) continue;
                log.info("\u62a5\u4ef7\u4ef7\u683c\u4fe1\u606f\u5bf9\u6bd4\uff1a" + quotePackMoney.compareTo(packBudgetMoney));
                if (quotePackMoney.compareTo(packBudgetMoney) <= 0) continue;
                arrayList.add("\u5305\u4ef6" + executePackPO.getPackCode() + "\u7684\u62a5\u4ef7\u91d1\u989d:" + quotePackMoney + "\u4e0d\u53ef\u5927\u4e8e\u5206\u5305\u8d77\u59cb\u4ef7\u683c:" + packBudgetMoney);
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                throw new BusinessException("8888", "\u5305\u4ef6\u62a5\u4ef7\u4ef7\u683c\u6821\u9a8c\u5931\u8d25\uff1a" + arrayList);
            }
        }
        if (!CollectionUtils.isEmpty(supQuotePackPOMap)) {
            SupQuotePackPO supQuotePackPO = new SupQuotePackPO();
            supQuotePackPO.setExecuteId(reqBO.getExecuteId());
            supQuotePackPO.setQuoteId(reqBO.getQuoteId());
            supQuotePackPO.setPackIdList(packIdList);
            List<SupQuotePackPO> supQuotePackPOList = this.supQuotePackMapper.selectListByCondition(supQuotePackPO);
            if (CollUtil.isNotEmpty(supQuotePackPOList)) {
                for (SupQuotePackPO record : supQuotePackPOList) {
                    Long packId = record.getPackId();
                    SupQuotePackPO packPO = (SupQuotePackPO)supQuotePackPOMap.get(packId);
                    packPO.setQuotePackId(record.getQuotePackId());
                    this.supQuotePackMapper.updateByPrimaryKeySelective(packPO);
                }
            }
        }
        SupQuotePO supQuotePO = new SupQuotePO();
        supQuotePO.setQuoteId(reqBO.getQuoteId());
        supQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
        supQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.LATEST);
        supQuotePO.setQuoteMoney(quoteMoney);
        supQuotePO.setPromiseDeliveryDays(maxDays);
        supQuotePO.setQuoteTime(new Date());
        supQuotePO.setUpdateUserId(EnquiryCommonUtil.valNull(reqBO.getMemIdIn()));
        supQuotePO.setUpdateUserName(reqBO.getName());
        supQuotePO.setSupplierContactsName(reqBO.getSupplierContactsName());
        supQuotePO.setSupplierContactsMobile(reqBO.getSupplierContactsMobile());
        supQuotePO.setRemarks(reqBO.getRemarks());
        supQuotePO.setQuoteIp(reqBO.getQuoteIp());
        supQuotePO.setQuoteRound(quoteRound);
        this.supQuoteMapper.updateByPrimaryKeySelective(supQuotePO);
        this.basFileInfoMapper.deleteByRelateId(supQuotePO.getQuoteId(), "1004");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFileInfoBoList())) {
            List basFileInfoPOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getFileInfoBoList()), BasFileInfoPO.class);
            for (BasFileInfoPO basFileInfoPO : basFileInfoPOS) {
                basFileInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                basFileInfoPO.setRelateId(supQuotePO.getQuoteId());
                basFileInfoPO.setFileinfoId(this.sequence.nextId());
                basFileInfoPO.setCreateTime(new Date());
                basFileInfoPO.setCreateId(reqBO.getUserId());
                basFileInfoPO.setCreateName(reqBO.getName());
                basFileInfoPO.setBillType("1004");
            }
            this.basFileInfoMapper.insertBatch(basFileInfoPOS);
        }
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(12, 5);
        if (nowTime.after(executeBillPO.getQuoteEndTime())) {
            Date quoteEndDate = new Date(executeBillPO.getQuoteEndTime().getTime() + 300000L);
            ExecuteBillPO updateExecutePO = new ExecuteBillPO();
            updateExecutePO.setExecuteId(reqBO.getExecuteId());
            updateExecutePO.setQuoteEndTime(quoteEndDate);
            updateExecutePO.setDelayCnt(executeBillPO.getDelayCnt() == null ? 1 : executeBillPO.getDelayCnt() + 1);
            updateExecutePO.setDelayLengthTime(executeBillPO.getDelayCnt() == null ? 5 : (executeBillPO.getDelayCnt() + 1) * 5);
            this.executeBillMapper.updateByPrimaryKeySelective(updateExecutePO);
        }
        currentQuotePo.setSupplierContactsName(supQuotePO.getSupplierContactsName());
        currentQuotePo.setSupplierContactsMobile(supQuotePO.getSupplierContactsMobile());
        return currentQuotePo;
    }

    private void getPackMoneyMap(Map<Long, SupQuotePackPO> supQuotePackPOMap, SupQuoteItemMidPO supQuoteItemMidP) {
        Long packId = supQuoteItemMidP.getPackId();
        if (supQuotePackPOMap.containsKey(packId)) {
            SupQuotePackPO quotePackPO = supQuotePackPOMap.get(packId);
            quotePackPO.setQuotePackMoney(quotePackPO.getQuotePackMoney().add(supQuoteItemMidP.getQuoteMoney()));
        } else {
            SupQuotePackPO quotePackPO = new SupQuotePackPO();
            quotePackPO.setExecuteId(supQuoteItemMidP.getExecuteId());
            quotePackPO.setPackId(packId);
            quotePackPO.setQuoteId(supQuoteItemMidP.getQuoteId());
            quotePackPO.setQuotePackMoney(supQuoteItemMidP.getQuoteMoney());
            supQuotePackPOMap.put(packId, quotePackPO);
        }
    }

    private void addQuotationBill(ExecuteBillPO executeBillPO, SupQuotePO currentQuotePo) {
        SupQuotePO newSupQuotePO = new SupQuotePO();
        Long quoteId = Sequence.getInstance().nextId();
        newSupQuotePO.setQuoteId(quoteId);
        newSupQuotePO.setUpperQuoteId(currentQuotePo.getQuoteId());
        newSupQuotePO.setSupplierId(currentQuotePo.getSupplierId());
        newSupQuotePO.setSupplierName(currentQuotePo.getSupplierName());
        newSupQuotePO.setExecuteId(currentQuotePo.getExecuteId());
        newSupQuotePO.setQuoteRound(currentQuotePo.getQuoteRound() + 1);
        newSupQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
        newSupQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
        newSupQuotePO.setCreateTime(new Date());
        newSupQuotePO.setUpperQuoteId(currentQuotePo.getQuoteId());
        newSupQuotePO.setQuoteCount(currentQuotePo.getQuoteCount() == null ? 1 : currentQuotePo.getQuoteCount() + 1);
        newSupQuotePO.setSupplierContactsName(currentQuotePo.getSupplierContactsName());
        newSupQuotePO.setSupplierContactsMobile(currentQuotePo.getSupplierContactsMobile());
        if ("2".equals(executeBillPO.getExecuteType())) {
            SupQuotePO qryQuoteQueryPO = new SupQuotePO();
            qryQuoteQueryPO.setExecuteId(currentQuotePo.getExecuteId());
            qryQuoteQueryPO.setOrderBy("quote_round DESC");
            qryQuoteQueryPO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
            List<SupQuotePO> supQuotePOList = this.supQuoteMapper.selectByCondition(qryQuoteQueryPO);
            if (!CollectionUtils.isEmpty(supQuotePOList)) {
                newSupQuotePO.setQuoteRound(supQuotePOList.get(0).getQuoteRound() + 1);
            }
        }
        this.supQuoteMapper.insert(newSupQuotePO);
        HashMap<Long, Long> quotePackIdMap = new HashMap<Long, Long>();
        if (executeBillPO.getExecuteType().equals("2")) {
            SupQuotePackPO supQuotePackPO = new SupQuotePackPO();
            supQuotePackPO.setQuoteId(currentQuotePo.getQuoteId());
            supQuotePackPO.setExecuteId(currentQuotePo.getExecuteId());
            List<SupQuotePackPO> supQuotePackPOS = this.supQuotePackMapper.selectListByCondition(supQuotePackPO);
            for (SupQuotePackPO packPO : supQuotePackPOS) {
                SupQuotePackPO quotePackPO = new SupQuotePackPO();
                quotePackPO.setExecuteId(executeBillPO.getExecuteId());
                quotePackPO.setPackId(packPO.getPackId());
                quotePackPO.setQuotePackId(Sequence.getInstance().nextId());
                quotePackPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                quotePackPO.setQuoteRound(newSupQuotePO.getQuoteRound());
                quotePackPO.setQuoteId(newSupQuotePO.getQuoteId());
                quotePackPO.setQuotePackMoney(quotePackPO.getQuotePackMoney());
                this.supQuotePackMapper.insert(quotePackPO);
                quotePackIdMap.put(quotePackPO.getPackId(), quotePackPO.getQuotePackId());
            }
        }
        SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
        supQuoteItemPO.setQuoteId(currentQuotePo.getQuoteId());
        supQuoteItemPO.setExecuteId(currentQuotePo.getExecuteId());
        Page page = new Page(1, 1000);
        List<SupQuoteItemPO> supQuoteItemPOS = this.supQuoteItemMapper.selectListPageByCondition(supQuoteItemPO, page);
        if (page.getTotalPages() == 1) {
            this.copyQuoteItem(supQuoteItemPOS, quoteId, quotePackIdMap);
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                page.setPageNo(i);
                supQuoteItemPOS = this.supQuoteItemMapper.selectListPageByCondition(supQuoteItemPO, page);
                this.copyQuoteItem(supQuoteItemPOS, quoteId, quotePackIdMap);
            }
        }
    }

    private void copyQuoteItem(List<SupQuoteItemPO> supQuoteItemPOS, Long quoteId, Map<Long, Long> quotePackIdMap) {
        ArrayList<SupQuoteItemPO> newSupQuoteItemPOS = new ArrayList<SupQuoteItemPO>();
        for (SupQuoteItemPO itemPO : supQuoteItemPOS) {
            SupQuoteItemPO newItemPO = new SupQuoteItemPO();
            newItemPO.setExecuteId(itemPO.getExecuteId());
            newItemPO.setPlanDetailId(itemPO.getPlanDetailId());
            newItemPO.setQuoteId(quoteId);
            newItemPO.setPlanId(itemPO.getPlanId());
            newItemPO.setQuoteNumbers(itemPO.getSl());
            newItemPO.setSl(itemPO.getSl());
            newItemPO.setPackId(itemPO.getPackId());
            if (quotePackIdMap.get(itemPO.getPackId()) != null) {
                newItemPO.setQuotePackId(quotePackIdMap.get(itemPO.getPackId()));
            } else {
                newItemPO.setQuotePackId(0L);
            }
            newItemPO.setExecuteItemId(itemPO.getExecuteItemId());
            newItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            newItemPO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
            newSupQuoteItemPOS.add(newItemPO);
        }
        this.supQuoteItemMapper.insertBatch(newSupQuoteItemPOS);
    }

    private List<String> priceCheckQuoteItem(ExecuteBillPO executeBillPO, List<SupQuoteItemMidPO> supQuoteItemMidPOList, List<SupQuoteItemPO> supQuoteItemPOList, SubmitQuotationBillRspBO rspBO) {
        ArrayList<String> priceCheckQuoteStrList = new ArrayList<String>();
        String biddingDecrease = executeBillPO.getBiddingDecrease();
        if (StringUtils.isEmpty((CharSequence)biddingDecrease)) {
            return priceCheckQuoteStrList;
        }
        BigDecimal decreaseDecimal = new BigDecimal(biddingDecrease);
        for (SupQuoteItemMidPO supQuoteItemMidPO : supQuoteItemMidPOList) {
            BigDecimal lowPrice = new BigDecimal(0);
            BigDecimal quotePrice = supQuoteItemMidPO.getQuotePrice();
            for (SupQuoteItemPO supQuoteItemPO : supQuoteItemPOList) {
                if (supQuoteItemPO.getQuoteItemId().longValue() != supQuoteItemMidPO.getQuoteItemId().longValue()) continue;
                lowPrice = supQuoteItemPO.getQuotePrice();
                break;
            }
            if (lowPrice.compareTo(BigDecimal.ZERO) <= 0 || quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (executeBillPO.getBiddingDecreaseType() == null && lowPrice.compareTo(quotePrice) < 0) {
                log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e\u4e0a\u6b21\u884c\u62a5\u4ef7:" + lowPrice);
                priceCheckQuoteStrList.add("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e\u4e0a\u6b21\u884c\u62a5\u4ef7:" + lowPrice);
            }
            if (EnquiryConstant.BiddingDecreaseType.COMPARED_QUOTE_TYPE_1.equals(executeBillPO.getBiddingDecreaseType()) && (lowPrice = lowPrice.subtract(lowPrice.multiply(decreaseDecimal = decreaseDecimal.divide(new BigDecimal(100), 2, 4)).setScale(2, 4))).compareTo(quotePrice) < 0) {
                log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                priceCheckQuoteStrList.add("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
            }
            if (!EnquiryConstant.BiddingDecreaseType.COMPARED_QUOTE_TYPE_2.equals(executeBillPO.getBiddingDecreaseType())) continue;
            if (lowPrice.compareTo(decreaseDecimal) > 0) {
                if ((lowPrice = lowPrice.subtract(decreaseDecimal)).compareTo(quotePrice) >= 0) continue;
                log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                priceCheckQuoteStrList.add("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                continue;
            }
            log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
            priceCheckQuoteStrList.add("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
        }
        return priceCheckQuoteStrList;
    }

    private String priceCheck(ExecuteBillPO executeBillPO, BigDecimal quotePrice, BigDecimal standPrice, SubmitQuotationBillRspBO rspBO) {
        String biddingDecrease = executeBillPO.getBiddingDecrease();
        String errorString = "";
        if (biddingDecrease != null) {
            BigDecimal lowPrice;
            BigDecimal decreaseDecimal = new BigDecimal(biddingDecrease);
            if (EnquiryConstant.BiddingDecreaseType.COMPARED_QUOTE_TYPE_1.equals(executeBillPO.getBiddingDecreaseType())) {
                decreaseDecimal = decreaseDecimal.divide(new BigDecimal(100), 2, 4);
                lowPrice = standPrice.subtract(standPrice.multiply(decreaseDecimal).setScale(2, 4));
                log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e:" + standPrice + "*" + decreaseDecimal + "=" + lowPrice);
                if (lowPrice.compareTo(quotePrice) < 0) {
                    log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                    errorString = "\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice;
                    return errorString;
                }
            }
            if (EnquiryConstant.BiddingDecreaseType.COMPARED_QUOTE_TYPE_2.equals(executeBillPO.getBiddingDecreaseType())) {
                if (standPrice.compareTo(decreaseDecimal) > 0) {
                    lowPrice = standPrice.subtract(decreaseDecimal);
                    if (lowPrice.compareTo(quotePrice) < 0) {
                        log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice);
                        errorString = "\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + lowPrice;
                        return errorString;
                    }
                } else {
                    log.error("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + standPrice);
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + standPrice);
                    errorString = "\u5f53\u524d\u62a5\u4ef7:" + quotePrice + ",\u4e0d\u80fd\u9ad8\u4e8e" + EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillPO.getBiddingDecreaseMethod()) + ":" + standPrice;
                    return errorString;
                }
            }
        }
        return errorString;
    }
}

