/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.AgrQryAgreementSkuByPageAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.bo.ability.SearchCommodityManageAbilityReqBo;
import com.tydic.commodity.bo.ability.SearchCommodityManageAbilityRspBo;
import com.tydic.commodity.bo.ability.SearchCommodityManageBo;
import com.tydic.enquiry.api.bo.QuotationMidItemBO;
import com.tydic.enquiry.api.bo.UpdateQuotationMidItemReqBO;
import com.tydic.enquiry.api.bo.UpdateQuotationMidItemRspBO;
import com.tydic.enquiry.busi.api.UpdateQuotationMidItemBusiService;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteItemMidMapper;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.SupQuoteItemMidPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.uccext.bo.UccExtSearchBarEsReqBO;
import com.tydic.uccext.bo.UccExtSearchBarEsRspBO;
import com.tydic.uccext.service.ExtSearchCommodityManageAbilityService;
import com.tydic.uccext.service.UccExtSearchBarEsAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UpdateQuotationMidItemBusiServiceImpl
implements UpdateQuotationMidItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(UpdateQuotationMidItemBusiServiceImpl.class);
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private SupQuoteItemMidMapper supQuoteItemMidMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private AgrQryAgreementSkuByPageAbilityService agrQryAgreementSkuByPageAbilityService;
    @Autowired
    private ExtSearchCommodityManageAbilityService extSearchCommodityManageAbilityService;
    @Autowired
    private UccExtSearchBarEsAbilityService uccExtSearchBarEsAbilityService;
    private final int checkSkuType = 1;
    private final int checkAgreeType = 2;
    private final int checkOutSkuType = 3;

    @Override
    public UpdateQuotationMidItemRspBO updateQuotationMidItem(UpdateQuotationMidItemReqBO reqBO) {
        UpdateQuotationMidItemRspBO rspBO = new UpdateQuotationMidItemRspBO();
        SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
        ArrayList<Long> quoteItemIdList = new ArrayList<Long>();
        ArrayList<Long> supQuoteItemIdList = new ArrayList<Long>();
        ArrayList<Long> errorQuoteItemIdList = new ArrayList<Long>();
        for (Object quotationMidItemBO : reqBO.getQuotationMidItemList()) {
            quoteItemIdList.add(quotationMidItemBO.getQuoteItemId());
        }
        supQuoteItemPO.setQuoteId(reqBO.getQuoteId());
        supQuoteItemPO.setQuoteItemIdList(quoteItemIdList);
        List<SupQuoteItemPO> quoteItemPOS = this.supQuoteItemMapper.selectListBy(supQuoteItemPO);
        if (CollectionUtils.isEmpty(quoteItemPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u660e\u7ec6\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7\u4e0d\u5b58\u5728\u62a5\u4ef7\u4fe1\u606f");
            return rspBO;
        }
        for (SupQuoteItemPO quoteItemPO : quoteItemPOS) {
            supQuoteItemIdList.add(quoteItemPO.getQuoteItemId());
        }
        for (QuotationMidItemBO quotationMidItemBO : reqBO.getQuotationMidItemList()) {
            if (supQuoteItemIdList.contains(quotationMidItemBO.getQuoteItemId())) continue;
            errorQuoteItemIdList.add(quotationMidItemBO.getQuoteItemId());
        }
        if (!CollectionUtils.isEmpty(errorQuoteItemIdList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u660e\u7ec6\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7" + errorQuoteItemIdList + "\u4e0d\u5b58\u5728\u62a5\u4ef7\u4fe1\u606f,\u4e0d\u53ef\u66f4\u65b0\u62a5\u4ef7");
            return rspBO;
        }
        Map quotationMidItemBOMap = reqBO.getQuotationMidItemList().stream().collect(Collectors.toMap(QuotationMidItemBO::getQuoteItemId, Function.identity(), (key1, key2) -> key2));
        ArrayList<SupQuoteItemPO> skuPOList = new ArrayList<SupQuoteItemPO>();
        ArrayList<SupQuoteItemPO> outSkuPOList = new ArrayList<SupQuoteItemPO>();
        ArrayList<SupQuoteItemPO> agreePOList = new ArrayList<SupQuoteItemPO>();
        if (!CollectionUtils.isEmpty(quoteItemPOS)) {
            List<Long> itemIdList = quoteItemPOS.stream().map(SupQuoteItemPO::getExecuteItemId).collect(Collectors.toList());
            ExecuteItemPO itemQuery = new ExecuteItemPO();
            itemQuery.setExecuteItemIdList(itemIdList);
            List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQuery);
            Map<Long, ExecuteItemPO> executeItemMap = executeItemPOList.stream().collect(Collectors.toMap(ExecuteItemPO::getExecuteItemId, e -> e));
            ArrayList<SupQuoteItemMidPO> insertList = new ArrayList<SupQuoteItemMidPO>();
            for (SupQuoteItemPO quoteItemPO : quoteItemPOS) {
                SupQuoteItemMidPO itemMidPO = new SupQuoteItemMidPO();
                BeanUtils.copyProperties((Object)quoteItemPO, (Object)itemMidPO);
                itemMidPO.setQuoteItemMidId(null);
                if (quotationMidItemBOMap.get(quoteItemPO.getQuoteItemId()) != null) {
                    QuotationMidItemBO quotationMidItemBO = (QuotationMidItemBO)quotationMidItemBOMap.get(quoteItemPO.getQuoteItemId());
                    if (quotationMidItemBO.getQuotePrice() == null) continue;
                    BigDecimal quoteMoney = quotationMidItemBO.getQuotePrice().multiply(quoteItemPO.getQuoteNumbers()).setScale(2, 4);
                    itemMidPO.setQuoteMoney(quoteMoney);
                    itemMidPO.setQuotePrice(quotationMidItemBO.getQuotePrice());
                    itemMidPO.setBrand(quotationMidItemBO.getBrand());
                    itemMidPO.setManufacturer(quotationMidItemBO.getManufacturer());
                    itemMidPO.setProductModelAndOther(quotationMidItemBO.getProductModelAndOther());
                    itemMidPO.setAgreementItemCode(quotationMidItemBO.getAgreementItemCode());
                    itemMidPO.setUpcCode(quotationMidItemBO.getUpcCode());
                    itemMidPO.setProductCode(quotationMidItemBO.getProductCode());
                    itemMidPO.setOutsideProductCode(quotationMidItemBO.getOutsideProductCode());
                    itemMidPO.setPromiseDeliveryDays(quotationMidItemBO.getPromiseDeliveryDays());
                    itemMidPO.setRedisNo(reqBO.getRedisNo());
                    itemMidPO.setQuoteIsDeviate(quotationMidItemBO.getQuoteIsDeviate());
                    itemMidPO.setQuoteDeviateDescribe(quotationMidItemBO.getQuoteDeviateDescribe());
                    itemMidPO.setQuoteIsEffective("1");
                    SupQuoteItemPO quoteItemCheck = new SupQuoteItemPO();
                    ExecuteItemPO executeItemPO = executeItemMap.get(quoteItemPO.getExecuteItemId());
                    BeanUtil.copyProperties((Object)executeItemPO, (Object)quoteItemCheck);
                    BeanUtils.copyProperties((Object)itemMidPO, (Object)quoteItemCheck);
                    if (this.getCheckType(quoteItemCheck) == 1) {
                        skuPOList.add(quoteItemCheck);
                    } else if (this.getCheckType(quoteItemCheck) == 2) {
                        agreePOList.add(quoteItemCheck);
                    } else if (this.getCheckType(quoteItemCheck) == 3) {
                        outSkuPOList.add(quoteItemCheck);
                    }
                }
                insertList.add(itemMidPO);
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getIsCheckSku()) && CollUtil.isNotEmpty(skuPOList)) {
                this.checkSkuPrice(reqBO, skuPOList);
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getIsCheckSku()) && CollUtil.isNotEmpty(outSkuPOList)) {
                this.checkOutSkuPrice(reqBO, outSkuPOList);
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getIsCheckSku()) && CollUtil.isNotEmpty(agreePOList)) {
                this.checkAgreePrice(agreePOList);
            }
            if (CollUtil.isNotEmpty(insertList)) {
                SupQuoteItemMidPO supQuoteItemMidPO = new SupQuoteItemMidPO();
                supQuoteItemMidPO.setRedisNo(reqBO.getRedisNo());
                supQuoteItemMidPO.setQuoteId(reqBO.getQuoteId());
                supQuoteItemMidPO.setExecuteId(reqBO.getExecuteId());
                supQuoteItemMidPO.setQuoteItemIdList(quoteItemIdList);
                this.supQuoteItemMidMapper.deleteByCondition(supQuoteItemMidPO);
                this.supQuoteItemMidMapper.insertQuoteItemMidBatch(insertList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private int getCheckType(SupQuoteItemPO supQuoteItemPO) {
        String productCode = supQuoteItemPO.getProductCode();
        String agreementItemCode = supQuoteItemPO.getAgreementItemCode();
        String outProductCode = supQuoteItemPO.getOutsideProductCode();
        int type = 0;
        if (StrUtil.isNotBlank((CharSequence)productCode)) {
            type = 1;
        } else {
            if (StrUtil.isNotBlank((CharSequence)outProductCode)) {
                type = 3;
                return type;
            }
            if (StrUtil.isNotBlank((CharSequence)agreementItemCode)) {
                type = 2;
            }
        }
        return type;
    }

    private void checkSkuPrice(UpdateQuotationMidItemReqBO reqBo, List<SupQuoteItemPO> itemPOList) {
        ArrayList<Long> skuIdList = new ArrayList<Long>();
        for (SupQuoteItemPO quoteItemPO : itemPOList) {
            String productCode = quoteItemPO.getProductCode();
            if (NumberUtil.isNumber((CharSequence)productCode)) {
                skuIdList.add(Long.parseLong(productCode));
                continue;
            }
            throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        SearchCommodityManageAbilityReqBo searchEsManageReqBo = new SearchCommodityManageAbilityReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)searchEsManageReqBo);
        searchEsManageReqBo.setSkuList(skuIdList);
        searchEsManageReqBo.setVendorId(reqBo.getSupId());
        searchEsManageReqBo.setPageNo(Integer.valueOf(-1));
        searchEsManageReqBo.setPageSize(Integer.valueOf(skuIdList.size()));
        SearchCommodityManageAbilityRspBo searchCommodityManageRspBo = this.extSearchCommodityManageAbilityService.searchCommodity(searchEsManageReqBo);
        List skuQryBySkuIdsBOList = searchCommodityManageRspBo.getResult();
        HashMap<Long, SearchCommodityManageBo> recodeMap = new HashMap<Long, SearchCommodityManageBo>();
        for (SearchCommodityManageBo searchCommodityManageBo : skuQryBySkuIdsBOList) {
            recodeMap.put(searchCommodityManageBo.getSkuId(), searchCommodityManageBo);
        }
        Integer putSelfOk = 3;
        for (SupQuoteItemPO supQuoteItemPO : itemPOList) {
            Long productCode = Long.parseLong(supQuoteItemPO.getProductCode());
            BigDecimal quotePrice = supQuoteItemPO.getQuotePrice();
            SearchCommodityManageBo commodityManageBo = (SearchCommodityManageBo)recodeMap.get(productCode);
            if (commodityManageBo == null) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            if (!putSelfOk.equals(commodityManageBo.getSkuStatus())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u4e3a\u5df2\u4e0a\u67b6\uff01");
            }
            String outsideProductCode = supQuoteItemPO.getOutsideProductCode();
            if (StrUtil.isNotBlank((CharSequence)outsideProductCode) && !outsideProductCode.equals(commodityManageBo.getExtSkuId())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u7684\u5916\u90e8\u5546\u54c1\u7f16\u7801\u3010" + outsideProductCode + "\u3011\u4e0d\u6b63\u786e\uff01");
            }
            BigDecimal priceBig = commodityManageBo.getSalePrice();
            if (priceBig == null) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5e73\u53f0\u5546\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (quotePrice == null) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (quotePrice.compareTo(priceBig) <= 0) continue;
            log.info("\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u5e73\u53f0\u5546\u54c1\u4ef7\u683c:" + priceBig);
            throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u62a5\u4ef7\u4e0d\u80fd\u5927\u4e8e\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\uff01");
        }
    }

    private void checkOutSkuPrice(UpdateQuotationMidItemReqBO reqBo, List<SupQuoteItemPO> itemPOList) {
        ArrayList<String> outSkuIdList = new ArrayList<String>();
        for (SupQuoteItemPO quoteItemPO : itemPOList) {
            String productCode = quoteItemPO.getOutsideProductCode();
            outSkuIdList.add(productCode);
        }
        List<Integer> skuStatus = Arrays.asList(3);
        UccExtSearchBarEsReqBO searchEsManageReqBo = new UccExtSearchBarEsReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)searchEsManageReqBo);
        searchEsManageReqBo.setExtSkuIds(outSkuIdList);
        searchEsManageReqBo.setVendorId(reqBo.getSupId());
        searchEsManageReqBo.setSkuStatus(skuStatus);
        searchEsManageReqBo.setPageNo(1);
        searchEsManageReqBo.setPageSize(outSkuIdList.size());
        log.info("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)searchEsManageReqBo));
        UccExtSearchBarEsRspBO searchCommodityManageRspBo = this.uccExtSearchBarEsAbilityService.qryBySearchBar(searchEsManageReqBo);
        log.info("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)searchCommodityManageRspBo));
        List skuQryBySkuIdsBOList = searchCommodityManageRspBo.getResult();
        HashMap<String, SearchBarEsRspInfo> recodeMap = new HashMap<String, SearchBarEsRspInfo>();
        for (SearchBarEsRspInfo searchCommodityManageBo : skuQryBySkuIdsBOList) {
            if (searchCommodityManageBo.getVendorId() == null || searchCommodityManageBo.getVendorId().longValue() != reqBo.getSupId().longValue()) continue;
            recodeMap.put(searchCommodityManageBo.getExtSkuId(), searchCommodityManageBo);
        }
        Integer putSelfOk = 3;
        for (SupQuoteItemPO supQuoteItemPO : itemPOList) {
            String productCode = supQuoteItemPO.getOutsideProductCode();
            BigDecimal quotePrice = supQuoteItemPO.getQuotePrice();
            SearchBarEsRspInfo commodityManageBo = (SearchBarEsRspInfo)recodeMap.get(productCode);
            if (commodityManageBo == null) {
                throw new BusinessException("8888", "\u5916\u90e8\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            BigDecimal priceBig = commodityManageBo.getSalePrice();
            if (priceBig == null) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5e73\u53f0\u5546\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (quotePrice == null) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (quotePrice.compareTo(priceBig) <= 0) continue;
            log.info("\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u5e73\u53f0\u5546\u54c1\u4ef7\u683c:" + priceBig);
            throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + productCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u62a5\u4ef7\u4e0d\u80fd\u5927\u4e8e\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\uff01");
        }
    }

    private void checkAgreePrice(List<SupQuoteItemPO> itemPOList) {
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        HashMap<Long, AgrAgreementSkuBO> recodeMap = new HashMap<Long, AgrAgreementSkuBO>();
        for (SupQuoteItemPO supQuoteItemPO : itemPOList) {
            String agreementItemCode = supQuoteItemPO.getAgreementItemCode();
            if (NumberUtil.isNumber((CharSequence)agreementItemCode)) {
                agreementIds.add(Long.parseLong(agreementItemCode));
                continue;
            }
            throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u3010" + agreementItemCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        List agrAgreementSkuBOList = new ArrayList();
        if (!CollectionUtils.isEmpty(agreementIds)) {
            AgrQryAgreementSkuByPageAbilityReqBO agrQryAgreementSkuByPageAbilityReqBO = new AgrQryAgreementSkuByPageAbilityReqBO();
            agrQryAgreementSkuByPageAbilityReqBO.setPageQueryFlag(Boolean.valueOf(false));
            agrQryAgreementSkuByPageAbilityReqBO.setAgreementSkuIds(agreementIds);
            agrQryAgreementSkuByPageAbilityReqBO.setAgreementStatus(new ArrayList(Byte.parseByte("4")));
            AgrQryAgreementSkuByPageAbilityRspBO agrQryAgreementSkuByPageAbilityRspBO = this.agrQryAgreementSkuByPageAbilityService.qryAgreementSkuByPage(agrQryAgreementSkuByPageAbilityReqBO);
            agrAgreementSkuBOList = agrQryAgreementSkuByPageAbilityRspBO.getRows();
            for (AgrAgreementSkuBO agrAgreementSkuBO : agrAgreementSkuBOList) {
                recodeMap.put(agrAgreementSkuBO.getAgreementSkuId(), agrAgreementSkuBO);
            }
        }
        for (SupQuoteItemPO supQuoteItemPO : itemPOList) {
            AgrAgreementSkuBO agrAgreementSkuBO;
            Long agreeId = Long.parseLong(supQuoteItemPO.getAgreementItemCode());
            agrAgreementSkuBO = (AgrAgreementSkuBO)recodeMap.get(agreeId);
            if (agrAgreementSkuBO == null) {
                throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            BigDecimal quotePrice = supQuoteItemPO.getQuotePrice();
            if (quotePrice == null) {
                throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u7684\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Long price = agrAgreementSkuBO.getSalePrice();
            if (price == null) {
                throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u7684\u5e73\u53f0\u5546\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BigDecimal priceBig = new BigDecimal(price).divide(BigDecimal.valueOf(10000L), 2, 4);
            if (quotePrice.compareTo(priceBig) <= 0) continue;
            log.info("\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u5bf9\u5e94\u7684\u534f\u8bae\u5546\u54c1\u4ef7\u683c:" + priceBig);
            throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u7684\u62a5\u4ef7\u4e0d\u80fd\u5927\u4e8e\u534f\u8bae\u5546\u54c1\u4ef7\u683c\uff01");
        }
    }
}

