/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl.plan;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.enquiry.api.bo.EnquriyOrgSupTagBO;
import com.tydic.enquiry.api.bo.QuotationItemBO;
import com.tydic.enquiry.busi.api.bo.QryQuotationBO;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umcext.ability.srm.UmcOrgSupTagQryAbilityService;
import com.tydic.umcext.ability.srm.bo.UmcOrgSupTagListQryAbilityReqBO;
import com.tydic.umcext.ability.srm.bo.UmcOrgSupTagListQryAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackSupinfoCommonService {
    private static final Logger log = LoggerFactory.getLogger(BlackSupinfoCommonService.class);
    @Autowired
    private UmcOrgSupTagQryAbilityService umcOrgSupTagQryAbilityService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;

    public Map<Long, List<EnquriyOrgSupTagBO>> getBlackSupMap(Long companyId, String orgPath, List<Long> supIds) {
        List<EnquriyOrgSupTagBO> enquriyOrgSupTagBOS = this.getBlackSupList(companyId, orgPath, supIds);
        Map<Long, List<EnquriyOrgSupTagBO>> orgSupTagMap = new HashMap<Long, List<EnquriyOrgSupTagBO>>();
        if (CollUtil.isNotEmpty(enquriyOrgSupTagBOS)) {
            orgSupTagMap = enquriyOrgSupTagBOS.stream().collect(Collectors.groupingBy(EnquriyOrgSupTagBO::getSupplierId));
        }
        return orgSupTagMap;
    }

    public Map<String, List<EnquriyOrgSupTagBO>> getOrgBlackSupMap(Set<String> orgIdSet, Long supId) {
        HashMap<String, List<EnquriyOrgSupTagBO>> allOrgBlackMap = new HashMap<String, List<EnquriyOrgSupTagBO>>();
        for (String demandOrgId : orgIdSet) {
            if (!StrUtil.isNotBlank((CharSequence)demandOrgId)) continue;
            Map<Long, List<EnquriyOrgSupTagBO>> orgSupTagMap = this.getBlackSupMap(Long.valueOf(demandOrgId), null, CollUtil.newArrayList((Object[])new Long[]{supId}));
            for (Map.Entry<Long, List<EnquriyOrgSupTagBO>> entry : orgSupTagMap.entrySet()) {
                List<EnquriyOrgSupTagBO> blackList = entry.getValue();
                if (!CollUtil.isNotEmpty(blackList)) continue;
                String key = demandOrgId + "_" + supId;
                allOrgBlackMap.put(key, blackList);
            }
        }
        return allOrgBlackMap;
    }

    public List<EnquriyOrgSupTagBO> getBlackSupList(Long companyId, String orgPath, List<Long> supIds) {
        if (StrUtil.isBlank((CharSequence)orgPath) && companyId != null) {
            UmcZhEnterpriseOrgAbilityBO umcZhEnterpriseOrgAbilityBO;
            UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
            umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(companyId);
            UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
            if (umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode().equals("0000") && (umcZhEnterpriseOrgAbilityBO = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO()) != null) {
                orgPath = umcZhEnterpriseOrgAbilityBO.getOrgTreePath();
            }
        }
        List<Object> enquriyOrgSupTagBOS = new ArrayList<EnquriyOrgSupTagBO>();
        if (StrUtil.isNotBlank((CharSequence)orgPath)) {
            List orgSupTagBOS;
            UmcOrgSupTagListQryAbilityReqBO tagReq = new UmcOrgSupTagListQryAbilityReqBO();
            List ordIdList = Arrays.stream(orgPath.split("-")).filter(NumberUtil::isLong).map(Long::parseLong).collect(Collectors.toList());
            tagReq.setOrgIdList(ordIdList);
            tagReq.setSupplierIdList(supIds);
            tagReq.setBqzList(Arrays.asList("50", "60"));
            tagReq.setBqztList((List)CollUtil.newArrayList((Object[])new String[]{"1"}));
            UmcOrgSupTagListQryAbilityRspBO orgSupTagListQryAbilityRspBO = this.umcOrgSupTagQryAbilityService.listOrgSupTag(tagReq);
            if ("0000".equals(orgSupTagListQryAbilityRspBO.getRespCode()) && CollUtil.isNotEmpty((Collection)(orgSupTagBOS = orgSupTagListQryAbilityRspBO.getTagList()))) {
                enquriyOrgSupTagBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)orgSupTagBOS), EnquriyOrgSupTagBO.class);
                return enquriyOrgSupTagBOS.stream().sorted(Comparator.comparing(EnquriyOrgSupTagBO::getBqfw, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
            }
        }
        return enquriyOrgSupTagBOS;
    }

    public Map<String, List<EnquriyOrgSupTagBO>> getQuoteBlackSupList(Long executeId, List<QuotationItemBO> quotationItemBOList) {
        QryQuotationBO qryQuotationBO = new QryQuotationBO();
        qryQuotationBO.setExecuteId(executeId);
        quotationItemBOList = this.supQuoteItemMapper.selectListPageWithBiddingQuoteByCondition(qryQuotationBO);
        HashMap<String, Set<String>> supOrgMap = new HashMap<String, Set<String>>();
        if (CollUtil.isNotEmpty(quotationItemBOList)) {
            for (QuotationItemBO quotationItemBO : quotationItemBOList) {
                Long supId = quotationItemBO.getSupplierId();
                if (supId == null) continue;
                this.addValToMap(supOrgMap, String.valueOf(supId), quotationItemBO.getDemandOrgId());
            }
        }
        HashMap<String, List<EnquriyOrgSupTagBO>> allOrgBlackMap = new HashMap<String, List<EnquriyOrgSupTagBO>>();
        if (CollUtil.isNotEmpty(supOrgMap)) {
            for (Map.Entry entry : supOrgMap.entrySet()) {
                String supId = (String)entry.getKey();
                Set orgIdset = (Set)entry.getValue();
                Map<String, List<EnquriyOrgSupTagBO>> orgBlackMap = this.getOrgBlackSupMap(orgIdset, Long.valueOf(supId));
                allOrgBlackMap.putAll(orgBlackMap);
            }
        }
        return allOrgBlackMap;
    }

    private void addValToMap(Map<String, Set<String>> dataMap, String key, String val) {
        if (StrUtil.isNotBlank((CharSequence)val)) {
            if (dataMap.containsKey(key)) {
                dataMap.get(key).add(val);
            } else {
                HashSet<String> dataSet = new HashSet<String>();
                dataSet.add(val);
                dataMap.put(key, dataSet);
            }
        }
    }
}

