/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl.plan;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.AgrQryAgreementByPageAbilityService;
import com.tydic.agreement.ability.AgrQryAgreementSkuByPageAbilityService;
import com.tydic.agreement.ability.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.AgrQryRelBusiPropLabelsAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryRelBusiPropLabelsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryRelBusiPropLabelsAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrRelBusiPropLabelInfoBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.common.bo.AgrAgreementScopeBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.contract.api.proplabel.bo.ContractQryRelBusiPropLabelsAbilityReqBO;
import com.tydic.contract.api.proplabel.bo.ContractQryRelBusiPropLabelsAbilityRspBO;
import com.tydic.contract.api.proplabel.bo.ContractRelBusiPropLabelInfoBO;
import com.tydic.contract.api.proplabel.service.ContractQryRelBusiPropLabelsAbilityService;
import com.tydic.enquiry.common.EnquiryReqBO;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.FitMapper;
import com.tydic.enquiry.dao.po.FitPO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingBO;
import com.tydic.order.third.intf.bo.ucc.list.SkuLabelInfoBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityReqBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityRspBO;
import com.tydic.uccext.bo.UccExtSearchBarEsReqBO;
import com.tydic.uccext.bo.UccExtSearchBarEsRspBO;
import com.tydic.uccext.service.CnncCatalogListQueryAbilityService;
import com.tydic.uccext.service.UccExtSearchBarEsAbilityService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MyPlanCommonService {
    private static final Logger log = LoggerFactory.getLogger(MyPlanCommonService.class);
    @Autowired
    private AgrQryAgreementByPageAbilityService agrQryAgreementByPageAbilityService;
    @Autowired
    private ContractQryRelBusiPropLabelsAbilityService contractQryRelBusiPropLabelsAbilityService;
    @Autowired
    private AgrQryRelBusiPropLabelsAbilityService agrQryRelBusiPropLabelsAbilityService;
    @Autowired
    private FitMapper fitMapper;
    @Autowired
    private AgrQryAgreementSkuByPageAbilityService agrQryAgreementSkuByPageAbilityService;
    @Autowired
    private UccExtSearchBarEsAbilityService uccExtSearchBarEsAbilityService;
    @Autowired
    private CnncCatalogListQueryAbilityService cnncCatalogListQueryAbilityService;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;

    public List<AgrAgreementBO> qryAgrAgreementList(Set<Long> agreeIdSet) {
        List<Object> agrAgreementList = new ArrayList<AgrAgreementBO>();
        if (CollUtil.isEmpty(agreeIdSet)) {
            return agrAgreementList;
        }
        AgrQryAgreementByPageAbilityReqBO agrReqBO = new AgrQryAgreementByPageAbilityReqBO();
        agrReqBO.setAgreementIds(new ArrayList<Long>(agreeIdSet));
        agrReqBO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
        agrReqBO.setPageQueryFlag(Boolean.valueOf(false));
        AgrQryAgreementByPageAbilityRspBO agreementRspBO = this.agrQryAgreementByPageAbilityService.qryAgreementInfoByPage(agrReqBO);
        if (agreementRspBO != null && "0000".equals(agreementRspBO.getRespCode())) {
            agrAgreementList = agreementRspBO.getRows();
        }
        return agrAgreementList;
    }

    public List<AgrAgreementSkuBO> qryAgrAgreementDetailList(List<Long> agreeDetailList) {
        List<Object> agrAgreementList = new ArrayList<AgrAgreementSkuBO>();
        if (CollUtil.isEmpty(agreeDetailList)) {
            return agrAgreementList;
        }
        AgrQryAgreementSkuByPageAbilityReqBO qryAgreementSkuReqBO = new AgrQryAgreementSkuByPageAbilityReqBO();
        qryAgreementSkuReqBO.setPageQueryFlag(Boolean.valueOf(false));
        qryAgreementSkuReqBO.setAgreementSkuIds(agreeDetailList);
        qryAgreementSkuReqBO.setPageNo(Integer.valueOf(1));
        qryAgreementSkuReqBO.setPageSize(Integer.valueOf(-1));
        AgrQryAgreementSkuByPageAbilityRspBO agrSkuRspBO = this.agrQryAgreementSkuByPageAbilityService.qryAgreementSkuByPage(qryAgreementSkuReqBO);
        if (agrSkuRspBO != null && "0000".equals(agrSkuRspBO.getRespCode())) {
            agrAgreementList = agrSkuRspBO.getRows();
        }
        return agrAgreementList;
    }

    public List<ContractRelBusiPropLabelInfoBO> getContractRelLabelList(List<Long> contractIdList) {
        List<Object> labelList = new ArrayList<ContractRelBusiPropLabelInfoBO>();
        if (CollUtil.isNotEmpty(contractIdList)) {
            ContractQryRelBusiPropLabelsAbilityReqBO infoReqBO = new ContractQryRelBusiPropLabelsAbilityReqBO();
            infoReqBO.setContractIds(contractIdList);
            ContractQryRelBusiPropLabelsAbilityRspBO contractRspBO = this.contractQryRelBusiPropLabelsAbilityService.qryRelBusiPropLabels(infoReqBO);
            if (contractRspBO != null && "0000".equals(contractRspBO.getCode())) {
                labelList = contractRspBO.getContractLabels();
            } else {
                String errorMsg = contractIdList + "\u5408\u540c\u67e5\u8be2\u51fa\u9519";
                if (contractRspBO != null) {
                    errorMsg = errorMsg + contractRspBO.getMessage();
                }
                log.error(errorMsg);
            }
        }
        return labelList;
    }

    public SkuLabelInfoBO getLabelInfo(String labelListStr) {
        List labelInfoBOList;
        Integer level1 = 1;
        SkuLabelInfoBO labelInfoBO = new SkuLabelInfoBO();
        if (JSON.isValidArray((String)labelListStr) && CollUtil.isNotEmpty((Collection)(labelInfoBOList = JSON.parseArray((String)labelListStr, SkuLabelInfoBO.class)))) {
            for (SkuLabelInfoBO busiPropLabelBO : labelInfoBOList) {
                if (!AgrEnum.AgrPropLabelType.YWSX.getType().equals(busiPropLabelBO.getLabelProp()) || !level1.equals(busiPropLabelBO.getLabelLevel())) continue;
                labelInfoBO = busiPropLabelBO;
                break;
            }
        }
        return labelInfoBO;
    }

    public List<AgrRelBusiPropLabelInfoBO> getAgrRelLabelList(List<Long> agreeIdList) {
        List<Object> labelList = new ArrayList<AgrRelBusiPropLabelInfoBO>();
        if (CollUtil.isNotEmpty(agreeIdList)) {
            AgrQryRelBusiPropLabelsAbilityReqBO infoReqBO = new AgrQryRelBusiPropLabelsAbilityReqBO();
            infoReqBO.setAgreementIds(agreeIdList);
            AgrQryRelBusiPropLabelsAbilityRspBO agreeRspBO = this.agrQryRelBusiPropLabelsAbilityService.qryRelBusiPropLabels(infoReqBO);
            if (agreeRspBO != null && "0000".equals(agreeRspBO.getRespCode())) {
                labelList = agreeRspBO.getAgrLabels();
            } else {
                String errorMsg = agreeIdList + "\u534f\u8bae\u67e5\u8be2\u51fa\u9519";
                if (agreeRspBO != null) {
                    errorMsg = errorMsg + agreeRspBO.getRespDesc();
                }
                log.error(errorMsg);
            }
        }
        return labelList;
    }

    public List<AgrRelBusiPropLabelInfoBO> getAgrRelLabelList(String agreeId) {
        if (StrUtil.isBlank((CharSequence)agreeId)) {
            return new ArrayList<AgrRelBusiPropLabelInfoBO>();
        }
        return this.getAgrRelLabelList(CollUtil.newArrayList((Object[])new Long[]{Long.valueOf(agreeId)}));
    }

    public List<ContractRelBusiPropLabelInfoBO> getContractRelLabelList(String contractId) {
        if (StrUtil.isBlank((CharSequence)contractId)) {
            return new ArrayList<ContractRelBusiPropLabelInfoBO>();
        }
        return this.getContractRelLabelList(CollUtil.newArrayList((Object[])new Long[]{Long.valueOf(contractId)}));
    }

    public List<SearchBarEsRspInfo> qrySkuInfoList(EnquiryReqBO reqBO, List<Long> skuIdList) {
        List<Object> skuList = new ArrayList<SearchBarEsRspInfo>();
        if (CollUtil.isEmpty(skuIdList)) {
            return skuList;
        }
        UccExtSearchBarEsReqBO searchCommodityReqBo = new UccExtSearchBarEsReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)searchCommodityReqBo);
        searchCommodityReqBo.setPageNo(1);
        searchCommodityReqBo.setPageSize(skuIdList.size());
        searchCommodityReqBo.setSkuList(skuIdList);
        searchCommodityReqBo.setQueryStr("");
        ArrayList<Integer> skuStatus = new ArrayList<Integer>();
        skuStatus.add(1);
        skuStatus.add(2);
        skuStatus.add(3);
        skuStatus.add(4);
        skuStatus.add(5);
        skuStatus.add(6);
        skuStatus.add(7);
        searchCommodityReqBo.setSkuStatus(skuStatus);
        UccExtSearchBarEsRspBO searchCommodityManageAbilityRspBo = this.uccExtSearchBarEsAbilityService.qryBySearchBar(searchCommodityReqBo);
        if (searchCommodityManageAbilityRspBo != null && CollUtil.isNotEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
            skuList = searchCommodityManageAbilityRspBo.getResult();
        } else {
            log.error(skuIdList + "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff1a\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        return skuList;
    }

    public List<Integer> getAllOptBtnList(PebExtPlanItemSecondBargainingBO planItemBO) {
        ArrayList<Integer> showBtnList = new ArrayList<Integer>();
        HashSet<Integer> showBtnSet = new HashSet<Integer>();
        ArrayList optBtnList = CollUtil.newArrayList((Object[])new Integer[]{EnquiryEnumConstant.OptBtnTypeEnum.ADD_SHOP_CART.getCode(), EnquiryEnumConstant.OptBtnTypeEnum.ENTRUST_SOURCE.getCode(), EnquiryEnumConstant.OptBtnTypeEnum.CONTACT_UNIT.getCode(), EnquiryEnumConstant.OptBtnTypeEnum.CONTACT_ORG.getCode(), EnquiryEnumConstant.OptBtnTypeEnum.CONTACT_ORG_ADD_TEST_UNIT.getCode()});
        for (Integer code : optBtnList) {
            if (!this.checkBtnUserable(planItemBO, code).booleanValue()) continue;
            showBtnSet.add(code);
        }
        if (CollUtil.isNotEmpty(showBtnSet)) {
            showBtnList = new ArrayList(showBtnSet);
        }
        return showBtnList;
    }

    public Boolean checkBtnUserable(PebExtPlanItemSecondBargainingBO planItemBO, Integer optBtnType) {
        boolean useableFlag = false;
        String checkContractId = planItemBO.getContractId();
        String checkAgreeId = planItemBO.getAgreeId();
        String yjlm = planItemBO.getYjjcqzml();
        Integer matchSkuCount = planItemBO.getIsMultiple();
        int relateType = 1;
        if (matchSkuCount != null && matchSkuCount > 0) {
            relateType = 2;
        } else {
            FitPO fitPO = new FitPO();
            fitPO.setPlanDetailId(planItemBO.getPlanItemId());
            fitPO.setFitStatus("1");
            fitPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            List<FitPO> fitPOList = this.fitMapper.selectList(fitPO);
            if (CollUtil.isNotEmpty(fitPOList)) {
                relateType = 2;
            }
        }
        String ywlx = planItemBO.getYwlx();
        Integer contractFlag = planItemBO.getContractFlag();
        if (new Integer("0").equals(contractFlag)) {
            if (EnquiryEnumConstant.OptBtnTypeEnum.ENTRUST_SOURCE.getCode().equals(optBtnType)) {
                useableFlag = true;
            }
            if ("0".equals(yjlm) && EnquiryEnumConstant.OptBtnTypeEnum.BACK.getCode().equals(optBtnType)) {
                useableFlag = true;
            }
        } else if (EnquiryConstant.WxRelateType.MATCH_ITEM.equals((byte)relateType)) {
            if (UocConstant.UocYwlxEnum.XTFN.getCode().equals(ywlx)) {
                String orgId = null;
                boolean addShopFlag = false;
                boolean testUnitFlag = false;
                if (StrUtil.isNotBlank((CharSequence)planItemBO.getExecuteOrgId())) {
                    orgId = planItemBO.getExecuteOrgId();
                } else if (StrUtil.isNotBlank((CharSequence)planItemBO.getDemandOrgId())) {
                    orgId = planItemBO.getDemandOrgId();
                }
                if (orgId != null && StrUtil.isNotBlank((CharSequence)checkAgreeId)) {
                    AgrAgreementBO agreementBO;
                    UmcZhEnterpriseOrgAbilityBO orgAbilityBO = this.getOrgInfo(Long.valueOf(orgId));
                    String orgTreePath = orgAbilityBO.getOrgTreePath();
                    List orgIdList = new ArrayList();
                    if (StrUtil.isNotBlank((CharSequence)orgTreePath)) {
                        orgIdList = StrUtil.splitTrim((CharSequence)orgTreePath, (CharSequence)"-");
                    }
                    AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
                    agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(Long.valueOf(checkAgreeId));
                    AgrQryAgreementSubjectDetailsAbilityRspBO agreementDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
                    if (agreementDetailsAbilityRspBO != null && "0000".equals(agreementDetailsAbilityRspBO.getRespCode()) && (agreementBO = agreementDetailsAbilityRspBO.getAgrAgreementBO()) != null) {
                        List agrAgreementScopeList = agreementBO.getAgrAgreementScopeBOs();
                        Integer visable = 1;
                        HashSet<String> visableSet = new HashSet<String>();
                        HashSet<String> scopeSet = new HashSet<String>();
                        for (AgrAgreementScopeBO agrAgreementScopeBO : agrAgreementScopeList) {
                            Integer scopeMode = agrAgreementScopeBO.getScopeMode();
                            String scopeCode = String.valueOf(agrAgreementScopeBO.getScopeCode());
                            if (scopeMode == 0 && orgIdList.contains(scopeCode)) {
                                if (visable.equals(agrAgreementScopeBO.getVisible())) {
                                    visableSet.add(orgId);
                                } else {
                                    scopeSet.add(orgId);
                                }
                            }
                            if (visable.equals(agrAgreementScopeBO.getVisible())) {
                                visableSet.add(scopeCode);
                                continue;
                            }
                            scopeSet.add(scopeCode);
                        }
                        if (scopeSet.contains("0") || scopeSet.contains(orgId)) {
                            addShopFlag = true;
                        } else if (visableSet.contains(orgId)) {
                            testUnitFlag = true;
                        }
                    }
                }
                if (addShopFlag && EnquiryEnumConstant.OptBtnTypeEnum.ADD_SHOP_CART.getCode().equals(optBtnType)) {
                    useableFlag = true;
                }
                if (testUnitFlag && EnquiryEnumConstant.OptBtnTypeEnum.CONTACT_ORG_ADD_TEST_UNIT.getCode().equals(optBtnType)) {
                    useableFlag = true;
                }
            } else if (EnquiryEnumConstant.OptBtnTypeEnum.ADD_SHOP_CART.getCode().equals(optBtnType)) {
                useableFlag = true;
            }
        } else if (UocConstant.UocYwlxEnum.YJJC.getCode().equals(ywlx)) {
            if (EnquiryEnumConstant.OptBtnTypeEnum.BIDDING_ALL.getCode().equals(optBtnType)) {
                useableFlag = true;
            }
        } else if (UocConstant.UocYwlxEnum.XTFN.getCode().equals(ywlx)) {
            if (EnquiryEnumConstant.OptBtnTypeEnum.BIDDING_ALL.getCode().equals(optBtnType)) {
                useableFlag = true;
            }
        } else if (UocConstant.UocYwlxEnum.EJJC.getCode().equals(ywlx)) {
            if (EnquiryEnumConstant.OptBtnTypeEnum.BIDDING_SELF.getCode().equals(optBtnType)) {
                useableFlag = true;
            }
        } else if (UocConstant.UocYwlxEnum.ZCYW.getCode().equals(ywlx) && EnquiryEnumConstant.OptBtnTypeEnum.BIDDING_SELF.getCode().equals(optBtnType)) {
            useableFlag = true;
        }
        return useableFlag;
    }

    private UmcZhEnterpriseOrgAbilityBO getOrgInfo(Long orgId) {
        UmcZhEnterpriseOrgAbilityBO umcZhEnterpriseOrgAbilityBO = null;
        UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
        umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(orgId);
        UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
        if (umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode().equals("0000")) {
            umcZhEnterpriseOrgAbilityBO = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO();
        }
        if (umcZhEnterpriseOrgAbilityBO == null) {
            umcZhEnterpriseOrgAbilityBO = new UmcZhEnterpriseOrgAbilityBO();
        }
        return umcZhEnterpriseOrgAbilityBO;
    }

    public Map<String, UccEMdmCatalogBO> getCatalogInfoMap(Set<String> wlflSet) {
        HashMap<String, UccEMdmCatalogBO> wlcglxMap = new HashMap<String, UccEMdmCatalogBO>();
        if (CollUtil.isNotEmpty(wlflSet)) {
            List catalogList;
            CnncCatalogListQueryAbilityReqBO qryReqBO = new CnncCatalogListQueryAbilityReqBO();
            qryReqBO.setCatalogCodes((List)CollUtil.newArrayList(wlflSet));
            CnncCatalogListQueryAbilityRspBO rspBO = this.cnncCatalogListQueryAbilityService.qryCatalogList(qryReqBO);
            if ("0000".equals(rspBO.getRespCode()) && CollUtil.isNotEmpty((Collection)(catalogList = rspBO.getCatalogBOList()))) {
                for (UccEMdmCatalogBO catalogBO : catalogList) {
                    wlcglxMap.put(catalogBO.getCatalogCode(), catalogBO);
                }
            }
        }
        return wlcglxMap;
    }
}

