/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl.plan;

import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.PurchasePlanItemUpdateDistributeReqBO;
import com.tydic.enquiry.api.bo.PurchasePlanItemUpdateDistributeRspBO;
import com.tydic.enquiry.api.bo.QueryPurchasePlanDistributeBO;
import com.tydic.enquiry.api.bo.QueryPurchasePlanDistributeListReqBO;
import com.tydic.enquiry.api.bo.QueryPurchasePlanDistributeListRspBO;
import com.tydic.enquiry.busi.api.plan.PurchasePlanDetailsDistributeBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryGenerateIdUtil;
import com.tydic.enquiry.dao.DistributePlanMapper;
import com.tydic.enquiry.dao.po.DistributePlanPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.ability.plan.PebExtPlanItemDetailQueryAbilityService;
import com.tydic.order.extend.ability.plan.PebExtPlanItemUpdateAbilityService;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingListQueryReqBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingListQueryRspBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemUpdateReqBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemUpdateRspBO;
import com.tydic.order.extend.constant.PebExtConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePlanDetailsDistributeBusiServiceImpl
implements PurchasePlanDetailsDistributeBusiService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePlanDetailsDistributeBusiServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(PurchasePlanDetailsDistributeBusiServiceImpl.class);
    private static final List<String> CHECK_EXECUTE_STATUS = Arrays.asList("3", "4");
    @Autowired
    private DistributePlanMapper distributePlanMapper;
    @Autowired
    private EnquiryGenerateIdUtil sequence;
    @Autowired
    private PebExtPlanItemUpdateAbilityService pebExtPlanItemUpdateAbilityService;
    @Autowired
    private PebExtPlanItemDetailQueryAbilityService pebExtPlanItemDetailQueryAbilityService;

    @Override
    public PurchasePlanItemUpdateDistributeRspBO updatePurchaseDistributePlanItem(PurchasePlanItemUpdateDistributeReqBO reqBO) {
        PurchasePlanItemUpdateDistributeRspBO rspBO = new PurchasePlanItemUpdateDistributeRspBO();
        this.validateParam(reqBO);
        Date createTime = new Date();
        ArrayList<String> notCheckPlanCodeList = new ArrayList<String>();
        ArrayList<DistributePlanPO> distributePlanPOList = new ArrayList<DistributePlanPO>();
        PebExtPlanItemSecondBargainingListQueryReqBO qryPebExtPlanItemBo = new PebExtPlanItemSecondBargainingListQueryReqBO();
        qryPebExtPlanItemBo.setPlanItemIdList(reqBO.getPlanItemIdList());
        PebExtPlanItemSecondBargainingListQueryRspBO planItemListQueryRspBO = this.pebExtPlanItemDetailQueryAbilityService.qryPlanItemListSecondBargainingQuery(qryPebExtPlanItemBo);
        List planItemBoList = planItemListQueryRspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)planItemBoList) || planItemBoList.size() != reqBO.getPlanItemIdList().size()) {
            throw new BusinessException("8888", "\u8ba1\u5212\u5206\u914d\u5931\u8d25\u66f4\u65b0\u5931\u8d25\uff1a\u5f85\u5339\u914d\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        for (PebExtPlanItemSecondBargainingBO planItemBO : planItemBoList) {
            if (CHECK_EXECUTE_STATUS.contains(planItemBO.getExecuteStatus())) continue;
            notCheckPlanCodeList.add(planItemBO.getJhmxbh());
        }
        if (!CollectionUtils.isEmpty(notCheckPlanCodeList)) {
            logger.error("\u8ba1\u5212\u5206\u914d\u5f02\u5e38:\u9700\u6c42\u660e\u7ec6" + ((Object)notCheckPlanCodeList).toString() + "\u4e0d\u5141\u8bb8\u8ba1\u5212\u5206\u914d");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba1\u5212\u5206\u914d\u5f02\u5e38:\u9700\u6c42\u660e\u7ec6" + ((Object)notCheckPlanCodeList).toString() + "\u72b6\u6001\u4e0d\u4e3a\u5f85\u5206\u914d\u6216\u5f85\u7b56\u5212,\u4e0d\u53ef\u4ee5\u8ba1\u5212\u5206\u914d");
            return rspBO;
        }
        for (PebExtPlanItemSecondBargainingBO purchasePlanDetailBO : planItemBoList) {
            DistributePlanPO distributePlanPO = new DistributePlanPO();
            BeanUtils.copyProperties((Object)purchasePlanDetailBO, (Object)distributePlanPO);
            distributePlanPO.setDistributePlanId(this.sequence.nextId());
            distributePlanPO.setPlanDetailId(purchasePlanDetailBO.getPlanItemId());
            distributePlanPO.setExecuteOrgIdHis(purchasePlanDetailBO.getExecuteOrgId());
            distributePlanPO.setExecuteOrgNameHis(purchasePlanDetailBO.getExecuteOrgName());
            distributePlanPO.setExecuteUserIdHis(purchasePlanDetailBO.getSchemeUserId());
            distributePlanPO.setExecuteUserNameHis(purchasePlanDetailBO.getSchemeUserName());
            distributePlanPO.setExecuteOrgId(reqBO.getExecuteOrgId());
            distributePlanPO.setExecuteOrgName(reqBO.getExecuteOrgName());
            distributePlanPO.setExecuteUserId(reqBO.getExecuteUserId());
            distributePlanPO.setExecuteUserName(reqBO.getExecuteUserName());
            distributePlanPO.setExecuteTime(createTime);
            distributePlanPO.setDistributeUserId(reqBO.getUserId().toString());
            distributePlanPO.setDistributeUserName(reqBO.getName());
            distributePlanPO.setDistributeOrgId(reqBO.getOrgIdIn());
            distributePlanPO.setDistributeOrgName(reqBO.getOrgName());
            distributePlanPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            distributePlanPOList.add(distributePlanPO);
        }
        try {
            this.distributePlanMapper.insertBatch(distributePlanPOList);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u5212\u5206\u914d\u5f02\u5e38,\u5339\u914d\u4fe1\u606f\u63d2\u5165\u5931\u8d25:" + e.getMessage());
            throw new BusinessException("8888", "\u8ba1\u5212\u5206\u914d\u5931\u8d25\uff1a\u5339\u914d\u4fe1\u606f\u63d2\u5165\u5931\u8d25");
        }
        DistributePlanPO updateRecord = new DistributePlanPO();
        updateRecord.setPlanDetailIdList(reqBO.getPlanItemIdList());
        updateRecord.setHistoryFlag(EnquiryConstant.HistoryFlag.HISTORY);
        updateRecord.setUpdateTime(createTime);
        updateRecord.setUpdateUserId(reqBO.getUserId().toString());
        updateRecord.setUpdateUserName(reqBO.getOrgName());
        this.distributePlanMapper.updateByPlanDetailIdList(updateRecord);
        PebExtPlanItemUpdateReqBO updatePlanItemReqBO = new PebExtPlanItemUpdateReqBO();
        updatePlanItemReqBO.setPlanItemIdList(reqBO.getPlanItemIdList());
        updatePlanItemReqBO.setExecuteStatus("3");
        updatePlanItemReqBO.setUpdateType(PebExtConstant.PlanExecuteUpdateType.DISTRIBUTE);
        updatePlanItemReqBO.setSchemeUserId(reqBO.getExecuteUserId());
        updatePlanItemReqBO.setSchemeUserName(reqBO.getExecuteUserName());
        PebExtPlanItemUpdateRspBO planItemUpdateRspBO = this.pebExtPlanItemUpdateAbilityService.dealPebExtPlanItemUpdate(updatePlanItemReqBO);
        if (!"0000".equals(planItemUpdateRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u6267\u884c\u5931\u8d25\u66f4\u65b0\u5931\u8d25\uff1a" + planItemUpdateRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public QueryPurchasePlanDistributeListRspBO queryPurchasePlanDistributeInList(QueryPurchasePlanDistributeListReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u8ba1\u5212\u5206\u914d\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPlanItemId() == null) {
            throw new BusinessException("7777", "\u8ba1\u5212\u5206\u914d\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u8ba1\u5212\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPurchasePlanDistributeListRspBO rspBO = new QueryPurchasePlanDistributeListRspBO();
        ArrayList<QueryPurchasePlanDistributeBO> rows = new ArrayList<QueryPurchasePlanDistributeBO>();
        rspBO.setRows(rows);
        DistributePlanPO record = new DistributePlanPO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        record.setPlanDetailId(reqBO.getPlanItemId());
        List<DistributePlanPO> distributePlanPOList = this.distributePlanMapper.getListPage((Page<DistributePlanPO>)page, record);
        for (DistributePlanPO distributePlanPO : distributePlanPOList) {
            QueryPurchasePlanDistributeBO queryPurchasePlanDistributeBO = new QueryPurchasePlanDistributeBO();
            BeanUtils.copyProperties((Object)distributePlanPO, (Object)queryPurchasePlanDistributeBO);
            queryPurchasePlanDistributeBO.setPlanItemId(distributePlanPO.getPlanDetailId());
            rows.add(queryPurchasePlanDistributeBO);
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParam(PurchasePlanItemUpdateDistributeReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u4e8c\u6b21\u8bae\u4ef7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPlanItemIdList() == null || reqBO.getPlanItemIdList().size() <= 0) {
            throw new BusinessException("7777", "\u4e8c\u6b21\u8bae\u4ef7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba1\u5212\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

