/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl.sequence;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.bo.CodeEnquiryReqBO;
import com.tydic.enquiry.api.bo.CodeEnquiryRspBO;
import com.tydic.enquiry.busi.api.sequence.SeqCodeCreateBusiService;
import com.tydic.enquiry.dao.PlanCodeMapper;
import com.tydic.enquiry.dao.SSystemParaMapper;
import com.tydic.enquiry.dao.po.PlanCodePO;
import com.tydic.enquiry.dao.po.SSystemParaPO;
import com.tydic.enquiry.dao.po.SSystemParaPOKey;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SeqCodeCreateBusiServiceImpl
implements SeqCodeCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(SeqCodeCreateBusiServiceImpl.class);
    public static final String PARA_TYPE_FIX_CODE = "FIX_CODE";
    @Autowired
    private SSystemParaMapper sSystemParaMapper;
    @Autowired
    private PlanCodeMapper planCodeMapper;

    @Override
    public CodeEnquiryRspBO createSeqCode(CodeEnquiryReqBO codeEnquiryReqBO) {
        log.info("\u5165\u53c2\u5bf9\u8c61\u4fe1\u606f\uff1acodeEnquiryReqBO=" + codeEnquiryReqBO.toString());
        String paraCode = codeEnquiryReqBO.getParaCode();
        if (StringUtils.isEmpty((Object)paraCode)) {
            paraCode = codeEnquiryReqBO.getDocumentType() + codeEnquiryReqBO.getBusiType() + codeEnquiryReqBO.getPurchaseCategory();
            if (codeEnquiryReqBO.getPurchaseMethod() != null) {
                paraCode = paraCode + codeEnquiryReqBO.getPurchaseMethod();
            }
        }
        SSystemParaPOKey sSystemParaPOKey = new SSystemParaPOKey();
        sSystemParaPOKey.setSystemId(codeEnquiryReqBO.getSystemId());
        sSystemParaPOKey.setParaType(PARA_TYPE_FIX_CODE);
        sSystemParaPOKey.setParaCode(paraCode);
        CodeEnquiryRspBO codeEnquiryRspBO = new CodeEnquiryRspBO();
        SSystemParaPO sSystemParaPO = this.sSystemParaMapper.selectByPrimaryKey(sSystemParaPOKey);
        if (sSystemParaPO == null) {
            codeEnquiryRspBO.setRespCode("8888");
            codeEnquiryRspBO.setRespDesc("\u914d\u7f6e\u53c2\u6570\u4e0d\u5b58\u5728");
            return codeEnquiryRspBO;
        }
        String fixCode = sSystemParaPO.getParaValue1();
        log.info("fixCode=" + fixCode);
        String dateStr = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd");
        log.info("dateStr=" + dateStr);
        PlanCodePO sPlanCodeQryPO = new PlanCodePO();
        sPlanCodeQryPO.setCompanyCode(codeEnquiryReqBO.getSystemId());
        sPlanCodeQryPO.setFixCode(fixCode);
        sPlanCodeQryPO.setDateCode("*");
        PlanCodePO sPlanCodePO = this.planCodeMapper.selectIdByKey(sPlanCodeQryPO);
        if (sPlanCodePO == null) {
            codeEnquiryRspBO.setRespCode("8888");
            codeEnquiryRspBO.setRespDesc("\u7f16\u53f7\u89c4\u5219\u4e0d\u5b58\u5728");
            return codeEnquiryRspBO;
        }
        String seqCode = sPlanCodePO.getId().toString();
        log.info("seqCode=" + seqCode);
        String docCode = fixCode + "-" + dateStr;
        for (int i = 0; i < 4 - seqCode.length(); ++i) {
            docCode = docCode + "0";
        }
        docCode = docCode + seqCode;
        log.info("docCode=" + docCode);
        PlanCodePO sPlanCodeUpPO = new PlanCodePO();
        sPlanCodeUpPO.setCompanyCode(sPlanCodePO.getCompanyCode());
        sPlanCodeUpPO.setFixCode(sPlanCodePO.getFixCode());
        sPlanCodeUpPO.setDateCode(sPlanCodePO.getDateCode());
        if (sPlanCodePO.getId() == 9999) {
            sPlanCodePO.setId(0);
        }
        sPlanCodeUpPO.setId(sPlanCodePO.getId() + 1);
        log.info("sPlanCodeUpPO.getId()=" + sPlanCodeUpPO.getId());
        int ret = this.planCodeMapper.updateByKey(sPlanCodeUpPO);
        log.info("ret=" + ret);
        codeEnquiryRspBO.setRespCode("0000");
        codeEnquiryRspBO.setRespDesc("\u6210\u529f");
        codeEnquiryRspBO.setDocCode(docCode);
        log.info("\u51fa\u53c2\u5bf9\u8c61\u4fe1\u606f\uff1acodeEnquiryRspBO=" + codeEnquiryRspBO.toString());
        return codeEnquiryRspBO;
    }
}

