/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.utils.http;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    private static PoolingHttpClientConnectionManager connManager;
    private static final String ENCODING = "UTF-8";
    private static final String RESULT = "-1";

    public static CloseableHttpClient getHttpClient(Integer timeOut) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).setSocketTimeout(timeOut.intValue()).build();
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).setRetryHandler(retryHandler).build();
        return httpClient;
    }

    private static SSLContext getSSLContext(boolean isDeceive, File creFile, String crePwd) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException {
        SSLContext sslContext = null;
        if (isDeceive) {
            sslContext = SSLContext.getInstance("SSLv3");
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        } else if (null != creFile && creFile.length() > 0L) {
            if (null != crePwd) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(new FileInputStream(creFile), crePwd.toCharArray());
                sslContext = SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            } else {
                throw new SSLHandshakeException("\u6574\u6570\u5bc6\u7801\u4e3a\u7a7a");
            }
        }
        return sslContext;
    }

    public static String httpPost(String url, Map<String, Object> headers, Map<String, Object> params, Integer timeOut, boolean isStream) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if (null != params) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpRequestUtils.covertParams2NVPS(params), ENCODING));
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpPost, timeOut, isStream);
    }

    public static String httpPost(String url, Map<String, Object> params, Integer timeOut) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (null != params) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpRequestUtils.covertParams2NVPS(params), ENCODING));
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpPost, timeOut, false);
    }

    public static String httpPost(String url, String params, Integer timeOut, boolean isStream) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (null != params) {
            httpPost.setEntity((HttpEntity)new StringEntity(params));
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpPost, timeOut, isStream);
    }

    public static String httpPost(String url, JSONObject headers, JSONObject params, Integer timeOut, boolean isStream) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            for (Map.Entry entry : headers.entrySet()) {
                httpPost.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        if (null != params) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpRequestUtils.covertParams2NVPS((Map<String, Object>)params), ENCODING));
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpPost, timeOut, isStream);
    }

    public static String httpPost(String url, JSONObject params, Integer timeOut) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (null != params) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpRequestUtils.covertParams2NVPS((Map<String, Object>)params), ENCODING));
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpPost, timeOut, false);
    }

    public static String httpGet(String url, Map<String, Object> headers, Map<String, Object> params, Integer timeOut, boolean isStream) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (null != params) {
            uriBuilder.setParameters(HttpRequestUtils.covertParams2NVPS(params));
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        if (null != headers) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpGet, timeOut, isStream);
    }

    public static String httpGet(String url, Map<String, Object> params, Integer timeOut) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (null != params) {
            uriBuilder.setParameters(HttpRequestUtils.covertParams2NVPS(params));
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        return HttpRequestUtils.getResult((HttpRequestBase)httpGet, timeOut, false);
    }

    public static String httpGet(String url, JSONObject headers, JSONObject params, Integer timeOut, boolean isStream) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (null != params) {
            uriBuilder.setParameters(HttpRequestUtils.covertParams2NVPS((Map<String, Object>)params));
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        if (null != headers) {
            for (Map.Entry entry : headers.entrySet()) {
                httpGet.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return HttpRequestUtils.getResult((HttpRequestBase)httpGet, timeOut, isStream);
    }

    public static String httpGet(String url, JSONObject params, Integer timeOut) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (null != params) {
            uriBuilder.setParameters(HttpRequestUtils.covertParams2NVPS((Map<String, Object>)params));
        }
        HttpGet httpGet = new HttpGet(url);
        return HttpRequestUtils.getResult((HttpRequestBase)httpGet, timeOut, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResult(HttpRequestBase httpRequest, Integer timeOut, boolean isStream) {
        StringBuilder sb = null;
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpRequestUtils.getHttpClient(timeOut);
            response = httpClient.execute((HttpUriRequest)httpRequest);
            int respCode = response.getStatusLine().getStatusCode();
            if (302 == respCode) {
                String locationUrl = response.getLastHeader("Location").getValue();
                String string = HttpRequestUtils.getResult((HttpRequestBase)new HttpPost(locationUrl), timeOut, isStream);
                return string;
            }
            if (200 == respCode) {
                HttpEntity entity = response.getEntity();
                sb = new StringBuilder();
                if (isStream) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(entity.getContent(), ENCODING));
                    String len = "";
                    while ((len = br.readLine()) != null) {
                        sb.append(len);
                    }
                } else {
                    sb.append(EntityUtils.toString((HttpEntity)entity, (String)ENCODING));
                    if (sb.length() < 1) {
                        sb.append(RESULT);
                    }
                }
            }
        }
        catch (ConnectionPoolTimeoutException e) {
            System.err.println("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6\u8fde\u63a5\u8d85\u65f6!!!");
            e.printStackTrace();
        }
        catch (SocketTimeoutException e) {
            System.err.println("\u54cd\u5e94\u8d85\u65f6");
            e.printStackTrace();
        }
        catch (ConnectTimeoutException e) {
            System.err.println("\u8bf7\u6c42\u8d85\u65f6");
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            System.err.println("http\u534f\u8bae\u9519\u8bef");
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801");
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            System.err.println("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u64cd\u4f5c");
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.err.println("\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IO\u9519\u8bef");
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    System.err.println("\u5173\u95ed\u54cd\u5e94\u8fde\u63a5\u51fa\u9519");
                    e.printStackTrace();
                }
            }
        }
        return sb == null ? RESULT : ("".equals(sb.toString().trim()) ? RESULT : sb.toString());
    }

    public static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        LinkedList<NameValuePair> paramList = new LinkedList<NameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        return paramList;
    }

    static {
        if (connManager == null) {
            try {
                SSLContext sslContext = HttpRequestUtils.getSSLContext(true, null, null);
                Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
                connManager = new PoolingHttpClientConnectionManager(registry);
                connManager.setMaxTotal(1000);
                connManager.setDefaultMaxPerRoute(20);
            }
            catch (SSLInitializationException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

