/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.constant;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.enquiry.api.bo.AuthorityInfo;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteBillBo;
import com.tydic.enquiry.common.EnquiryReqBO;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemSecondBargainingBO;
import com.tydic.order.extend.constant.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EnquiryCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(EnquiryCommonUtil.class);

    public static String valNull(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static List<String> getUserType(EnquiryReqBO reqBO, Set<AuthorityInfo> authorityInfoSet) {
        HashSet<String> roleSet = new HashSet<String>();
        for (AuthorityInfo authorityInfo : authorityInfoSet) {
            roleSet.add(authorityInfo.getKey());
        }
        ArrayList<String> userTypeList = new ArrayList<String>();
        if (roleSet.size() == 0) {
            log.error("\u5f53\u524d\u7528\u6237\u3010" + reqBO.getName() + "\u3011\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u5ba1\u6279\u89d2\u8272");
        } else {
            if (roleSet.contains("003")) {
                userTypeList.add("1");
            }
            if (roleSet.contains("overall:yunyingdanweiercijingjiashenhegang")) {
                userTypeList.add("2");
            }
            if (roleSet.contains("002")) {
                userTypeList.add("3");
            }
            if (roleSet.contains("004")) {
                userTypeList.add("4");
            }
        }
        return userTypeList;
    }

    public static int getEndFlag(ExecuteBillPO executeBillPO) {
        Date date = new Date();
        Date endTime = executeBillPO.getQuoteEndTime();
        Date endExtendTime = executeBillPO.getQuoteEndExtendTime();
        int c1 = 0;
        int endFlag = 0;
        if (endTime != null) {
            int c0;
            c1 = DateUtil.compare((Date)date, (Date)endTime);
            if (endExtendTime != null && (c0 = DateUtil.compare((Date)endExtendTime, (Date)endTime)) > 0) {
                c1 = DateUtil.compare((Date)date, (Date)endExtendTime);
            }
        }
        if (c1 > 0) {
            endFlag = 1;
        }
        return endFlag;
    }

    public static void transItemName(EnquiryExecuteItemBO executeItemBO) {
        if (executeItemBO.getWxfl() != null) {
            executeItemBO.setWxflName(executeItemBO.getWxfl() + "_" + executeItemBO.getWxflStr());
        }
        if (executeItemBO.getWlbh() != null) {
            executeItemBO.setWlbhName(executeItemBO.getWlbh() + "_" + executeItemBO.getWlbhStr());
        }
        if (executeItemBO.getDsfjczm() != null) {
            executeItemBO.setDsfjczmName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemBO.getDsfjczm().intValue()));
        }
        if (executeItemBO.getPtfw() != null) {
            executeItemBO.setPtfwName(PebExtConstant.YesOrNot.getDesc((Integer)executeItemBO.getPtfw().intValue()));
        }
        executeItemBO.setBzfsName(EnquiryCommonUtil.getBzfsName(executeItemBO.getBzfs()));
        if (!StringUtils.isEmpty((Object)executeItemBO.getJhmc()) && !StringUtils.isEmpty((Object)executeItemBO.getZxlsjhbh())) {
            executeItemBO.setPlanDescribe(executeItemBO.getZxlsjhbh() + "-" + executeItemBO.getJhmc());
        }
        if (executeItemBO.getPromiseDeliveryDays() != null) {
            executeItemBO.setPromiseDeliveryDaysName("\u8ba2\u5355\u751f\u6548\u540e" + executeItemBO.getPromiseDeliveryDays() + "\u5929");
        }
    }

    public static String getBzfsName(String bzfsStr) {
        String bzfsName = "";
        if (JSONArray.isValidArray((String)bzfsStr)) {
            List bzfsList = JSONObject.parseArray((String)bzfsStr, Integer.class);
            for (Integer bzfs : bzfsList) {
                bzfsName = bzfsName + PebExtConstant.PlanPackTypeEnum.getPackTypeEnumDesc((int)bzfs) + ";";
            }
        }
        return bzfsName;
    }

    public static void transExecuteBillBO(PurchaseExecuteBillBo executeBillBO) {
        if (executeBillBO.getExecuteType() != null) {
            executeBillBO.setExecuteTypeName(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)executeBillBO.getExecuteType()));
        }
        if (executeBillBO.getExecuteStatus() != null) {
            executeBillBO.setExecuteStatusName(EnquiryEnumConstant.ExecuteStatusEnum.getDesc((String)executeBillBO.getExecuteStatus()));
        }
        if (executeBillBO.getConfirmDealType() != null) {
            executeBillBO.setConfirmDealTypeName(EnquiryEnumConstant.ConfirmDealTypeEnum.getDesc((String)executeBillBO.getConfirmDealType()));
        }
        if (executeBillBO.getPublishBudgetFlag() != null) {
            executeBillBO.setPublishBudgetFlagName(EnquiryEnumConstant.YesOrNotEnum.getDesc((String)executeBillBO.getPublishBudgetFlag().toString()));
        }
        if (executeBillBO.getBondFlag() != null) {
            executeBillBO.setBondFlagName(EnquiryEnumConstant.YesOrNotEnum.getDesc((String)executeBillBO.getBondFlag().toString()));
        }
        if (executeBillBO.getTimeDelayFlag() != null) {
            executeBillBO.setTimeDelayFlagName(EnquiryEnumConstant.YesOrNotEnum.getDesc((String)executeBillBO.getTimeDelayFlag().toString()));
        }
        if (executeBillBO.getNeedFirstQuoteFlag() != null) {
            executeBillBO.setNeedFirstQuoteFlagName(EnquiryEnumConstant.NeedFirstQuoteFlagEnum.getDesc((String)executeBillBO.getNeedFirstQuoteFlag().toString()));
        }
        if (executeBillBO.getBiddingDecreaseMethod() != null) {
            executeBillBO.setBiddingDecreaseMethodName(EnquiryEnumConstant.BiddingDecreaseMethodEnum.getDesc((Integer)executeBillBO.getBiddingDecreaseMethod()));
        }
        if (executeBillBO.getBiddingDecreaseType() != null) {
            executeBillBO.setBiddingDecreaseTypeName(EnquiryEnumConstant.BiddingDecreaseTypeEnum.getDesc((Integer)executeBillBO.getBiddingDecreaseType()));
        }
    }

    public static int getExceptFlag(BigDecimal start, BigDecimal end, BigDecimal quoteMoney) {
        if (start.compareTo(quoteMoney) > 0) {
            return 1;
        }
        if (quoteMoney.compareTo(end) > 0) {
            return 1;
        }
        return 0;
    }

    public static String getProductStatus(String skuStatus) {
        String proStatus = "";
        if ("15".equals(skuStatus) || "4".equals(skuStatus)) {
            proStatus = EnquiryConstant.MatchProductStatus.WAITING_SUBMIT.toString();
        } else if ("1".equals(skuStatus)) {
            proStatus = EnquiryConstant.MatchProductStatus.WAITING_APPROVAL.toString();
        } else if ("2".equals(skuStatus)) {
            proStatus = EnquiryConstant.MatchProductStatus.WAITING_PUTSHELF.toString();
        } else if ("3".equals(skuStatus)) {
            proStatus = EnquiryConstant.MatchProductStatus.PUTSHELF.toString();
        }
        return proStatus;
    }

    public static String getConfirmDealTypeTip(String confirmDealType) {
        String msg = "\u5206\u9879\u786e\u8ba4\uff1a\u786e\u5b9a\u6210\u4ea4\u7ed3\u679c\u6309\u8ba1\u5212\u62c6\u5206\u5ba1\u6838\uff0c\u88ab\u5ba1\u6838\u9a73\u56de\u3001\u4f9b\u5e94\u5546\u62d2\u7edd\u540e\u53ef\u9488\u5bf9\u9a73\u56de\u90e8\u5206\u91cd\u65b0\u786e\u8ba4\u6210\u4ea4\u4f9b\u5e94\u5546\uff1b";
        if ("2".equals(confirmDealType)) {
            msg = "\u6574\u5355\u786e\u8ba4\u5206\u9879\u6210\u4ea4\uff1a\u786e\u5b9a\u6210\u4ea4\u7ed3\u679c\u6309\u8ba1\u5212\u62c6\u5206\u5ba1\u6838\u88ab\u5ba1\u6838\u9a73\u56de\u3001\u4f9b\u5e94\u5546\u62d2\u7edd\u540e\u7684\u90e8\u5206\u4e0d\u53ef\u91cd\u65b0\u786e\u8ba4\u6210\u4ea4\u4f9b\u5e94\u5546";
        } else if ("3".equals(confirmDealType)) {
            msg = "\u6574\u5355\u786e\u8ba4\u6574\u5355\u6210\u4ea4\uff1a\u786e\u5b9a\u6210\u4ea4\u7ed3\u679c\u5ba1\u6838\u9700\u7531\u6267\u884c\u5355\u4e2d\u8ba1\u5212\u6d89\u53ca\u5230\u7684\u5ba1\u6838\u4eba\u5458\u5171\u540c\u5ba1\u6838\uff0c\u88ab\u5ba1\u6838\u9a73\u56de\u3001\u4f9b\u5e94\u5546\u62d2\u7edd\u540e\u7684\u53ef\u6574\u5355\u91cd\u65b0\u786e\u8ba4\u6210\u4ea4\u4f9b\u5e94\u5546";
        }
        return "\u63d0\u793a\uff1a" + msg;
    }

    public static Set<Long> transArrStrToSet(String arrStr) {
        HashSet contractIdSet = new HashSet();
        if (StrUtil.isNotBlank((CharSequence)arrStr) && JSON.isValidArray((String)arrStr)) {
            contractIdSet = CollUtil.newHashSet((Collection)JSONObject.parseArray((String)arrStr, Long.class));
        }
        return contractIdSet;
    }

    public static String getProjectCodeAndName(PebExtPlanItemSecondBargainingBO planItemBO) {
        String projectCodeAndName = "";
        if (planItemBO.getProjectCode() != null) {
            projectCodeAndName = planItemBO.getProjectCode();
        }
        if (planItemBO.getProjectName() != null) {
            projectCodeAndName = projectCodeAndName + "-" + planItemBO.getProjectName();
        }
        return projectCodeAndName;
    }
}

