/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.utils;

import com.tydic.enquiry.annotation.ImportField;
import com.tydic.enquiry.utils.ExcelUtils;
import com.tydic.enquiry.utils.HttpUtil;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class BatchImportUtils<T> {
    private static final Logger log = LoggerFactory.getLogger(BatchImportUtils.class);
    public static final String IMP_RESULT_STR = "impResult";
    public static final String IMP_REMARK_STR = "impRemark";
    public static final String EXCEPTION_ERROR_CODE = "8888";
    public static final String REQUIRED_ERROR_CODE = "0001";
    public static final String FORMAT_ERROR_CODE = "0002";
    public static final String VALUE_ERROR_CODE = "0003";
    public static final String SUCCESS = "0";
    public static final String FAILED = "1";
    private Class<T> tClass;
    private List<String> title;
    private List<List<String>> data;
    private List<Map<String, Object>> importDataMaps;

    public List<Map<String, Object>> getImportDataMaps() {
        return this.importDataMaps;
    }

    public List<String> getTitle() {
        return this.title;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public BatchImportUtils(List<String> title, List<List<String>> data, Class<T> tClass) {
        this.title = title;
        this.data = data;
        this.tClass = tClass;
        this.importDataMaps = new ArrayList<Map<String, Object>>();
    }

    public void processExcelData() {
        HashMap<Integer, String> dateMapIndex = new HashMap<Integer, String>();
        Field[] fields = this.tClass.getDeclaredFields();
        block2: for (Field field : fields) {
            ImportField annotation;
            if (field.getName().equals("serialVersionUID") || (annotation = field.getAnnotation(ImportField.class)) == null) continue;
            int index = annotation.index();
            String mapping = annotation.mapping();
            if (index != 0) {
                dateMapIndex.put(index, field.getName());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)mapping)) continue;
            for (int i = 0; i < this.title.size(); ++i) {
                if (!this.title.get(i).equals(mapping.trim()) && !this.title.get(i).equals(mapping)) continue;
                dateMapIndex.put(i, field.getName());
                continue block2;
            }
        }
        if (dateMapIndex.size() == 0) {
            return;
        }
        for (List list : this.data) {
            HashMap dataMap = new HashMap();
            log.info("\u5bfc\u5165\u6570\u636e\u4e3asheet:" + list);
            log.info("\u5bfc\u5165\u6570\u636e\u4e3adateMapIndex:" + dateMapIndex);
            dataMap.put(IMP_RESULT_STR, SUCCESS);
            for (int i = 0; i < list.size(); ++i) {
                boolean errMsgFlag = false;
                String errCode = "";
                String content = (String)list.get(i);
                try {
                    Field field;
                    ImportField annotation;
                    if (dateMapIndex.get(i) == null) continue;
                    if ("null".equals(content)) {
                        content = "";
                    }
                    if ((annotation = (field = this.tClass.getDeclaredField((String)dateMapIndex.get(i))).getAnnotation(ImportField.class)) != null) {
                        Pattern pattern;
                        if (annotation.isMustFill() && (StringUtils.isEmpty((CharSequence)content) || "null".equals(content))) {
                            errMsgFlag = true;
                            errCode = annotation.mapping() + "_" + REQUIRED_ERROR_CODE;
                        }
                        if (!(StringUtils.isEmpty((CharSequence)content) || "null".equals(content) || StringUtils.isBlank((CharSequence)annotation.reg()) || (pattern = Pattern.compile(annotation.reg())).matcher(content).matches())) {
                            errMsgFlag = true;
                            errCode = annotation.mapping() + "_" + FORMAT_ERROR_CODE;
                        }
                        if (annotation.valueMap().length > 0 && !annotation.valueMap()[0].equals("") && !Arrays.toString(annotation.valueMap()).contains(content)) {
                            errMsgFlag = true;
                            errCode = annotation.mapping() + "_" + VALUE_ERROR_CODE;
                        }
                        field.setAccessible(true);
                        dataMap.put(dateMapIndex.get(i), content);
                    }
                    if (!errMsgFlag) continue;
                    String errCodeStr = (String)dataMap.get(IMP_REMARK_STR);
                    dataMap.put(dateMapIndex.get(i), content);
                    dataMap.put(IMP_RESULT_STR, FAILED);
                    String[] tips = errCode.split("_");
                    if (tips[1].equals(REQUIRED_ERROR_CODE)) {
                        dataMap.put(IMP_REMARK_STR, !StringUtils.isEmpty((CharSequence)errCodeStr) ? errCodeStr + ";" + tips[0] + "\u5fc5\u586b" : tips[0] + "\u5fc5\u586b");
                        continue;
                    }
                    if (tips[1].equals(FORMAT_ERROR_CODE)) {
                        dataMap.put(IMP_REMARK_STR, !StringUtils.isEmpty((CharSequence)errCodeStr) ? errCodeStr + ";" + tips[0] + "\u683c\u5f0f\u9519\u8bef" : tips[0] + "\u683c\u5f0f\u9519\u8bef");
                        continue;
                    }
                    if (tips[1].equals(VALUE_ERROR_CODE)) {
                        dataMap.put(IMP_REMARK_STR, !StringUtils.isEmpty((CharSequence)errCodeStr) ? errCodeStr + ";" + tips[0] + "\u53d6\u503c\u9519\u8bef" : tips[0] + "\u53d6\u503c\u9519\u8bef");
                        continue;
                    }
                    dataMap.put(IMP_REMARK_STR, !StringUtils.isEmpty((CharSequence)errCodeStr) ? errCodeStr + ";" + VALUE_ERROR_CODE : VALUE_ERROR_CODE);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dataMap.put(dateMapIndex.get(i), content);
                    dataMap.put(IMP_RESULT_STR, FAILED);
                    dataMap.put(IMP_REMARK_STR, "8888:" + e.toString());
                }
            }
            log.info("\u5bfc\u5165\u884c\u6570\u636e\u4e3a:" + dataMap);
            this.importDataMaps.add(dataMap);
        }
    }

    private void setFieldValueType(Class declaringClass, Field field, Object obj, String content, ImportField annotation) throws Exception {
        if (declaringClass.equals(Long.class)) {
            field.set(obj, Long.valueOf(content));
        } else if (declaringClass.equals(String.class)) {
            field.set(obj, String.valueOf(content));
        } else if (declaringClass.equals(Integer.class)) {
            field.set(obj, Integer.valueOf(content));
        } else if (declaringClass.equals(Byte.class)) {
            field.set(obj, Byte.valueOf(content));
        } else if (declaringClass.equals(Double.class)) {
            field.set(obj, Double.valueOf(content));
        } else if (declaringClass.equals(Date.class)) {
            SimpleDateFormat simpleDateFormatter = new SimpleDateFormat(annotation.format());
            field.set(obj, simpleDateFormatter.parse(content));
        } else if (declaringClass.equals(BigDecimal.class)) {
            field.set(obj, new BigDecimal(content));
        } else {
            field.set(obj, null);
        }
    }

    private void setMethodValue(Method[] methods, String objName, Object objValue) {
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.equals("set" + objName.substring(0, 1).toUpperCase() + objName.substring(1))) continue;
            try {
                method.invoke(objValue, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void batchImport(String url, int titleRow, int dataRow, int maxSize) {
        if (this.data == null || this.title == null) {
            return;
        }
        try {
            String fileName = "content_" + UUID.randomUUID().toString() + ".xlsx";
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + fileName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(url, file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            BatchImportUtils.getExcelDateByImport((MultipartFile)multipartFile, this.data, this.title, titleRow, dataRow);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(this.title)) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(this.data)) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (maxSize != -1 && this.data.size() > maxSize) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u5185\u5bb9\u6700\u591a" + maxSize + "\u884c\u6570\u636e\uff01");
        }
        this.processExcelData();
    }

    private static void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, int titleRow, int dataRow) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < titleRow) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == titleRow) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < dataRow) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    if (str.endsWith(".0")) {
                        str = str.substring(0, str.length() - 2);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, e.getMessage());
        }
    }
}

