/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.utils;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.enquiry.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ExportUtils {
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${preFilePath}")
    private String preFilePath;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    public static final String OSS = "OSS";
    public static final String FASTDFS = "FASTDFS";

    public String uploadFile(List<Map<String, Object>> data, String name) {
        String string;
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, name);
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String result = "";
        String uploadPath = "enquiry";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            out.flush();
            String fullFilePath = "";
            if (OSS.equals(this.fileType)) {
                fullFilePath = this.preFilePath + result;
            } else if (FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            }
            string = fullFilePath;
        }
        catch (IOException e) {
            try {
                throw new BusinessException("22051", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
        return string;
    }
}

