/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.utils;

import cn.hutool.core.collection.CollUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkdayUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkdayUtils.class);
    public static final int LEGAL_WORKDAY = 1;
    public static final int LEGAL_HOLIDAY = 2;
    public static final int WORKDAY = 3;
    public static final int HOLIDAY = 4;
    private String datePattern = "yyyy-MM-dd";
    private List<String> legalWorkdayList;
    private List<String> legalHolidayList;

    public WorkdayUtils() {
    }

    public WorkdayUtils(List<String> legalWorkdayList, List<String> legalHolidayList) {
        this.legalWorkdayList = legalWorkdayList;
        this.legalHolidayList = legalHolidayList;
    }

    public WorkdayUtils(List<String> legalWorkdayList, List<String> legalHolidayList, String datePattern) {
        this.legalWorkdayList = legalWorkdayList;
        this.legalHolidayList = legalHolidayList;
        this.datePattern = datePattern;
    }

    public void setLegalWorkdayList(List<String> legalWorkdayList) {
        this.legalWorkdayList = legalWorkdayList;
    }

    public void setLegalHolidayList(List<String> legalHolidayList) {
        this.legalHolidayList = legalHolidayList;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        if (StringUtils.isNotBlank((String)datePattern)) {
            this.datePattern = datePattern;
        }
    }

    public Date getWorkday(Date date, int amount) {
        int i;
        this.assertNotNull(date);
        Date workday = date;
        if (amount > 0) {
            for (i = 0; i < amount; ++i) {
                workday = this.getNextWorkday(workday);
            }
        }
        if (amount < 0) {
            for (i = amount; i < 0; ++i) {
                workday = this.getPrevWorkday(workday);
            }
        }
        return workday;
    }

    public int getWorkdayCount(Date startDate, Date endDate) {
        this.assertNotNull(startDate);
        this.assertNotNull(endDate);
        int count = 0;
        if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
            if (this.isWorkday(startDate)) {
                count = 1;
            }
            return count;
        }
        if (endDate.before(startDate)) {
            throw new IllegalArgumentException("The endDate must be greater than startDate");
        }
        Date day = startDate;
        while (!DateUtils.isSameDay((Date)day, (Date)endDate)) {
            if (!this.isWorkday(day = DateUtils.addDays((Date)day, (int)1))) continue;
            ++count;
        }
        return count;
    }

    public Date getNextWorkday(Date date) {
        return this.getNeighbourWorkday(date, 1);
    }

    public Date getPrevWorkday(Date date) {
        return this.getNeighbourWorkday(date, -1);
    }

    public int getDayType(Date date) {
        this.assertNotNull(date);
        String dateStr = DateFormatUtils.format((Date)date, (String)this.datePattern);
        if (this.legalWorkdayList != null && !this.legalWorkdayList.isEmpty() && this.legalWorkdayList.contains(dateStr)) {
            return 1;
        }
        if (this.legalHolidayList != null && !this.legalHolidayList.isEmpty() && this.legalHolidayList.contains(dateStr)) {
            return 2;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(7);
        if (2 <= day && day <= 6) {
            return 3;
        }
        return 4;
    }

    public boolean isWorkday(Date date) {
        int dayType = this.getDayType(date);
        return dayType == 1 || dayType == 3;
    }

    private void assertNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("The date must not be null!");
        }
    }

    private Date getNeighbourWorkday(Date date, int neighbour) {
        this.assertNotNull(date);
        Date nextWorkday = date;
        while (!this.isWorkday(nextWorkday = DateUtils.addDays((Date)nextWorkday, (int)neighbour))) {
        }
        return nextWorkday;
    }

    public static void main(String[] args) throws ParseException {
        WorkdayUtils workdayUtils = new WorkdayUtils();
        ArrayList legalHolidayList = CollUtil.newArrayList((Object[])new String[]{"2025-03-22", "2025-03-23"});
        workdayUtils.setLegalHolidayList(legalHolidayList);
        Date date = workdayUtils.getWorkday(new Date(), 1);
        System.out.println(date);
    }
}

