/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeDeatilRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticePageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeQueryReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeRspBO;
import com.tydic.enquiry.api.bo.EnquiryQuateTotalBO;
import com.tydic.enquiry.busi.api.EnquiryDealNoticeBusiService;
import com.tydic.enquiry.busi.api.bo.DealNoticeBusiBO;
import com.tydic.enquiry.busi.api.bo.DealNoticeBusiReqBO;
import com.tydic.enquiry.busi.api.bo.DealQuateTotalBusiBO;
import com.tydic.enquiry.busi.utils.BigDecimalUtils;
import com.tydic.enquiry.dao.DealConfirmItemMapper;
import com.tydic.enquiry.dao.DealNoticeItemMapper;
import com.tydic.enquiry.dao.DealNoticeMapper;
import com.tydic.enquiry.dao.po.DealConfirmItemPO;
import com.tydic.enquiry.dao.po.DealNoticeItemPO;
import com.tydic.enquiry.dao.po.DealNoticePO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.uac.util.GenerateIdUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryDealNoticeBusiServiceImpl
implements EnquiryDealNoticeBusiService {
    @Autowired
    DealConfirmItemMapper dealConfirmItemMapper;
    @Autowired
    DealNoticeMapper dealNoticeMapper;
    @Autowired
    DealNoticeItemMapper dealNoticeItemMapper;
    @Autowired
    private GenerateIdUtil idUtil;

    @Override
    public EnquiryDealNoticeRspBO saveDealNotice(EnquiryDealNoticeReqBO reqBO) {
        List confirmItemIdList = reqBO.getConfirmItemIdList();
        if (CollUtil.isEmpty((Collection)confirmItemIdList)) {
            throw new BusinessException("8888", "\u6210\u4ea4\u786e\u8ba4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DealConfirmItemPO itemPO = new DealConfirmItemPO();
        itemPO.setItemIdList(confirmItemIdList);
        List<DealNoticeBusiBO> confirmItemPOList = this.dealConfirmItemMapper.selectItemBy(itemPO);
        if (CollUtil.isEmpty(confirmItemPOList)) {
            throw new BusinessException("8888", "\u6210\u4ea4\u786e\u8ba4\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        Map<Long, List<DealNoticeBusiBO>> confirmItemMap = confirmItemPOList.stream().sorted(Comparator.comparing(DealNoticePO::getQuotedEffectiveTime)).collect(Collectors.groupingBy(DealNoticePO::getSupplierId));
        for (Map.Entry<Long, List<DealNoticeBusiBO>> entry : confirmItemMap.entrySet()) {
            List<DealNoticeBusiBO> groupList = entry.getValue();
            Long noticeId = this.idUtil.nextId();
            BigDecimal sum = BigDecimal.ZERO;
            for (DealNoticeBusiBO dealConfirmItemPO : groupList) {
                DealNoticeItemPO dealNoticeItemPO = new DealNoticeItemPO();
                BeanUtil.copyProperties((Object)dealConfirmItemPO, (Object)dealNoticeItemPO);
                dealNoticeItemPO.setDealNoticeItemId(this.idUtil.nextId());
                dealNoticeItemPO.setDealNoticeId(noticeId);
                sum = sum.add(BigDecimalUtils.ifNullSet0(dealNoticeItemPO.getDealMoney()));
                this.dealNoticeItemMapper.insert(dealNoticeItemPO);
            }
            DealNoticePO dealNoticePO = new DealNoticePO();
            BeanUtil.copyProperties((Object)CollUtil.getFirst(groupList), (Object)dealNoticePO);
            dealNoticePO.setDealNoticeCode("no" + noticeId);
            dealNoticePO.setDealNoticeName("\u901a\u77e5" + noticeId);
            dealNoticePO.setDealNoticeId(noticeId);
            dealNoticePO.setDealMoney(sum);
            dealNoticePO.setDealBillStatus("1");
            this.dealNoticeMapper.insert(dealNoticePO);
        }
        EnquiryDealNoticeRspBO rspBO = new EnquiryDealNoticeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fdd\u5b58\u6210\u4ea4\u786e\u8ba4\u901a\u77e5\u6210\u529f");
        return rspBO;
    }

    @Override
    public EnquiryDealNoticePageRspBO queryNoticeList(EnquiryDealNoticeQueryReqBO reqBO) {
        DealNoticeBusiReqBO dealNoticeBusiReqBO = new DealNoticeBusiReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)dealNoticeBusiReqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setLimit(reqBO.getPageSize().intValue());
        List<DealNoticePO> noticePOList = this.dealNoticeMapper.selectByCondtion(dealNoticeBusiReqBO, (Page<DealNoticePO>)page);
        EnquiryDealNoticePageRspBO busiRspBO = new EnquiryDealNoticePageRspBO();
        if (CollectionUtils.isEmpty(noticePOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<EnquiryDealNoticeBO> rows = new ArrayList<EnquiryDealNoticeBO>();
        for (DealNoticePO dealNoticePO : noticePOList) {
            EnquiryDealNoticeBO noticeBO = new EnquiryDealNoticeBO();
            BeanUtil.copyProperties((Object)dealNoticePO, (Object)noticeBO);
            noticeBO.setExecuteTypeStr(noticeBO.getExecuteType());
            rows.add(noticeBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u901a\u77e5\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryDealNoticeDeatilRspBO queryNoticeDetail(EnquiryDealNoticeQueryReqBO reqBO) {
        Long noticeId = reqBO.getDealNoticeId();
        DealNoticeBusiReqBO dealNoticeBusiReqBO = new DealNoticeBusiReqBO();
        dealNoticeBusiReqBO.setDealNoticeId(noticeId);
        DealNoticePO noticePO = this.dealNoticeMapper.selectByCondtion(dealNoticeBusiReqBO);
        EnquiryDealNoticeDeatilRspBO busiRspBO = new EnquiryDealNoticeDeatilRspBO();
        if (noticePO == null) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        BeanUtil.copyProperties((Object)noticePO, (Object)busiRspBO);
        DealQuateTotalBusiBO totalBusiBO = this.dealNoticeMapper.selectTotalBy(dealNoticeBusiReqBO);
        EnquiryQuateTotalBO totalBO = new EnquiryQuateTotalBO();
        BeanUtil.copyProperties((Object)noticePO, (Object)totalBO);
        BeanUtil.copyProperties((Object)totalBusiBO, (Object)totalBO);
        ArrayList totalList = CollUtil.newArrayList((Object[])new EnquiryQuateTotalBO[]{totalBO});
        busiRspBO.setQuoteTotalList((List)totalList);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u901a\u77e5\u660e\u7ec6\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }
}

