/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyInfoBO;
import com.tydic.enquiry.api.bo.EnquiryClarifyLaunchTypeTotalBO;
import com.tydic.enquiry.api.bo.EnquiryQryClarifyListByPageReqBO;
import com.tydic.enquiry.api.bo.EnquiryQryClarifyListByPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryRepliedClarifyInfoBO;
import com.tydic.enquiry.busi.api.EnquiryQryClarifyListByPageBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.BillFileInfoMapper;
import com.tydic.enquiry.dao.ClarifyInfoMapper;
import com.tydic.enquiry.dao.EnquiryDicDictionaryMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.BillFileInfoPO;
import com.tydic.enquiry.dao.po.ClarifyInfoPO;
import com.tydic.enquiry.dao.po.DicDictionaryPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryQryClarifyListByPageBusiServiceImpl
implements EnquiryQryClarifyListByPageBusiService {
    @Autowired
    private ClarifyInfoMapper clarifyInfoMapper;
    @Autowired
    private BillFileInfoMapper billFileInfoMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;
    @Autowired
    private EnquiryDicDictionaryMapper dicDictionaryMapper;

    @Override
    public EnquiryQryClarifyListByPageRspBO qryClarifyListByPage(EnquiryQryClarifyListByPageReqBO reqBO) {
        EnquiryQryClarifyListByPageRspBO rspBO = new EnquiryQryClarifyListByPageRspBO();
        ArrayList<EnquiryRepliedClarifyInfoBO> repliedClarifyInfoBOList = new ArrayList<EnquiryRepliedClarifyInfoBO>();
        ArrayList<ClarifyInfoPO> waitReplyList = new ArrayList<ClarifyInfoPO>();
        ClarifyInfoPO record = new ClarifyInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        List<ClarifyInfoPO> clarifyInfoPOS = this.clarifyInfoMapper.qryClarifyInfoList(record);
        if (!CollectionUtils.isEmpty(clarifyInfoPOS)) {
            for (ClarifyInfoPO po : clarifyInfoPOS) {
                if (EnquiryConstant.clarifyStatus.REPLIED.equals(po.getClarifyType())) {
                    EnquiryClarifyInfoBO waitReplyBO = (EnquiryClarifyInfoBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)po), EnquiryClarifyInfoBO.class);
                    this.buildAnnex(waitReplyBO);
                    ClarifyInfoPO infoPO = this.clarifyInfoMapper.qryClarifyInfoByReply(po.getClarifyId());
                    EnquiryClarifyInfoBO childInfoBO = new EnquiryClarifyInfoBO();
                    BeanUtils.copyProperties((Object)infoPO, (Object)childInfoBO);
                    this.buildAnnex(childInfoBO);
                    EnquiryRepliedClarifyInfoBO repliedClarifyInfoBO = new EnquiryRepliedClarifyInfoBO();
                    BeanUtils.copyProperties((Object)waitReplyBO, (Object)repliedClarifyInfoBO);
                    repliedClarifyInfoBO.setRepliedClarifyInfoBO(repliedClarifyInfoBO);
                    repliedClarifyInfoBOList.add(repliedClarifyInfoBO);
                    continue;
                }
                waitReplyList.add(po);
            }
            rspBO.setRepliedClarifyInfoBOList(repliedClarifyInfoBOList);
        }
        if (!CollectionUtils.isEmpty(waitReplyList)) {
            List collect = waitReplyList.stream().map(item -> {
                EnquiryClarifyInfoBO bo = new EnquiryClarifyInfoBO();
                BeanUtils.copyProperties((Object)item, (Object)bo);
                this.buildAnnex(bo);
                return bo;
            }).collect(Collectors.toList());
            rspBO.setPendingClarifyInfoBOList(collect);
        }
        this.buildGetTotal(rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildAnnex(EnquiryClarifyInfoBO bo) {
        BillFileInfoPO record = new BillFileInfoPO();
        ArrayList<EnquiryBasFileInfoBO> fileInfoBOList = new ArrayList<EnquiryBasFileInfoBO>();
        record.setBillId(bo.getClarifyId());
        List<BillFileInfoPO> billFileInfoPOS = this.billFileInfoMapper.qryFileInfoList(record);
        if (!CollectionUtils.isEmpty(billFileInfoPOS)) {
            for (BillFileInfoPO po : billFileInfoPOS) {
                BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
                basFileInfoPO.setFileinfoId(po.getFileinfoId());
                BasFileInfoPO fileInfoPO = this.basFileInfoMapper.selectByContidion(basFileInfoPO);
                EnquiryBasFileInfoBO fileInfoBO = new EnquiryBasFileInfoBO();
                BeanUtils.copyProperties((Object)fileInfoPO, (Object)fileInfoBO);
                fileInfoBOList.add(fileInfoBO);
            }
            bo.setFileInfoBOList(fileInfoBOList);
        }
    }

    private void buildGetTotal(EnquiryQryClarifyListByPageRspBO rspBO) {
        ArrayList<EnquiryClarifyLaunchTypeTotalBO> boList = new ArrayList<EnquiryClarifyLaunchTypeTotalBO>();
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setSysCode("ENQ");
        dicDictionaryPO.setPCode("LAUNCH_CLARIFY_TYPE");
        List<DicDictionaryPO> dictionaryPOS = this.dicDictionaryMapper.getListByCondition(dicDictionaryPO);
        if (!CollectionUtils.isEmpty(dictionaryPOS)) {
            for (DicDictionaryPO po : dictionaryPOS) {
                EnquiryClarifyLaunchTypeTotalBO typeTotalBO = new EnquiryClarifyLaunchTypeTotalBO();
                int total = this.clarifyInfoMapper.getClarifyInfoTotal(Integer.parseInt(po.getCode()));
                typeTotalBO.setCreateType(Integer.valueOf(Integer.parseInt(po.getCode())));
                typeTotalBO.setCreateTypeStr(po.getDescrip());
                typeTotalBO.setTypeTotal(Integer.valueOf(total));
                boList.add(typeTotalBO);
            }
        }
        rspBO.setTypeTotalBOList(boList);
    }
}

