/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.EnquiryBasFileInfoBO;
import com.tydic.enquiry.api.bo.EnquiryReplyClarifyReqBO;
import com.tydic.enquiry.api.bo.EnquiryReplyClarifyRspBO;
import com.tydic.enquiry.busi.api.EnquiryReplyClarifyBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.BasFileInfoMapper;
import com.tydic.enquiry.dao.BillFileInfoMapper;
import com.tydic.enquiry.dao.ClarifyInfoMapper;
import com.tydic.enquiry.dao.po.BasFileInfoPO;
import com.tydic.enquiry.dao.po.BillFileInfoPO;
import com.tydic.enquiry.dao.po.ClarifyInfoPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryReplyClarifyBusiServiceImpl
implements EnquiryReplyClarifyBusiService {
    @Autowired
    private ClarifyInfoMapper clarifyInfoMapper;
    @Autowired
    private BillFileInfoMapper billFileInfoMapper;
    @Autowired
    private BasFileInfoMapper basFileInfoMapper;

    @Override
    public EnquiryReplyClarifyRspBO replyClarify(EnquiryReplyClarifyReqBO replyClarifyReqBO) {
        EnquiryReplyClarifyRspBO rspBO = new EnquiryReplyClarifyRspBO();
        ClarifyInfoPO clarifyInfoPO = new ClarifyInfoPO();
        Date date = new Date();
        clarifyInfoPO.setClarifyId(Sequence.getInstance().nextId());
        clarifyInfoPO.setReplyClarifyId(replyClarifyReqBO.getClarifyId());
        clarifyInfoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        clarifyInfoPO.setCreateTime(date);
        clarifyInfoPO.setCreateUserId(String.valueOf(replyClarifyReqBO.getUserId()));
        clarifyInfoPO.setCreateUserName(replyClarifyReqBO.getName());
        clarifyInfoPO.setCreateOrgId(String.valueOf(replyClarifyReqBO.getOrgId()));
        clarifyInfoPO.setCreateOrgName(replyClarifyReqBO.getOrgName());
        try {
            this.clarifyInfoMapper.insert(clarifyInfoPO);
            if (!CollectionUtils.isEmpty((Collection)replyClarifyReqBO.getFileInfoBOList())) {
                ArrayList<BasFileInfoPO> list = new ArrayList<BasFileInfoPO>();
                ArrayList<BillFileInfoPO> billFileInfoPOS = new ArrayList<BillFileInfoPO>();
                for (EnquiryBasFileInfoBO bo : replyClarifyReqBO.getFileInfoBOList()) {
                    BasFileInfoPO basFileInfoPO = new BasFileInfoPO();
                    BeanUtils.copyProperties((Object)bo, (Object)basFileInfoPO);
                    basFileInfoPO.setFileinfoId(Sequence.getInstance().nextId());
                    basFileInfoPO.setCreateId(replyClarifyReqBO.getMemIdIn());
                    basFileInfoPO.setCreateName(replyClarifyReqBO.getName());
                    basFileInfoPO.setCreateTime(new Date());
                    list.add(basFileInfoPO);
                    BillFileInfoPO billFileInfoPO = new BillFileInfoPO();
                    billFileInfoPO.setBillFileinfoId(Sequence.getInstance().nextId());
                    billFileInfoPO.setBillId(clarifyInfoPO.getClarifyId());
                    billFileInfoPO.setFileinfoId(basFileInfoPO.getFileinfoId());
                    billFileInfoPO.setCreateTime(new Date());
                    basFileInfoPO.setCreateName(replyClarifyReqBO.getName());
                    basFileInfoPO.setCreateId(replyClarifyReqBO.getMemIdIn());
                    billFileInfoPOS.add(billFileInfoPO);
                }
                this.basFileInfoMapper.insertBatch(list);
                this.billFileInfoMapper.insertBatch(billFileInfoPOS);
            }
            ClarifyInfoPO record = new ClarifyInfoPO();
            record.setReplyClarifyId(replyClarifyReqBO.getClarifyId());
            record.setClarifyStatus(EnquiryConstant.clarifyStatus.REPLIED);
            record.setClarifyTime(date);
            this.clarifyInfoMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u56de\u590d\u6f84\u6e05\u5f02\u5e38\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

