/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.controller;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.enquiry.api.user.bo.AddUserReqBO;
import com.tydic.enquiry.api.user.bo.QueryUserReqBO;
import com.tydic.enquiry.api.user.bo.QueryUserRspBO;
import com.tydic.enquiry.api.user.service.AddUserService;
import com.tydic.enquiry.api.user.service.EditUserService;
import com.tydic.enquiry.api.user.service.GetUserByIdService;
import com.tydic.enquiry.api.user.service.QueryUserListService;
import com.tydic.enquiry.demo.api.IOneService;
import com.tydic.enquiry.demo.bo.ExampleBo;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    private AddUserService addUserService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    private QueryUserListService queryUserListService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    private IOneService oneService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    private EditUserService editUserService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    private GetUserByIdService getUserByIdService;

    @RequestMapping(value={"/addUser"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object addUser(@Valid AddUserReqBO addUserReqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.addUserService.save(addUserReqBO);
        return null;
    }

    @RequestMapping(value={"/editUser"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object editUser(@Valid AddUserReqBO addUserReqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.editUserService.edit(addUserReqBO);
        return null;
    }

    @RequestMapping(value={"/queryUserList"}, method={RequestMethod.GET})
    @BusiResponseBody
    public RspPage<QueryUserRspBO> queryUserList(QueryUserReqBO queryUserReqBO) {
        RspPage rspPage = this.queryUserListService.selectRoleInfo(queryUserReqBO);
        return rspPage;
    }

    @RequestMapping(value={"/getUserById"}, method={RequestMethod.GET})
    @BusiResponseBody
    public Object getUserById(@RequestParam Long userId) {
        return this.getUserByIdService.getUserById(userId);
    }

    @RequestMapping(value={"/getExampleBoById"})
    @BusiResponseBody
    public Object getExampleBoById(@RequestParam(value="exampleId") Integer exampleId) {
        ArrayList<ExampleBo> result = new ArrayList<ExampleBo>();
        if (this.oneService != null) {
            result.add(this.oneService.getExampleBoById(exampleId));
        }
        return result;
    }
}

