/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.ExecOrderInfoBO;
import com.tydic.enquiry.api.performlist.bo.IqrDealNoticeBO;
import com.tydic.enquiry.api.performlist.bo.QryExecOrderReqBO;
import com.tydic.enquiry.api.performlist.bo.QryExecOrderRspBO;
import com.tydic.enquiry.api.performlist.service.QryExecOrderService;
import com.tydic.enquiry.dao.DIqrDealNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.po.DIqrDealNoticePO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.QryExecOrderService"})
public class QryExecOrderServiceImpl
implements QryExecOrderService {
    private static final Logger log = LoggerFactory.getLogger(QryExecOrderServiceImpl.class);
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrDealNoticeMapper dIqrDealNoticeMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryExecOrderInfo"})
    public QryExecOrderRspBO qryExecOrderInfo(@RequestBody QryExecOrderReqBO qryExecOrderReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryExecOrderReqBO=" + qryExecOrderReqBO.toString());
        Page page = new Page(qryExecOrderReqBO.getPageNo(), qryExecOrderReqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        QryExecOrderRspBO qryExecOrderRspBO = new QryExecOrderRspBO();
        List<DIqrInquiryMatePO> inquiryMatePOList = null;
        map.put("planDepart", qryExecOrderReqBO.getPlanDepart());
        map.put("inquiryCode", qryExecOrderReqBO.getInquiryCode());
        log.info("qryExecOrderReqBO.getInquiryCode()=" + qryExecOrderReqBO.getInquiryCode());
        map.put("purchaseAccount", qryExecOrderReqBO.getPurchaseAccount());
        map.put("inquiryName", qryExecOrderReqBO.getInquiryName());
        map.put("operId", qryExecOrderReqBO.getOperId());
        map.put("operName", qryExecOrderReqBO.getOperName());
        map.put("docStatus", qryExecOrderReqBO.getDocStatus());
        if (qryExecOrderReqBO.getPurchaseMethod() != null && !"".equals(qryExecOrderReqBO.getPurchaseMethod())) {
            map.put("purchaseMethod", Integer.parseInt(qryExecOrderReqBO.getPurchaseMethod()));
        }
        Date createDateTemp = DateUtils.strToDateLong((String)qryExecOrderReqBO.getCreateDate());
        map.put("createDate", createDateTemp);
        map.put("busiType", qryExecOrderReqBO.getBusiType());
        if (qryExecOrderReqBO.getDetailDocStatus() != null && qryExecOrderReqBO.getDetailDocStatus() != "") {
            map.put("detailDocStatus", Integer.valueOf(qryExecOrderReqBO.getDetailDocStatus()));
        }
        log.info("createDateTemp=" + createDateTemp);
        if (CollectionUtils.isNotEmpty((Collection)qryExecOrderReqBO.getChoiceIds())) {
            map.put("idList", qryExecOrderReqBO.getChoiceIds());
        }
        log.info("qryExecOrderReqBO.getIsPagination()=" + qryExecOrderReqBO.getIsPagination());
        if ("Y".equals(qryExecOrderReqBO.getIsPagination())) {
            try {
                inquiryMatePOList = this.dIqrInquiryMateMapper.queryInquiryMateForPage(map, (Page<DIqrInquiryMatePO>)page);
            }
            catch (Exception e) {
                qryExecOrderRspBO.setRespCode("9999");
                qryExecOrderRspBO.setRespDesc(e.toString());
                log.error("\u5f02\u5e38\u4fe1\u606f\uff1ae=" + e.toString());
                return qryExecOrderRspBO;
            }
        } else {
            inquiryMatePOList = this.dIqrInquiryMateMapper.queryInquiryMateNoPage(map);
        }
        log.info("queryInquiryMate end");
        ArrayList<ExecOrderInfoBO> execOrderInfoBOList = new ArrayList<ExecOrderInfoBO>();
        if (CollectionUtils.isNotEmpty(inquiryMatePOList)) {
            log.info("inquiryMatePOList.size()=" + inquiryMatePOList.size());
            for (DIqrInquiryMatePO po : inquiryMatePOList) {
                ExecOrderInfoBO execOrderInfoBO = new ExecOrderInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)execOrderInfoBO);
                execOrderInfoBO.setOperId(po.getCreateUserId());
                log.info("execOrderInfoBO.getOperName()=" + execOrderInfoBO.getOperName());
                if (po.getPurchaseAccountsJson() != null && !"".equals(po.getPurchaseAccountsJson())) {
                    execOrderInfoBO.setPurchaseAccount(Long.valueOf(Long.parseLong(po.getPurchaseAccountsJson())));
                }
                execOrderInfoBO.setPurchaseAccountName(po.getPurchaseAccountsNameJson());
                execOrderInfoBO.setOperName(po.getCreateUserName());
                execOrderInfoBO.setCreateDate(DateUtils.dateToStr((Date)po.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                execOrderInfoBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", po.getDocStatus() + ""));
                execOrderInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", po.getPurchaseMethod() + ""));
                HashMap<String, Object> maps = new HashMap<String, Object>();
                maps.put("inquiryId", po.getInquiryId());
                maps.put("dealNoticeNameLike", qryExecOrderReqBO.getDealNoticeName());
                maps.put("dealNoticeCode", qryExecOrderReqBO.getDealNoticeCode());
                if (qryExecOrderReqBO.getSupConfirmTime() != null && !"".equals(qryExecOrderReqBO.getSupConfirmTime())) {
                    Date supConfirmTimeTemp = DateUtils.strToDate((String)qryExecOrderReqBO.getSupConfirmTime(), (String)"yyyyMMddHHmmss");
                    maps.put("supConfirmTime", supConfirmTimeTemp);
                }
                maps.put("confirmOperId", qryExecOrderReqBO.getConfirmOperId());
                List<DIqrDealNoticePO> dIqrDealNoticePOList = this.dIqrDealNoticeMapper.selectDealNoticeByMaps(maps);
                if (CollectionUtils.isNotEmpty(dIqrDealNoticePOList)) {
                    ArrayList<IqrDealNoticeBO> iqrDealNoticeBOList = new ArrayList<IqrDealNoticeBO>();
                    for (DIqrDealNoticePO dIqrDealNoticePO : dIqrDealNoticePOList) {
                        IqrDealNoticeBO iqrDealNoticeBO = new IqrDealNoticeBO();
                        BeanUtils.copyProperties((Object)dIqrDealNoticePO, (Object)iqrDealNoticeBO);
                        iqrDealNoticeBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("DNOTICE_DOC_STATUS", dIqrDealNoticePO.getDocStatus().toString()));
                        iqrDealNoticeBOList.add(iqrDealNoticeBO);
                    }
                    execOrderInfoBO.setIqrDealNoticeList(iqrDealNoticeBOList);
                }
                execOrderInfoBOList.add(execOrderInfoBO);
            }
        }
        log.info("execOrderInfoBOList\u8d4b\u503c\u5b8c\u6210");
        qryExecOrderRspBO.setPageNo(page.getPageNo());
        qryExecOrderRspBO.setTotal(page.getTotalPages());
        qryExecOrderRspBO.setRecordsTotal(page.getTotalCount());
        qryExecOrderRspBO.setRows(execOrderInfoBOList);
        qryExecOrderRspBO.setRespCode("0000");
        qryExecOrderRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryExecOrderRspBO=" + qryExecOrderRspBO.toString());
        return qryExecOrderRspBO;
    }
}

