/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.requirement;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.requirement.bo.QryRequireOrderReqBO;
import com.tydic.enquiry.api.requirement.bo.QryRequireOrderRspBO;
import com.tydic.enquiry.api.requirement.bo.RequireOrderInfoBO;
import com.tydic.enquiry.api.requirement.service.QryRequireOrderInfoService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.requirement.service.QryRequireOrderInfoService"})
public class QryRequireOrderInfoServiceImpl
implements QryRequireOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(QryRequireOrderInfoServiceImpl.class);
    @Autowired
    DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryRequireOrder"})
    public QryRequireOrderRspBO qryRequireOrder(@RequestBody QryRequireOrderReqBO qryRequireOrderReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryRequireOrderReqBO=" + qryRequireOrderReqBO.toString());
        Page page = new Page(qryRequireOrderReqBO.getPageNo(), qryRequireOrderReqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        QryRequireOrderRspBO qryRequireOrderRspBO = new QryRequireOrderRspBO();
        qryRequireOrderRspBO.setPageSize(qryRequireOrderReqBO.getPageSize());
        Long beginBudget = null;
        Long endBudget = null;
        if (qryRequireOrderReqBO.getBeginBudgetAmount() != null && qryRequireOrderReqBO.getEndBudgetAmount() != null) {
            beginBudget = qryRequireOrderReqBO.getBeginBudgetAmount().multiply(BigDecimal.valueOf(10000L)).longValue();
            log.info("beginBudget=" + beginBudget);
            endBudget = qryRequireOrderReqBO.getEndBudgetAmount().multiply(BigDecimal.valueOf(10000L)).longValue();
            log.info("endBudget=" + endBudget);
        }
        Date planApproveDateTemp = null;
        Date inquireCreateDateTemp = null;
        Date CreateDateTemp = null;
        if (qryRequireOrderReqBO.getPlanApproveDate() != null && qryRequireOrderReqBO.getInquireCreateDate() != null && qryRequireOrderReqBO.getCreateDate() != null) {
            inquireCreateDateTemp = DateUtils.strToDateLong((String)qryRequireOrderReqBO.getInquireCreateDate());
            log.info("inquireCreateDateTemp=" + inquireCreateDateTemp);
            planApproveDateTemp = DateUtils.strToDateLong((String)qryRequireOrderReqBO.getPlanApproveDate());
            log.info("planApproveDateTemp=" + planApproveDateTemp);
            CreateDateTemp = DateUtils.strToDateLong((String)qryRequireOrderReqBO.getCreateDate());
            log.info("CreateDateTemp=" + CreateDateTemp);
        }
        List<DPlanMaterialPO> planMaterialPOList = null;
        map.put("inquireCreateDate", inquireCreateDateTemp);
        map.put("planApproveDate", planApproveDateTemp);
        map.put("createDate", CreateDateTemp);
        map.put("beginBudgetAmount", beginBudget);
        map.put("endBudgetAmount", endBudget);
        map.put("planDepart", qryRequireOrderReqBO.getPlanDepart());
        map.put("planUnit", qryRequireOrderReqBO.getPlanUnit());
        map.put("planCode", qryRequireOrderReqBO.getPlanCode());
        log.info("qryRequireOrderReqBO.getPlanCode()=" + qryRequireOrderReqBO.getPlanCode());
        map.put("purchaseAccount", qryRequireOrderReqBO.getPurchaseAccount());
        map.put("planName", qryRequireOrderReqBO.getPlanName());
        if (qryRequireOrderReqBO.getQryApprFlag() == null || "".equals(qryRequireOrderReqBO.getQryApprFlag())) {
            map.put("operId", qryRequireOrderReqBO.getUserId());
        }
        map.put("operName", qryRequireOrderReqBO.getOperName());
        if ("1".equals(qryRequireOrderReqBO.getQryStatusFlag())) {
            ArrayList<Integer> docStatusList = new ArrayList<Integer>();
            docStatusList.add(1001);
            docStatusList.add(1007);
            map.put("docStatusList", docStatusList);
        } else {
            map.put("docStatus", qryRequireOrderReqBO.getDocStatus());
        }
        map.put("qryApprFlag", qryRequireOrderReqBO.getQryApprFlag());
        if ("1004".equals(qryRequireOrderReqBO.getDocStatus() + "")) {
            map.put("orderByFlag", "inquiry_create");
        } else if ("1001".equals(qryRequireOrderReqBO.getDocStatus() + "") || "1007".equals(qryRequireOrderReqBO.getDocStatus() + "")) {
            map.put("orderByFlag", "require_create");
        } else {
            map.put("orderByFlag", "require_submit");
        }
        if (CollectionUtils.isNotEmpty((Collection)qryRequireOrderReqBO.getChoiceIds())) {
            map.put("idList", qryRequireOrderReqBO.getChoiceIds());
        }
        if (StringUtils.isNotBlank((CharSequence)qryRequireOrderReqBO.getPurchaseMethod()) && !"ALL".equals(qryRequireOrderReqBO.getPurchaseMethod())) {
            map.put("purchaseMethod", Integer.parseInt(qryRequireOrderReqBO.getPurchaseMethod()));
        }
        log.info("qryRequireOrderReqBO.getIsPagination()=" + qryRequireOrderReqBO.getIsPagination());
        planMaterialPOList = "Y".equals(qryRequireOrderReqBO.getIsPagination()) ? this.dPlanMaterialMapper.queryPlanMaterialForPage(map, (Page<Map<String, Object>>)page) : this.dPlanMaterialMapper.queryPlanMaterialNoPage(map);
        log.info("queryPlanMaterial end");
        List reqOrderInfoList = null;
        if (CollectionUtils.isNotEmpty(planMaterialPOList)) {
            log.info("planMaterialPOList.size()=" + planMaterialPOList.size());
            reqOrderInfoList = planMaterialPOList.stream().map(e -> {
                RequireOrderInfoBO reqOrderInfoBO = new RequireOrderInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)reqOrderInfoBO);
                reqOrderInfoBO.setOperId(e.getCreateUserId());
                log.info("reqOrderInfoBO.getOperName()=" + reqOrderInfoBO.getOperName());
                reqOrderInfoBO.setOperName(e.getCreateUserName());
                reqOrderInfoBO.setPlanUnit(e.getPurchaseId());
                reqOrderInfoBO.setPlanUnitName(e.getPurchaseName());
                if (e.getSubmitTime() != null) {
                    reqOrderInfoBO.setCreateDate(DateUtils.dateToStr((Date)e.getSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    reqOrderInfoBO.setCreateDate("--");
                }
                if (e.getPlanApproveDate() != null) {
                    reqOrderInfoBO.setPlanApproveDate(DateUtils.dateToStr((Date)e.getPlanApproveDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    reqOrderInfoBO.setPlanApproveDate("--");
                }
                if (e.getInquiryCreateDate() != null) {
                    reqOrderInfoBO.setInquireCreateDate(DateUtils.dateToStr((Date)e.getInquiryCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    reqOrderInfoBO.setInquireCreateDate("--");
                }
                BigDecimal amount = new BigDecimal(10000);
                BigDecimal budgetTemp = null;
                if (e.getBudgetAmount() != null) {
                    budgetTemp = new BigDecimal(e.getBudgetAmount());
                    log.info("budgetTemp=" + budgetTemp);
                    reqOrderInfoBO.setBudgetAmount(budgetTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
                } else {
                    budgetTemp = new BigDecimal(0);
                    reqOrderInfoBO.setBudgetAmount(budgetTemp);
                }
                log.info("reqOrderInfoBO.getBudgetAmount()=" + reqOrderInfoBO.getBudgetAmount());
                reqOrderInfoBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("REQ_DOC_STATUS", e.getDocStatus() + ""));
                reqOrderInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", e.getPurchaseMethod() + ""));
                List<DIqrInquiryMatePO> dIqrInquiryMatePOS = this.dIqrInquiryMateMapper.selectByPlanId(reqOrderInfoBO.getPlanId());
                if (CollectionUtils.isNotEmpty(dIqrInquiryMatePOS)) {
                    reqOrderInfoBO.setHadIqrOrderFlag("1");
                    for (DIqrInquiryMatePO dIqrInquiryMatePO : dIqrInquiryMatePOS) {
                        reqOrderInfoBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    }
                } else {
                    reqOrderInfoBO.setHadIqrOrderFlag("0");
                }
                if ("1002".equals(reqOrderInfoBO.getDocStatus()) || "1003".equals(reqOrderInfoBO.getDocStatus())) {
                    reqOrderInfoBO.setIsShowCloseFlag("1");
                } else {
                    reqOrderInfoBO.setIsShowCloseFlag("0");
                }
                return reqOrderInfoBO;
            }).collect(Collectors.toList());
        }
        log.info("reqOrderInfoList\u8d4b\u503c\u5b8c\u6210");
        qryRequireOrderRspBO.setPageNo(qryRequireOrderReqBO.getPageNo());
        qryRequireOrderRspBO.setTotal(page.getTotalPages());
        qryRequireOrderRspBO.setRecordsTotal(page.getTotalCount());
        qryRequireOrderRspBO.setRows(reqOrderInfoList);
        qryRequireOrderRspBO.setRespCode("0000");
        qryRequireOrderRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryRequireOrderRspBO=" + qryRequireOrderRspBO.toString());
        return qryRequireOrderRspBO;
    }
}

