/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.fastjson.JSON;
import com.tydic.enquiry.api.performlist.bo.ChngQuotationRoundReqBO;
import com.tydic.enquiry.api.performlist.bo.ChngQuotationRoundRspBO;
import com.tydic.enquiry.api.performlist.service.ChngQuotationRoundService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.ChngQuotationRoundService"})
public class ChngQuotationRoundServiceImpl
implements ChngQuotationRoundService {
    private static final Logger log = LoggerFactory.getLogger(ChngQuotationRoundServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    @PostMapping(value={"chngQuotationRound"})
    public ChngQuotationRoundRspBO chngQuotationRound(@RequestBody ChngQuotationRoundReqBO reqBO) {
        ChngQuotationRoundRspBO rspBO = new ChngQuotationRoundRspBO();
        if (reqBO.getInquiryId() == null) {
            log.error("\u5165\u53c2\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO == null || dIqrInquiryMatePO.getLimitBargainNum() == null) {
            log.error("\u6267\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u6267\u884c\u5355\u53ef\u8bae\u4ef7\u9650\u5236\u6b21\u6570\u4e3a\u7a7a,\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        log.info("\u6267\u884c\u5355\u6570\u636e :" + JSON.toJSONString((Object)dIqrInquiryMatePO));
        Integer limitBargainNum = dIqrInquiryMatePO.getLimitBargainNum();
        if (!"22".equals(dIqrInquiryMatePO.getDocType())) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u7c7b\u578b\u975e\u591a\u6b21\u8bae\u4ef7\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u7c7b\u578b\u975e\u591a\u6b21\u8bae\u4ef7\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
            return rspBO;
        }
        Date quoteEndDate = dIqrInquiryMatePO.getQuoteEndDate();
        Date nowDate = new Date();
        log.info("eq: " + "2003".equals(dIqrInquiryMatePO.getDocStatus().toString()));
        if (quoteEndDate.before(nowDate) || !"2003".equals(dIqrInquiryMatePO.getDocStatus().toString())) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u5df2\u8fc7\u62a5\u4ef7\u65f6\u95f4\u6216\u4e0d\u5728\u62a5\u4ef7\u4e2d\u9636\u6bb5\uff0c\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u5df2\u8fc7\u62a5\u4ef7\u65f6\u95f4\u6216\u4e0d\u5728\u62a5\u4ef7\u4e2d\u9636\u6bb5\uff0c\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
            return rspBO;
        }
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("4002"));
        docStatusList.add(Integer.valueOf("4004"));
        docStatusList.add(Integer.valueOf("4006"));
        DIqrQuotationPO record = new DIqrQuotationPO();
        record.setHisStatus("1");
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setInquiryId(reqBO.getInquiryId());
        record.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> quotationPOS = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        if (CollectionUtils.isEmpty(quotationPOS)) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u672a\u6709\u5df2\u62a5\u4ef7\u7684\u6570\u636e\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u672a\u6709\u5df2\u62a5\u4ef7\u7684\u6570\u636e\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7!!!");
            return rspBO;
        }
        Integer quoteTimeLimit = quotationPOS.get(0).getQuoteTimeLimit();
        if (quoteTimeLimit != null && quoteTimeLimit >= limitBargainNum) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u5df2\u91cd\u542f\u62a5\u4ef7" + quoteTimeLimit + "\u6b21,\u4e0d\u53ef\u4ee5\u518d\u91cd\u65b0\u62a5\u4ef7!!!");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u5df2\u91cd\u542f\u62a5\u4ef7" + quoteTimeLimit + "\u6b21,\u4e0d\u53ef\u4ee5\u518d\u91cd\u65b0\u62a5\u4ef7!!!");
            return rspBO;
        }
        this.dIqrQuotationMapper.updateTimeLimitByInquiryId(reqBO.getInquiryId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u91cd\u65b0\u62a5\u4ef7\u6210\u529f");
        return rspBO;
    }
}

