/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.GoodsDetailBO;
import com.tydic.enquiry.api.performlist.bo.GoodsPicInfoBO;
import com.tydic.enquiry.api.performlist.bo.InquiryAttachmentBO;
import com.tydic.enquiry.api.performlist.bo.InquiryDetailBO;
import com.tydic.enquiry.api.performlist.bo.PackageBO;
import com.tydic.enquiry.api.performlist.bo.SaveExecOrderReqBO;
import com.tydic.enquiry.api.performlist.bo.SaveExecOrderRspBO;
import com.tydic.enquiry.api.performlist.service.SaveExecOrderService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryAttchmentMapper;
import com.tydic.enquiry.dao.DIqrInquiryDepartRangeMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailPicMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.dao.DPlanItemMaterialMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.dao.HIqrFormApprNodeMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.dao.RPlanSupplierRelMapper;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryDepartRangePO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPicPO;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import com.tydic.enquiry.po.HIqrFormApprNodePO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import com.tydic.enquiry.po.RPlanSupplierRelPO;
import com.tydic.enquiry.util.RedisUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.SaveExecOrderService"})
public class SaveExecOrderServiceImpl
implements SaveExecOrderService {
    private static final Logger log = LoggerFactory.getLogger(SaveExecOrderServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;
    @Autowired
    private DIqrInquiryAttchmentMapper dIqrInquiryAttchmentMapper;
    @Autowired
    private HIqrFormApprNodeMapper hIqrFormApprNodeMapper;
    @Autowired
    private DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    private DPlanItemMaterialMapper dPlanItemMaterialMapper;
    @Autowired
    private RPlanSupplierRelMapper rPlanSupplierRelMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;
    @Autowired
    private CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    private DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    private DIqrInquiryDepartRangeMapper dIqrInquiryDepartRangeMapper;
    @Autowired
    private DIqrInquiryDetailPicMapper dIqrInquiryDetailPicMapper;

    @PostMapping(value={"saveExecOrder"})
    public SaveExecOrderRspBO saveExecOrder(@RequestBody SaveExecOrderReqBO reqBO) {
        int picCnt;
        DIqrInquiryDetailPicPO detailPicPO;
        ArrayList<DIqrInquiryDetailPicPO> detailPicPOList;
        int detailResult;
        SeqEnquiryRspBO seqRspBO;
        int dIqrInquiryMateResult;
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1asaveExecOrderReqBO=" + reqBO.toString());
        this.initParam(reqBO);
        SaveExecOrderRspBO rspBO = new SaveExecOrderRspBO();
        Date operDate = new Date();
        String docType = "";
        Long purchaseAccount = null;
        String purchaseAccountName = "";
        BigDecimal amount = new BigDecimal(10000);
        Long sumAmount = 0L;
        DIqrInquiryMatePO dIqrInquiryMatePO = new DIqrInquiryMatePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)dIqrInquiryMatePO);
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("ZH01");
        seqEnquiryReqBO.setSeqType("2");
        SeqEnquiryRspBO seqEnquiryRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        rspBO.setInquiryId(seqEnquiryRspBO.getDocId());
        log.info("rspBO.getInquiryId()=" + rspBO.getInquiryId());
        dIqrInquiryMatePO.setInquiryId(seqEnquiryRspBO.getDocId());
        dIqrInquiryMatePO.setValidStatus(Constants.IS_VALID_Y);
        if ("1".equals(reqBO.getBusiType()) && reqBO.getPlanId() != null) {
            DPlanMaterialPO dPlanMaterialPO = this.dPlanMaterialMapper.selectByPrimaryKey(reqBO.getPlanId());
            if (dPlanMaterialPO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8be5\u9700\u6c42\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
                return rspBO;
            }
            BeanUtils.copyProperties((Object)dPlanMaterialPO, (Object)dIqrInquiryMatePO);
            dIqrInquiryMatePO.setInquiryId(seqEnquiryRspBO.getDocId());
            dIqrInquiryMatePO.setValidStatus(Constants.IS_VALID_Y);
            log.info("dPlanMaterialPO.getPurchaseAccount()=" + dPlanMaterialPO.getPurchaseAccount());
            dIqrInquiryMatePO.setPurchaseAccountsJson(dPlanMaterialPO.getPurchaseAccount() + "");
            dIqrInquiryMatePO.setPurchaseAccountsNameJson(dPlanMaterialPO.getPurchaseAccountName());
            dIqrInquiryMatePO.setPurchaseIdJson(dPlanMaterialPO.getPurchaseId() + "");
            dIqrInquiryMatePO.setProfessionalOrgId(dPlanMaterialPO.getPlanDepart());
            dIqrInquiryMatePO.setProfessionalOrgName(dPlanMaterialPO.getPlanDepartName());
            dIqrInquiryMatePO.setPayTypeJson(dPlanMaterialPO.getPayType());
            dIqrInquiryMatePO.setReqArrivalPeriod(dPlanMaterialPO.getReqArrivalTimeInt());
            dIqrInquiryMatePO.setSupplierClass("1");
            log.info("reqBO.getPlanId()=" + reqBO.getPlanId());
            List<RPlanSupplierRelPO> planSupplierRelPOList = this.rPlanSupplierRelMapper.selectSupplierByPlanId(reqBO.getPlanId());
            if (CollectionUtils.isNotEmpty(planSupplierRelPOList)) {
                String supplierIdJson = ",";
                Iterator supplierNameJson = ",";
                for (RPlanSupplierRelPO rPlanSupplierRelPO : planSupplierRelPOList) {
                    supplierIdJson = supplierIdJson + rPlanSupplierRelPO.getSupplierId() + ",";
                    supplierNameJson = (String)((Object)supplierNameJson) + rPlanSupplierRelPO.getSupplierName() + ",";
                }
                dIqrInquiryMatePO.setInviteSupplierIdJson(supplierIdJson);
                dIqrInquiryMatePO.setInviteSupplierNameJson((String)((Object)supplierNameJson));
                log.info("supplierIdJson=" + supplierIdJson);
                log.info("supplierNameJson=" + (String)((Object)supplierNameJson));
            }
            log.info("dPlanMaterialPO.getDocType()=" + dPlanMaterialPO.getDocType());
            log.info("dPlanMaterialPO.getPurchaseMethod()=" + dPlanMaterialPO.getPurchaseMethod());
            docType = dPlanMaterialPO.getDocType() != null && !"".equals(dPlanMaterialPO.getDocType()) ? dPlanMaterialPO.getDocType() : dPlanMaterialPO.getPurchaseMethod() + "";
            purchaseAccount = dPlanMaterialPO.getPurchaseAccount();
            purchaseAccountName = dPlanMaterialPO.getPurchaseAccountName();
        } else {
            docType = "23";
            dIqrInquiryMatePO.setPurchaseIdJson(reqBO.getPlanUnit() + "");
            dIqrInquiryMatePO.setPurchaseName(reqBO.getPlanUnitName());
            dIqrInquiryMatePO.setProfessionalOrgId(reqBO.getPlanDepart());
            dIqrInquiryMatePO.setProfessionalOrgName(reqBO.getPlanDepartName());
            dIqrInquiryMatePO.setSupplierClass("2");
            dIqrInquiryMatePO.setContactCountryId(reqBO.getContactCountryId());
            dIqrInquiryMatePO.setContactCountryName(reqBO.getContactCountryName());
            dIqrInquiryMatePO.setContactProvinceId(reqBO.getContactProvinceId());
            dIqrInquiryMatePO.setContactProvinceName(reqBO.getContactProvinceName());
            dIqrInquiryMatePO.setContactCityId(reqBO.getContactCityId());
            dIqrInquiryMatePO.setContactCityName(reqBO.getContactCityName());
            dIqrInquiryMatePO.setContactCountyId(reqBO.getContactCountyId());
            dIqrInquiryMatePO.setContactCountyName(reqBO.getContactCountyName());
            if (StringUtils.isEmpty((CharSequence)reqBO.getContactTownId())) {
                dIqrInquiryMatePO.setContactTownId("0");
            } else {
                dIqrInquiryMatePO.setContactTownId(reqBO.getContactTownId());
            }
            dIqrInquiryMatePO.setContactTown(reqBO.getContactTown());
        }
        dIqrInquiryMatePO.setInquiryCode(reqBO.getInquiryCode());
        dIqrInquiryMatePO.setInquiryName(reqBO.getInquiryName());
        log.info("dIqrInquiryMatePO.getInquiryName()=" + dIqrInquiryMatePO.getInquiryName());
        dIqrInquiryMatePO.setDocType(docType);
        log.info("docType=" + docType);
        dIqrInquiryMatePO.setPurchaseMethod(Integer.parseInt(docType));
        dIqrInquiryMatePO.setGuaranteePeriod(reqBO.getGuaranteePeriod());
        dIqrInquiryMatePO.setCurrency(reqBO.getCurrencyType());
        dIqrInquiryMatePO.setAllowTradingNum(reqBO.getAllowTradingNum());
        dIqrInquiryMatePO.setQuoteMethod(reqBO.getQuoteMethod());
        if ("2".equals(reqBO.getQuoteMethod() + "")) {
            dIqrInquiryMatePO.setTotalPriceFlag("N");
        }
        dIqrInquiryMatePO.setLimitBargainNum(reqBO.getLimitBargainNum());
        dIqrInquiryMatePO.setRegistBeginDate(DateUtils.strToDateLong((String)reqBO.getRegistBeginDate()));
        dIqrInquiryMatePO.setRegistEndDate(DateUtils.strToDateLong((String)reqBO.getRegistEndDate()));
        dIqrInquiryMatePO.setLimitQuoteDate(DateUtils.strToDateLong((String)reqBO.getLimitQuoteDate()));
        dIqrInquiryMatePO.setQuoteEndDate(DateUtils.strToDateLong((String)reqBO.getQuoteEndDate()));
        dIqrInquiryMatePO.setCreateUserId(reqBO.getOperId());
        dIqrInquiryMatePO.setCreateUserName(reqBO.getOperName());
        dIqrInquiryMatePO.setCreateTime(operDate);
        if ("Y".equals(reqBO.getPublishFlag())) {
            dIqrInquiryMatePO.setDocStatus(Integer.parseInt("2002"));
            dIqrInquiryMatePO.setNodeStatus(Integer.parseInt("2102"));
            dIqrInquiryMatePO.setBusiStatus(Integer.parseInt("2202"));
        } else {
            dIqrInquiryMatePO.setDocStatus(Integer.parseInt("2001"));
            dIqrInquiryMatePO.setNodeStatus(Integer.parseInt("2101"));
            dIqrInquiryMatePO.setBusiStatus(Integer.parseInt("2201"));
        }
        if (reqBO.getDelayBiddingFlag() != null && "Y".equals(reqBO.getDelayBiddingFlag())) {
            dIqrInquiryMatePO.setDelayEachTime(5);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsDetailList())) {
            for (GoodsDetailBO goodsDetailBO : reqBO.getGoodsDetailList()) {
                sumAmount = sumAmount + goodsDetailBO.getBudgetPrice().multiply(amount).multiply(goodsDetailBO.getGoodsNumber()).longValue();
            }
            log.info("sumAmount=" + sumAmount);
            dIqrInquiryMatePO.setBudgetAmount(sumAmount);
        }
        if ((dIqrInquiryMateResult = this.dIqrInquiryMateMapper.insertSelective(dIqrInquiryMatePO)) < 1) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01");
            return rspBO;
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgRangeList())) {
            List<DIqrInquiryDepartRangePO> departRangePOList = reqBO.getOrgRangeList().stream().map(e -> {
                DIqrInquiryDepartRangePO departRangePO = new DIqrInquiryDepartRangePO();
                BeanUtils.copyProperties((Object)e, (Object)departRangePO);
                departRangePO.setInquiryId(seqEnquiryRspBO.getDocId());
                departRangePO.setInquiryCode(reqBO.getInquiryCode());
                departRangePO.setValidStatus(Constants.IS_VALID_Y);
                departRangePO.setCreateDate(operDate);
                return departRangePO;
            }).collect(Collectors.toList());
            int supplierIdJson = this.dIqrInquiryDepartRangeMapper.insertDepartRangeBatch(departRangePOList);
        }
        log.info("reqBO.getQuoteMethod()=" + reqBO.getQuoteMethod());
        log.info("docType=" + docType);
        String allInquiryPkdId = "";
        ArrayList<InquiryDetailBO> biddingDetailList = new ArrayList<InquiryDetailBO>();
        if ("2".equals(reqBO.getQuoteMethod() + "")) {
            if (!"23".equals(docType)) {
                log.info("reqBO.getGoodsDetailList()=" + reqBO.getGoodsDetailList());
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsDetailList())) {
                    for (GoodsDetailBO goodsDetailBO : reqBO.getGoodsDetailList()) {
                        int dIqrInquiryMateItemResult;
                        seqEnquiryReqBO = new SeqEnquiryReqBO();
                        seqEnquiryReqBO.setSystemId("ZH01");
                        seqEnquiryReqBO.setSeqType("201");
                        seqEnquiryReqBO.setDocCode(reqBO.getInquiryCode());
                        SeqEnquiryRspBO seqRspBO2 = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                        DIqrInquiryMateItemPO dIqrInquiryMateItemPO = new DIqrInquiryMateItemPO();
                        dIqrInquiryMateItemPO.setInquiryPkgId(seqRspBO2.getPkgDocId());
                        goodsDetailBO.setInquiryPkgId(seqRspBO2.getPkgDocId());
                        dIqrInquiryMateItemPO.setInquiryId(seqEnquiryRspBO.getDocId());
                        dIqrInquiryMateItemPO.setValidStatus(Constants.IS_VALID_Y);
                        dIqrInquiryMateItemPO.setDetailNum(1);
                        dIqrInquiryMateItemPO.setPkgTotalAmount(goodsDetailBO.getBudgetPrice().multiply(amount).multiply(goodsDetailBO.getGoodsNumber()).longValue());
                        dIqrInquiryMateItemPO.setCreateDate(operDate);
                        if (purchaseAccount != null) {
                            dIqrInquiryMateItemPO.setPurchaseAccount(purchaseAccount);
                        }
                        if (purchaseAccountName != null && !"".equals(purchaseAccountName)) {
                            dIqrInquiryMateItemPO.setPurchaseAccountName(purchaseAccountName);
                        }
                        if ((dIqrInquiryMateItemResult = this.dIqrInquiryMateItemMapper.insertSelective(dIqrInquiryMateItemPO)) >= 1) continue;
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u5305\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                        return rspBO;
                    }
                }
            } else {
                log.info("reqBO.getPackageList()=" + reqBO.getPackageList());
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getPackageList())) {
                    for (PackageBO packageBO : reqBO.getPackageList()) {
                        int dIqrInquiryMateItemResult;
                        DIqrInquiryMateItemPO dIqrInquiryMateItemPO = new DIqrInquiryMateItemPO();
                        log.info("bo.getInquiryPkgId()=" + packageBO.getInquiryPkgId());
                        dIqrInquiryMateItemPO.setInquiryPkgId(packageBO.getInquiryPkgId());
                        dIqrInquiryMateItemPO.setInquiryId(seqEnquiryRspBO.getDocId());
                        dIqrInquiryMateItemPO.setValidStatus(Constants.IS_VALID_Y);
                        dIqrInquiryMateItemPO.setDetailNum(packageBO.getDetailNum());
                        if (packageBO.getPkgTotalAmount() != null) {
                            dIqrInquiryMateItemPO.setPkgTotalAmount(packageBO.getPkgTotalAmount().multiply(amount).longValue());
                        }
                        if (packageBO.getPkgCreateDate() != null && !"".equals(packageBO.getPkgCreateDate())) {
                            dIqrInquiryMateItemPO.setCreateDate(DateUtils.strToDate((String)packageBO.getPkgCreateDate(), (String)"yyyyMMddHHmmss"));
                        } else {
                            dIqrInquiryMateItemPO.setCreateDate(operDate);
                        }
                        if (purchaseAccount != null) {
                            dIqrInquiryMateItemPO.setPurchaseAccount(purchaseAccount);
                        }
                        if (purchaseAccountName != null && !"".equals(purchaseAccountName)) {
                            dIqrInquiryMateItemPO.setPurchaseAccountName(purchaseAccountName);
                        }
                        if ((dIqrInquiryMateItemResult = this.dIqrInquiryMateItemMapper.insertSelective(dIqrInquiryMateItemPO)) < 1) {
                            rspBO.setRespCode("9999");
                            rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u5305\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                            return rspBO;
                        }
                        if (!CollectionUtils.isNotEmpty((Collection)packageBO.getDetailList())) continue;
                        for (InquiryDetailBO detailBO : packageBO.getDetailList()) {
                            biddingDetailList.add(detailBO);
                        }
                    }
                }
            }
        } else if ("1".equals(reqBO.getQuoteMethod() + "")) {
            seqEnquiryReqBO = new SeqEnquiryReqBO();
            seqEnquiryReqBO.setSystemId("ZH01");
            seqEnquiryReqBO.setSeqType("201");
            seqEnquiryReqBO.setDocCode(reqBO.getInquiryCode());
            SeqEnquiryRspBO seqRspBO3 = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
            allInquiryPkdId = seqRspBO3.getPkgDocId();
            log.info("allInquiryPkdId=" + allInquiryPkdId);
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsDetailList())) {
                int dIqrInquiryMateItemResult;
                DIqrInquiryMateItemPO dIqrInquiryMateItemPO = new DIqrInquiryMateItemPO();
                dIqrInquiryMateItemPO.setInquiryPkgId(seqRspBO3.getPkgDocId());
                dIqrInquiryMateItemPO.setInquiryId(seqEnquiryRspBO.getDocId());
                dIqrInquiryMateItemPO.setValidStatus(Constants.IS_VALID_Y);
                dIqrInquiryMateItemPO.setDetailNum(reqBO.getGoodsDetailList().size());
                dIqrInquiryMateItemPO.setPkgTotalAmount(sumAmount);
                dIqrInquiryMateItemPO.setCreateDate(operDate);
                if (purchaseAccount != null) {
                    dIqrInquiryMateItemPO.setPurchaseAccount(purchaseAccount);
                }
                if (purchaseAccountName != null && !"".equals(purchaseAccountName)) {
                    dIqrInquiryMateItemPO.setPurchaseAccountName(purchaseAccountName);
                }
                if ((dIqrInquiryMateItemResult = this.dIqrInquiryMateItemMapper.insertSelective(dIqrInquiryMateItemPO)) < 1) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u5305\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
            }
        }
        if (("1".equals(reqBO.getBusiType()) || "2".equals(reqBO.getBusiType()) && "1".equals(reqBO.getQuoteMethod() + "")) && CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsDetailList())) {
            for (GoodsDetailBO goodsDetailBO : reqBO.getGoodsDetailList()) {
                DIqrInquiryDetailPO dIqrInquiryDetailPO = new DIqrInquiryDetailPO();
                log.info("\u6267\u884c\u5355\u660e\u7ec6Bo\u5165\u53c2+" + goodsDetailBO.toString());
                BeanUtils.copyProperties((Object)goodsDetailBO, (Object)dIqrInquiryDetailPO);
                seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("21");
                seqRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                dIqrInquiryDetailPO.setInquiryItemId(seqRspBO.getDocId());
                dIqrInquiryDetailPO.setInquiryId(seqEnquiryRspBO.getDocId());
                if ("1".equals(reqBO.getQuoteMethod() + "")) {
                    dIqrInquiryDetailPO.setInquiryPkgId(allInquiryPkdId);
                }
                dIqrInquiryDetailPO.setGoodsNumber(goodsDetailBO.getGoodsNumber().multiply(amount).longValue());
                dIqrInquiryDetailPO.setBudgetPrice(goodsDetailBO.getBudgetPrice().multiply(amount).longValue());
                dIqrInquiryDetailPO.setBudgetAmount(goodsDetailBO.getBudgetPrice().multiply(amount).multiply(goodsDetailBO.getGoodsNumber()).longValue());
                if ("2".equals(reqBO.getBusiType())) {
                    if (goodsDetailBO.getProductionDate() != null && !"".equals(goodsDetailBO.getProductionDate())) {
                        if (goodsDetailBO.getProductionDate().length() == 10) {
                            dIqrInquiryDetailPO.setProductionDate(DateUtils.strToDate((String)goodsDetailBO.getProductionDate(), (String)"yyyy-MM-dd"));
                        } else {
                            dIqrInquiryDetailPO.setProductionDate(DateUtils.strToDateLong((String)goodsDetailBO.getProductionDate()));
                        }
                    }
                    if (goodsDetailBO.getEvalAmount() != null) {
                        dIqrInquiryDetailPO.setEvalAmount(goodsDetailBO.getEvalAmount().multiply(amount).longValue());
                    }
                    if (goodsDetailBO.getOriginalAmount() != null) {
                        dIqrInquiryDetailPO.setOriginalAmount(goodsDetailBO.getOriginalAmount().multiply(amount).longValue());
                    }
                    if (goodsDetailBO.getShowAmount() != null) {
                        dIqrInquiryDetailPO.setShowAmount(goodsDetailBO.getShowAmount().multiply(amount).longValue());
                    }
                }
                dIqrInquiryDetailPO.setValidStatus(Constants.IS_VALID_Y);
                dIqrInquiryDetailPO.setCreateUserId(reqBO.getOperId());
                dIqrInquiryDetailPO.setCreateUserName(reqBO.getOperName());
                dIqrInquiryDetailPO.setCreateTime(operDate);
                if ("Y".equals(reqBO.getPublishFlag())) {
                    dIqrInquiryDetailPO.setDocStatus(Constants.INQUIRY_DETAIL_DOC_STATUS_22002);
                    dIqrInquiryDetailPO.setNodeStatus("22102");
                } else {
                    dIqrInquiryDetailPO.setDocStatus(Constants.INQUIRY_DETAIL_DOC_STATUS_22001);
                    dIqrInquiryDetailPO.setNodeStatus("22101");
                }
                dIqrInquiryDetailPO.setUnitNameInfo(goodsDetailBO.getUnitNameInfo());
                dIqrInquiryDetailPO.setRecommendBrandName(goodsDetailBO.getRecommendBrandName());
                log.info("\u65b0\u589e\u6267\u884c\u5355\u660e\u7ec6\u4fe1\u606f\u5165\u53c2" + dIqrInquiryDetailPO.toString());
                detailResult = this.dIqrInquiryDetailMapper.insertSelective(dIqrInquiryDetailPO);
                if (detailResult < 1) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
                if (!CollectionUtils.isNotEmpty((Collection)goodsDetailBO.getGoodsPicList())) continue;
                detailPicPOList = new ArrayList<DIqrInquiryDetailPicPO>();
                for (GoodsPicInfoBO goodsPicInfoBO : goodsDetailBO.getGoodsPicList()) {
                    detailPicPO = new DIqrInquiryDetailPicPO();
                    detailPicPO.setInquiryItemId(seqRspBO.getDocId());
                    detailPicPO.setInquiryId(seqEnquiryRspBO.getDocId());
                    detailPicPO.setValidStatus(Constants.IS_VALID_Y);
                    log.info("==getGoodsDetailList==goodsPicInfoBO.getPicType()=" + goodsPicInfoBO.getPicType());
                    log.info("==getGoodsDetailList==goodsPicInfoBO.getPicUrl()=" + goodsPicInfoBO.getPicUrl());
                    detailPicPO.setPicType(goodsPicInfoBO.getPicType());
                    detailPicPO.setPicUrl(goodsPicInfoBO.getPicUrl());
                    detailPicPOList.add(detailPicPO);
                }
                picCnt = this.dIqrInquiryDetailPicMapper.insertDetailPicBatch(detailPicPOList);
                if (picCnt >= 0) continue;
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u660e\u7ec6\u56fe\u7247\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        } else if ("2".equals(reqBO.getBusiType()) && CollectionUtils.isNotEmpty(biddingDetailList)) {
            for (InquiryDetailBO inquiryDetailBO : biddingDetailList) {
                DIqrInquiryDetailPO dIqrInquiryDetailPO = new DIqrInquiryDetailPO();
                BeanUtils.copyProperties((Object)inquiryDetailBO, (Object)dIqrInquiryDetailPO);
                seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("21");
                seqRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                dIqrInquiryDetailPO.setInquiryPkgId(inquiryDetailBO.getInquiryPkgId());
                log.info("dIqrInquiryDetailPO.getInquiryPkgId()=" + dIqrInquiryDetailPO.getInquiryPkgId());
                dIqrInquiryDetailPO.setInquiryItemId(seqRspBO.getDocId());
                dIqrInquiryDetailPO.setInquiryId(seqEnquiryRspBO.getDocId());
                if ("1".equals(reqBO.getQuoteMethod() + "")) {
                    dIqrInquiryDetailPO.setInquiryPkgId(allInquiryPkdId);
                }
                dIqrInquiryDetailPO.setGoodsNumber(inquiryDetailBO.getGoodsNumber().multiply(amount).longValue());
                dIqrInquiryDetailPO.setBudgetPrice(inquiryDetailBO.getBudgetPrice().multiply(amount).longValue());
                dIqrInquiryDetailPO.setBudgetAmount(inquiryDetailBO.getBudgetPrice().multiply(amount).multiply(inquiryDetailBO.getGoodsNumber()).longValue());
                if ("2".equals(reqBO.getBusiType())) {
                    if (inquiryDetailBO.getProductionDate() != null && !"".equals(inquiryDetailBO.getProductionDate())) {
                        dIqrInquiryDetailPO.setProductionDate(DateUtils.strToDateLong((String)inquiryDetailBO.getProductionDate()));
                    }
                    if (inquiryDetailBO.getEvalAmount() != null) {
                        dIqrInquiryDetailPO.setEvalAmount(inquiryDetailBO.getEvalAmount().multiply(amount).longValue());
                    }
                    if (inquiryDetailBO.getOriginalAmount() != null) {
                        dIqrInquiryDetailPO.setOriginalAmount(inquiryDetailBO.getOriginalAmount().multiply(amount).longValue());
                    }
                    if (inquiryDetailBO.getShowAmount() != null) {
                        dIqrInquiryDetailPO.setShowAmount(inquiryDetailBO.getShowAmount().multiply(amount).longValue());
                    }
                }
                dIqrInquiryDetailPO.setValidStatus(Constants.IS_VALID_Y);
                dIqrInquiryDetailPO.setCreateUserId(reqBO.getOperId());
                dIqrInquiryDetailPO.setCreateUserName(reqBO.getOperName());
                dIqrInquiryDetailPO.setCreateTime(operDate);
                if ("Y".equals(reqBO.getPublishFlag())) {
                    dIqrInquiryDetailPO.setDocStatus(Constants.INQUIRY_DETAIL_DOC_STATUS_22002);
                    dIqrInquiryDetailPO.setNodeStatus("22102");
                } else {
                    dIqrInquiryDetailPO.setDocStatus(Constants.INQUIRY_DETAIL_DOC_STATUS_22001);
                    dIqrInquiryDetailPO.setNodeStatus("22101");
                }
                dIqrInquiryDetailPO.setUnitNameInfo(inquiryDetailBO.getUnitNameInfo());
                dIqrInquiryDetailPO.setRecommendBrandName(inquiryDetailBO.getRecommendBrandName());
                log.info("\u65b0\u589e\u6267\u884c\u5355\u660e\u7ec6\u4fe1\u606f\u5165\u53c2" + dIqrInquiryDetailPO.toString());
                detailResult = this.dIqrInquiryDetailMapper.insertSelective(dIqrInquiryDetailPO);
                if (detailResult < 1) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
                if (!CollectionUtils.isNotEmpty((Collection)inquiryDetailBO.getGoodsPicList())) continue;
                log.info("==biddingDetailList==bmGoodsDetailBO.getGoodsPicList()=" + inquiryDetailBO.getGoodsPicList());
                detailPicPOList = new ArrayList();
                for (GoodsPicInfoBO goodsPicInfoBO : inquiryDetailBO.getGoodsPicList()) {
                    detailPicPO = new DIqrInquiryDetailPicPO();
                    detailPicPO.setInquiryItemId(seqRspBO.getDocId());
                    detailPicPO.setInquiryId(seqEnquiryRspBO.getDocId());
                    detailPicPO.setValidStatus(Constants.IS_VALID_Y);
                    log.info("==biddingDetailList==goodsPicInfoBO.getPicType()=" + goodsPicInfoBO.getPicType());
                    log.info("==biddingDetailList==goodsPicInfoBO.getPicUrl()=" + goodsPicInfoBO.getPicUrl());
                    detailPicPO.setPicType(goodsPicInfoBO.getPicType());
                    detailPicPO.setPicUrl(goodsPicInfoBO.getPicUrl());
                    detailPicPOList.add(detailPicPO);
                }
                picCnt = this.dIqrInquiryDetailPicMapper.insertDetailPicBatch(detailPicPOList);
                if (picCnt >= 0) continue;
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u6267\u884c\u5355\u660e\u7ec6\u56fe\u7247\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getInquiryAttachmentInfoList())) {
            log.info("reqBO.getInquiryAttachmentInfoList().size=" + reqBO.getInquiryAttachmentInfoList().size());
            for (InquiryAttachmentBO inquiryAttachmentBO : reqBO.getInquiryAttachmentInfoList()) {
                RPlanAttachmentInfoPO rPlanAttachmentInfoPO = new RPlanAttachmentInfoPO();
                BeanUtils.copyProperties((Object)inquiryAttachmentBO, (Object)rPlanAttachmentInfoPO);
                seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("99");
                SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                rPlanAttachmentInfoPO.setAttachmentId(seqEnquiryPubRspBO.getDocId());
                rPlanAttachmentInfoPO.setObjectId(seqEnquiryRspBO.getDocId());
                rPlanAttachmentInfoPO.setCreateUserId(reqBO.getOperId());
                rPlanAttachmentInfoPO.setCreateUserName(reqBO.getOperName());
                rPlanAttachmentInfoPO.setCreateTime(operDate);
                rPlanAttachmentInfoPO.setObjectType(2);
                rPlanAttachmentInfoPO.setValidFlag(String.valueOf(Constants.IS_VALID_Y));
                int resultattach = this.rPlanAttachmentInfoMapper.insertSelective(rPlanAttachmentInfoPO);
                if (resultattach >= 1) continue;
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        if ("Y".equals(reqBO.getPublishFlag())) {
            DIqrPurchaseNoticePO dIqrPurchaseNoticePO = new DIqrPurchaseNoticePO();
            SeqEnquiryReqBO seqEnquiryReqBO2 = new SeqEnquiryReqBO();
            seqEnquiryReqBO2.setSystemId("ZH01");
            seqEnquiryReqBO2.setSeqType("99");
            SeqEnquiryRspBO seqNoticeRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO2);
            log.info("publishExecOrder:seqNoticeRspBO.getDocId()=" + seqNoticeRspBO.getDocId());
            dIqrPurchaseNoticePO.setInquiryCode(dIqrInquiryMatePO.getInquiryCode());
            dIqrPurchaseNoticePO.setInquiryName(dIqrInquiryMatePO.getInquiryName());
            dIqrPurchaseNoticePO.setDeliveryDateMethod(dIqrInquiryMatePO.getDeliveryDateMethod());
            dIqrPurchaseNoticePO.setIqrSeq(dIqrInquiryMatePO.getIqrSeq());
            dIqrPurchaseNoticePO.setPlanClass(dIqrInquiryMatePO.getPlanClass());
            dIqrPurchaseNoticePO.setInventoryClass(dIqrInquiryMatePO.getInventoryClass());
            dIqrPurchaseNoticePO.setProfessionalOrgId(dIqrInquiryMatePO.getProfessionalOrgId());
            dIqrPurchaseNoticePO.setProfessionalOrgName(dIqrInquiryMatePO.getProfessionalOrgName());
            dIqrPurchaseNoticePO.setQuoteEndDate(dIqrInquiryMatePO.getQuoteEndDate());
            dIqrPurchaseNoticePO.setLimitQuoteDate(dIqrInquiryMatePO.getLimitQuoteDate());
            dIqrPurchaseNoticePO.setRegistBeginDate(dIqrInquiryMatePO.getRegistBeginDate());
            dIqrPurchaseNoticePO.setRegistEndDate(dIqrInquiryMatePO.getRegistEndDate());
            dIqrPurchaseNoticePO.setPurchaseCategory(dIqrInquiryMatePO.getPlanCategory());
            dIqrPurchaseNoticePO.setReqArrivalDate(dIqrInquiryMatePO.getReqArrivalDate());
            dIqrPurchaseNoticePO.setReqArrivalPeriod(dIqrInquiryMatePO.getReqArrivalPeriod());
            dIqrPurchaseNoticePO.setPurchaserId(dIqrInquiryMatePO.getPurchaserId());
            dIqrPurchaseNoticePO.setPurchaserName(dIqrInquiryMatePO.getPurchaserName());
            if (dIqrInquiryMatePO.getPurchaseAccountsJson() != null && !"".equals(dIqrInquiryMatePO.getPurchaseAccountsJson())) {
                dIqrPurchaseNoticePO.setPurchaseAccountId(Long.parseLong(dIqrInquiryMatePO.getPurchaseAccountsJson()));
            }
            dIqrPurchaseNoticePO.setPurchaseAccountName(dIqrInquiryMatePO.getPurchaseAccountsNameJson());
            if (dIqrInquiryMatePO.getPurchaseIdJson() != null && !"".equals(dIqrInquiryMatePO.getPurchaseIdJson())) {
                dIqrPurchaseNoticePO.setPurchaseId(Long.parseLong(dIqrInquiryMatePO.getPurchaseIdJson()));
            }
            dIqrPurchaseNoticePO.setPurchaseName(dIqrInquiryMatePO.getPurchaseName());
            dIqrPurchaseNoticePO.setNoticeId(seqNoticeRspBO.getDocId());
            dIqrPurchaseNoticePO.setInquiryId(seqEnquiryRspBO.getDocId());
            dIqrPurchaseNoticePO.setValidStatus(Constants.IS_VALID_Y);
            dIqrPurchaseNoticePO.setPublishTime(operDate);
            dIqrPurchaseNoticePO.setBusiType(dIqrInquiryMatePO.getBusiType());
            dIqrPurchaseNoticePO.setDocType(docType);
            int ret = this.dIqrPurchaseNoticeMapper.insertSelective(dIqrPurchaseNoticePO);
            if (ret < 0) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6267\u884c\u5355\u516c\u544a\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        HIqrFormApprNodePO hIqrFormApprNodePO = new HIqrFormApprNodePO();
        seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("ZH01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqEnquiryRspBO2 = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        hIqrFormApprNodePO.setIqrNodeRecId(seqEnquiryRspBO2.getDocId());
        hIqrFormApprNodePO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
        hIqrFormApprNodePO.setInquiryCode(dIqrInquiryMatePO.getInquiryCode());
        hIqrFormApprNodePO.setInquiryName(dIqrInquiryMatePO.getInquiryName());
        hIqrFormApprNodePO.setPurchaseCategor(1);
        if ("Y".equals(reqBO.getPublishFlag())) {
            hIqrFormApprNodePO.setBusiStatusId(Integer.parseInt("2202"));
            hIqrFormApprNodePO.setBusiStatus(this.qryDicAtomService.getDicCodeName("BUSI_STATUS", "2202"));
            hIqrFormApprNodePO.setNodeStatusId(Integer.parseInt("2102"));
            hIqrFormApprNodePO.setNodeStatus(this.qryDicAtomService.getDicCodeName("INQ_NODE_STATUS", "2102"));
            hIqrFormApprNodePO.setDocStatusId(Integer.parseInt("2002"));
            hIqrFormApprNodePO.setDocStatus(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", "2002"));
        } else {
            hIqrFormApprNodePO.setBusiStatusId(Integer.parseInt("2201"));
            hIqrFormApprNodePO.setBusiStatus(this.qryDicAtomService.getDicCodeName("BUSI_STATUS", "2201"));
            hIqrFormApprNodePO.setNodeStatusId(Integer.parseInt("2101"));
            hIqrFormApprNodePO.setNodeStatus(this.qryDicAtomService.getDicCodeName("INQ_NODE_STATUS", "2101"));
            hIqrFormApprNodePO.setDocStatusId(Integer.parseInt("2001"));
            hIqrFormApprNodePO.setDocStatus(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", "2001"));
        }
        hIqrFormApprNodePO.setCreateTime(operDate);
        hIqrFormApprNodePO.setOperId(reqBO.getOperId());
        hIqrFormApprNodePO.setOperName(reqBO.getOperName());
        hIqrFormApprNodePO.setOperTime(operDate);
        hIqrFormApprNodePO.setRemark("\u6267\u884c\u5355\u521b\u5efa");
        int hIqrFormApprNodeResult = this.hIqrFormApprNodeMapper.insertSelective(hIqrFormApprNodePO);
        if (hIqrFormApprNodeResult < 1) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u8282\u70b9\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            return rspBO;
        }
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("ZH01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqOperLogRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        cAllOperLogPO.setHisId(seqOperLogRspBO.getDocId());
        if ("1".equals(reqBO.getBusiType())) {
            cAllOperLogPO.setDocId(reqBO.getPlanId());
            cAllOperLogPO.setOperLink("\u7b56\u5212\u9700\u6c42\u5355");
            cAllOperLogPO.setOperBehavior("\u7b56\u5212\u9700\u6c42\u5355");
            cAllOperLogPO.setRemark("\u5927\u5355\u8bae\u4ef7\u6267\u884c\u5355\u521b\u5efa\u6210\u529f");
        } else {
            cAllOperLogPO.setDocId(seqEnquiryRspBO.getDocId());
            cAllOperLogPO.setOperLink("\u6267\u884c\u5355\u521b\u5efa");
            cAllOperLogPO.setOperBehavior("\u6267\u884c\u5355\u521b\u5efa");
            cAllOperLogPO.setRemark("\u5197\u4f59\u7269\u8d44\u6267\u884c\u5355\u521b\u5efa\u6210\u529f");
        }
        cAllOperLogPO.setOperId(reqBO.getOperId());
        cAllOperLogPO.setOperName(reqBO.getOperName());
        cAllOperLogPO.setOperOrgId(reqBO.getPlanDepart());
        cAllOperLogPO.setOperOrgName(reqBO.getPlanDepartName());
        cAllOperLogPO.setOperTime(operDate);
        cAllOperLogPO.setArrivalTime(operDate);
        int callResult = this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
        if (callResult < 1) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u8bb0\u5f55\u64cd\u4f5c\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            return rspBO;
        }
        if ("1".equals(reqBO.getBusiType()) && reqBO.getPlanId() != null) {
            DPlanMaterialPO dPlanMaterialPO = new DPlanMaterialPO();
            dPlanMaterialPO.setPlanId(reqBO.getPlanId());
            dPlanMaterialPO.setInquiryCreateDate(operDate);
            int dPlanResult = this.dPlanMaterialMapper.updateByPrimaryKeySelective(dPlanMaterialPO);
            if (dPlanResult < 1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u9700\u6c42\u5355\u8868\u6267\u884c\u5355\u751f\u6210\u65f6\u95f4\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        rspBO.setInquiryCode(reqBO.getInquiryCode());
        rspBO.setInquiryName(reqBO.getInquiryName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO.toString()=" + rspBO.toString());
        return rspBO;
    }

    private SaveExecOrderRspBO initParam(SaveExecOrderReqBO reqBO) {
        SaveExecOrderRspBO rspBO = new SaveExecOrderRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInquiryCode()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInquiryName()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5236\u5355\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperName() || reqBO.getOperName().equals("")) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5236\u5355\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCreateDate()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5236\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return rspBO;
    }
}

