/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.registdoc.bo.MarginSnBO;
import com.tydic.enquiry.api.registdoc.bo.QryMarginSnListReqBO;
import com.tydic.enquiry.api.registdoc.bo.QryMarginSnListRspBO;
import com.tydic.enquiry.api.registdoc.service.QryMarginSnListService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.dao.DIqrTransSerialMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.po.DIqrTransSerialPO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.QryMarginSnListService"})
public class QryMarginSnListServiceImpl
implements QryMarginSnListService {
    private static final Logger log = LoggerFactory.getLogger(QryMarginSnListServiceImpl.class);
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrTransSerialMapper dIqrTransSerialMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryMarginSnList"})
    public QryMarginSnListRspBO qryMarginSnList(@RequestBody QryMarginSnListReqBO qryMarginSnListReqBO) {
        List<DIqrTransSerialPO> transSerialPOList;
        DIqrInquiryMatePO dIqrInquiryMatePO;
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryMarginSnListReqBO=" + qryMarginSnListReqBO.toString());
        QryMarginSnListRspBO qryMarginSnListRspBO = new QryMarginSnListRspBO();
        DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(qryMarginSnListReqBO.getRegistId());
        if (dIqrRegistDocPO != null && (dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(dIqrRegistDocPO.getInquiryId())) != null && "Y".equals(dIqrInquiryMatePO.getMarginFlag()) && ("1".equals(dIqrInquiryMatePO.getBusiType()) || "2".equals(dIqrInquiryMatePO.getBusiType()) && !"4".equals(dIqrRegistDocPO.getAnyDog1())) && CollectionUtils.isNotEmpty(transSerialPOList = this.dIqrTransSerialMapper.selectTransSerialByRegistId(dIqrRegistDocPO.getRegistId()))) {
            List marginSnBOList = transSerialPOList.stream().map(e -> {
                MarginSnBO marginSnBO = new MarginSnBO();
                BeanUtils.copyProperties((Object)e, (Object)marginSnBO);
                if ("1".equals(e.getPayBusiType())) {
                    marginSnBO.setPurchaseId(dIqrRegistDocPO.getPurchaseId());
                    marginSnBO.setPurchaseName(dIqrRegistDocPO.getPurchaseName());
                } else {
                    marginSnBO.setPurchaseId(dIqrRegistDocPO.getSupplierId());
                    marginSnBO.setPurchaseName(dIqrRegistDocPO.getSupplierName());
                    marginSnBO.setPayOperId(e.getRefundUserId());
                    marginSnBO.setPayOperName(e.getRefundUserName());
                }
                marginSnBO.setChannelId(e.getPaymentInsId());
                marginSnBO.setChannelName(e.getPaymentInsName());
                marginSnBO.setTradeTime(DateUtils.dateToStrLong((Date)e.getTradeTime()));
                marginSnBO.setPayNotifyTransId(e.getOrderId());
                try {
                    marginSnBO.setTotalFee(MoneyUtils.Long2BigDecimal((Long)e.getTotalFee()));
                    marginSnBO.setRealFee(MoneyUtils.Long2BigDecimal((Long)e.getRealFee()));
                }
                catch (Exception exc) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + exc.getStackTrace());
                    qryMarginSnListRspBO.setRespCode("9999");
                    qryMarginSnListRspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                marginSnBO.setMemUserTypeName(this.qryDicAtomService.getDicCodeName("MEM_USER_TYPE", dIqrRegistDocPO.getAnyDog1()));
                return marginSnBO;
            }).collect(Collectors.toList());
            qryMarginSnListRspBO.setMarginSnList(marginSnBOList);
        }
        qryMarginSnListRspBO.setRespCode("0000");
        qryMarginSnListRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryMarginSnListRspBO=" + qryMarginSnListRspBO.toString());
        return qryMarginSnListRspBO;
    }
}

