/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.registdoc.bo.QryHadRegistInfoReqBO;
import com.tydic.enquiry.api.registdoc.bo.QryHadRegistInfoRspBO;
import com.tydic.enquiry.api.registdoc.bo.RegistIqrDocBO;
import com.tydic.enquiry.api.registdoc.service.QryHadRegistInfoService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.po.DIqrRegistMarginPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.QryHadRegistInfoService"})
public class QryHadRegistInfoServiceImpl
implements QryHadRegistInfoService {
    private static final Logger log = LoggerFactory.getLogger(QryHadRegistInfoServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    DIqrRegistMarginMapper dIqrRegistMarginMapper;

    @PostMapping(value={"qryHadRegistInfo"})
    public QryHadRegistInfoRspBO qryHadRegistInfo(@RequestBody QryHadRegistInfoReqBO qryHadRegistInfoReqBO) {
        Page page = new Page(qryHadRegistInfoReqBO.getPageNo(), qryHadRegistInfoReqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        QryHadRegistInfoRspBO qryHadRegistInfoRspBO = new QryHadRegistInfoRspBO();
        List<DIqrRegistDocPO> iqrRegistDocPOList = null;
        if (!"ALL".equals(qryHadRegistInfoReqBO.getPurchaseMethod())) {
            map.put("purchaseMethod", qryHadRegistInfoReqBO.getPurchaseMethod());
        }
        if ("3".equals(qryHadRegistInfoReqBO.getIdentityFlag())) {
            map.put("unitId", qryHadRegistInfoReqBO.getCompanyId());
        } else if (!"0".equals(qryHadRegistInfoReqBO.getIdentityFlag()) && qryHadRegistInfoReqBO.getSupplierId() != null && qryHadRegistInfoReqBO.getSupplierId() != 0L) {
            map.put("supplierId", qryHadRegistInfoReqBO.getSupplierId());
        }
        map.put("purchaseId", qryHadRegistInfoReqBO.getPurchaseId());
        map.put("inquiryCode", qryHadRegistInfoReqBO.getInquiryCode());
        log.info("qryHadRegistInfoReqBO.getInquiryCode()=" + qryHadRegistInfoReqBO.getInquiryCode());
        map.put("inquiryName", qryHadRegistInfoReqBO.getInquiryName());
        log.info("qryHadRegistInfoReqBO.getSupplierId()=" + qryHadRegistInfoReqBO.getSupplierId());
        if (StringUtils.isNotEmpty((CharSequence)qryHadRegistInfoReqBO.getPayStatus())) {
            map.put("payStatus", qryHadRegistInfoReqBO.getPayStatus());
        }
        Date registTimeTemp = DateUtils.strToDateLong((String)qryHadRegistInfoReqBO.getRegistTime());
        map.put("registTime", registTimeTemp);
        log.info("registTimeTemp=" + registTimeTemp);
        log.info("qryHadRegistInfoReqBO.getIsPagination()=" + qryHadRegistInfoReqBO.getIsPagination());
        map.put("busiType", qryHadRegistInfoReqBO.getBusiType());
        if (CollectionUtils.isNotEmpty((Collection)qryHadRegistInfoReqBO.getChoiceIds())) {
            map.put("idList", qryHadRegistInfoReqBO.getChoiceIds());
        }
        log.info("qryHadRegistInfoReqBO.getQuoteStatus()=" + qryHadRegistInfoReqBO.getQuoteStatus());
        if (StringUtils.isNotEmpty((CharSequence)qryHadRegistInfoReqBO.getQuoteStatus()) && !"1".equals(qryHadRegistInfoReqBO.getSupFlag())) {
            if ("1".equals(qryHadRegistInfoReqBO.getQuoteStatus())) {
                map.put("inquiryDocStatus", Integer.parseInt("2008"));
                map.put("quoteStatusStr", "wait");
            } else {
                map.put("quoteStatusStr", "finish");
            }
        }
        iqrRegistDocPOList = "Y".equals(qryHadRegistInfoReqBO.getIsPagination()) ? this.dIqrRegistDocMapper.queryHadRegistInfoForPage(map, (Page<Map<String, Object>>)page) : this.dIqrRegistDocMapper.queryHadRegistInfoNoPage(map);
        log.info("queryHadRegistInfo end");
        List registIqrDocBOList = null;
        if (CollectionUtils.isNotEmpty(iqrRegistDocPOList)) {
            log.info("iqrRegistDocPOList.size()=" + iqrRegistDocPOList.size());
            registIqrDocBOList = iqrRegistDocPOList.stream().map(e -> {
                RegistIqrDocBO registIqrDocBO = new RegistIqrDocBO();
                BeanUtils.copyProperties((Object)e, (Object)registIqrDocBO);
                registIqrDocBO.setIsConfirmFlag("N");
                registIqrDocBO.setMemUserType(e.getAnyDog1());
                registIqrDocBO.setQuoteBeginDate(DateUtils.dateToStr((Date)e.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDocBO.setQuoteEndDate(DateUtils.dateToStr((Date)e.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDocBO.setRegistBeginDate(DateUtils.dateToStr((Date)e.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDocBO.setRegistEndDate(DateUtils.dateToStr((Date)e.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDocBO.setRegistTime(DateUtils.dateToStr((Date)e.getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDocBO.setRegistTimeReq(DateUtils.dateToStr((Date)e.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss") + " \u81f3 " + DateUtils.dateToStr((Date)e.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDocBO.setQuoteTimeReq(DateUtils.dateToStr((Date)e.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss") + " \u81f3 " + DateUtils.dateToStr((Date)e.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (e.getPayDate() != null) {
                    registIqrDocBO.setPayDate(DateUtils.dateToStr((Date)e.getPayDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (e.getRefundDate() != null) {
                    registIqrDocBO.setRefundDate(DateUtils.dateToStr((Date)e.getRefundDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                BigDecimal amount = new BigDecimal(10000);
                if (e.getMarginAmount() != null) {
                    BigDecimal marginAmountTemp = new BigDecimal(e.getMarginAmount());
                    log.info("marginAmountTemp=" + marginAmountTemp);
                    registIqrDocBO.setMarginAmount(marginAmountTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
                }
                log.info("registIqrDocBO.getMarginAmount()=" + registIqrDocBO.getMarginAmount());
                String payStatusTemp = "";
                if (e.getDocType() != null) {
                    registIqrDocBO.setPurchaseMethod(Integer.valueOf(Integer.parseInt(e.getDocType())));
                    registIqrDocBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", e.getDocType() + ""));
                }
                if (qryHadRegistInfoReqBO.getSupplierId() != null) {
                    if (qryHadRegistInfoReqBO.getSupplierId().equals(e.getSupplierId())) {
                        registIqrDocBO.setIsShowRegistSit("Y");
                    } else {
                        registIqrDocBO.setIsShowRegistSit("N");
                    }
                }
                if ("1".equals(e.getPayStatus())) {
                    registIqrDocBO.setIsPayFlag("N");
                    registIqrDocBO.setIsRefundFlag("N");
                } else if ("2".equals(e.getPayStatus()) || "5".equals(e.getPayStatus())) {
                    String isPayFlag = "";
                    List<DIqrRegistMarginPO> dIqrRegistMarginPOList = this.dIqrRegistMarginMapper.selectRegistMarginByRegistId(e.getRegistId());
                    if ("2".equals(e.getQuoteMethod() + "") && CollectionUtils.isNotEmpty(dIqrRegistMarginPOList)) {
                        int hadMarginCnt = 0;
                        for (DIqrRegistMarginPO iqrRegistMargin : dIqrRegistMarginPOList) {
                            log.info("=QryHadRegistInfoService==iqrRegistMargin.getPayStatus()=" + iqrRegistMargin.getPayStatus());
                            if (!"Y".equals(iqrRegistMargin.getPayStatus())) continue;
                            ++hadMarginCnt;
                        }
                        log.info("=QryHadRegistInfoService==hadMarginCnt=" + hadMarginCnt);
                        if (hadMarginCnt == dIqrRegistMarginPOList.size()) {
                            isPayFlag = "Y";
                        } else {
                            isPayFlag = "N";
                            payStatusTemp = "5";
                        }
                    } else {
                        isPayFlag = "Y";
                    }
                    registIqrDocBO.setIsPayFlag(isPayFlag);
                    registIqrDocBO.setIsRefundFlag("N");
                } else if ("3".equals(e.getPayStatus())) {
                    registIqrDocBO.setIsPayFlag("N");
                    registIqrDocBO.setIsRefundFlag("Y");
                } else {
                    registIqrDocBO.setIsPayFlag("N");
                    registIqrDocBO.setIsRefundFlag("N");
                }
                log.info("=QryHadRegistInfoService==payStatusTemp=" + payStatusTemp);
                if (StringUtils.isNotEmpty((CharSequence)payStatusTemp)) {
                    registIqrDocBO.setPayStatus(payStatusTemp);
                    registIqrDocBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", payStatusTemp));
                } else {
                    log.info("=QryHadRegistInfoService==e.getPayStatus()=" + e.getPayStatus());
                    registIqrDocBO.setPayStatus(e.getPayStatus());
                    registIqrDocBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", e.getPayStatus()));
                }
                DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(e.getInquiryId());
                if (dIqrInquiryMatePO != null) {
                    if ("N".equals(dIqrInquiryMatePO.getMarginFlag()) || "21".equals(dIqrInquiryMatePO.getDocType()) || "22".equals(dIqrInquiryMatePO.getDocType()) || "2".equals(dIqrInquiryMatePO.getBusiType()) && "4".equals(e.getAnyDog1())) {
                        registIqrDocBO.setIsNeedPayFlag("N");
                    } else {
                        registIqrDocBO.setIsNeedPayFlag("Y");
                    }
                    registIqrDocBO.setDocStatus(dIqrInquiryMatePO.getDocStatus());
                    registIqrDocBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", registIqrDocBO.getDocStatus() + ""));
                    if ("2005".equals(dIqrInquiryMatePO.getDocStatus()) || "2006".equals(dIqrInquiryMatePO.getDocStatus()) || "2007".equals(dIqrInquiryMatePO.getDocStatus()) || "2008".equals(dIqrInquiryMatePO.getDocStatus()) || "2009".equals(dIqrInquiryMatePO.getDocStatus())) {
                        registIqrDocBO.setIsConfirmFlag("Y");
                    }
                }
                return registIqrDocBO;
            }).collect(Collectors.toList());
        }
        log.info("registIqrDocBOList\u8d4b\u503c\u5b8c\u6210");
        qryHadRegistInfoRspBO.setPageNo(qryHadRegistInfoReqBO.getPageNo());
        qryHadRegistInfoRspBO.setTotal(page.getTotalPages());
        qryHadRegistInfoRspBO.setRecordsTotal(page.getTotalCount());
        qryHadRegistInfoRspBO.setRows(registIqrDocBOList);
        qryHadRegistInfoRspBO.setRespCode("0000");
        qryHadRegistInfoRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryHadRegistInfoRspBO=" + qryHadRegistInfoRspBO.toString());
        return qryHadRegistInfoRspBO;
    }
}

