/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.util;

import com.tydic.enquiry.util.Base64Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuoteUtil {
    private static final Log log = LogFactory.getLog(QuoteUtil.class);
    private static final String separator = "$@$@$";

    public static Long decode(String priceSec, String salt) {
        if (StringUtils.isBlank((CharSequence)priceSec)) {
            return null;
        }
        Long price = null;
        try {
            String priceStep1 = Base64Util.decode(priceSec);
            String priceStep2 = Base64Util.decode(QuoteUtil.removeSalt(priceStep1));
            String priceStep3 = Base64Util.decode(StringUtils.reverse((String)priceStep2));
            price = Long.parseLong(priceStep3);
        }
        catch (Exception e) {
            log.error((Object)"\u62a5\u4ef7\u89e3\u5bc6\u51fa\u9519", (Throwable)e);
        }
        return price;
    }

    public static String encode(Long price, String salt) {
        if (price == null || price == 0L) {
            return null;
        }
        String priceSec = null;
        try {
            String priceStr = String.valueOf(price);
            String priceStrStep1 = Base64Util.encode(priceStr);
            String priceStrStep2 = Base64Util.encode(StringUtils.reverse((String)priceStrStep1));
            priceSec = Base64Util.encode(QuoteUtil.appendSalt(priceStrStep2, salt));
        }
        catch (Exception e) {
            log.error((Object)"\u62a5\u4ef7\u52a0\u5bc6\u51fa\u9519", (Throwable)e);
        }
        return priceSec;
    }

    private static String appendSalt(String str, String salt) {
        return StringUtils.join((Object[])new String[]{str, salt}, (String)separator);
    }

    private static String removeSalt(String str) {
        return StringUtils.split((String)str, (String)separator)[0];
    }

    public static void main(String[] args) {
        System.out.println(QuoteUtil.encode(12000000000L, "20210423000148"));
        System.out.println(QuoteUtil.decode("UFQxQlRYZEJSRTEzUVVSTmQwbFVUUT09JEAkQCQyMDIxMDQyMzAwMDE0OA==", "20210423000148"));
        System.out.println(QuoteUtil.decode("UFQxQlRYZEJSRTEzUVVSTmVrbFVUUT09JEAkQCQyMDIxMDQyMzAwMDE0Mg==", "20210423000142"));
    }
}

