/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.sequence;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.sequence.bo.CodeEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.CodeEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqCodeCreateService;
import com.tydic.enquiry.dao.SPlanCodeMapper;
import com.tydic.enquiry.dao.SSystemParaMapper;
import com.tydic.enquiry.po.SPlanCodePO;
import com.tydic.enquiry.po.SSystemParaPO;
import com.tydic.enquiry.po.SSystemParaPOKey;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.sequence.service.SeqCodeCreateService"})
public class SeqCodeCreateServiceImpl
implements SeqCodeCreateService {
    private static final Logger log = LoggerFactory.getLogger(SeqCodeCreateServiceImpl.class);
    @Autowired
    private SSystemParaMapper sSystemParaMapper;
    @Autowired
    private SPlanCodeMapper sPlanCodeMapper;

    @PostMapping(value={"getSeqCode"})
    public CodeEnquiryRspBO getSeqCode(@RequestBody CodeEnquiryReqBO codeEnquiryReqBO) {
        log.info("\u5165\u53c2\u5bf9\u8c61\u4fe1\u606f\uff1acodeEnquiryReqBO=" + codeEnquiryReqBO.toString());
        String paraCode = codeEnquiryReqBO.getDocumentType() + codeEnquiryReqBO.getBusiType() + codeEnquiryReqBO.getPurchaseCategory();
        if (codeEnquiryReqBO.getPurchaseMethod() != null && !"".equals(codeEnquiryReqBO.getPurchaseMethod())) {
            paraCode = paraCode + codeEnquiryReqBO.getPurchaseMethod();
        }
        SSystemParaPOKey sSystemParaPOKey = new SSystemParaPOKey();
        sSystemParaPOKey.setSystemId(codeEnquiryReqBO.getSystemId());
        sSystemParaPOKey.setParaType("FIX_CODE");
        sSystemParaPOKey.setParaCode(paraCode);
        SSystemParaPO sSystemParaPO = this.sSystemParaMapper.selectByPrimaryKey(sSystemParaPOKey);
        String fixCode = sSystemParaPO.getParaValue1();
        log.info("fixCode=" + fixCode);
        String dateStr = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd");
        log.info("dateStr=" + dateStr);
        SPlanCodePO sPlanCodeQryPO = new SPlanCodePO();
        sPlanCodeQryPO.setCompanyCode(codeEnquiryReqBO.getSystemId());
        sPlanCodeQryPO.setFixCode(fixCode);
        sPlanCodeQryPO.setDateCode("*");
        SPlanCodePO sPlanCodePO = this.sPlanCodeMapper.selectIdByKey(sPlanCodeQryPO);
        String seqCode = sPlanCodePO.getId().toString();
        log.info("seqCode=" + seqCode);
        String docCode = fixCode + "-" + dateStr;
        for (int i = 0; i < 4 - seqCode.length(); ++i) {
            docCode = docCode + "0";
        }
        docCode = docCode + seqCode;
        log.info("docCode=" + docCode);
        SPlanCodePO sPlanCodeUpPO = new SPlanCodePO();
        sPlanCodeUpPO.setCompanyCode(sPlanCodePO.getCompanyCode());
        sPlanCodeUpPO.setFixCode(sPlanCodePO.getFixCode());
        sPlanCodeUpPO.setDateCode(sPlanCodePO.getDateCode());
        if (sPlanCodePO.getId() == 9999) {
            sPlanCodePO.setId(0);
        }
        sPlanCodeUpPO.setId(sPlanCodePO.getId() + 1);
        log.info("sPlanCodeUpPO.getId()=" + sPlanCodeUpPO.getId());
        int ret = this.sPlanCodeMapper.updateByKey(sPlanCodeUpPO);
        log.info("ret=" + ret);
        CodeEnquiryRspBO codeEnquiryRspBO = new CodeEnquiryRspBO();
        codeEnquiryRspBO.setRespCode("0000");
        codeEnquiryRspBO.setRespDesc("\u6210\u529f");
        codeEnquiryRspBO.setDocCode(docCode);
        log.info("\u51fa\u53c2\u5bf9\u8c61\u4fe1\u606f\uff1acodeEnquiryRspBO=" + codeEnquiryRspBO.toString());
        return codeEnquiryRspBO;
    }
}

