/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.atom.plan.impl;

import com.tydic.enquiry.api.plan.SavePlanOrderService;
import com.tydic.enquiry.api.plan.bo.PlanAttachmentBO;
import com.tydic.enquiry.api.plan.bo.PlanOrderDetailBO;
import com.tydic.enquiry.api.plan.bo.PlanOtherInfoBO;
import com.tydic.enquiry.api.plan.bo.PlanPurchaseInfoBO;
import com.tydic.enquiry.api.plan.bo.PlanSettleInfoBO;
import com.tydic.enquiry.api.plan.bo.PlanSupplierInfoBO;
import com.tydic.enquiry.api.plan.bo.SavePlanOrderReqBO;
import com.tydic.enquiry.api.plan.bo.SavePlanOrderRspBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.CPlanStatusNodeLogMapper;
import com.tydic.enquiry.dao.DPlanItemMaterialMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.dao.RPlanSupplierRelMapper;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.CPlanStatusNodeLogPO;
import com.tydic.enquiry.po.DPlanItemMaterialPO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import com.tydic.enquiry.po.RPlanSupplierRelPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.plan.SavePlanOrderService"})
public class SavePlanOrderServiceImpl
implements SavePlanOrderService {
    private static final Logger log = LoggerFactory.getLogger(SavePlanOrderServiceImpl.class);
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    private DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    private DPlanItemMaterialMapper dPlanItemMaterialMapper;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;
    @Autowired
    private RPlanSupplierRelMapper rPlanSupplierRelMapper;
    @Autowired
    private CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    private CPlanStatusNodeLogMapper cPlanStatusNodeLogMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"savePlanOrder"})
    public SavePlanOrderRspBO savePlanOrder(@RequestBody SavePlanOrderReqBO savePlanOrderReqBO) {
        SavePlanOrderRspBO savePlanOrderRspBO = new SavePlanOrderRspBO();
        log.info("\u5165\u53c2\u6570\u636e\uff1asavePlanOrderReqBO=" + savePlanOrderReqBO.toString());
        if (savePlanOrderReqBO.getPlanUnit() != null && savePlanOrderReqBO.getPlanUnitName() != null && savePlanOrderReqBO.getPlanUnitName().length() != 0 && savePlanOrderReqBO.getPlanDepart() != null && savePlanOrderReqBO.getPlanDepartName() != null && savePlanOrderReqBO.getPlanDepartName().length() != 0 && savePlanOrderReqBO.getPlanCode() != null && savePlanOrderReqBO.getPlanCode().length() != 0 && savePlanOrderReqBO.getPlanName() != null && savePlanOrderReqBO.getPlanName().length() != 0 && savePlanOrderReqBO.getOperId() != null && savePlanOrderReqBO.getOperName() != null && savePlanOrderReqBO.getOperName().length() != 0 && savePlanOrderReqBO.getCreateDate() != null && savePlanOrderReqBO.getCreateDate().length() != 0 && savePlanOrderReqBO.getPlanPurchaseInfo() != null && savePlanOrderReqBO.getPlanSettleInfo() != null && savePlanOrderReqBO.getPlanDetailList() != null && savePlanOrderReqBO.getPlanDetailList().size() != 0) {
            DPlanMaterialPO dPlanMaterialPO = new DPlanMaterialPO();
            ArrayList dPlanItemMaterialPOList = new ArrayList();
            RPlanSupplierRelPO rPlanSupplierRelPO = new RPlanSupplierRelPO();
            CPlanStatusNodeLogPO cPlanStatusNodeLogPO = new CPlanStatusNodeLogPO();
            Date now = new Date();
            Long operId = savePlanOrderReqBO.getOperId();
            String operName = savePlanOrderReqBO.getOperName();
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date createTime = simpleDateFormat.parse(savePlanOrderReqBO.getCreateDate());
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("1");
                Long planId = this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
                dPlanMaterialPO.setPlanId(planId);
                BeanUtils.copyProperties((Object)savePlanOrderReqBO, (Object)dPlanMaterialPO);
                dPlanMaterialPO.setCreateUserId(operId);
                dPlanMaterialPO.setCreateUserName(operName);
                dPlanMaterialPO.setCreateTime(now);
                PlanPurchaseInfoBO planPurchaseInfo = savePlanOrderReqBO.getPlanPurchaseInfo();
                if (planPurchaseInfo.getPurchaseAccount() != null && planPurchaseInfo.getPurchaseAccountName() != null && planPurchaseInfo.getPurchaseAccountName().length() != 0 && planPurchaseInfo.getDeliveryDateMethod() != null && planPurchaseInfo.getReqArrivalDate() != null && planPurchaseInfo.getReqArrivalDate().length() != 0 && planPurchaseInfo.getReqArrivalTimeInt() != null && planPurchaseInfo.getDeliveryAddr() != null && planPurchaseInfo.getDeliveryAddr().length() != 0 && planPurchaseInfo.getPurchaseMethod() != null && planPurchaseInfo.getPurchaseCategory() != null && planPurchaseInfo.getSupplierTendencyList() != null) {
                    List supplierTendencyList = planPurchaseInfo.getSupplierTendencyList();
                    for (PlanSupplierInfoBO planSupplierInfoBO : supplierTendencyList) {
                        if (planSupplierInfoBO.getSupplierId() != null && planSupplierInfoBO.getSupplierName() != null && planSupplierInfoBO.getSupplierName().length() != 0) {
                            rPlanSupplierRelPO.setPlanId(planId);
                            SeqEnquiryReqBO planOrderSupplierRelReqBO = new SeqEnquiryReqBO();
                            planOrderSupplierRelReqBO.setSystemId("ZH01");
                            planOrderSupplierRelReqBO.setSeqType("99");
                            rPlanSupplierRelPO.setPlanSupplierRelId(this.seqIdCreateService.getSeqId(planOrderSupplierRelReqBO).getDocId());
                            rPlanSupplierRelPO.setSupplierId(planSupplierInfoBO.getSupplierId());
                            rPlanSupplierRelPO.setSupplierName(planSupplierInfoBO.getSupplierName());
                            BeanUtils.copyProperties((Object)planPurchaseInfo, (Object)dPlanMaterialPO);
                            dPlanMaterialPO.setDocStatus(planPurchaseInfo.getPurchaseMethod());
                            dPlanMaterialPO.setDeliveryDateMethod(planPurchaseInfo.getDeliveryDateMethod().intValue());
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            dPlanMaterialPO.setReqArrivalDate(sdf.parse(planPurchaseInfo.getReqArrivalDate()));
                            dPlanMaterialPO.setReqArrivalTimeInt(planPurchaseInfo.getReqArrivalTimeInt().intValue());
                            dPlanMaterialPO.setDocType(planPurchaseInfo.getPurchaseMethod().toString());
                            continue;
                        }
                        log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u4f9b\u5e94\u5546\u4fe1\u606f\u53c2\u6570\u4e0d\u5168");
                        savePlanOrderRspBO.setRespCode("9999");
                        savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25,\u4f9b\u5e94\u5546\u4fe1\u606f\u53c2\u6570\u4e0d\u5168");
                        return savePlanOrderRspBO;
                    }
                } else {
                    log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u91c7\u8d2d\u4fe1\u606f\u53c2\u6570\u4e0d\u5168");
                    savePlanOrderRspBO.setRespCode("9999");
                    savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25,\u91c7\u8d2d\u4fe1\u606f\u53c2\u6570\u4e0d\u5168");
                    return savePlanOrderRspBO;
                }
                PlanSettleInfoBO planSettleInfo = savePlanOrderReqBO.getPlanSettleInfo();
                if (planSettleInfo.getInvoiceId() == null || planSettleInfo.getInvoiceId().length() == 0 || planSettleInfo.getInvoiceTitle() == null || planSettleInfo.getInvoiceTitle().length() == 0 || planSettleInfo.getInvoiceType() == null || planSettleInfo.getInvoiceTitle().length() == 0 || planSettleInfo.getPayChannel() == null || planSettleInfo.getInvoiceTitle().length() == 0 || planSettleInfo.getPayType() == null || planSettleInfo.getInvoiceTitle().length() == 0) {
                    log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u7ed3\u7b97\u4fe1\u606f\u53c2\u6570\u4e0d\u5168");
                    savePlanOrderRspBO.setRespCode("9999");
                    savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25,\u7ed3\u7b97\u4fe1\u606f\u53c2\u6570\u4e0d\u5168");
                    return savePlanOrderRspBO;
                }
                BeanUtils.copyProperties((Object)planSettleInfo, (Object)dPlanMaterialPO);
                if (savePlanOrderReqBO.getPlanOtherInfo() != null) {
                    PlanOtherInfoBO planOtherInfo = savePlanOrderReqBO.getPlanOtherInfo();
                    if ("0".equals(planOtherInfo.getIsApprove()) || "1".equals(planOtherInfo.getIsApprove())) {
                        BeanUtils.copyProperties((Object)savePlanOrderReqBO.getPlanOtherInfo(), (Object)dPlanMaterialPO);
                    } else {
                        log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u662f\u5426\u9700\u8981\u5ba1\u6279\u53c2\u6570\u9519\u8bef");
                        savePlanOrderRspBO.setRespCode("9999");
                        savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25,\u5176\u4ed6\u4fe1\u606f\u662f\u5426\u9700\u8981\u5ba1\u6279\u53c2\u6570\u53c2\u6570\u6709\u8bef");
                        return savePlanOrderRspBO;
                    }
                }
                dPlanMaterialPO.setValidStatus(Constants.IS_VALID_Y);
                dPlanMaterialPO.setPurchaseId(savePlanOrderReqBO.getPlanUnit());
                dPlanMaterialPO.setPurchaseName(savePlanOrderReqBO.getPlanUnitName());
                dPlanMaterialPO.setBusiStatus(Integer.parseInt("1201"));
                dPlanMaterialPO.setBusiType("1");
                dPlanMaterialPO.setPlanDepart(savePlanOrderReqBO.getPlanDepart());
                dPlanMaterialPO.setPlanDepartName(savePlanOrderReqBO.getPlanDepartName());
                SeqEnquiryReqBO planNodeRel = new SeqEnquiryReqBO();
                planNodeRel.setSystemId("ZH01");
                planNodeRel.setSeqType("99");
                cPlanStatusNodeLogPO.setPlanNodeRelId(this.seqIdCreateService.getSeqId(planNodeRel).getDocId());
                cPlanStatusNodeLogPO.setPlanId(planId);
                cPlanStatusNodeLogPO.setPlanCode(savePlanOrderReqBO.getPlanCode());
                cPlanStatusNodeLogPO.setBusiStatusId(Integer.parseInt("1201"));
                cPlanStatusNodeLogPO.setBusiStatusName("\u8ba1\u5212\u5355\u521b\u5efa");
                cPlanStatusNodeLogPO.setNodeName("\u8ba1\u5212\u5355\u7f16\u5236\u4e2d");
                cPlanStatusNodeLogPO.setPlanProType(Integer.parseInt("1001"));
                cPlanStatusNodeLogPO.setCreateTime(now);
                cPlanStatusNodeLogPO.setOperId(operId);
                cPlanStatusNodeLogPO.setOperName(operName);
                cPlanStatusNodeLogPO.setOperBehavior("\u8ba1\u5212\u5355\u521b\u5efa");
                cPlanStatusNodeLogPO.setRemark("\u8ba1\u5212\u5355\u521b\u5efa");
                cPlanStatusNodeLogPO.setOperTime(now);
                cPlanStatusNodeLogPO.setNodeStatus(Integer.parseInt("1101"));
                cPlanStatusNodeLogPO.setDocStatusName("\u8349\u7a3f");
                CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
                planNodeRel.setSystemId("ZH01");
                planNodeRel.setSeqType("99");
                cAllOperLogPO.setHisId(this.seqIdCreateService.getSeqId(planNodeRel).getDocId());
                cAllOperLogPO.setDocId(planId);
                cAllOperLogPO.setOperLink("\u8ba1\u5212\u5355\u521b\u5efa");
                cAllOperLogPO.setOperId(operId);
                cAllOperLogPO.setOperName(operName);
                cAllOperLogPO.setOperOrgId(savePlanOrderReqBO.getPlanDepart());
                cAllOperLogPO.setOperOrgName(savePlanOrderReqBO.getPlanDepartName());
                cAllOperLogPO.setOperBehavior("\u8ba1\u5212\u5355\u521b\u5efa");
                cAllOperLogPO.setRemark("\u8ba1\u5212\u5355\u521b\u5efa\u6210\u529f");
                cAllOperLogPO.setOperTime(now);
                cAllOperLogPO.setArrivalTime(now);
                ArrayList<DPlanItemMaterialPO> detailList = new ArrayList<DPlanItemMaterialPO>();
                if (CollectionUtils.isNotEmpty((Collection)savePlanOrderReqBO.getPlanDetailList())) {
                    BigDecimal amount = new BigDecimal("0");
                    for (PlanOrderDetailBO planOrderDetailBO : savePlanOrderReqBO.getPlanDetailList()) {
                        if (planOrderDetailBO.getMaterialId() != null && planOrderDetailBO.getMaterialId().length() != 0 && planOrderDetailBO.getMaterialName() != null && planOrderDetailBO.getMaterialName().length() != 0 && planOrderDetailBO.getMaterialClassId() != null && planOrderDetailBO.getMaterialClassId().length() != 0 && planOrderDetailBO.getUnitName() != null && planOrderDetailBO.getUnitName().length() != 0 && planOrderDetailBO.getUnitNameInfo() != null && planOrderDetailBO.getUnitNameInfo().length() != 0 && planOrderDetailBO.getBudgetAmount() != null && planOrderDetailBO.getRequireNumber() != null && planOrderDetailBO.getBudgetPrice() != null) {
                            DPlanItemMaterialPO dPlanItemMaterialPO = new DPlanItemMaterialPO();
                            BeanUtils.copyProperties((Object)planOrderDetailBO, (Object)dPlanItemMaterialPO);
                            dPlanItemMaterialPO.setBudgetAmount(planOrderDetailBO.getBudgetPrice().multiply(planOrderDetailBO.getRequireNumber()).multiply(new BigDecimal("10000")).longValue());
                            dPlanItemMaterialPO.setRequireNumber(planOrderDetailBO.getRequireNumber().multiply(new BigDecimal("10000")).longValue());
                            dPlanItemMaterialPO.setBudgetPrice(planOrderDetailBO.getBudgetPrice().multiply(new BigDecimal("10000")).longValue());
                            SeqEnquiryReqBO planOrderDetailReq = new SeqEnquiryReqBO();
                            planOrderDetailReq.setSystemId("ZH01");
                            planOrderDetailReq.setSeqType("11");
                            dPlanItemMaterialPO.setPlanItemId(this.seqIdCreateService.getSeqId(planOrderDetailReq).getDocId());
                            dPlanItemMaterialPO.setPlanCode(savePlanOrderReqBO.getPlanCode());
                            dPlanItemMaterialPO.setPlanId(planId);
                            dPlanItemMaterialPO.setDocStatus(Integer.parseInt("1001"));
                            dPlanItemMaterialPO.setBusiStatus(Integer.parseInt("1201"));
                            dPlanItemMaterialPO.setNodeStatus("1101");
                            dPlanItemMaterialPO.setValidStatus(Constants.IS_VALID_Y);
                            dPlanItemMaterialPO.setCreateUserId(operId);
                            dPlanItemMaterialPO.setCreateUserName(operName);
                            dPlanItemMaterialPO.setCreateTime(now);
                            dPlanItemMaterialPO.setSubmitTime(now);
                            amount = amount.add(new BigDecimal(dPlanItemMaterialPO.getBudgetAmount().toString()));
                            detailList.add(dPlanItemMaterialPO);
                            continue;
                        }
                        log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u8ba1\u5212\u5355\u660e\u7ec6\u53c2\u6570\u4e0d\u5168");
                        savePlanOrderRspBO.setRespCode("9999");
                        savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25,\u8ba1\u5212\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                        return savePlanOrderRspBO;
                    }
                    log.info("dPlanItemMaterialPOList:" + ((Object)dPlanItemMaterialPOList).toString());
                    dPlanMaterialPO.setBudgetAmount(amount.longValue());
                } else {
                    log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u5165\u53c2\u6570\u636esavePlanOrderReqBO\u53c2\u6570\u4e0d\u5168");
                    savePlanOrderRspBO.setRespCode("9999");
                    savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u5165\u53c2\u6570\u636eBmSavePlanOrderReqBO\u53c2\u6570\u4e0d\u5168");
                }
                ArrayList<RPlanAttachmentInfoPO> attachmentList = new ArrayList<RPlanAttachmentInfoPO>();
                if (CollectionUtils.isNotEmpty((Collection)savePlanOrderReqBO.getPlanAttachmentInfoList())) {
                    for (PlanAttachmentBO planAttachmentBO : savePlanOrderReqBO.getPlanAttachmentInfoList()) {
                        RPlanAttachmentInfoPO rPlanAttachmentInfoPO = new RPlanAttachmentInfoPO();
                        BeanUtils.copyProperties((Object)planAttachmentBO, (Object)rPlanAttachmentInfoPO);
                        SeqEnquiryReqBO planAttachmentInfoReqBO = new SeqEnquiryReqBO();
                        planAttachmentInfoReqBO.setSystemId("ZH01");
                        planAttachmentInfoReqBO.setSeqType("99");
                        rPlanAttachmentInfoPO.setAttachmentId(this.seqIdCreateService.getSeqId(planAttachmentInfoReqBO).getDocId());
                        rPlanAttachmentInfoPO.setObjectId(planId);
                        rPlanAttachmentInfoPO.setObjectType(Constants.OBJECT_TYPE_1);
                        rPlanAttachmentInfoPO.setCreateTime(createTime);
                        rPlanAttachmentInfoPO.setCreateUserId(operId);
                        rPlanAttachmentInfoPO.setCreateUserName(operName);
                        rPlanAttachmentInfoPO.setValidFlag(Constants.IS_VALID_Y.toString());
                        attachmentList.add(rPlanAttachmentInfoPO);
                    }
                    log.info("planAttachmentInfoList:" + savePlanOrderReqBO.getPlanAttachmentInfoList().toString());
                }
                this.dPlanMaterialMapper.insert(dPlanMaterialPO);
                for (DPlanItemMaterialPO dPlanItemMaterialPO : detailList) {
                    this.dPlanItemMaterialMapper.insert(dPlanItemMaterialPO);
                }
                for (RPlanAttachmentInfoPO rPlanAttachmentInfoPO : attachmentList) {
                    this.rPlanAttachmentInfoMapper.insert(rPlanAttachmentInfoPO);
                }
                this.rPlanSupplierRelMapper.insert(rPlanSupplierRelPO);
                this.cPlanStatusNodeLogMapper.insert(cPlanStatusNodeLogPO);
                this.cAllOperLogMapper.insert(cAllOperLogPO);
                savePlanOrderRspBO.setRespCode("0000");
                savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u6210\u529f");
                savePlanOrderRspBO.setPlanId(planId);
                savePlanOrderRspBO.setPlanCode(savePlanOrderReqBO.getPlanCode());
            }
            catch (Exception e) {
                log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25:" + e.toString());
                savePlanOrderRspBO.setRespCode("9999");
                savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25");
            }
        } else {
            log.error("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u5165\u53c2\u6570\u636esavePlanOrderReqBO\u53c2\u6570\u4e0d\u5168");
            savePlanOrderRspBO.setRespCode("9999");
            savePlanOrderRspBO.setRespDesc("\u8ba1\u5212\u5355\u521b\u5efa\u5931\u8d25: \u5165\u53c2\u6570\u636eBmSavePlanOrderReqBO\u53c2\u6570\u4e0d\u5168");
        }
        return savePlanOrderRspBO;
    }
}

