/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocReqBO;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocRspBO;
import com.tydic.enquiry.api.registdoc.service.CreateRisunRegistDocService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.CreateRisunRegistDocService"})
public class CreateRisunRegistDocServiceImpl
implements CreateRisunRegistDocService {
    private static final Logger log = LoggerFactory.getLogger(CreateRisunRegistDocServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"risunRegistDocCreate"})
    public CreateRisunRegistDocRspBO risunRegistDocCreate(@RequestBody CreateRisunRegistDocReqBO reqBO) {
        log.info("\u62a5\u540d\u5355\u521b\u5efa\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aCreateRisunRegistDocReqBO=" + reqBO.toString());
        CreateRisunRegistDocRspBO rspBO = this.initParam(reqBO);
        if ("9999".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        try {
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
            List<DIqrInquiryDetailPO> dIqrInquiryDetailPOS = this.dIqrInquiryDetailMapper.selectByInquiryId(reqBO.getInquiryId());
            if (null != dIqrInquiryMatePO || CollectionUtils.isNotEmpty(dIqrInquiryDetailPOS)) {
                DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(reqBO.getInquiryId(), reqBO.getSupplierId());
                if (null != dIqrRegistDocPO) {
                    dIqrRegistDocPO.setDocStatus(Integer.valueOf("3002"));
                    dIqrRegistDocPO.setRegistTime(new Date());
                    dIqrRegistDocPO.setRegistUserId(reqBO.getRegistUserId());
                    dIqrRegistDocPO.setRegistUserName(reqBO.getRegistUserName());
                    this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                    this.insertOperLog(dIqrRegistDocPO.getRegistId(), "\u4f9b\u5e94\u5546\u62a5\u540d", "\u9080\u8bf7\u7c7b\u4f9b\u5e94\u5546\u72b6\u6001\u53d8\u66f4", reqBO.getRegistUserId(), reqBO.getRegistUserName(), "\u6210\u529f");
                } else {
                    DIqrRegistDocPO dIqrRegistDocInsert = new DIqrRegistDocPO();
                    dIqrRegistDocInsert.setRegistId(this.getDocId("RISUN01", "3"));
                    BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)dIqrRegistDocInsert);
                    dIqrRegistDocInsert.setRegistUserId(reqBO.getRegistUserId());
                    dIqrRegistDocInsert.setRegistUserName(reqBO.getRegistUserName());
                    dIqrRegistDocInsert.setRegistIpAddr(reqBO.getRegistIpAddr());
                    dIqrRegistDocInsert.setValidStatus(Constants.IS_VALID_Y);
                    dIqrRegistDocInsert.setSupplierId(reqBO.getSupplierId());
                    dIqrRegistDocInsert.setSupplierName(reqBO.getSupplierName());
                    dIqrRegistDocInsert.setCreditNo(reqBO.getCreditNo());
                    dIqrRegistDocInsert.setPhoneNumber(reqBO.getPhoneNumber());
                    dIqrRegistDocInsert.setSupplierContactName(reqBO.getSupplierContactName());
                    dIqrRegistDocInsert.setSupplierContactTele(reqBO.getSupplierContactTele());
                    dIqrRegistDocInsert.setRegistBeginDate(new Date());
                    dIqrRegistDocInsert.setRegistEndDate(dIqrInquiryMatePO.getLimitQuoteDate());
                    dIqrRegistDocInsert.setRegistTime(new Date());
                    if (Constants.PURCHASE_METHOD_INVITE.equals(reqBO.getPurchaseMethod())) {
                        dIqrRegistDocInsert.setDocStatus(Integer.valueOf("3001"));
                        dIqrRegistDocInsert.setPayStatus("1");
                    } else {
                        dIqrRegistDocInsert.setDocStatus(Integer.valueOf("3002"));
                        dIqrRegistDocInsert.setPayStatus("1");
                    }
                    int ret = this.dIqrRegistDocMapper.insertSelective(dIqrRegistDocInsert);
                    if (ret > 0) {
                        DIqrRegistDetailPO dIqrRegistDetailInsert = new DIqrRegistDetailPO();
                        dIqrRegistDetailInsert.setRegistItemId(this.getDocId("RISUN01", "31"));
                        dIqrRegistDetailInsert.setInquiryId(reqBO.getInquiryId());
                        dIqrRegistDetailInsert.setRegistId(dIqrRegistDocInsert.getRegistId());
                        dIqrRegistDetailInsert.setInquiryItemId(dIqrInquiryDetailPOS.get(0).getInquiryItemId());
                        dIqrRegistDetailInsert.setRemarks("\u62a5\u540d\u660e\u7ec6\u521b\u5efa");
                        dIqrRegistDetailInsert.setValidStatus(Constants.IS_VALID_Y);
                        this.dIqrRegistDetailMapper.insertSelective(dIqrRegistDetailInsert);
                    }
                    this.insertOperLog(dIqrRegistDocInsert.getRegistId(), "\u4f9b\u5e94\u5546\u62a5\u540d", "\u4f9b\u5e94\u5546\u62a5\u540d\u4fe1\u606f\u751f\u6210", reqBO.getRegistUserId(), reqBO.getRegistUserName(), "\u6210\u529f");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u7ade\u4ef7\u5355\u6570\u636e\u4e0d\u5b58\u5728!");
            }
        }
        catch (Exception e) {
            log.error("\u62a5\u540d\u5355\u521b\u5efa\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u62a5\u540d\u5355\u521b\u5efa\u5f02\u5e38");
        }
        return rspBO;
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName, String remark) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(this.getDocId("RISUN01", "99"));
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark(remark);
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private Long getDocId(String systemId, String type) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId(systemId);
        seqEnquiryReqBO.setSeqType(type);
        return this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
    }

    private CreateRisunRegistDocRspBO initParam(CreateRisunRegistDocReqBO reqBO) {
        CreateRisunRegistDocRspBO rspBO = new CreateRisunRegistDocRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getPurchaseMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

