/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryInquiryAllQuotationBillListReqBO;
import com.tydic.enquiry.api.quote.bo.QryInquiryAllQuotationBillListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationBillBO;
import com.tydic.enquiry.api.quote.service.QryInquiryAllQuotationBillListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.QryInquiryAllQuotationBillListService"})
public class QryInquiryAllQuotationBillListServiceImpl
implements QryInquiryAllQuotationBillListService {
    private static final Logger log = LoggerFactory.getLogger(QryInquiryAllQuotationBillListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryInquiryAllQuotationBillList"})
    public QryInquiryAllQuotationBillListRspBO qryInquiryAllQuotationBillList(@RequestBody QryInquiryAllQuotationBillListReqBO reqBO) {
        QryInquiryAllQuotationBillListRspBO rspBO = new QryInquiryAllQuotationBillListRspBO();
        ArrayList<QuotationBillBO> quotationBillBOList = new ArrayList<QuotationBillBO>();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        DIqrQuotationPO quotationPO = new DIqrQuotationPO();
        DIqrQuotationPO record = new DIqrQuotationPO();
        ArrayList<String> hisStatusList = new ArrayList<String>();
        hisStatusList.add("1");
        hisStatusList.add("2");
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("4002"));
        docStatusList.add(Integer.valueOf("4004"));
        docStatusList.add(Integer.valueOf("4006"));
        quotationPO.setInquiryId(reqBO.getInquiryId());
        quotationPO.setValidStatus(Constants.IS_VALID_Y);
        quotationPO.setHisStatus("1");
        quotationPO.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> effectiveQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(quotationPO);
        if (CollectionUtils.isEmpty(effectiveQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setQuotationBillBOList(quotationBillBOList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        HashMap effectiveQuotationPOMap = new HashMap();
        Long allQuotationAmount = 0L;
        BigDecimal count = new BigDecimal("0");
        for (DIqrQuotationPO dIqrQuotationPO : effectiveQuotationPOList) {
            Long amount = dIqrQuotationPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
            }
            allQuotationAmount = allQuotationAmount + amount;
            count = count.add(new BigDecimal("1"));
        }
        BigDecimal averageAmount = new BigDecimal("0");
        try {
            averageAmount = MoneyUtils.Long2BigDecimal((Long)allQuotationAmount).divide(count).setScale(2, 4);
        }
        catch (Exception e2) {
            log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e2.getStackTrace());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
        }
        rspBO.setAverageAmount(averageAmount);
        record.setInquiryId(reqBO.getInquiryId());
        record.setHisStatusList(hisStatusList);
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> dIqrQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        if (CollectionUtils.isEmpty(dIqrQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setQuotationBillBOList(quotationBillBOList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        int higherAaverageAmountNumber = 0;
        int lowerAaverageAmountNumber = 0;
        for (DIqrQuotationPO dIqrQuotationPO : dIqrQuotationPOList) {
            QuotationBillBO quotationBillBO = new QuotationBillBO();
            BeanUtils.copyProperties((Object)dIqrQuotationPO, (Object)quotationBillBO);
            try {
                Long amount = dIqrQuotationPO.getAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                    amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                }
                quotationBillBO.setAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                quotationBillBO.setMarginAmount(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationPO.getMarginAmount()));
            }
            catch (Exception e1) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            if (dIqrQuotationPO.getQuotationCreateTime() != null) {
                quotationBillBO.setQuotationCreateTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dIqrQuotationPO.getQuotationSubmitTime() != null) {
                quotationBillBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (quotationBillBO.getAmount().compareTo(averageAmount) <= 0) {
                ++lowerAaverageAmountNumber;
            } else {
                ++higherAaverageAmountNumber;
            }
            quotationBillBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrQuotationPO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillBO.setRegistTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillBO.setQuoteTimeReq(quotationBillBO.getLimitQuoteDate() + "\u81f3" + quotationBillBO.getQuoteEndDate());
            quotationBillBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", dIqrQuotationPO.getPayStatus() + ""));
            quotationBillBO.setQuoteMethodName(this.qryDicAtomService.getDicCodeName("QUOTE_METHOD", dIqrQuotationPO.getQuoteMethod() + ""));
            quotationBillBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("QUOTE_DOC_STATUS", dIqrQuotationPO.getDocStatus() + ""));
            quotationBillBO.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", dIqrQuotationPO.getBusiType() + ""));
            quotationBillBO.setDocTypeName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", dIqrQuotationPO.getDocType() + ""));
            quotationBillBO.setSupplierClassName(this.qryDicAtomService.getDicCodeName("SUPPLIER_CLASS_ID", dIqrQuotationPO.getSupplierClassId() + ""));
            quotationBillBOList.add(quotationBillBO);
        }
        rspBO.setHigherAaverageAmountNumber(Integer.valueOf(higherAaverageAmountNumber));
        rspBO.setLowerAaverageAmountNumber(Integer.valueOf(lowerAaverageAmountNumber));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setQuotationBillBOList(quotationBillBOList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

