/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.tydic.enquiry.api.performlist.bo.InquiryDetailBO;
import com.tydic.enquiry.api.performlist.bo.PackageBO;
import com.tydic.enquiry.api.registdoc.bo.CheckIsRegistReqBO;
import com.tydic.enquiry.api.registdoc.bo.CheckIsRegistRspBO;
import com.tydic.enquiry.api.registdoc.service.CheckIsRegistService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.CheckIsRegistService"})
public class CheckIsRegistServiceImpl
implements CheckIsRegistService {
    private static final Logger log = LoggerFactory.getLogger(CheckIsRegistServiceImpl.class);
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;

    @PostMapping(value={"checkIsRegist"})
    public CheckIsRegistRspBO checkIsRegist(@RequestBody CheckIsRegistReqBO reqBO) {
        CheckIsRegistRspBO rspBO = new CheckIsRegistRspBO();
        if (reqBO.getPurchaseMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5ba2\u5546ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(reqBO.getInquiryId(), reqBO.getSupplierId());
        if (dIqrRegistDocPO == null) {
            rspBO.setHadRegistFlag("N");
        } else {
            List<DIqrRegistDetailPO> dIqrRegistDetailPOS = this.dIqrRegistDetailMapper.selectByRegistId(dIqrRegistDocPO.getRegistId());
            List<DIqrInquiryDetailPO> dIqrInquiryDetailPOS = this.dIqrInquiryDetailMapper.selectByInquiryId(dIqrRegistDocPO.getInquiryId());
            List<DIqrInquiryMateItemPO> dIqrInquiryMateItemPOS = this.dIqrInquiryMateItemMapper.selectInquiryItemByInquiryId(reqBO.getInquiryId());
            ArrayList<Long> tempList = new ArrayList<Long>();
            ArrayList<PackageBO> packageBOS = new ArrayList<PackageBO>();
            ArrayList<InquiryDetailBO> detailList = new ArrayList<InquiryDetailBO>();
            if (reqBO.getPurchaseMethod() == 22 || reqBO.getPurchaseMethod() == 21) {
                for (DIqrInquiryDetailPO dIqrInquiryDetailPO : dIqrInquiryDetailPOS) {
                    InquiryDetailBO inquiryDetailBO = new InquiryDetailBO();
                    BeanUtils.copyProperties((Object)dIqrInquiryDetailPO, (Object)inquiryDetailBO);
                    for (DIqrRegistDetailPO dIqrRegistDetailPO : dIqrRegistDetailPOS) {
                        if (!dIqrInquiryDetailPO.getInquiryItemId().equals(dIqrRegistDetailPO.getInquiryItemId())) {
                            inquiryDetailBO.setChoiceFlag("N");
                            continue;
                        }
                        inquiryDetailBO.setChoiceFlag("Y");
                        tempList.add(dIqrRegistDetailPO.getInquiryItemId());
                        break;
                    }
                    detailList.add(inquiryDetailBO);
                }
                if (tempList.size() != dIqrInquiryDetailPOS.size()) {
                    rspBO.setHadRegistFlag("N");
                } else {
                    rspBO.setHadRegistFlag("Y");
                }
                rspBO.setDetailList(detailList);
            }
            if (reqBO.getPurchaseMethod() == 23) {
                for (DIqrInquiryMateItemPO dIqrInquiryMateItemPO : dIqrInquiryMateItemPOS) {
                    PackageBO packageBO = new PackageBO();
                    BeanUtils.copyProperties((Object)dIqrInquiryMateItemPO, (Object)packageBO);
                    for (DIqrRegistDetailPO dIqrInquiryDetailPO : dIqrRegistDetailPOS) {
                        if (!dIqrInquiryMateItemPO.getInquiryPkgId().equals(dIqrInquiryDetailPO.getInquiryPkgId())) {
                            packageBO.setChoiceFlag("N");
                            continue;
                        }
                        packageBO.setChoiceFlag("Y");
                        tempList.add(dIqrInquiryMateItemPO.getInquiryId());
                        break;
                    }
                    packageBOS.add(packageBO);
                }
                if (tempList.size() != dIqrInquiryMateItemPOS.size()) {
                    rspBO.setHadRegistFlag("N");
                } else {
                    rspBO.setHadRegistFlag("Y");
                }
                rspBO.setPackageList(packageBOS);
            }
            rspBO.setRegistId(dIqrRegistDocPO.getRegistId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private CheckIsRegistRspBO initParam(CheckIsRegistReqBO reqBO) {
        CheckIsRegistRspBO rspBO = new CheckIsRegistRspBO();
        if (reqBO.getPurchaseMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5ba2\u5546ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

