/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.ExecOrderDetailBO;
import com.tydic.enquiry.api.registdoc.bo.QryRegistInfoReqBO;
import com.tydic.enquiry.api.registdoc.bo.QryRegistInfoRspBO;
import com.tydic.enquiry.api.registdoc.bo.RegistInfoBO;
import com.tydic.enquiry.api.registdoc.service.QryRegistInfoService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.QryRegistInfoService"})
public class QryRegistInfoServiceImpl
implements QryRegistInfoService {
    private static final Logger log = LoggerFactory.getLogger(QryRegistInfoServiceImpl.class);
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryRegistInfo"})
    public QryRegistInfoRspBO qryRegistInfo(@RequestBody QryRegistInfoReqBO qryRegistInfoReqBO) {
        QryRegistInfoRspBO qryRegistInfoRspBO = new QryRegistInfoRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(qryRegistInfoReqBO.getInquiryId());
        ExecOrderDetailBO execOrderDetailBO = new ExecOrderDetailBO();
        BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)execOrderDetailBO);
        execOrderDetailBO.setOperId(dIqrInquiryMatePO.getCreateUserId());
        execOrderDetailBO.setOperName(dIqrInquiryMatePO.getCreateUserName());
        execOrderDetailBO.setCurrencyType(dIqrInquiryMatePO.getCurrency());
        execOrderDetailBO.setCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        execOrderDetailBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        execOrderDetailBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        execOrderDetailBO.setRegistBeginDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        execOrderDetailBO.setRegistEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        execOrderDetailBO.setCurrencyTypeName(this.qryDicAtomService.getDicCodeName("CURRENCY_TYPE", dIqrInquiryMatePO.getCurrency() + ""));
        execOrderDetailBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", execOrderDetailBO.getDocStatus() + ""));
        execOrderDetailBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", execOrderDetailBO.getPurchaseMethod() + ""));
        execOrderDetailBO.setQuoteMethodName(this.qryDicAtomService.getDicCodeName("QUOTE_METHOD", execOrderDetailBO.getQuoteMethod() + ""));
        execOrderDetailBO.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", execOrderDetailBO.getBusiType() + ""));
        execOrderDetailBO.setComparedQuoteTypeName(this.qryDicAtomService.getDicCodeName("COMPARED_QUOTE_TYPE", execOrderDetailBO.getComparedQuoteType() + ""));
        execOrderDetailBO.setDelayBiddingFlagName(this.qryDicAtomService.getDicCodeName("DELAY_BIDDING_FLAG", execOrderDetailBO.getDelayBiddingFlag() + ""));
        execOrderDetailBO.setIsBudgetAnnounceName(this.qryDicAtomService.getDicCodeName("IS_BUDGET_ANNOUNCE", execOrderDetailBO.getIsBudgetAnnounce() + ""));
        execOrderDetailBO.setMarginFlagName(this.qryDicAtomService.getDicCodeName("MARGIN_FLAG", execOrderDetailBO.getMarginFlag() + ""));
        execOrderDetailBO.setOfferIncreaseTypeName(this.qryDicAtomService.getDicCodeName("OFFER_INCREASE_TYPE", execOrderDetailBO.getOfferIncreaseType() + ""));
        execOrderDetailBO.setTotalPriceFlagName(this.qryDicAtomService.getDicCodeName("TOTAL_PRICE_FLAG", execOrderDetailBO.getTotalPriceFlag() + ""));
        qryRegistInfoRspBO.setExecOrderInfo(execOrderDetailBO);
        List<DIqrRegistDocPO> registDocPOS = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(qryRegistInfoReqBO.getInquiryId());
        if (CollectionUtils.isNotEmpty(registDocPOS)) {
            List registInfoBOList = registDocPOS.stream().map(e -> {
                RegistInfoBO registInfoBO = new RegistInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)registInfoBO);
                registInfoBO.setRegistTime(DateUtils.dateToStr((Date)e.getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                registInfoBO.setIsTendSupplierName(this.qryDicAtomService.getDicCodeName("IS_TEND_SUPPLIER", e.getIsTendSupplier() + ""));
                if ("1".equals(e.getQuoteMethod())) {
                    registInfoBO.setRegistDetailNumName("\u6574\u5355");
                } else {
                    registInfoBO.setRegistDetailNumName(e.getRegistDetailNum());
                }
                return registInfoBO;
            }).collect(Collectors.toList());
            qryRegistInfoRspBO.setRegistInfoList(registInfoBOList);
        }
        qryRegistInfoRspBO.setRespCode("0000");
        qryRegistInfoRspBO.setRespDesc("\u6210\u529f");
        return qryRegistInfoRspBO;
    }
}

