/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.taobao.eagleeye.EagleEye;
import com.tydic.enquiry.aop.EnqAopUtils;
import com.tydic.enquiry.aop.EnqBusiAspect;
import com.tydic.uac.exception.BusinessException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnqAtomAspect {
    private static final String TRACE_ID = "traceId";
    private static final Logger atomLog = LoggerFactory.getLogger(EnqBusiAspect.class);

    @Pointcut(value="execution(* com.tydic.enquiry.service.atom.*(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object rspObj;
        String traceId;
        Map hiddenParm = RpcContext.getContext().getAttachments();
        if (hiddenParm.containsKey(TRACE_ID)) {
            traceId = (String)hiddenParm.get(TRACE_ID);
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put(TRACE_ID, traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        String[] infos = this.printAtomAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "\u5931\u8d25";
            }
            atomLog.info("atom BusinessException:{}", (Object)desc);
            this.printAtomAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            this.printAtomAopErrorLog(infos, e);
            if (!rspClass.isInterface()) {
                rspObj = rspClass.newInstance();
                this.putCodeToRsp(rspObj, "\u5931\u8d25", "\u5931\u8d25:" + e.getMessage());
            }
            throw e;
        }
        this.printAtomAopEndLog(infos, rspObj);
        return rspObj;
    }

    private void printAtomAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        EnqAopUtils.buildAopErrorLog(infos, e);
        atomLog.error(EnqAopUtils.getLogInfoByStrings(infos));
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        EnqAopUtils.putCodeToRsp(object, code, desc, false);
    }

    private String[] printAtomAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        String[] infos = EnqAopUtils.buildAopStartLog(pjp, traceId);
        if (null != infos) {
            atomLog.info(EnqAopUtils.getLogInfoByStrings(infos));
        }
        return infos;
    }

    private void printAtomAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        EnqAopUtils.buildAopEndLog(infos, object);
        atomLog.info(EnqAopUtils.getLogInfoByStrings(infos));
    }
}

