/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.util;

import com.tydic.enquiry.util.SerializeUtil;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class RedisUtils {
    @Autowired
    JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key) {
        try (Jedis jedis = null;){
            String t;
            jedis = this.jedisPool.getResource();
            String string = t = jedis.get(key);
            return (T)string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean set(String key, T value) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (key == null || key.length() <= 0) {
                boolean bl = false;
                return bl;
            }
            jedis.set(key, value.toString());
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String key) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            long ret = jedis.del(key);
            boolean bl = ret > 0L;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeys(String keyStr) {
        try (Jedis jedis = null;){
            Set keys;
            jedis = this.jedisPool.getResource();
            Set set = keys = jedis.keys(keyStr);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(String key, List<?> list) {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (list == null || list.size() == 0) {
                jedis.set(key.getBytes(), "".getBytes());
            } else {
                jedis.set(key.getBytes(), SerializeUtil.serializeList(list));
            }
        }
    }

    public List<?> getList(String key) {
        Jedis jedis = this.jedisPool.getResource();
        if (jedis == null || !jedis.exists(key).booleanValue()) {
            return null;
        }
        byte[] data = jedis.get(key.getBytes());
        jedis.close();
        return SerializeUtil.unserializeList(data);
    }
}

