/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.QuotationItemInfo;
import com.tydic.enquiry.api.performlist.bo.UpdateQuotationBillItemReqBO;
import com.tydic.enquiry.api.performlist.bo.UpdateQuotationBillItemRspBO;
import com.tydic.enquiry.api.performlist.service.UpdateQuotationBillItemService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMidMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemMidPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.enquiry.util.RedisUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.UpdateQuotationBillItemService"})
public class UpdateQuotationBillItemServiceImpl
implements UpdateQuotationBillItemService {
    private static final Logger log = LoggerFactory.getLogger(UpdateQuotationBillItemServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationItemMidMapper dIqrQuotationItemMidMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"upQuotationBillItem"})
    public UpdateQuotationBillItemRspBO upQuotationBillItem(@RequestBody UpdateQuotationBillItemReqBO reqBO) {
        UpdateQuotationBillItemRspBO rspBO = new UpdateQuotationBillItemRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getQuotationId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((String)reqBO.getRedisNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355RedisNo\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getQuotationItemList() || reqBO.getQuotationItemList().size() <= 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            Date nowDate;
            DIqrQuotationPO quotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
            if (quotationPO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            rspBO = this.initParam(reqBO, quotationPO.getBusiType(), quotationPO.getDocType());
            if ("9999".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(quotationPO.getInquiryId());
            if (inquiryMatePO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8be5\u62a5\u4ef7\u5355\u5bf9\u5e94\u7684\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if (inquiryMatePO.getDocStatus() == null || !"2003".equals(inquiryMatePO.getDocStatus().toString())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u4e0d\u53ef\u4ee5\u8fdb\u884c\u62a5\u4ef7\uff01");
                return rspBO;
            }
            Date limitQuoteDate = inquiryMatePO.getLimitQuoteDate();
            Date quoteEndDate = inquiryMatePO.getQuoteEndDate();
            if (quoteEndDate.before(nowDate = new Date())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u65f6\u95f4\u5df2\u8fc7\u4e0d\u53ef\u62a5\u4ef7\uff01");
                return rspBO;
            }
            if (limitQuoteDate.after(nowDate)) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u65f6\u95f4\u8fd8\u672a\u5f00\u59cb\u4e0d\u53ef\u62a5\u4ef7\uff01");
                return rspBO;
            }
            if ("21".equals(inquiryMatePO.getDocType()) && !quotationPO.getDocStatus().toString().equals("4001") || "22".equals(inquiryMatePO.getDocType()) && "4002".equals(quotationPO.getDocStatus().toString()) && Integer.parseInt(quotationPO.getQuoteRounds()) >= quotationPO.getQuoteTimeLimit()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7\uff01");
                return rspBO;
            }
            List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationId(reqBO.getQuotationId());
            ArrayList<DIqrQuotationItemMidPO> dIqrQuotationItemMidPOList = new ArrayList<DIqrQuotationItemMidPO>();
            for (QuotationItemInfo quotationItemInfo : reqBO.getQuotationItemList()) {
                DIqrQuotationItemMidPO dIqrQuotationItemMidPO = new DIqrQuotationItemMidPO();
                BigDecimal quotationAmount = new BigDecimal("0");
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
                    if (quotationItemInfo.getQuotationItemId().longValue() == dIqrQuotationItemPO.getQuotationItemId().longValue() && quotationItemInfo.getQuotePrice() != null && quotationItemInfo.getQuotePrice().compareTo(BigDecimal.ZERO) > 0) {
                        quotationAmount = quotationItemInfo.getQuotePrice().multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    }
                    if (quotationItemInfo.getQuotationItemId().longValue() == dIqrQuotationItemPO.getQuotationItemId().longValue() && dIqrQuotationItemPO.getQuotePrice() != null && dIqrQuotationItemPO.getQuotePrice() > 0L && quotationItemInfo.getQuotePrice() != null && quotationItemInfo.getQuotePrice().compareTo(BigDecimal.ZERO) > 0) {
                        if ("1".equals(inquiryMatePO.getBusiType()) && quotationItemInfo.getQuotePrice().compareTo(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getQuotePrice())) > 0) {
                            rspBO.setRespCode("9999");
                            rspBO.setRespDesc("\u62a5\u4ef7\u91d1\u989d\u4e0d\u80fd\u9ad8\u4e8e\u539f\u62a5\u4ef7\u91d1\u989d\uff01");
                            return rspBO;
                        }
                        if (quotationItemInfo.getQuotePrice().compareTo(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getQuotePrice())) > 0) {
                            rspBO.setRespCode("9999");
                            rspBO.setRespDesc("\u62a5\u4ef7\u91d1\u989d\u4e0d\u80fd\u4f4e\u4e8e\u539f\u62a5\u4ef7\u91d1\u989d\uff01");
                            return rspBO;
                        }
                    }
                    if (quotationItemInfo.getQuotationItemId().longValue() != dIqrQuotationItemPO.getQuotationItemId().longValue()) continue;
                    dIqrQuotationItemMidPO.setQuotationId(dIqrQuotationItemPO.getQuotationId());
                    break;
                }
                BeanUtils.copyProperties((Object)quotationItemInfo, (Object)dIqrQuotationItemMidPO);
                dIqrQuotationItemMidPO.setQuoteAmount(0L);
                dIqrQuotationItemMidPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationAmount), dIqrQuotationItemMidPO.getQuotationId().toString()));
                dIqrQuotationItemMidPO.setQuotePrice(0L);
                dIqrQuotationItemMidPO.setQuotePriceSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationItemInfo.getQuotePrice()), dIqrQuotationItemMidPO.getQuotationId().toString()));
                dIqrQuotationItemMidPO.setRedisNo(reqBO.getRedisNo());
                this.dIqrQuotationItemMidMapper.updateByQuotationItemId(dIqrQuotationItemMidPO);
                dIqrQuotationItemMidPOList.add(dIqrQuotationItemMidPO);
            }
        }
        catch (Exception e) {
            log.error("\u62a5\u4ef7\u5355\u66f4\u65b0\u5931\u8d25\uff1a", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25\uff01" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }

    private UpdateQuotationBillItemRspBO initParam(UpdateQuotationBillItemReqBO reqBO, String busiType, String docType) {
        UpdateQuotationBillItemRspBO rspBO = new UpdateQuotationBillItemRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getQuotationId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getQuotationItemList())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getQuotationItemList().stream().map(e -> {
            if (null == e.getQuotationItemId()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ("1".equals(busiType)) {
                if (StringUtils.isEmpty((String)e.getBrand())) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u5927\u5355\u8bae\u4ef7\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)e.getManufacturer())) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u5927\u5355\u8bae\u4ef7\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (null == e.getQuotePrice()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return rspBO;
        }).collect(Collectors.toList());
        return rspBO;
    }
}

