/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryTopThreeQuoteItemReqBO;
import com.tydic.enquiry.api.quote.bo.QryTopThreeQuoteItemRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationItemBO;
import com.tydic.enquiry.api.quote.service.QryTopThreeQuoteItemService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.QryTopThreeQuoteItemService"})
public class QryTopThreeQuoteItemServiceImpl
implements QryTopThreeQuoteItemService {
    private static final Logger log = LoggerFactory.getLogger(QryTopThreeQuoteItemServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"qryTopThreeQuoteItem"})
    public QryTopThreeQuoteItemRspBO qryTopThreeQuoteItem(@RequestBody QryTopThreeQuoteItemReqBO qryTopThreeQuoteItemReqBO) {
        Long amount;
        int sequence;
        QryTopThreeQuoteItemRspBO rspBO = new QryTopThreeQuoteItemRspBO();
        DIqrQuotationPO record = new DIqrQuotationPO();
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("40014"));
        docStatusList.add(Integer.valueOf("40015"));
        record.setInquiryId(qryTopThreeQuoteItemReqBO.getInquiryId());
        record.setHisStatus("1");
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> dIqrQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        if (CollectionUtils.isEmpty(dIqrQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        ArrayList<Long> quotationIds = new ArrayList<Long>();
        ArrayList<Long> quoteAmountList = new ArrayList<Long>();
        HashMap<Integer, Long> quoteSequenceMap = new HashMap<Integer, Long>();
        HashMap<Long, DIqrQuotationPO> dIqrQuotationPOMap = new HashMap<Long, DIqrQuotationPO>();
        for (DIqrQuotationPO dIqrQuotationPO : dIqrQuotationPOList) {
            dIqrQuotationPOMap.put(dIqrQuotationPO.getQuotationId(), dIqrQuotationPO);
            Long quoteAmount2 = dIqrQuotationPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                quoteAmount2 = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
            }
            quoteAmountList.add(quoteAmount2);
        }
        Collections.sort(quoteAmountList);
        if (dIqrQuotationPOList.size() <= 3) {
            sequence = 0;
            for (Long quoteAmount : quoteAmountList) {
                for (DIqrQuotationPO dIqrQuotationPO : dIqrQuotationPOList) {
                    amount = dIqrQuotationPO.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                        amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                    }
                    if (amount.longValue() != quoteAmount.longValue()) continue;
                    quoteSequenceMap.put(++sequence, dIqrQuotationPO.getQuotationId());
                    quotationIds.add(dIqrQuotationPO.getQuotationId());
                }
            }
        } else {
            void var11_16;
            sequence = 0;
            boolean bl = false;
            while (var11_16 <= 3) {
                Long quoteAmount;
                quoteAmount = (Long)quoteAmountList.get((int)var11_16);
                for (DIqrQuotationPO dIqrQuotationPO : dIqrQuotationPOList) {
                    amount = dIqrQuotationPO.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                        amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                    }
                    if (amount.longValue() != quoteAmount.longValue()) continue;
                    quoteSequenceMap.put(++sequence, dIqrQuotationPO.getQuotationId());
                    quotationIds.add(dIqrQuotationPO.getQuotationId());
                }
                ++var11_16;
            }
        }
        DIqrQuotationItemPO quotationItemPO = new DIqrQuotationItemPO();
        quotationItemPO.setQuotationIds(quotationIds);
        List<DIqrQuotationItemPO> list = this.dIqrQuotationItemMapper.selectByQuotationItem(quotationItemPO);
        ArrayList<QuotationItemBO> quotationItemBOList = new ArrayList<QuotationItemBO>();
        for (Long quotationId : quoteSequenceMap.values()) {
            for (DIqrQuotationItemPO dIqrQuotationItemPO : list) {
                if (dIqrQuotationItemPO.getQuotationId().longValue() != quotationId.longValue()) continue;
                QuotationItemBO quotationItemBO = new QuotationItemBO();
                BeanUtils.copyProperties((Object)dIqrQuotationItemPO, (Object)quotationItemBO);
                try {
                    Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                    Long quoteAmount3 = dIqrQuotationItemPO.getQuoteAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                        quoteAmount3 = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    quotationItemBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)quotePrice));
                    quotationItemBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quoteAmount3));
                }
                catch (Exception e1) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null && ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationSubmitTime() != null) {
                    quotationItemBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null && ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDeliveryDatePromise() != null) {
                    quotationItemBO.setDeliveryDatePromise(DateUtils.dateToStr((Date)((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null) {
                    quotationItemBO.setDocStatus(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDocStatus());
                    quotationItemBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDocStatus() + ""));
                    quotationItemBO.setSupplierId(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getSupplierId());
                    quotationItemBO.setSupplierName(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getSupplierName());
                    quotationItemBO.setQuotationCode(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationCode());
                }
                quotationItemBOList.add(quotationItemBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u67e5\u8be2\u62a5\u4ef7\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(quotationItemBOList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

