/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.tydic.enquiry.api.registdoc.bo.RegistStatusAutoChangeReqBO;
import com.tydic.enquiry.api.registdoc.bo.RegistStatusAutoChangeRspBO;
import com.tydic.enquiry.api.registdoc.service.RegistStatusAutoChangeService;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.RegistStatusAutoChangeService"})
public class RegistStatusAutoChangeServiceImpl
implements RegistStatusAutoChangeService {
    private static final Logger log = LoggerFactory.getLogger(RegistStatusAutoChangeServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;

    @PostMapping(value={"registStatusAutoChange"})
    public RegistStatusAutoChangeRspBO registStatusAutoChange(@RequestBody RegistStatusAutoChangeReqBO reqBO) {
        RegistStatusAutoChangeRspBO rspBO = new RegistStatusAutoChangeRspBO();
        try {
            Date currentDate = new Date();
            List<Integer> statusList = Arrays.asList(Integer.valueOf("3002"), Integer.valueOf("3005"), Integer.valueOf("3006"));
            List<DIqrRegistDocPO> dIqrRegistDocList = this.dIqrRegistDocMapper.queryByRegistTimeAndStatus(statusList, currentDate);
            if (CollectionUtils.isNotEmpty(dIqrRegistDocList)) {
                for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocList) {
                    if ("3003".equals(dIqrRegistDocPO.getPayStatus()) || "3004".equals(dIqrRegistDocPO.getPayStatus())) continue;
                    if ("1".equals(dIqrRegistDocPO.getPayStatus())) {
                        dIqrRegistDocPO.setDocStatus(Integer.valueOf("3002"));
                        this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                    } else if (currentDate.before(dIqrRegistDocPO.getLimitQuoteDate())) {
                        dIqrRegistDocPO.setDocStatus(Integer.valueOf("3005"));
                        this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                    } else if (currentDate.after(dIqrRegistDocPO.getLimitQuoteDate()) && currentDate.before(dIqrRegistDocPO.getQuoteEndDate())) {
                        dIqrRegistDocPO.setDocStatus(Integer.valueOf("3006"));
                        this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                    }
                    if (!currentDate.after(dIqrRegistDocPO.getQuoteEndDate())) continue;
                    dIqrRegistDocPO.setDocStatus(Integer.valueOf("3004"));
                    this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u62a5\u540d\u5355\u72b6\u6001\u53d8\u66f4\u5b9a\u65f6\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

