/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusReqBO;
import com.tydic.enquiry.api.performlist.service.UpExecOrderStatusService;
import com.tydic.enquiry.api.quote.bo.ConfirmBiddingResultsReqBO;
import com.tydic.enquiry.api.quote.bo.ConfirmBiddingResultsRspBO;
import com.tydic.enquiry.api.quote.service.ConfirmBiddingResultsService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.ConfirmBiddingResultsService"})
public class ConfirmBiddingResultsServiceImpl
implements ConfirmBiddingResultsService {
    private static final Logger log = LoggerFactory.getLogger(ConfirmBiddingResultsServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private UpExecOrderStatusService upExecOrderStatusService;

    @PostMapping(value={"confirmBiddingResults"})
    public ConfirmBiddingResultsRspBO confirmBiddingResults(@RequestBody ConfirmBiddingResultsReqBO confirmBiddingResultsReqBO) {
        ConfirmBiddingResultsRspBO rspBO = new ConfirmBiddingResultsRspBO();
        DIqrQuotationPO qryInquiryQuotationPO = new DIqrQuotationPO();
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("40014"));
        docStatusList.add(Integer.valueOf("40015"));
        qryInquiryQuotationPO.setInquiryId(confirmBiddingResultsReqBO.getInquiryId());
        qryInquiryQuotationPO.setHisStatus("1");
        qryInquiryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryInquiryQuotationPO.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> inquiryQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryInquiryQuotationPO);
        Long mostQuotationId = null;
        if (inquiryQuotationPOs != null && inquiryQuotationPOs.size() > 0) {
            Long quoteAmount = inquiryQuotationPOs.get(0).getAmount();
            if (StringUtils.isNotEmpty((CharSequence)inquiryQuotationPOs.get(0).getAmountSec())) {
                quoteAmount = QuoteUtil.decode(inquiryQuotationPOs.get(0).getAmountSec(), inquiryQuotationPOs.get(0).getQuotationId().toString());
            }
            mostQuotationId = inquiryQuotationPOs.get(0).getQuotationId();
            for (DIqrQuotationPO dIqrQuotationPO : inquiryQuotationPOs) {
                Long amount = dIqrQuotationPO.getAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                    amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                }
                if (quoteAmount <= amount) continue;
                mostQuotationId = dIqrQuotationPO.getQuotationId();
            }
        }
        DIqrQuotationPO updateStatusPO = new DIqrQuotationPO();
        updateStatusPO.setReviewResult(Constants.REVIEW_RESULT_2);
        updateStatusPO.setInquiryId(confirmBiddingResultsReqBO.getInquiryId());
        this.dIqrQuotationMapper.updateStatusByInquiryId(updateStatusPO);
        updateStatusPO.setReviewResult(Constants.REVIEW_RESULT_1);
        updateStatusPO.setQuotationId(mostQuotationId);
        this.dIqrQuotationMapper.updateStatusByInquiryId(updateStatusPO);
        ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
        execOrderStatusReqBO.setInquiryId(confirmBiddingResultsReqBO.getInquiryId());
        execOrderStatusReqBO.setOperId(confirmBiddingResultsReqBO.getUserId());
        execOrderStatusReqBO.setOperName(confirmBiddingResultsReqBO.getUsername());
        execOrderStatusReqBO.setDocStatus(Integer.valueOf("2008"));
        execOrderStatusReqBO.setNodeStatus("2008");
        execOrderStatusReqBO.setUpFlag("1");
        this.upExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6267\u884c\u5355\u786e\u8ba4\u7ade\u4ef7\u7ed3\u679c\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

