/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.GoodsDetailBO;
import com.tydic.enquiry.api.performlist.bo.InquiryAttachmentBO;
import com.tydic.enquiry.api.performlist.bo.InviteSupplierInfoBO;
import com.tydic.enquiry.api.performlist.bo.ModifyRisunExecOrderReqBO;
import com.tydic.enquiry.api.performlist.bo.ModifyRisunExecOrderRspBO;
import com.tydic.enquiry.api.performlist.service.ModifyRisunExecOrderService;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocReqBO;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocRspBO;
import com.tydic.enquiry.api.registdoc.bo.UpdateRisunRegistDocReqBO;
import com.tydic.enquiry.api.registdoc.bo.UpdateRisunRegistDocRspBO;
import com.tydic.enquiry.api.registdoc.service.CreateRisunRegistDocService;
import com.tydic.enquiry.api.registdoc.service.UpdateRisunRegistDocService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.ModifyRisunExecOrderService"})
public class ModifyRisunExecOrderServiceImpl
implements ModifyRisunExecOrderService {
    private static final Logger log = LoggerFactory.getLogger(ModifyRisunExecOrderServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    CreateRisunRegistDocService createRisunRegistDocService;
    @Autowired
    UpdateRisunRegistDocService updateRisunRegistDocService;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"modifyRisunExecOrder"})
    public ModifyRisunExecOrderRspBO modifyRisunExecOrder(@RequestBody ModifyRisunExecOrderReqBO reqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aModifyRisunExecOrderReqBO=" + reqBO.toString());
        ModifyRisunExecOrderRspBO rspBO = new ModifyRisunExecOrderRspBO();
        if (null == reqBO.getInquiryId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
            if (inquiryMatePO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u672a\u627e\u5230\u7ade\u4ef7\u5355\u4fe1\u606f");
                return rspBO;
            }
            DIqrInquiryMatePO dIqrInquiryMatePO = new DIqrInquiryMatePO();
            BeanUtils.copyProperties((Object)reqBO, (Object)dIqrInquiryMatePO);
            if (StringUtils.isNotBlank((CharSequence)reqBO.getLimitQuoteDate())) {
                dIqrInquiryMatePO.setLimitQuoteDate(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getLimitQuoteDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getQuoteEndDate())) {
                dIqrInquiryMatePO.setQuoteEndDate(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getQuoteEndDate()));
            }
            if (null != reqBO.getMarginAmount()) {
                dIqrInquiryMatePO.setMarginAmount(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getMarginAmount()));
            }
            dIqrInquiryMatePO.setDelayEachTime(reqBO.getDelayLengthTime());
            dIqrInquiryMatePO.setModifyUserId(reqBO.getUpdateOperId());
            dIqrInquiryMatePO.setModifyUserName(reqBO.getUpdateOperName());
            dIqrInquiryMatePO.setPurchaseName(reqBO.getPlanUnitName());
            dIqrInquiryMatePO.setModifyTime(new Date());
            this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(dIqrInquiryMatePO);
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsDetailList())) {
                for (GoodsDetailBO goodsDetailBO : reqBO.getGoodsDetailList()) {
                    DIqrInquiryDetailPO dIqrInquiryDetailUpate = new DIqrInquiryDetailPO();
                    BeanUtils.copyProperties((Object)goodsDetailBO, (Object)dIqrInquiryDetailUpate);
                    dIqrInquiryDetailUpate.setBudgetPrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsDetailBO.getBudgetPrice()));
                    dIqrInquiryDetailUpate.setGoodsNumber(MoneyUtils.BigDecimal2Long((BigDecimal)goodsDetailBO.getGoodsNumber()));
                    dIqrInquiryDetailUpate.setMinGoodsNumber(MoneyUtils.BigDecimal2Long((BigDecimal)goodsDetailBO.getMinGoodsNumber()));
                    dIqrInquiryDetailUpate.setInquiryItemId(goodsDetailBO.getInquiryItemId());
                    this.dIqrInquiryDetailMapper.updateByPrimaryKeySelective(dIqrInquiryDetailUpate);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getAttachmentInfoList())) {
                RPlanAttachmentInfoPO rPlanAttachmentInfoPO = new RPlanAttachmentInfoPO();
                for (InquiryAttachmentBO attachmentBO : reqBO.getAttachmentInfoList()) {
                    if ("1".equals(attachmentBO.getOperFlag())) {
                        BeanUtils.copyProperties((Object)attachmentBO, (Object)rPlanAttachmentInfoPO);
                        rPlanAttachmentInfoPO.setAttachmentId(this.getDocId("RISUN01", "99"));
                        rPlanAttachmentInfoPO.setObjectId(reqBO.getInquiryId());
                        rPlanAttachmentInfoPO.setCreateUserId(reqBO.getUpdateOperId());
                        rPlanAttachmentInfoPO.setCreateUserName(reqBO.getUpdateOperName());
                        rPlanAttachmentInfoPO.setCreateTime(new Date());
                        rPlanAttachmentInfoPO.setObjectType(2);
                        rPlanAttachmentInfoPO.setValidFlag(String.valueOf(Constants.IS_VALID_Y));
                        this.rPlanAttachmentInfoMapper.insertSelective(rPlanAttachmentInfoPO);
                    }
                    if (!"2".equals(attachmentBO.getOperFlag())) continue;
                    this.rPlanAttachmentInfoMapper.deleteByPrimaryKey(attachmentBO.getInquiryAttachmentId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getInviteSupplierList())) {
                if (Constants.PURCHASE_METHOD_INVITE.equals(reqBO.getPurchaseMethod()) || Constants.PURCHASE_METHOD_PUB.equals(inquiryMatePO.getPurchaseMethod()) && Constants.PURCHASE_METHOD_INVITE.equals(reqBO.getPurchaseMethod())) {
                    this.createRegistDoc(reqBO.getInviteSupplierList(), reqBO.getInquiryId(), inquiryMatePO.getPurchaseMethod());
                }
                if (Constants.PURCHASE_METHOD_INVITE.equals(inquiryMatePO.getPurchaseMethod()) && Constants.PURCHASE_METHOD_PUB.equals(reqBO.getPurchaseMethod())) {
                    this.createRegistDoc(reqBO.getInviteSupplierList(), reqBO.getInquiryId(), inquiryMatePO.getPurchaseMethod());
                }
            }
            this.insertOperLog(reqBO.getInquiryId(), "\u7ade\u4ef7\u9879\u76ee\u521b\u5efa", "\u7ade\u4ef7\u5355\u4fe1\u606f\u4fee\u6539", reqBO.getCreateUserId(), reqBO.getCreateUserName(), "\u6210\u529f");
            rspBO.setInquiryId(reqBO.getInquiryId());
            rspBO.setInquiryCode(reqBO.getInquiryCode());
            rspBO.setInquiryName(reqBO.getInquiryName());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u5355\u4fee\u6539\u5f02\u5e38", (Throwable)e);
            if (e instanceof EnqBusinessException) {
                throw new EnqBusinessException("9999", e.getMessage());
            }
            throw new EnqBusinessException("9999", "\u7ade\u4ef7\u5355\u4fee\u6539\u5f02\u5e38");
        }
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aModifyRisunExecOrderRspBO=" + rspBO.toString());
        return rspBO;
    }

    private void createRegistDoc(List<InviteSupplierInfoBO> inviteSupplierList, Long inquiryId, Integer purchaseMethod) {
        for (InviteSupplierInfoBO inviteSupplierInfoBO : inviteSupplierList) {
            CreateRisunRegistDocReqBO createRisunRegistDocReqBO = new CreateRisunRegistDocReqBO();
            if ("1".equals(inviteSupplierInfoBO.getOperFlag())) {
                createRisunRegistDocReqBO.setInquiryId(inquiryId);
                createRisunRegistDocReqBO.setSupplierId(inviteSupplierInfoBO.getSupplierId());
                createRisunRegistDocReqBO.setSupplierName(inviteSupplierInfoBO.getSupplierName());
                createRisunRegistDocReqBO.setSupplierContactName(inviteSupplierInfoBO.getSupplierContactName());
                createRisunRegistDocReqBO.setSupplierContactTele(inviteSupplierInfoBO.getSupplierContactTele());
                createRisunRegistDocReqBO.setPhoneNumber(inviteSupplierInfoBO.getPhoneNumber());
                createRisunRegistDocReqBO.setCreditNo(inviteSupplierInfoBO.getCreditNo());
                createRisunRegistDocReqBO.setPurchaseMethod(purchaseMethod);
                CreateRisunRegistDocRspBO createRisunRegistDocRspBO = this.createRisunRegistDocService.risunRegistDocCreate(createRisunRegistDocReqBO);
                if (null != createRisunRegistDocRspBO && !"0000".equals(createRisunRegistDocRspBO.getRespCode())) {
                    throw new EnqBusinessException("9999", createRisunRegistDocRspBO.getRespDesc());
                }
                log.info("\u7ade\u4ef7\u5355\u4fee\u6539\uff0c\u4fdd\u5b58\u62a5\u540d\u5355\u4fe1\u606f\u8fd4\u56de\uff1a" + createRisunRegistDocRspBO);
            }
            if (!"2".equals(inviteSupplierInfoBO.getOperFlag())) continue;
            DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(inquiryId, inviteSupplierInfoBO.getSupplierId());
            UpdateRisunRegistDocReqBO updateRisunRegistDocReqBO = new UpdateRisunRegistDocReqBO();
            updateRisunRegistDocReqBO.setRegistId(dIqrRegistDocPO.getRegistId());
            updateRisunRegistDocReqBO.setValidStatus(Constants.IS_VALID_N);
            UpdateRisunRegistDocRspBO updateRisunRegistDocRspBO = this.updateRisunRegistDocService.risunRegistDocUpdate(updateRisunRegistDocReqBO);
            if (null != updateRisunRegistDocRspBO && !"0000".equals(updateRisunRegistDocRspBO.getRespCode())) {
                throw new EnqBusinessException("9999", updateRisunRegistDocRspBO.getRespDesc());
            }
            log.info("\u7ade\u4ef7\u5355\u4fee\u6539,\u4fee\u6539\u62a5\u540d\u5355\u4fe1\u606f\u8fd4\u56de\uff1a" + updateRisunRegistDocRspBO);
        }
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName, String remark) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(this.getDocId("RISUN01", "99"));
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark(remark);
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private Long getDocId(String systemId, String type) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId(systemId);
        seqEnquiryReqBO.setSeqType(type);
        return this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
    }
}

